/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.InputStream;
import java.util.Map;
import javajs.J2SIgnoreImport;
import javajs.util.AU;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import org.jmol.api.JmolAudioPlayer;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import sun.audio.AudioData;
import sun.audio.AudioDataStream;

@J2SIgnoreImport(value={AudioInputStream.class, AudioSystem.class, Clip.class, Line.class, LineEvent.class, LineListener.class, AudioData.class, AudioDataStream.class})
public class JmolAudio
implements LineListener,
JmolAudioPlayer {
    private static final int MAX_LOOP = 10;
    private Map<String, Object> params;
    private Clip myClip;
    private String fileName;
    private Viewer vwr;
    private String id;
    private static int idCount;
    private boolean autoClose;

    public void playAudio(Viewer viewer, Map<String, Object> map) {
        try {
            this.id = (String)map.get("id");
            if (this.id == null || this.id.length() == 0) {
                this.autoClose = true;
                this.id = "audio" + ++idCount;
                map.put("id", this.id);
            }
            this.vwr = viewer;
            this.params = map;
            this.params.put("audioPlayer", this);
            this.fileName = (String)map.get("audioFile");
            viewer.sm.registerAudio(this.id, map);
            this.getClip();
            if (this.myClip == null) {
                return;
            }
            if (map.containsKey("action")) {
                this.action((String)map.get("action"));
            } else if (map.containsKey("loop")) {
                this.action("loop");
            } else {
                this.autoClose = true;
                this.action("start");
            }
        }
        catch (Exception exception) {
            Logger.info("File " + this.fileName + " could not be opened as an audio file");
        }
    }

    private void getClip() throws Exception {
        Object object = this.vwr.fm.getFileAsBytes(this.fileName, null);
        if (!AU.isAB(object)) {
            Logger.info("File " + this.fileName + " " + object);
            return;
        }
        this.myClip = (Clip)AudioSystem.getLine(new Line.Info(Clip.class));
        this.myClip.addLineListener(this);
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream((InputStream)new AudioDataStream(new AudioData((byte[])object)));
        this.myClip.open(audioInputStream);
    }

    @Override
    public void update(LineEvent lineEvent) {
        this.processUpdate(lineEvent.getType().toString());
    }

    public void processUpdate(String string) {
        Logger.info("audio id " + this.id + " " + this.fileName + " " + string);
        if (string == "open" || string == "Open") {
            this.params.put("status", "open");
        } else if (string == "play" || string == "Start") {
            this.params.put("status", "play");
        } else if (string == "pause" || string == "Stop") {
            this.params.put("status", "pause");
            if (this.autoClose) {
                this.myClip.close();
            }
        } else if (string == "ended" || string == "Close") {
            this.params.put("status", "ended");
        } else {
            this.params.put("status", string);
        }
        this.vwr.sm.notifyAudioStatus(this.params);
    }

    @Override
    public void action(String string) {
        if (this.myClip == null) {
            if (string == "kill") {
                return;
            }
            this.params.put("status", "ended");
            this.vwr.sm.notifyAudioStatus(this.params);
            return;
        }
        try {
            if ("start".equals(string)) {
                this.myClip.setMicrosecondPosition(0L);
                this.myClip.loop(0);
                this.myClip.start();
            } else if ("loop".equals(string)) {
                this.myClip.setMicrosecondPosition(0L);
                this.myClip.loop(10);
                this.myClip.start();
            } else if ("pause".equals(string)) {
                if (this.myClip != null) {
                    this.myClip.stop();
                }
            } else if ("play".equals(string)) {
                this.myClip.stop();
                this.myClip.start();
            } else if ("close".equals(string)) {
                this.myClip.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

