/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.Geodesic;
import org.jmol.util.MeshSlicer;
import org.jmol.util.TempArray;
import org.jmol.viewer.Viewer;

public class MeshSurface {
    protected static final int SEED_COUNT = 25;
    public static final int P_CHECK = 3;
    public static final int P_CONTOUR = 4;
    public static final int P_EXPLICIT_COLOR = 4;
    public Viewer vwr;
    private MeshSlicer slicer;
    public V3[] oabc;
    public String meshType;
    public int vc;
    public T3[] vs;
    public float[] vvs;
    public int[] vertexSource;
    public BS surfaceAtoms;
    public int pc;
    public int[][] pis;
    public boolean colorsExplicit;
    public boolean isDrawPolygon;
    public boolean haveQuads;
    public short colix;
    public short colixBack;
    public boolean isColorSolid = true;
    public P3 offset;
    public T3[] altVertices;
    public short[] pcs;
    public short[] vcs;
    public T3[] normals;
    public V3[] normalsTemp;
    public int normalCount;
    public int normixCount;
    public BS bsPolygons;
    public M4 mat4;
    public BS[] surfaceSet;
    public int[] vertexSets;
    public int nSets = 0;
    public boolean dataOnly;
    private int lastColor;
    private short lastColix;
    protected int iA;
    protected int iB;
    protected int iC;
    public int polygonCount0;
    public int vertexCount0;
    public BS bsSlabDisplay;
    public BS bsSlabGhost;
    public int slabMeshType;
    public short slabColix;
    public BS bsDisplay;
    public SB slabOptions;
    public int mergeVertexCount0;
    public int mergePolygonCount0;
    public boolean isMerged;

    public MeshSlicer getMeshSlicer() {
        return this.slicer == null ? (this.slicer = ((MeshSlicer)Interface.getInterface("org.jmol.util.MeshSlicer", this.vwr, "script")).set(this)) : this.slicer;
    }

    public static MeshSurface newMesh(boolean bl, T3[] t3Array, int n, int[][] nArray, T3[] t3Array2, int n2) {
        MeshSurface meshSurface = new MeshSurface();
        meshSurface.pis = nArray;
        if (bl) {
            meshSurface.altVertices = t3Array;
        } else {
            meshSurface.vs = t3Array;
        }
        meshSurface.vc = n == 0 ? t3Array.length : n;
        meshSurface.normals = t3Array2;
        meshSurface.normalCount = n2 == 0 && t3Array2 != null ? t3Array2.length : n2;
        return meshSurface;
    }

    public T3[] getVertices() {
        return this.altVertices == null ? this.vs : this.altVertices;
    }

    public int[][] getFaces() {
        return this.pis;
    }

    public void setColix(short s) {
        this.colix = s;
    }

    public void setColixBack(short s) {
        this.colixBack = s;
    }

    public int addV(T3 t3, boolean bl) {
        if (this.vc == 0) {
            this.vs = new T3[25];
        } else if (this.vc == this.vs.length) {
            this.vs = (T3[])AU.doubleLength(this.vs);
        }
        this.vs[this.vc] = bl ? P3.newP(t3) : t3;
        return this.vc++;
    }

    public void addTriangle(int n, int n2, int n3) {
        this.addPolygon(new int[]{n, n2, n3}, null);
    }

    public void addQuad(int n, int n2, int n3, int n4) {
        this.haveQuads = true;
        this.addPolygon(new int[]{n, n2, n3, n4}, null);
    }

    public void setPolygonCount(int n) {
        this.pc = n;
        if (n < 0) {
            return;
        }
        if (this.pis == null || n > this.pis.length) {
            this.pis = AU.newInt2(n);
        }
    }

    public int addVCVal(T3 t3, float f, boolean bl) {
        if (this.vc == 0) {
            this.vvs = new float[25];
        } else if (this.vc >= this.vvs.length) {
            this.vvs = AU.doubleLengthF(this.vvs);
        }
        this.vvs[this.vc] = f;
        return this.addV(t3, bl);
    }

    public int addTriangleCheck(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.vs == null || this.vvs != null && (Float.isNaN(this.vvs[n]) || Float.isNaN(this.vvs[n2]) || Float.isNaN(this.vvs[n3])) || Float.isNaN(this.vs[n].x) || Float.isNaN(this.vs[n2].x) || Float.isNaN(this.vs[n3].x) ? -1 : this.addPolygonV3(n, n2, n3, n4, n5, n6, null);
    }

    int addPolygonV3(int n, int n2, int n3, int n4, int n5, int n6, BS bS) {
        return this.dataOnly ? this.addPolygon(new int[]{n, n2, n3, n4}, bS) : this.addPolygonC(new int[]{n, n2, n3, n4, n5}, n6, bS, n5 < 0);
    }

    protected int addPolygonC(int[] nArray, int n, BS bS, boolean bl) {
        if (n != 0) {
            if (this.pcs == null || this.pc == 0) {
                this.lastColor = 0;
            }
            if (bl) {
                this.colorsExplicit = true;
            } else {
                int n2;
                if (this.pcs == null) {
                    this.pcs = new short[25];
                } else if (this.pc >= this.pcs.length) {
                    this.pcs = AU.doubleLengthShort(this.pcs);
                }
                if (bl) {
                    n2 = 2047;
                } else if (n == this.lastColor) {
                    n2 = this.lastColix;
                } else {
                    this.lastColor = n;
                    short s = C.getColix(this.lastColor);
                    n2 = s;
                    this.lastColix = s;
                }
                this.pcs[this.pc] = n2;
            }
        }
        return this.addPolygon(nArray, bS);
    }

    public int addPolygon(int[] nArray, BS bS) {
        int n = this.pc;
        if (n == 0) {
            this.pis = AU.newInt2(25);
        } else if (n == this.pis.length) {
            this.pis = (int[][])AU.doubleLength(this.pis);
        }
        if (bS != null) {
            bS.set(n);
        }
        this.pis[this.pc++] = nArray;
        return n;
    }

    public void invalidatePolygons() {
        int n = this.pc;
        while (--n >= this.mergePolygonCount0) {
            if (this.bsSlabDisplay != null && !this.bsSlabDisplay.get(n) || this.setABC(n) != null) continue;
            this.pis[n] = null;
        }
    }

    protected int[] setABC(int n) {
        if (!(this.bsSlabDisplay == null || this.bsSlabDisplay.get(n) || this.bsSlabGhost != null && this.bsSlabGhost.get(n))) {
            return null;
        }
        int[] nArray = this.pis[n];
        if (nArray == null || nArray.length < 3) {
            return null;
        }
        this.iA = nArray[0];
        this.iB = nArray[1];
        this.iC = nArray[2];
        return (int[])(this.vvs == null || !Float.isNaN(this.vvs[this.iA]) && !Float.isNaN(this.vvs[this.iB]) && !Float.isNaN(this.vvs[this.iC]) ? nArray : null);
    }

    public void setTranslucentVertices(BS bS) {
    }

    public String getSlabColor() {
        return this.bsSlabGhost == null ? null : C.getHexCode(this.slabColix);
    }

    public String getSlabType() {
        return this.bsSlabGhost != null && this.slabMeshType == 1073742018 ? "mesh" : null;
    }

    public void resetSlab() {
        if (this.slicer != null) {
            this.slicer.slabPolygons(TempArray.getSlabObjectType(1073742333, null, false, null), false);
        }
    }

    public void slabPolygonsList(Lst<Object[]> lst, boolean bl) {
        this.getMeshSlicer();
        int n = 0;
        while (n < lst.size()) {
            if (!this.slicer.slabPolygons((Object[])lst.get(n), bl)) break;
            ++n;
        }
    }

    protected void slabBrillouin(P3[] p3Array) {
    }

    public float getResolution() {
        return 0.0f;
    }

    public static MeshSurface getSphereData(int n) {
        Geodesic.createGeodesic(n);
        int n2 = Geodesic.getVertexCount(n);
        short[] sArray = Geodesic.getFaceVertexes(n);
        int n3 = sArray.length / 3;
        int[][] nArray = AU.newInt2(n3);
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            nArray[n4] = new int[]{sArray[n5++], sArray[n5++], sArray[n5++]};
            ++n4;
        }
        T3[] t3Array = new V3[n2];
        n5 = 0;
        while (n5 < n2) {
            t3Array[n5] = Geodesic.getVertexVector(n5);
            ++n5;
        }
        return MeshSurface.newMesh(true, t3Array, 0, nArray, t3Array, 0);
    }

    public void setBox(P3 p3, P3 p32) {
        p3.set(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        p32.set(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        int n = 0;
        while (n < this.vc) {
            T3 t3 = this.vs[n];
            if (!Float.isNaN(t3.x)) {
                BoxInfo.addPoint(t3, p3, p32, 0.0f);
            }
            ++n;
        }
    }

    public void setBoundingBox(P3[] p3Array) {
    }

    public static float getSphericalInterpolationFraction(double d, double d2, double d3, double d4) {
        double d5 = Math.abs(d + d2) / d4;
        double d6 = Math.abs(d + d3) / d4;
        double d7 = d5 * d5;
        double d8 = d7 - d6 * d6 + 1.0;
        double d9 = 4.0 * ((d /= d4) * d - d7);
        double d10 = d5 < d6 ? 1 : -1;
        return (float)((d8 + d10 * Math.sqrt(d8 * d8 + d9)) / 2.0);
    }
}

