/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.io.IOException;
import java.util.Set;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.xml.sax.SAXException;

public abstract class AbstractPrimitiveTask
extends PleaseWaitRunnable {
    protected final DataSet ds = new DataSet();
    protected boolean canceled;
    protected Exception lastException;
    private Set<PrimitiveId> missingPrimitives;
    protected final OsmDataLayer layer;
    protected MultiFetchServerObjectReader multiObjectReader;
    protected OsmServerObjectReader objectReader;
    private boolean zoom;
    private boolean downloadRelations;
    private boolean fullRelation;

    protected AbstractPrimitiveTask(String title, OsmDataLayer layer) {
        this(title, (ProgressMonitor)new PleaseWaitProgressMonitor(title), layer);
    }

    protected AbstractPrimitiveTask(String title, ProgressMonitor progressMonitor, OsmDataLayer layer) {
        super(title, progressMonitor, false);
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.layer = layer;
        if (!layer.isDownloadable()) {
            throw new IllegalArgumentException("Non-downloadable layer: " + layer);
        }
    }

    protected abstract void initMultiFetchReader(MultiFetchServerObjectReader var1);

    public final AbstractPrimitiveTask setZoom(boolean zoom) {
        this.zoom = zoom;
        return this;
    }

    public final AbstractPrimitiveTask setDownloadRelations(boolean downloadRelations, boolean fullRelation) {
        this.downloadRelations = downloadRelations;
        this.fullRelation = fullRelation;
        return this;
    }

    public Set<PrimitiveId> getMissingPrimitives() {
        return this.missingPrimitives;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            AbstractPrimitiveTask abstractPrimitiveTask = this;
            synchronized (abstractPrimitiveTask) {
                if (this.canceled) {
                    return;
                }
                this.multiObjectReader = MultiFetchServerObjectReader.create();
            }
            this.initMultiFetchReader(this.multiObjectReader);
            DataSet theirDataSet = this.multiObjectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            this.missingPrimitives = this.multiObjectReader.getMissingPrimitives();
            abstractPrimitiveTask = this;
            synchronized (abstractPrimitiveTask) {
                this.multiObjectReader = null;
            }
            new DataSetMerger(this.ds, theirDataSet).merge();
            if (this.downloadRelations) {
                this.loadIncompleteRelationMembers();
            }
            this.loadIncompleteNodes();
        }
        catch (OsmTransferException e) {
            if (this.canceled) {
                return;
            }
            this.lastException = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadIncompleteRelationMembers() throws OsmTransferException {
        for (Relation r : this.ds.getRelations()) {
            if (this.canceled) {
                return;
            }
            if (!r.isIncomplete() && !r.hasIncompleteMembers()) continue;
            AbstractPrimitiveTask abstractPrimitiveTask = this;
            synchronized (abstractPrimitiveTask) {
                if (this.canceled) {
                    return;
                }
                this.objectReader = new OsmServerObjectReader(r.getId(), OsmPrimitiveType.RELATION, this.fullRelation);
            }
            DataSet theirDataSet = this.objectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            AbstractPrimitiveTask abstractPrimitiveTask2 = this;
            synchronized (abstractPrimitiveTask2) {
                this.objectReader = null;
            }
            new DataSetMerger(this.ds, theirDataSet).merge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadIncompleteNodes() throws OsmTransferException {
        for (Way w : this.ds.getWays()) {
            if (this.canceled) {
                return;
            }
            if (!w.hasIncompleteNodes()) continue;
            AbstractPrimitiveTask abstractPrimitiveTask = this;
            synchronized (abstractPrimitiveTask) {
                if (this.canceled) {
                    return;
                }
                this.objectReader = new OsmServerObjectReader(w.getId(), OsmPrimitiveType.WAY, true);
            }
            DataSet theirDataSet = this.objectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            AbstractPrimitiveTask abstractPrimitiveTask2 = this;
            synchronized (abstractPrimitiveTask2) {
                this.objectReader = null;
            }
            new DataSetMerger(this.ds, theirDataSet).merge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        AbstractPrimitiveTask abstractPrimitiveTask = this;
        synchronized (abstractPrimitiveTask) {
            if (this.multiObjectReader != null) {
                this.multiObjectReader.cancel();
            }
            if (this.objectReader != null) {
                this.objectReader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        GuiHelper.runInEDTAndWait(() -> {
            this.layer.mergeFrom(this.ds);
            if (this.zoom && MainApplication.getMap() != null) {
                AutoScaleAction.zoomTo(this.ds.allPrimitives());
            }
            this.layer.onPostDownloadFromServer();
        });
    }
}

