/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoOperandInstr;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RaiseArgumentErrorInstr
extends NoOperandInstr
implements FixedArityInstr {
    private final int required;
    private final int opt;
    private final boolean rest;
    private final int numArgs;

    public RaiseArgumentErrorInstr(int required, int opt, boolean rest2, int numArgs) {
        super(Operation.RAISE_ARGUMENT_ERROR);
        this.required = required;
        this.opt = opt;
        this.rest = rest2;
        this.numArgs = numArgs;
    }

    public int getNumArgs() {
        return this.numArgs;
    }

    public int getOpt() {
        return this.opt;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"req: " + this.required, "o: " + this.opt, "*r: " + this.rest};
    }

    public int getRequired() {
        return this.required;
    }

    public boolean getRest() {
        return this.rest;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new RaiseArgumentErrorInstr(this.required, this.opt, this.rest, this.numArgs);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getRequired());
        e.encode(this.getOpt());
        e.encode(this.getRest());
        e.encode(this.getNumArgs());
    }

    public static RaiseArgumentErrorInstr decode(IRReaderDecoder d) {
        return new RaiseArgumentErrorInstr(d.decodeInt(), d.decodeInt(), d.decodeBoolean(), d.decodeInt());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Arity.raiseArgumentError(context.runtime, this.numArgs, this.required, this.required + this.opt);
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.RaiseArgumentErrorInstr(this);
    }
}

