"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class EventLoopDelayMetric {
    constructor(metricFeature) {
        this.TIME_INTERVAL = 1000;
        this.metricFeature = metricFeature;
    }
    init(config) {
        let oldTime = process.hrtime();
        const histogram = this.metricFeature.histogram({
            name: 'Event Loop Latency',
            type: 'internal/libuv/latency',
            measurement: 'mean',
            unit: 'ms'
        });
        if (histogram) {
            this.timer = setInterval(() => {
                const newTime = process.hrtime();
                const delay = (newTime[0] - oldTime[0]) * 1e3 + (newTime[1] - oldTime[1]) / 1e6 - this.TIME_INTERVAL;
                oldTime = newTime;
                histogram.update(delay);
            }, this.TIME_INTERVAL);
            this.timer.unref();
        }
    }
    destroy() {
        clearInterval(this.timer);
    }
}
exports.default = EventLoopDelayMetric;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXZlbnRMb29wRGVsYXkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvbWV0cmljcy9ldmVudExvb3BEZWxheS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUdBO0lBTUUsWUFBYSxhQUE2QjtRQUN4QyxJQUFJLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQTtRQUN6QixJQUFJLENBQUMsYUFBYSxHQUFHLGFBQWEsQ0FBQTtJQUNwQyxDQUFDO0lBRUQsSUFBSSxDQUFFLE1BQXNCO1FBQzFCLElBQUksT0FBTyxHQUFHLE9BQU8sQ0FBQyxNQUFNLEVBQUUsQ0FBQTtRQUU5QixNQUFNLFNBQVMsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQztZQUM3QyxJQUFJLEVBQUUsb0JBQW9CO1lBQzFCLElBQUksRUFBRSx3QkFBd0I7WUFDOUIsV0FBVyxFQUFFLE1BQU07WUFDbkIsSUFBSSxFQUFFLElBQUk7U0FDWCxDQUFDLENBQUE7UUFFRixJQUFJLFNBQVMsRUFBRTtZQUNiLElBQUksQ0FBQyxLQUFLLEdBQUcsV0FBVyxDQUFDLEdBQUcsRUFBRTtnQkFDNUIsTUFBTSxPQUFPLEdBQUcsT0FBTyxDQUFDLE1BQU0sRUFBRSxDQUFBO2dCQUNoQyxNQUFNLEtBQUssR0FBRyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsR0FBRyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEdBQUcsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEdBQUcsR0FBRyxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUE7Z0JBQ3BHLE9BQU8sR0FBRyxPQUFPLENBQUE7Z0JBQ2pCLFNBQVMsQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUE7WUFDekIsQ0FBQyxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQTtZQUV0QixJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFBO1NBQ25CO0lBQ0gsQ0FBQztJQUVELE9BQU87UUFDTCxhQUFhLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFBO0lBQzNCLENBQUM7Q0FDRjtBQXBDRCx1Q0FvQ0MifQ==