/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import sbt.ForkConfiguration;
import sbt.ForkTags;
import sbt.FrameworkWrapper;
import sbt.testing.AnnotatedFingerprint;
import sbt.testing.Event;
import sbt.testing.EventHandler;
import sbt.testing.Fingerprint;
import sbt.testing.Framework;
import sbt.testing.Logger;
import sbt.testing.OptionalThrowable;
import sbt.testing.Runner;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.SubclassFingerprint;
import sbt.testing.SuiteSelector;
import sbt.testing.Task;
import sbt.testing.TaskDef;

public final class ForkMain {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        Socket socket = new Socket(InetAddress.getByName(null), (int)Integer.valueOf(stringArray[0]));
        ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
        objectOutputStream.flush();
        try {
            new Run().run(objectInputStream, objectOutputStream);
        }
        finally {
            try {
                objectInputStream.close();
                objectOutputStream.close();
            }
            finally {
                System.exit(0);
            }
        }
    }

    private static final class Run {
        private Run() {
        }

        private void run(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) {
            try {
                this.runTests(objectInputStream, objectOutputStream);
            }
            catch (RunAborted runAborted) {
                this.internalError(runAborted);
            }
            catch (Throwable throwable) {
                try {
                    this.logError(objectOutputStream, "Uncaught exception when running tests: " + throwable.toString());
                    this.write(objectOutputStream, new ForkError(throwable));
                }
                catch (Throwable throwable2) {
                    this.internalError(throwable2);
                }
            }
        }

        private boolean matches(Fingerprint fingerprint, Fingerprint fingerprint2) {
            if (fingerprint instanceof SubclassFingerprint && fingerprint2 instanceof SubclassFingerprint) {
                SubclassFingerprint subclassFingerprint = (SubclassFingerprint)fingerprint;
                SubclassFingerprint subclassFingerprint2 = (SubclassFingerprint)fingerprint2;
                return subclassFingerprint.isModule() == subclassFingerprint2.isModule() && subclassFingerprint.superclassName().equals(subclassFingerprint2.superclassName());
            }
            if (fingerprint instanceof AnnotatedFingerprint && fingerprint2 instanceof AnnotatedFingerprint) {
                AnnotatedFingerprint annotatedFingerprint = (AnnotatedFingerprint)fingerprint;
                AnnotatedFingerprint annotatedFingerprint2 = (AnnotatedFingerprint)fingerprint2;
                return annotatedFingerprint.isModule() == annotatedFingerprint2.isModule() && annotatedFingerprint.annotationName().equals(annotatedFingerprint2.annotationName());
            }
            return false;
        }

        private synchronized void write(ObjectOutputStream objectOutputStream, Object object) {
            try {
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
            }
            catch (IOException iOException) {
                throw new RunAborted(iOException);
            }
        }

        private void log(ObjectOutputStream objectOutputStream, String string, ForkTags forkTags) {
            this.write(objectOutputStream, new Object[]{forkTags, string});
        }

        private void logDebug(ObjectOutputStream objectOutputStream, String string) {
            this.log(objectOutputStream, string, ForkTags.Debug);
        }

        private void logInfo(ObjectOutputStream objectOutputStream, String string) {
            this.log(objectOutputStream, string, ForkTags.Info);
        }

        private void logWarn(ObjectOutputStream objectOutputStream, String string) {
            this.log(objectOutputStream, string, ForkTags.Warn);
        }

        private void logError(ObjectOutputStream objectOutputStream, String string) {
            this.log(objectOutputStream, string, ForkTags.Error);
        }

        private Logger remoteLogger(final boolean bl, final ObjectOutputStream objectOutputStream) {
            return new Logger(){

                public boolean ansiCodesSupported() {
                    return bl;
                }

                public void error(String string) {
                    this.logError(objectOutputStream, string);
                }

                public void warn(String string) {
                    this.logWarn(objectOutputStream, string);
                }

                public void info(String string) {
                    this.logInfo(objectOutputStream, string);
                }

                public void debug(String string) {
                    this.logDebug(objectOutputStream, string);
                }

                public void trace(Throwable throwable) {
                    this.write(objectOutputStream, new ForkError(throwable));
                }
            };
        }

        private void writeEvents(ObjectOutputStream objectOutputStream, TaskDef taskDef, ForkEvent[] forkEventArray) {
            this.write(objectOutputStream, new Object[]{taskDef.fullyQualifiedName(), forkEventArray});
        }

        private ExecutorService executorService(ForkConfiguration forkConfiguration, ObjectOutputStream objectOutputStream) {
            if (forkConfiguration.isParallel()) {
                int n = Runtime.getRuntime().availableProcessors();
                this.logDebug(objectOutputStream, "Create a test executor with a thread pool of " + n + " threads.");
                return Executors.newFixedThreadPool(n);
            }
            this.logDebug(objectOutputStream, "Create a single-thread test executor");
            return Executors.newSingleThreadExecutor();
        }

        /*
         * WARNING - void declaration
         */
        private void runTests(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) throws Exception {
            ForkConfiguration forkConfiguration = (ForkConfiguration)objectInputStream.readObject();
            ExecutorService executorService = this.executorService(forkConfiguration, objectOutputStream);
            TaskDef[] taskDefArray = (TaskDef[])objectInputStream.readObject();
            int n = objectInputStream.readInt();
            Logger[] loggerArray = new Logger[]{this.remoteLogger(forkConfiguration.isAnsiCodesSupported(), objectOutputStream)};
            for (int i = 0; i < n; ++i) {
                void var16_21;
                Object object;
                String[] stringArray = (String[])objectInputStream.readObject();
                String[] stringArray2 = (String[])objectInputStream.readObject();
                String[] stringArray3 = (String[])objectInputStream.readObject();
                Framework framework = null;
                for (String string : stringArray) {
                    try {
                        object = Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        if (object instanceof Framework) {
                            framework = (Framework)object;
                            break;
                        }
                        framework = new FrameworkWrapper((org.scalatools.testing.Framework)object);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.logDebug(objectOutputStream, "Framework implementation '" + string + "' not present.");
                    }
                }
                if (framework == null) continue;
                ArrayList arrayList = new ArrayList();
                Runner runner = framework.fingerprints();
                int n2 = ((Fingerprint[])runner).length;
                boolean bl = false;
                while (var16_21 < n2) {
                    object = runner[var16_21];
                    for (TaskDef taskDef : taskDefArray) {
                        if (!this.matches((Fingerprint)object, taskDef.fingerprint())) continue;
                        arrayList.add(new TaskDef(taskDef.fullyQualifiedName(), taskDef.fingerprint(), taskDef.explicitlySpecified(), taskDef.selectors()));
                    }
                    ++var16_21;
                }
                runner = framework.runner(stringArray2, stringArray3, this.getClass().getClassLoader());
                Task[] taskArray = runner.tasks(arrayList.toArray(new TaskDef[arrayList.size()]));
                this.logDebug(objectOutputStream, "Runner for " + framework.getClass().getName() + " produced " + taskArray.length + " initial tasks for " + arrayList.size() + " tests.");
                Thread thread = new Thread(() -> runner.done());
                Runtime.getRuntime().addShutdownHook(thread);
                this.runTestTasks(executorService, taskArray, loggerArray, objectOutputStream);
                runner.done();
                Runtime.getRuntime().removeShutdownHook(thread);
            }
            this.write(objectOutputStream, (Object)ForkTags.Done);
            objectInputStream.readObject();
        }

        /*
         * WARNING - void declaration
         */
        private void runTestTasks(ExecutorService executorService, Task[] taskArray, Logger[] loggerArray, ObjectOutputStream objectOutputStream) {
            if (taskArray.length > 0) {
                void future;
                ArrayList<Future<Task[]>> arrayList = new ArrayList<Future<Task[]>>();
                Object arrayList2 = taskArray;
                int n = ((Task[])arrayList2).length;
                boolean bl = false;
                while (future < n) {
                    Task exception = arrayList2[future];
                    arrayList.add(this.runTest(executorService, exception, loggerArray, objectOutputStream));
                    ++future;
                }
                arrayList2 = new ArrayList();
                for (Future future2 : arrayList) {
                    try {
                        arrayList2.addAll(Arrays.asList((Object[])future2.get()));
                    }
                    catch (Exception exception) {
                        this.logError(objectOutputStream, "Failed to execute task " + future2);
                    }
                }
                this.runTestTasks(executorService, arrayList2.toArray(new Task[arrayList2.size()]), loggerArray, objectOutputStream);
            }
        }

        private Future<Task[]> runTest(ExecutorService executorService, Task task, Logger[] loggerArray, ObjectOutputStream objectOutputStream) {
            return executorService.submit(() -> {
                ForkEvent[] forkEventArray;
                Task[] taskArray;
                TaskDef taskDef = task.taskDef();
                try {
                    final ConcurrentLinkedDeque concurrentLinkedDeque = new ConcurrentLinkedDeque();
                    EventHandler eventHandler = new EventHandler(){

                        public void handle(Event event) {
                            concurrentLinkedDeque.add(new ForkEvent(event));
                        }
                    };
                    this.logDebug(objectOutputStream, "  Running " + taskDef);
                    taskArray = task.execute(eventHandler, loggerArray);
                    if (taskArray.length > 0 || concurrentLinkedDeque.size() > 0) {
                        this.logDebug(objectOutputStream, "    Produced " + taskArray.length + " nested tasks and " + concurrentLinkedDeque.size() + " events.");
                    }
                    forkEventArray = concurrentLinkedDeque.toArray(new ForkEvent[concurrentLinkedDeque.size()]);
                }
                catch (Throwable throwable) {
                    taskArray = new Task[]{};
                    forkEventArray = new ForkEvent[]{this.testError(objectOutputStream, taskDef, "Uncaught exception when running " + taskDef.fullyQualifiedName() + ": " + throwable.toString(), throwable)};
                }
                this.writeEvents(objectOutputStream, taskDef, forkEventArray);
                return taskArray;
            });
        }

        private void internalError(Throwable throwable) {
            System.err.println("Internal error when running tests: " + throwable.toString());
        }

        private ForkEvent testEvent(final String string, final Fingerprint fingerprint, final Selector selector, final Status status, ForkError forkError, final long l) {
            final OptionalThrowable optionalThrowable = forkError == null ? new OptionalThrowable() : new OptionalThrowable((Throwable)forkError);
            return new ForkEvent(new Event(){

                public String fullyQualifiedName() {
                    return string;
                }

                public Fingerprint fingerprint() {
                    return fingerprint;
                }

                public Selector selector() {
                    return selector;
                }

                public Status status() {
                    return status;
                }

                public OptionalThrowable throwable() {
                    return optionalThrowable;
                }

                public long duration() {
                    return l;
                }
            });
        }

        private ForkEvent testError(ObjectOutputStream objectOutputStream, TaskDef taskDef, String string, Throwable throwable) {
            this.logError(objectOutputStream, string);
            ForkError forkError = new ForkError(throwable);
            this.write(objectOutputStream, forkError);
            return this.testEvent(taskDef.fullyQualifiedName(), taskDef.fingerprint(), (Selector)new SuiteSelector(), Status.Error, forkError, 0L);
        }

        class RunAborted
        extends RuntimeException {
            RunAborted(Exception exception) {
                super(exception);
            }
        }
    }

    static final class ForkError
    extends Exception {
        private final String originalMessage;
        private final String originalName;
        private ForkError cause;

        ForkError(Throwable throwable) {
            this.originalMessage = throwable.getMessage();
            this.originalName = throwable.getClass().getName();
            this.setStackTrace(throwable.getStackTrace());
            if (throwable.getCause() != null) {
                this.cause = new ForkError(throwable.getCause());
            }
        }

        @Override
        public String getMessage() {
            return this.originalName + ": " + this.originalMessage;
        }

        @Override
        public Exception getCause() {
            return this.cause;
        }
    }

    static final class ForkEvent
    implements Event,
    Serializable {
        private final String fullyQualifiedName;
        private final Fingerprint fingerprint;
        private final Selector selector;
        private final Status status;
        private final OptionalThrowable throwable;
        private final long duration;

        ForkEvent(Event event) {
            this.fullyQualifiedName = event.fullyQualifiedName();
            Fingerprint fingerprint = event.fingerprint();
            this.fingerprint = fingerprint instanceof SubclassFingerprint ? new SubclassFingerscan((SubclassFingerprint)fingerprint) : new AnnotatedFingerscan((AnnotatedFingerprint)fingerprint);
            this.selector = event.selector();
            ForkEvent.checkSerializableSelector(this.selector);
            this.status = event.status();
            OptionalThrowable optionalThrowable = event.throwable();
            this.throwable = optionalThrowable.isDefined() ? new OptionalThrowable((Throwable)new ForkError(optionalThrowable.get())) : optionalThrowable;
            this.duration = event.duration();
        }

        public String fullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public Fingerprint fingerprint() {
            return this.fingerprint;
        }

        public Selector selector() {
            return this.selector;
        }

        public Status status() {
            return this.status;
        }

        public OptionalThrowable throwable() {
            return this.throwable;
        }

        public long duration() {
            return this.duration;
        }

        private static void checkSerializableSelector(Selector selector) {
            if (!(selector instanceof Serializable)) {
                throw new UnsupportedOperationException("Selector implementation must be Serializable, but " + selector.getClass().getName() + " is not.");
            }
        }
    }

    static final class AnnotatedFingerscan
    implements AnnotatedFingerprint,
    Serializable {
        private final boolean isModule;
        private final String annotationName;

        AnnotatedFingerscan(AnnotatedFingerprint annotatedFingerprint) {
            this.isModule = annotatedFingerprint.isModule();
            this.annotationName = annotatedFingerprint.annotationName();
        }

        public boolean isModule() {
            return this.isModule;
        }

        public String annotationName() {
            return this.annotationName;
        }
    }

    static final class SubclassFingerscan
    implements SubclassFingerprint,
    Serializable {
        private final boolean isModule;
        private final String superclassName;
        private final boolean requireNoArgConstructor;

        SubclassFingerscan(SubclassFingerprint subclassFingerprint) {
            this.isModule = subclassFingerprint.isModule();
            this.superclassName = subclassFingerprint.superclassName();
            this.requireNoArgConstructor = subclassFingerprint.requireNoArgConstructor();
        }

        public boolean isModule() {
            return this.isModule;
        }

        public String superclassName() {
            return this.superclassName;
        }

        public boolean requireNoArgConstructor() {
            return this.requireNoArgConstructor;
        }
    }
}

