/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.message;

import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.ArrowStroke;
import net.sf.sdedit.message.ForwardMessage;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Direction;

public class Answer
extends Message {
    private final ForwardMessage forward;

    public Answer(Lifeline caller, Lifeline callee, SequenceDiagram diagram, MessageData data, ForwardMessage forwardMsg) {
        super(caller, callee, diagram, data);
        this.forward = forwardMsg;
    }

    public final ForwardMessage getForwardMessage() {
        return this.forward;
    }

    @Override
    protected void execute() {
        this.getDiagram().getFragmentManager().finishFragmentsNotIncluding(this);
        if (this.getCallee().isAlwaysActive()) {
            return;
        }
        ArrowStroke stroke = this.getCallee().isExternal() || this.getText().equals("") && this.getCallee().isAlwaysActive() ? ArrowStroke.NONE : ArrowStroke.DASHED;
        this.getDiagram().getPaintDevice().announce(Arrow.getInnerHeight(this) + this.diagram.arrowSize / 2);
        Arrow arrow = this.getCaller().getPosition() < this.getCallee().getPosition() ? new Arrow(this, stroke, Direction.RIGHT, this.v()) : new Arrow(this, stroke, Direction.LEFT, this.v());
        arrow.setVisible(this.getText().length() > 0 || this.diagram.returnArrowVisible);
        this.setArrow(arrow);
        this.getDiagram().getPaintDevice().append(arrow);
        this.extendLifelines(arrow.getInnerHeight());
        if (!this.getCaller().isAlwaysActive()) {
            this.terminate();
        }
    }

    protected final void terminate() {
        this.getCaller().finish();
        if (this.getCaller().getRoot() != this.getCaller()) {
            this.getCaller().dispose();
        }
    }

    @Override
    public String getText() {
        return this.getData().getAnswer();
    }
}

