/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.zeroc.IceGrid.ApplicationDescriptor;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.ListTextField;
import com.zeroc.IceGridGUI.Application.Root;
import com.zeroc.IceGridGUI.Application.SimpleMapField;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.MainPane;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class ApplicationEditor
extends Editor {
    private static final Object NO_DISTRIB = new Object(){

        public String toString() {
            return "None selected";
        }
    };
    private JTextField _name = new JTextField(20);
    private JTextArea _description = new JTextArea(3, 20);
    private SimpleMapField _variables;
    private JComboBox _distrib;
    private ListTextField _distribDirs = new ListTextField(20);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean applyUpdate(boolean refresh) {
        Root root = (Root)this._target;
        MainPane mainPane = this._target.getCoordinator().getMainPane();
        root.disableSelectionListener();
        try {
            if (this.isSimpleUpdate()) {
                this.writeDescriptor();
                root.updated();
                root.getEditable().markModified();
            } else {
                ApplicationDescriptor savedDescriptor = root.saveDescriptor();
                this.writeDescriptor();
                try {
                    root.rebuild();
                }
                catch (UpdateFailedException e) {
                    root.restoreDescriptor(savedDescriptor);
                    JOptionPane.showMessageDialog(root.getCoordinator().getMainFrame(), e.toString(), "Apply failed", 0);
                    boolean bl = false;
                    root.enableSelectionListener();
                    return bl;
                }
                root.updated();
                root.getEditable().markModified();
                if (!savedDescriptor.name.equals(root.getId())) {
                    mainPane.resetTitle(root);
                    root.getTreeModel().nodeChanged(root);
                }
            }
            this._applyButton.setEnabled(false);
            this._discardButton.setEnabled(false);
            boolean bl = true;
            return bl;
        }
        finally {
            root.enableSelectionListener();
        }
    }

    ApplicationEditor() {
        this._name.getDocument().addDocumentListener(this._updateListener);
        this._description.getDocument().addDocumentListener(this._updateListener);
        this._variables = new SimpleMapField(this, false, "Name", "Value");
        this._distrib = new JComboBox<Object>(new Object[]{NO_DISTRIB, "${application}.IcePatch2/server"});
        this._distrib.setEditable(true);
        this._distrib.setToolTipText("The proxy to the IcePatch2 server holding your files");
        JTextField distribTextField = (JTextField)this._distrib.getEditor().getEditorComponent();
        distribTextField.getDocument().addDocumentListener(this._updateListener);
        this._distribDirs.getDocument().addDocumentListener(this._updateListener);
        this._distribDirs.setToolTipText("<html>Include only these directories when patching.<br>Use whitespace as separator; use double-quotes around directories containing whitespaces</html>");
    }

    @Override
    protected void appendProperties(DefaultFormBuilder builder) {
        builder.append("Name");
        builder.append((Component)this._name, 3);
        builder.append("Description");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-2);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._description);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 3));
        builder.nextRow(2);
        builder.nextLine();
        builder.append("Variables");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._variables);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
        JComponent c = builder.appendSeparator("Distribution");
        c.setToolTipText("Files shared by all servers in your application");
        builder.append("IcePatch2 Proxy");
        builder.append((Component)this._distrib, 3);
        builder.nextLine();
        builder.append("Directories");
        builder.append((Component)this._distribDirs, 3);
        builder.nextLine();
    }

    @Override
    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Application Properties");
    }

    boolean isSimpleUpdate() {
        ApplicationDescriptor descriptor = (ApplicationDescriptor)this._target.getDescriptor();
        return descriptor.name.equals(this._name.getText().trim()) && this._variables.get().equals(descriptor.variables);
    }

    void writeDescriptor() {
        ApplicationDescriptor descriptor = (ApplicationDescriptor)this._target.getDescriptor();
        descriptor.name = this._name.getText().trim();
        descriptor.variables = this._variables.get();
        descriptor.description = this._description.getText();
        descriptor.distrib.icepatch = this._distrib.getSelectedItem() == NO_DISTRIB ? "" : this._distrib.getSelectedItem().toString().trim();
        descriptor.distrib.directories = this._distribDirs.getList();
    }

    @Override
    protected boolean validate() {
        return this.check(new String[]{"Name", this._name.getText().trim()});
    }

    void show(Root root) {
        this.detectUpdates(false);
        this._target = root;
        Utils.Resolver resolver = this.getDetailResolver();
        boolean isEditable = resolver == null;
        ApplicationDescriptor descriptor = (ApplicationDescriptor)root.getDescriptor();
        this._name.setText(descriptor.name);
        this._name.setEditable(!root.isLive() && isEditable);
        this._description.setText(Utils.substitute(descriptor.description, resolver));
        this._description.setEditable(isEditable);
        this._description.setOpaque(isEditable);
        this._description.setToolTipText("An optional description for this application");
        this._variables.set(descriptor.variables, resolver, isEditable);
        this._distrib.setEnabled(true);
        this._distrib.setEditable(true);
        String icepatch = Utils.substitute(descriptor.distrib.icepatch, resolver);
        if (icepatch.equals("")) {
            this._distrib.setSelectedItem(NO_DISTRIB);
        } else {
            this._distrib.setSelectedItem(icepatch);
        }
        this._distrib.setEnabled(isEditable);
        this._distrib.setEditable(isEditable);
        this._distribDirs.setList(descriptor.distrib.directories, resolver);
        this._distribDirs.setEditable(isEditable);
        this._applyButton.setEnabled(false);
        this._discardButton.setEnabled(false);
        this.detectUpdates(true);
    }

    @Override
    Utils.Resolver getDetailResolver() {
        if (this._target.getCoordinator().substitute()) {
            return this._target.getResolver();
        }
        return null;
    }
}

