#ifndef _EFL_INTERPOLATOR_ACCELERATE_EO_H_
#define _EFL_INTERPOLATOR_ACCELERATE_EO_H_

#ifndef _EFL_INTERPOLATOR_ACCELERATE_EO_CLASS_TYPE
#define _EFL_INTERPOLATOR_ACCELERATE_EO_CLASS_TYPE

typedef Eo Efl_Interpolator_Accelerate;

#endif

#ifndef _EFL_INTERPOLATOR_ACCELERATE_EO_TYPES
#define _EFL_INTERPOLATOR_ACCELERATE_EO_TYPES


#endif
/**
 * @brief Efl accelerate interpolator class
 *
 * output = 1 - sin(Pi / 2 + input * Pi / 2);
 *
 * @ingroup Efl_Interpolator_Accelerate
 */
#define EFL_INTERPOLATOR_ACCELERATE_CLASS efl_interpolator_accelerate_class_get()

EWAPI const Efl_Class *efl_interpolator_accelerate_class_get(void);

/**
 * @brief Factor property
 *
 * @param[in] obj The object.
 * @param[in] factor Factor of the interpolation function.
 *
 * @ingroup Efl_Interpolator_Accelerate
 */
EOAPI void efl_interpolator_accelerate_factor_set(Eo *obj, double factor);

/**
 * @brief Factor property
 *
 * @param[in] obj The object.
 *
 * @return Factor of the interpolation function.
 *
 * @ingroup Efl_Interpolator_Accelerate
 */
EOAPI double efl_interpolator_accelerate_factor_get(const Eo *obj);

#endif
