#ifndef _EFL_CANVAS_GESTURE_RECOGNIZER_EO_H_
#define _EFL_CANVAS_GESTURE_RECOGNIZER_EO_H_

#ifndef _EFL_CANVAS_GESTURE_RECOGNIZER_EO_CLASS_TYPE
#define _EFL_CANVAS_GESTURE_RECOGNIZER_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Gesture_Recognizer;

#endif

#ifndef _EFL_CANVAS_GESTURE_RECOGNIZER_EO_TYPES
#define _EFL_CANVAS_GESTURE_RECOGNIZER_EO_TYPES


#endif
/** EFL Gesture Recognizer abstract class
 *
 * @ingroup Efl_Canvas_Gesture_Recognizer
 */
#define EFL_CANVAS_GESTURE_RECOGNIZER_CLASS efl_canvas_gesture_recognizer_class_get()

EWAPI const Efl_Class *efl_canvas_gesture_recognizer_class_get(void);

/**
 * @brief This function is called to create a new Efl.Canvas.Gesture object for
 * the given target
 *
 * @param[in] obj The object.
 * @param[in] target The target widget
 *
 * @return Returns the Efl.Canvas.Gesture event object
 *
 * @ingroup Efl_Canvas_Gesture_Recognizer
 */
EOAPI Efl_Canvas_Gesture *efl_gesture_recognizer_create(Eo *obj, Efl_Object *target);

/**
 * @brief Handles the given event for the watched object.
 *
 * Updates the state of the gesture object as required, and returns a suitable
 * result for the current recognition step.
 *
 * @param[in] obj The object.
 * @param[in] gesture The gesture object
 * @param[in] watched The watched object
 * @param[in] event The pointer event
 *
 * @return Returns the Efl.Canvas.Gesture event object
 *
 * @ingroup Efl_Canvas_Gesture_Recognizer
 */
EOAPI Efl_Canvas_Gesture_Recognizer_Result efl_gesture_recognizer_recognize(Eo *obj, Efl_Canvas_Gesture *gesture, Efl_Object *watched, Efl_Canvas_Gesture_Touch *event);

/**
 * @brief This function is called by the framework to reset a given gesture.
 *
 * @param[in] obj The object.
 * @param[in] gesture The gesture object
 *
 * @ingroup Efl_Canvas_Gesture_Recognizer
 */
EOAPI void efl_gesture_recognizer_reset(Eo *obj, Efl_Canvas_Gesture *gesture);

/**
 * @brief This property holds the config value for the recognizer
 *
 * @param[in] obj The object.
 * @param[in] name propery name
 *
 * @return value of the property
 *
 * @ingroup Efl_Canvas_Gesture_Recognizer
 */
EOAPI Eina_Value *efl_gesture_recognizer_config_get(const Eo *obj, const char *name);

#endif
