/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import org.jetbrains.annotations.Nullable;

public final class FieldArg
extends RegisterArg {
    private final FieldInfo field;
    @Nullable
    private final InsnArg instArg;

    public FieldArg(FieldInfo field, @Nullable InsnArg reg) {
        super(-1);
        this.instArg = reg;
        this.field = field;
    }

    public FieldInfo getField() {
        return this.field;
    }

    public InsnArg getInstanceArg() {
        return this.instArg;
    }

    public boolean isStatic() {
        return this.instArg == null;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public boolean isRegister() {
        return false;
    }

    @Override
    public void setType(ArgType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldArg) || !super.equals(obj)) {
            return false;
        }
        FieldArg fieldArg = (FieldArg)obj;
        if (!this.field.equals(fieldArg.field)) {
            return false;
        }
        return !(this.instArg != null ? !this.instArg.equals(fieldArg.instArg) : fieldArg.instArg != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + (this.instArg != null ? this.instArg.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "(" + this.field + ")";
    }
}

