"use strict";
const pmx_1 = require("./pmx");
const entrypoint_1 = require("./features/entrypoint");
//let io: PMX
var io;
if (process.env.PMX_FORCE_UPDATE) {
    io = new pmx_1.default();
    io.init();
    io.Entrypoint = entrypoint_1.default;
}
else {
    // -----------------------------------
    // create a unique, global symbol name
    // -----------------------------------
    const IO_KEY = Symbol.for('@pm2/io');
    // ------------------------------------------
    // check if the global object has this symbol
    // add it if it does not have the symbol, yet
    // ------------------------------------------
    const globalSymbols = Object.getOwnPropertySymbols(global);
    const hasKey = (globalSymbols.indexOf(IO_KEY) > -1);
    if (!hasKey) {
        io = global[IO_KEY] = new pmx_1.default();
    }
    if (!hasKey) {
        global[IO_KEY].Entrypoint = entrypoint_1.default;
        // Freeze API, cannot be modified
        //Object.freeze(global[IO_KEY])
    }
    io = global[IO_KEY];
}
module.exports = io;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUNBLCtCQUF1QjtBQUN2QixzREFBOEM7QUFFOUMsYUFBYTtBQUNiLElBQUksRUFBRSxDQUFBO0FBRU4sSUFBSSxPQUFPLENBQUMsR0FBRyxDQUFDLGdCQUFnQixFQUFFO0lBQ2hDLEVBQUUsR0FBRyxJQUFJLGFBQUcsRUFBRSxDQUFBO0lBQ2QsRUFBRSxDQUFDLElBQUksRUFBRSxDQUFBO0lBQ1QsRUFBRSxDQUFDLFVBQVUsR0FBRyxvQkFBVSxDQUFBO0NBQzNCO0tBQ0k7SUFDSCxzQ0FBc0M7SUFDdEMsc0NBQXNDO0lBQ3RDLHNDQUFzQztJQUN0QyxNQUFNLE1BQU0sR0FBRyxNQUFNLENBQUMsR0FBRyxDQUFDLFNBQVMsQ0FBQyxDQUFBO0lBRXBDLDZDQUE2QztJQUM3Qyw2Q0FBNkM7SUFDN0MsNkNBQTZDO0lBQzdDLDZDQUE2QztJQUM3QyxNQUFNLGFBQWEsR0FBRyxNQUFNLENBQUMscUJBQXFCLENBQUMsTUFBTSxDQUFDLENBQUE7SUFDMUQsTUFBTSxNQUFNLEdBQUcsQ0FBQyxhQUFhLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUE7SUFFbkQsSUFBSSxDQUFDLE1BQU0sRUFBRTtRQUNYLEVBQUUsR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDLEdBQUcsSUFBSSxhQUFHLEVBQUUsQ0FBQTtLQUNoQztJQUVELElBQUksQ0FBQyxNQUFNLEVBQUU7UUFDWCxNQUFNLENBQUMsTUFBTSxDQUFDLENBQUMsVUFBVSxHQUFHLG9CQUFVLENBQUE7UUFFdEMsaUNBQWlDO1FBQ2pDLCtCQUErQjtLQUNoQztJQUVELEVBQUUsR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDLENBQUE7Q0FDcEI7QUFFRCxpQkFBUyxFQUFFLENBQUEifQ==