/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.text;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.LifelineFlag;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.diagram.SequenceDiagramDataProvider;
import net.sf.sdedit.drawable.Note;
import net.sf.sdedit.error.SyntaxError;
import net.sf.sdedit.text.AbstractTextHandler;
import net.sf.sdedit.text.TextBasedMessageData;
import net.sf.sdedit.util.Grep;
import net.sf.sdedit.util.Pair;

public class TextHandler
extends AbstractTextHandler
implements SequenceDiagramDataProvider {
    private int section = -1;
    private String title;
    private String[] description;
    private Map<Lifeline, String> annotations;
    private int objectSectionEnd = 0;
    private SequenceDiagram diagram;
    private final Grep grep = new Grep(Grep.DEFAULT_UNESCAPE);
    private Map<String, String> userData;

    public TextHandler(String text) {
        super(text);
        this.annotations = new HashMap<Lifeline, String>();
        this.reset();
    }

    @Override
    public SequenceDiagram getDiagram() {
        return this.diagram;
    }

    @Override
    public void setDiagram(SequenceDiagram diagram) {
        this.diagram = diagram;
    }

    @Override
    public Object getState() {
        return this.getLineBegin();
    }

    public int getObjectSectionEnd() {
        if (this.section > 0) {
            return this.objectSectionEnd;
        }
        return this.getLineNumber();
    }

    @Override
    protected void reset() {
        super.reset();
        String[] titleString = this.grep.parse("(?s).*#!\\[([^\n\r]*?)\\].*", this.text());
        this.title = titleString == null ? null : titleString[0];
        String[] descString = this.grep.parse("(?s).*#!>>(.*)#!<<.*", this.text());
        this.description = descString == null ? null : descString[0].trim().split("\n");
        for (int i = 0; this.description != null && i < this.description.length; ++i) {
            this.description[i] = this.description[i].trim();
            if (!this.description[i].startsWith("#!")) {
                this.description = null;
                continue;
            }
            this.description[i] = this.description[i].replaceFirst("#!", "");
        }
        this.section = -1;
        this.annotations.clear();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String[] getDescription() {
        return this.description;
    }

    @Override
    public boolean advance() {
        return this.advance(true);
    }

    private void updateUserData(String txt) {
        if (txt.length() == 0) {
            this.userData = null;
        } else {
            this.userData = new HashMap<String, String>();
            for (String part : txt.split(";")) {
                int i = part.indexOf(58);
                if (i <= 0) continue;
                String key = part.substring(0, i).trim();
                key = key.toLowerCase();
                String value = part.substring(i + 1).trim();
                if (value.length() == 0) {
                    this.userData.remove(key);
                    continue;
                }
                this.userData.put(key, value);
            }
        }
    }

    private boolean advance(boolean ignoreEmptyLines) {
        try {
            String line;
            if (!this.ready()) {
                this.section = 1;
                return false;
            }
            do {
                int cmt;
                if ((line = this.readLine()) == null) {
                    this.section = 1;
                    return false;
                }
                if (ignoreEmptyLines) {
                    line = line.trim();
                }
                if (this.section == 1 && line.trim().startsWith("#!")) {
                    this.updateUserData(line.trim().substring(2));
                }
                if (this.section == -1 && (line.equals("") || line.startsWith("#"))) continue;
                this.section = Math.max(0, this.section);
                if (this.section == 0 && (cmt = line.indexOf("#")) >= 0) {
                    line = line.substring(0, cmt).trim();
                }
                if (this.section != 0 || !line.equals("")) continue;
                this.objectSectionEnd = this.getLineNumber() - 1;
                this.section = 1;
                return false;
            } while (ignoreEmptyLines && (line.equals("") || line.startsWith("#")));
            this.setCurrentLine(line);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String openFragment() {
        if (this.section == 0) {
            throw new IllegalStateException("not all objects have been read");
        }
        if (this.currentLine() == null) {
            throw new IllegalStateException("nothing to read");
        }
        if (this.currentLine().startsWith("//")) {
            System.err.println("Warning: Comments starting with // are deprecated. Use [c:<type> <text>]...[/c].");
            return this.currentLine().substring(2).trim();
        }
        if (this.currentLine().endsWith("]") && this.currentLine().startsWith("[c")) {
            return this.currentLine();
        }
        return null;
    }

    @Override
    public String getFragmentSeparator() {
        if (this.section == 0) {
            throw new IllegalStateException("not all objects have been read");
        }
        if (this.currentLine() == null) {
            throw new IllegalStateException("nothing to read");
        }
        if (this.currentLine().startsWith("--")) {
            return this.currentLine().substring(2);
        }
        return null;
    }

    @Override
    public boolean closeFragment() {
        if (this.section == 0) {
            throw new IllegalStateException("not all objects have been read");
        }
        if (this.currentLine() == null) {
            throw new IllegalStateException("nothing to read");
        }
        return this.currentLine().equals("\\\\") || this.currentLine().endsWith("]") && this.currentLine().startsWith("[/c");
    }

    @Override
    public MessageData nextMessage() throws SyntaxError {
        TextBasedMessageData data;
        if (this.section == 0) {
            throw new IllegalStateException("not all objects have been read");
        }
        if (this.currentLine() == null) {
            throw new IllegalStateException("nothing to read");
        }
        try {
            data = new TextBasedMessageData(this.currentLine(), this.grep);
        }
        catch (SyntaxError e) {
            e.setProvider(this);
            throw e;
        }
        this.setCurrentLine(null);
        data.setUserData(this.userData);
        return data;
    }

    @Override
    public Lifeline nextObject() throws SyntaxError {
        Lifeline lifeline;
        if (this.section == 1) {
            throw new IllegalStateException("reading objects has already been finished");
        }
        if (this.currentLine() == null) {
            throw new IllegalStateException("nothing to read");
        }
        if (this.currentLine().indexOf(58) == -1) {
            throw new SyntaxError(this, "not a valid object declaration - ':' missing");
        }
        ArrayList<Grep.Region> regions = new ArrayList<Grep.Region>();
        String[] parts = this.grep.parse("(\\/?.+?):([^\\[\\]]+?)\\s*(\\[.*?\\]|)\\s*(\".*\"|)", this.currentLine(), regions);
        if (parts == null || parts.length != 4) {
            String msg = this.currentLine().indexOf(46) >= 0 ? "not a valid object declaration, perhaps you forgot to enter an empty line before the message section" : "not a valid object declaration";
            throw new SyntaxError(this, msg);
        }
        this.setCurrentLine(null);
        String name = parts[0];
        String type = parts[1];
        String flags = parts[2];
        String label = parts[3];
        if (!label.equals("")) {
            label = label.substring(1, label.length() - 1);
        }
        if (flags.indexOf(102) >= 0) {
            throw new SyntaxError(this, "The f flag is not supported anymore. Use v (variable, the inverse of f[ixed]) instead.");
        }
        Set<LifelineFlag> lflags = LifelineFlag.getFlags(flags);
        if (name.startsWith("/")) {
            if (type.equals("Actor") || LifelineFlag.PROCESS.in(lflags)) {
                throw new SyntaxError(this, "processes and actors must be visible");
            }
            lflags.remove((Object)LifelineFlag.THREAD);
            lflags.remove((Object)LifelineFlag.PROCESS);
            lifeline = new Lifeline(name.substring(1), type, label, false, lflags, this.diagram);
        } else {
            if (type.equals("Actor") && LifelineFlag.ANONYMOUS.in(lflags)) {
                throw new SyntaxError(this, "actors cannot be anonymous");
            }
            if ((type.equals("Actor") || LifelineFlag.PROCESS.in(lflags)) && LifelineFlag.THREAD.in(lflags)) {
                throw new SyntaxError(this, "actors cannot have their own thread");
            }
            if ((type.equals("Actor") || LifelineFlag.PROCESS.in(lflags)) && LifelineFlag.AUTOMATIC.in(lflags)) {
                throw new SyntaxError(this, "actors cannot be (automatically) destroyed");
            }
            if (LifelineFlag.VARIABLE.in(lflags)) {
                throw new SyntaxError(this, "only objects that are created by a constructor can have a variable position");
            }
            lifeline = new Lifeline(parts[0], parts[1], label, true, lflags, this.diagram);
        }
        lifeline.setNameRegion(regions.get(0));
        int cmt = this.rawLine().indexOf("#!");
        if (cmt >= 0 && cmt + 2 < this.rawLine().length() - 1) {
            String annotation = this.rawLine().substring(cmt + 2).trim();
            this.annotations.put(lifeline, annotation);
        }
        return lifeline;
    }

    public String getAnnotation(Lifeline lifeline) {
        String name = this.annotations.get(lifeline);
        return name;
    }

    @Override
    public Note getNote() throws SyntaxError {
        String linkString;
        boolean more;
        if (this.section == 0) {
            throw new IllegalStateException("not all objects have been read");
        }
        if (this.currentLine() == null) {
            throw new IllegalStateException("nothing to read");
        }
        String[] parts = this.grep.parse("\\s*(\\*|\\+)(\\d+)\\s*(.+)", this.currentLine());
        if (parts == null) {
            return null;
        }
        boolean consuming = parts[0].equals("+");
        int number = -1;
        try {
            number = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (number < 0) {
            throw new SyntaxError(this, "bad note number: " + parts[1]);
        }
        String obj = parts[2];
        Lifeline line = this.diagram.getLifeline(obj);
        if (line == null) {
            throw new SyntaxError(this, obj + " does not exist");
        }
        int oldBegin = this.getLineBegin();
        int oldEnd = this.getLineEnd();
        line = line.getRightmost();
        LinkedList<String> desc = new LinkedList<String>();
        do {
            if (!this.advance(false)) {
                this.reset(oldBegin, oldEnd);
                throw new SyntaxError(this, "The note is not closed.");
            }
            boolean bl = more = !this.currentLine().trim().equals(parts[0] + parts[1]);
        } while (more && desc.add(this.currentLine()));
        if (desc.size() == 0) {
            this.reset(oldBegin, oldEnd);
            throw new SyntaxError(this, "The note is empty.");
        }
        String[] noteText = desc.toArray(new String[0]);
        URI link = null;
        if (noteText.length == 1 && (linkString = noteText[0].trim()).startsWith("link:")) {
            try {
                linkString = linkString.substring(5).trim();
                link = new URI(linkString);
                if (link.getPath() == null) {
                    throw new SyntaxError(this, "Empty path in URI: " + linkString);
                }
                noteText[0] = link.getPath();
            }
            catch (URISyntaxException e) {
                throw new SyntaxError(this, "Bad URI syntax: " + e.getMessage());
            }
        }
        Note note = new Note(line, number, noteText, consuming);
        note.setLink(link);
        return note;
    }

    @Override
    public Pair<Lifeline, Integer> getEventAssociation() throws SyntaxError {
        if (this.section == 0) {
            throw new IllegalStateException("not all objects have been read");
        }
        if (this.currentLine() == null) {
            throw new IllegalStateException("nothing to read");
        }
        String[] parts = this.grep.parse("\\((\\d+)\\)\\s*(\\w+)", this.currentLine());
        if (parts == null) {
            return null;
        }
        int number = Integer.parseInt(parts[0]);
        String obj = parts[1];
        Lifeline line = this.diagram.getLifeline(obj);
        if (line == null) {
            throw new SyntaxError(this, obj + " does not exist");
        }
        return new Pair<Lifeline, Integer>(line, number);
    }

    public boolean pass() {
        return false;
    }
}

