/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.search.SearchTerm;

public abstract class Message
implements Part {
    protected int msgnum = 0;
    protected boolean expunged = false;
    protected Folder folder;
    protected Session session;

    protected Message() {
        this.folder = null;
        this.session = null;
    }

    protected Message(Folder folder, int msgnum) {
        this.folder = folder;
        this.msgnum = msgnum;
        this.session = folder.store.session;
    }

    protected Message(Session session) {
        this.folder = null;
        this.session = session;
    }

    public abstract Address[] getFrom() throws MessagingException;

    public abstract void setFrom() throws MessagingException;

    public abstract void setFrom(Address var1) throws MessagingException;

    public abstract void addFrom(Address[] var1) throws MessagingException;

    public abstract Address[] getRecipients(RecipientType var1) throws MessagingException;

    public Address[] getAllRecipients() throws MessagingException {
        Address[] to = this.getRecipients(RecipientType.TO);
        Address[] cc = this.getRecipients(RecipientType.CC);
        Address[] bcc = this.getRecipients(RecipientType.BCC);
        if (cc == null && bcc == null) {
            return to;
        }
        int count = (to == null ? 0 : to.length) + (cc == null ? 0 : cc.length) + (bcc == null ? 0 : bcc.length);
        Address[] all = new Address[count];
        int offset = 0;
        if (to != null) {
            System.arraycopy(to, 0, all, offset, to.length);
            offset += to.length;
        }
        if (cc != null) {
            System.arraycopy(cc, 0, all, offset, cc.length);
            offset += cc.length;
        }
        if (bcc != null) {
            System.arraycopy(bcc, 0, all, offset, bcc.length);
            offset += bcc.length;
        }
        return all;
    }

    public abstract void setRecipients(RecipientType var1, Address[] var2) throws MessagingException;

    public void setRecipient(RecipientType type, Address address) throws MessagingException {
        this.setRecipients(type, new Address[]{address});
    }

    public abstract void addRecipients(RecipientType var1, Address[] var2) throws MessagingException;

    public void addRecipient(RecipientType type, Address address) throws MessagingException {
        this.addRecipients(type, new Address[]{address});
    }

    public Address[] getReplyTo() throws MessagingException {
        return this.getFrom();
    }

    public void setReplyTo(Address[] addresses) throws MessagingException {
        throw new MethodNotSupportedException();
    }

    public abstract String getSubject() throws MessagingException;

    public abstract void setSubject(String var1) throws MessagingException;

    public abstract Date getSentDate() throws MessagingException;

    public abstract void setSentDate(Date var1) throws MessagingException;

    public abstract Date getReceivedDate() throws MessagingException;

    public abstract Flags getFlags() throws MessagingException;

    public boolean isSet(Flags.Flag flag) throws MessagingException {
        return this.getFlags().contains(flag);
    }

    public abstract void setFlags(Flags var1, boolean var2) throws MessagingException;

    public void setFlag(Flags.Flag flag, boolean set) throws MessagingException {
        this.setFlags(new Flags(flag), set);
    }

    public int getMessageNumber() {
        return this.msgnum;
    }

    protected void setMessageNumber(int msgnum) {
        this.msgnum = msgnum;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public boolean isExpunged() {
        return this.expunged;
    }

    protected void setExpunged(boolean expunged) {
        this.expunged = expunged;
    }

    public abstract Message reply(boolean var1) throws MessagingException;

    public abstract void saveChanges() throws MessagingException;

    public boolean match(SearchTerm term) throws MessagingException {
        return term.match(this);
    }

    public static class RecipientType
    implements Serializable {
        public static final RecipientType TO = new RecipientType("To");
        public static final RecipientType CC = new RecipientType("Cc");
        public static final RecipientType BCC = new RecipientType("Bcc");
        protected String type;

        protected RecipientType(String type) {
            this.type = type;
        }

        protected Object readResolve() throws ObjectStreamException {
            if (this.type.equals("To")) {
                return TO;
            }
            if (this.type.equals("Cc")) {
                return CC;
            }
            if (this.type.equals("Bcc")) {
                return BCC;
            }
            throw new InvalidObjectException("Unknown RecipientType: " + this.type);
        }

        public String toString() {
            return this.type;
        }
    }
}

