/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class Decimal
extends BigDecimal {
    private static final long serialVersionUID = 1L;
    public static final Decimal ZERO = new Decimal(0);
    public static final Decimal NEGATIVE_ZERO = new NegativeZero(0);

    public static boolean isNegativeZero(BigDecimal val2) {
        return val2.getClass() == NegativeZero.class;
    }

    public static BigDecimal bigDecimalValue(BigDecimal val2) {
        if (val2 == null || val2.getClass() == BigDecimal.class) {
            return val2;
        }
        return new BigDecimal(val2.unscaledValue(), val2.scale());
    }

    public static boolean equals(BigDecimal v1, BigDecimal v2) {
        return Decimal.isNegativeZero(v1) == Decimal.isNegativeZero(v2) && v1.equals(v2);
    }

    public static Decimal negativeZero(int scale) {
        return new NegativeZero(scale);
    }

    public static Decimal negativeZero(int scale, MathContext mc) {
        return new NegativeZero(scale, mc);
    }

    public static Decimal valueOf(BigInteger unscaledVal, int scale) {
        return new Decimal(unscaledVal, scale);
    }

    public static Decimal valueOf(BigInteger unscaledVal, int scale, MathContext mc) {
        return new Decimal(unscaledVal, scale, mc);
    }

    public static Decimal valueOf(BigInteger val2) {
        return new Decimal(val2);
    }

    public static Decimal valueOf(BigInteger val2, MathContext mc) {
        return new Decimal(val2, mc);
    }

    public static Decimal valueOf(int val2) {
        return new Decimal(val2);
    }

    public static Decimal valueOf(int val2, MathContext mc) {
        return new Decimal(val2, mc);
    }

    public static Decimal valueOf(long val2) {
        return new Decimal(val2);
    }

    public static Decimal valueOf(long val2, MathContext mc) {
        return new Decimal(val2, mc);
    }

    public static Decimal valueOf(double val2) {
        if (Double.compare(val2, -0.0) == 0) {
            return new NegativeZero(1);
        }
        return new Decimal(Double.toString(val2));
    }

    public static Decimal valueOf(double val2, MathContext mc) {
        if (Double.compare(val2, -0.0) == 0) {
            return new NegativeZero(1, mc);
        }
        return new Decimal(Double.toString(val2), mc);
    }

    public static Decimal valueOf(BigDecimal val2) {
        if (val2 == null || val2 instanceof Decimal) {
            return (Decimal)val2;
        }
        return new Decimal(val2.unscaledValue(), val2.scale());
    }

    public static Decimal valueOf(BigDecimal val2, MathContext mc) {
        return new Decimal(val2.unscaledValue(), val2.scale(), mc);
    }

    public static Decimal valueOf(String val2) {
        boolean negative = val2.startsWith("-");
        Decimal ibd = new Decimal(val2);
        if (negative && ibd.signum() == 0) {
            ibd = new NegativeZero(ibd.scale());
        }
        return ibd;
    }

    public static Decimal valueOf(String val2, MathContext mc) {
        boolean negative = val2.startsWith("-");
        Decimal ibd = new Decimal(val2, mc);
        if (negative && ibd.signum() == 0) {
            ibd = new NegativeZero(ibd.scale(), mc);
        }
        return ibd;
    }

    private Decimal(BigInteger unscaledVal, int scale) {
        super(unscaledVal, scale);
    }

    private Decimal(BigInteger unscaledVal, int scale, MathContext mc) {
        super(unscaledVal, scale, mc);
    }

    private Decimal(BigInteger val2) {
        super(val2);
    }

    private Decimal(BigInteger val2, MathContext mc) {
        super(val2, mc);
    }

    private Decimal(int val2) {
        super(val2);
    }

    private Decimal(int val2, MathContext mc) {
        super(val2, mc);
    }

    private Decimal(long val2) {
        super(val2);
    }

    private Decimal(long val2, MathContext mc) {
        super(val2, mc);
    }

    private Decimal(double val2) {
        super(val2);
    }

    private Decimal(double val2, MathContext mc) {
        super(val2, mc);
    }

    private Decimal(char[] in, int offset, int len) {
        super(in, offset, len);
    }

    private Decimal(char[] in, int offset, int len, MathContext mc) {
        super(in, offset, len, mc);
    }

    private Decimal(char[] in) {
        super(in);
    }

    private Decimal(char[] in, MathContext mc) {
        super(in, mc);
    }

    private Decimal(String val2) {
        super(val2);
    }

    private Decimal(String val2, MathContext mc) {
        super(val2, mc);
    }

    public final boolean isNegativeZero() {
        return this.getClass() == NegativeZero.class;
    }

    public final BigDecimal bigDecimalValue() {
        return new BigDecimal(this.unscaledValue(), this.scale());
    }

    private static final class NegativeZero
    extends Decimal {
        private static final long serialVersionUID = 1L;

        private NegativeZero(int scale) {
            super(BigInteger.ZERO, scale);
        }

        private NegativeZero(int scale, MathContext mc) {
            super(BigInteger.ZERO, scale, mc);
        }

        public float floatValue() {
            float v = super.floatValue();
            if (Float.compare(0.0f, v) <= 0) {
                v = -1.0f * v;
            }
            return v;
        }

        public double doubleValue() {
            double v = super.doubleValue();
            if (Double.compare(0.0, v) <= 0) {
                v = -1.0 * v;
            }
            return v;
        }

        public BigDecimal abs() {
            return new BigDecimal(this.unscaledValue(), this.scale());
        }

        public BigDecimal abs(MathContext mc) {
            return new BigDecimal(this.unscaledValue(), this.scale(), mc);
        }

        public String toString() {
            return '-' + super.toString();
        }

        public String toEngineeringString() {
            return '-' + super.toEngineeringString();
        }

        public String toPlainString() {
            return '-' + super.toPlainString();
        }
    }
}

