/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.LatLonShapeQuery;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Tessellator;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.FutureArrays;
import org.apache.lucene.util.NumericUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class LatLonShapeBoundingBoxQuery
extends LatLonShapeQuery {
    final byte[] bbox;
    final int minX;
    final int maxX;
    final int minY;
    final int maxY;

    public LatLonShapeBoundingBoxQuery(String field, LatLonShape.QueryRelation queryRelation, double minLat, double maxLat, double minLon, double maxLon) {
        super(field, queryRelation);
        if (minLon > maxLon) {
            throw new IllegalArgumentException("dateline crossing bounding box queries are not supported for [" + field + "]");
        }
        this.bbox = new byte[16];
        this.minX = GeoEncodingUtils.encodeLongitudeCeil((double)minLon);
        this.maxX = GeoEncodingUtils.encodeLongitude((double)maxLon);
        this.minY = GeoEncodingUtils.encodeLatitudeCeil((double)minLat);
        this.maxY = GeoEncodingUtils.encodeLatitude((double)maxLat);
        NumericUtils.intToSortableBytes((int)this.minY, (byte[])this.bbox, (int)0);
        NumericUtils.intToSortableBytes((int)this.minX, (byte[])this.bbox, (int)4);
        NumericUtils.intToSortableBytes((int)this.maxY, (byte[])this.bbox, (int)8);
        NumericUtils.intToSortableBytes((int)this.maxX, (byte[])this.bbox, (int)12);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        if (FutureArrays.compareUnsigned((byte[])minTriangle, (int)minXOffset, (int)(minXOffset + 4), (byte[])this.bbox, (int)12, (int)16) > 0 || FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxXOffset, (int)(maxXOffset + 4), (byte[])this.bbox, (int)4, (int)8) < 0 || FutureArrays.compareUnsigned((byte[])minTriangle, (int)minYOffset, (int)(minYOffset + 4), (byte[])this.bbox, (int)8, (int)12) > 0 || FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxYOffset, (int)(maxYOffset + 4), (byte[])this.bbox, (int)0, (int)4) < 0) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (FutureArrays.compareUnsigned((byte[])minTriangle, (int)minXOffset, (int)(minXOffset + 4), (byte[])this.bbox, (int)4, (int)8) > 0 && FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxXOffset, (int)(maxXOffset + 4), (byte[])this.bbox, (int)12, (int)16) < 0 && FutureArrays.compareUnsigned((byte[])minTriangle, (int)minYOffset, (int)(minYOffset + 4), (byte[])this.bbox, (int)0, (int)4) > 0 && FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxYOffset, (int)(maxYOffset + 4), (byte[])this.bbox, (int)8, (int)8) < 0) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    @Override
    protected boolean queryMatches(byte[] t) {
        if (this.queryRelation == LatLonShape.QueryRelation.WITHIN) {
            return this.queryContains(t, 0) && this.queryContains(t, 1) && this.queryContains(t, 2);
        }
        return this.queryIntersects(t);
    }

    protected boolean queryIntersects(byte[] t) {
        if (this.queryContains(t, 0) || this.queryContains(t, 1) || this.queryContains(t, 2)) {
            return true;
        }
        int aY = NumericUtils.sortableBytesToInt((byte[])t, (int)0);
        int aX = NumericUtils.sortableBytesToInt((byte[])t, (int)4);
        int bY = NumericUtils.sortableBytesToInt((byte[])t, (int)8);
        int bX = NumericUtils.sortableBytesToInt((byte[])t, (int)12);
        int cY = NumericUtils.sortableBytesToInt((byte[])t, (int)16);
        int cX = NumericUtils.sortableBytesToInt((byte[])t, (int)20);
        int tMinX = StrictMath.min(StrictMath.min(aX, bX), cX);
        int tMaxX = StrictMath.max(StrictMath.max(aX, bX), cX);
        int tMinY = StrictMath.min(StrictMath.min(aY, bY), cY);
        int tMaxY = StrictMath.max(StrictMath.max(aY, bY), cY);
        if (tMaxX < this.minX || tMinX > this.maxX || tMinY > this.maxY || tMaxY < this.minY) {
            return false;
        }
        if (Tessellator.pointInTriangle(this.minX, this.minY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        if (Tessellator.pointInTriangle(this.maxX, this.minY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        if (Tessellator.pointInTriangle(this.maxX, this.maxY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        if (Tessellator.pointInTriangle(this.minX, this.maxY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        return this.queryIntersects(aX, aY, bX, bY, cX, cY);
    }

    private boolean edgeIntersectsQuery(double ax, double ay, double bx, double by) {
        if (GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.minX, (double)this.maxY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.maxX, (double)this.maxY) <= 0 && GeoUtils.orient((double)this.minX, (double)this.maxY, (double)this.maxX, (double)this.maxY, (double)ax, (double)ay) * GeoUtils.orient((double)this.minX, (double)this.maxY, (double)this.maxX, (double)this.maxY, (double)bx, (double)by) <= 0) {
            return true;
        }
        if (GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.maxX, (double)this.maxY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.maxX, (double)this.minY) <= 0 && GeoUtils.orient((double)this.maxX, (double)this.maxY, (double)this.maxX, (double)this.minY, (double)ax, (double)ay) * GeoUtils.orient((double)this.maxX, (double)this.maxY, (double)this.maxX, (double)this.minY, (double)bx, (double)by) <= 0) {
            return true;
        }
        if (GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.maxX, (double)this.minY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.minX, (double)this.minY) <= 0 && GeoUtils.orient((double)this.maxX, (double)this.minY, (double)this.minX, (double)this.minY, (double)ax, (double)ay) * GeoUtils.orient((double)this.maxX, (double)this.minY, (double)this.minX, (double)this.minY, (double)bx, (double)by) <= 0) {
            return true;
        }
        return GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.minX, (double)this.minY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.minX, (double)this.maxY) <= 0 && GeoUtils.orient((double)this.minX, (double)this.minY, (double)this.minX, (double)this.maxY, (double)ax, (double)ay) * GeoUtils.orient((double)this.minX, (double)this.minY, (double)this.minX, (double)this.maxY, (double)bx, (double)by) <= 0;
    }

    private boolean queryContains(byte[] t, int point) {
        int yIdx = 8 * point;
        int xIdx = yIdx + 4;
        return FutureArrays.compareUnsigned((byte[])t, (int)yIdx, (int)xIdx, (byte[])this.bbox, (int)0, (int)4) >= 0 && FutureArrays.compareUnsigned((byte[])t, (int)yIdx, (int)xIdx, (byte[])this.bbox, (int)8, (int)12) <= 0 && FutureArrays.compareUnsigned((byte[])t, (int)xIdx, (int)(xIdx + 4), (byte[])this.bbox, (int)4, (int)8) >= 0 && FutureArrays.compareUnsigned((byte[])t, (int)xIdx, (int)(xIdx + 4), (byte[])this.bbox, (int)12, (int)this.bbox.length) <= 0;
    }

    private boolean queryIntersects(int ax, int ay, int bx, int by, int cx, int cy) {
        return this.edgeIntersectsQuery(ax, ay, bx, by) || this.edgeIntersectsQuery(bx, by, cx, cy) || this.edgeIntersectsQuery(cx, cy, ax, ay);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo(((Object)((Object)this)).getClass().cast(o));
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.bbox, ((LatLonShapeBoundingBoxQuery)((Object)o)).bbox);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.bbox);
        return hash;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("Rectangle(lat=");
        sb.append(GeoEncodingUtils.decodeLatitude((int)this.minY));
        sb.append(" TO ");
        sb.append(GeoEncodingUtils.decodeLatitude((int)this.maxY));
        sb.append(" lon=");
        sb.append(GeoEncodingUtils.decodeLongitude((int)this.minX));
        sb.append(" TO ");
        sb.append(GeoEncodingUtils.decodeLongitude((int)this.maxX));
        sb.append(")");
        return sb.toString();
    }
}

