/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.aflow;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.readers.xtal.VaspPoscarReader;
import org.jmol.util.Logger;

public class AFLOWReader
extends VaspPoscarReader {
    private String aabb;
    private boolean readPRE;
    private float fracB = Float.NaN;
    private Map<String, float[]> compositions;
    private boolean getComposition;
    private String listKey;
    private String listKeyCase;
    private int fileModelNumber;
    private boolean havePRE;
    private String titleMsg;
    private Map<String, String> keyMap = new Hashtable<String, String>();

    @Override
    protected void initializeReader() throws Exception {
        this.readPRE = this.checkFilterKey("PRE");
        String s = this.getFilter("CA=");
        if (s != null) {
            this.fracB = 1.0f - this.parseFloatStr(s);
        }
        if ((s = this.getFilter("CB=")) != null) {
            this.fracB = this.parseFloatStr(s);
        }
        this.listKeyCase = this.listKey = (s = this.getFilter("LIST=")) == null ? "HF" : s;
        this.getComposition = !Float.isNaN(this.fracB);
        this.discardLinesUntilStartsWith("[");
        this.aabb = this.line.substring(1, this.line.indexOf("]"));
        int pt = PT.isUpperCase(this.aabb.charAt(1)) ? 1 : 2;
        this.defaultLabels = new String[]{this.aabb.substring(0, pt), this.aabb.substring(pt)};
        while (this.rd().indexOf("] REFERENCE:") >= 0) {
            this.appendLoadNote(this.line);
        }
        this.compositions = new Hashtable<String, float[]>();
        this.quiet = true;
        this.asc.bsAtoms = new BS();
        this.addJmolScript("unitcell off;axes off;");
        this.havePRE = this.line.indexOf("Structure PRE") >= 0;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (!this.havePRE) {
            this.discardLinesUntilContains("Structure PRE");
        }
        this.havePRE = false;
        if (this.line == null) {
            return false;
        }
        this.continuing &= this.readPrePost();
        return this.continuing;
    }

    private boolean readPrePost() throws Exception {
        ++this.fileModelNumber;
        this.titleMsg = "#" + (this.modelNumber + 1) + (this.getComposition ? "," + this.fileModelNumber + ", Cb=" + this.fracB : "");
        this.elementLabel = null;
        int n0 = this.asc.bsAtoms.cardinality();
        if (this.readPRE) {
            this.readStructure(this.titleMsg);
        } else {
            this.readElementLabelsOnly();
            this.discardLinesUntilContains("Structure POST");
            this.readStructure(this.titleMsg);
        }
        if (this.getData()) {
            this.applySymmetryAndSetTrajectory();
        } else {
            this.asc.bsAtoms.clearBits(this.asc.getLastAtomSetAtomIndex(), this.asc.ac);
            this.doCheckUnitCell = false;
        }
        this.finalizeModel();
        if (n0 != this.asc.bsAtoms.cardinality()) {
            Logger.info("AFLOW: file#, saved#, atoms: " + this.fileModelNumber + " " + this.modelNumber + " " + (this.asc.bsAtoms.cardinality() - n0));
        }
        return !this.haveModel || this.modelNumber != this.desiredModelNumber;
    }

    private void finalizeModel() throws Exception {
        this.asc.removeLastUnselectedAtoms();
    }

    private void readElementLabelsOnly() throws Exception {
        this.readLines(5);
        this.rdline();
        int n = this.getTokens().length;
        this.elementLabel = new String[n];
        this.rdline();
        this.line = "";
        String s = null;
        String last = null;
        for (int i = 0; i < n; ++i) {
            while (s == null || s.equals(last)) {
                this.rdline();
                String[] tokens = this.getTokens();
                if (tokens.length == 4) {
                    s = this.elementLabel[i] = this.getElement(tokens[3]);
                    if (this.elementLabel[i] != null) continue;
                }
                i = n + 1;
                break;
            }
            last = s;
        }
        if (s == null) {
            this.elementLabel = this.defaultLabels;
        }
    }

    private boolean getData() throws Exception {
        this.discardLinesUntilContains("- DATA -");
        Hashtable<String, Object> htAFLOW = new Hashtable<String, Object>();
        htAFLOW.put("fileModelNumber", this.fileModelNumber);
        htAFLOW.put("modelNumber", this.modelNumber + 1);
        htAFLOW.put("AaBb", this.aabb);
        int pt = 0;
        SB sb = new SB();
        float listVal = Float.MAX_VALUE;
        String strcb = "?";
        String listValStr = null;
        float cb = 0.0f;
        while (this.rdline() != null && (pt = this.line.indexOf(" # ")) >= 0) {
            String key = this.line.substring(pt + 3).trim();
            String val = this.line.substring(0, pt).trim();
            sb.append(key).append("=").append(val).append(" | ");
            if (key.toUpperCase().startsWith(this.listKey)) {
                this.listKey = key.toUpperCase();
                this.listKeyCase = key;
                listValStr = val;
                listVal = this.parseFloatStr(val);
            }
            if (key.equals("Ca")) {
                float ca = this.parseFloatStr(val);
                if (!this.getComposition || !(Math.abs(1.0f - ca - this.fracB) > 0.01f)) continue;
                return false;
            }
            if (key.equals("Cb")) {
                strcb = val;
                cb = this.parseFloatStr(strcb);
                if (!this.getComposition || !(Math.abs(cb - this.fracB) > 0.01f)) continue;
                return false;
            }
            if (!key.equals("Hf_atom [eV] (VASP)")) continue;
            float e = this.parseFloatStr(val);
            this.asc.setAtomSetEnergy(val, e);
        }
        this.asc.setAtomSetName(this.titleMsg + (this.getComposition ? "" : " Cb=" + cb) + " " + this.listKey + "=" + listValStr);
        float[] count_min = this.compositions.get(strcb);
        if (!this.doGetModel(++this.modelNumber, null)) {
            return false;
        }
        if (count_min == null) {
            count_min = new float[]{0.0f, Float.MAX_VALUE, 0.0f};
            this.compositions.put(strcb, count_min);
        }
        count_min[0] = count_min[0] + 1.0f;
        if (listVal < count_min[1]) {
            count_min[1] = listVal;
            count_min[2] = this.fileModelNumber;
        }
        while (this.line.indexOf("- URL -") < 0) {
            this.rdline();
        }
        sb.append("URL=" + this.rdline() + "|");
        while (this.line.indexOf("aurl=") < 0) {
            this.rdline();
        }
        sb.append(this.line);
        String[] pairs = PT.split(sb.toString(), " | ");
        int i = pairs.length;
        while (--i >= 0) {
            String[] kv = pairs[i].split("=");
            if (kv.length < 2) continue;
            float f = this.parseFloatStr(kv[1]);
            Object o = Float.isNaN(f) ? kv[1] : Float.valueOf(f);
            htAFLOW.put(kv[0], o);
            String kvclean = this.cleanKey(kv[0]);
            if (kvclean == kv[0]) continue;
            htAFLOW.put(kvclean, o);
        }
        this.asc.setCurrentModelInfo("aflowInfo", htAFLOW);
        return true;
    }

    private String cleanKey(String key) {
        String kclean = this.keyMap.get(key);
        if (kclean != null) {
            return kclean;
        }
        char[] chars = key.toCharArray();
        int i = chars.length;
        while (--i >= 0) {
            if (PT.isLetterOrDigit(chars[i])) continue;
            chars[i] = 95;
        }
        kclean = PT.trim(PT.rep(new String(chars), "__", "_"), "_");
        this.keyMap.put(key, kclean);
        return kclean;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.alignUnitCells();
        this.listCompositions();
        this.finalizeReaderASCR();
    }

    private void listCompositions() {
        Lst<String> list = new Lst<String>();
        for (Map.Entry<String, float[]> e : this.compositions.entrySet()) {
            float[] count_min = e.getValue();
            list.addLast(e.getKey() + "\t" + (int)count_min[0] + "\t" + (int)count_min[2] + "\t" + this.listKeyCase + "\t" + count_min[1]);
        }
        Object[] a = new String[list.size()];
        list.toArray(a);
        Arrays.sort(a);
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            this.appendLoadNote(this.aabb + "\t" + (String)a[i]);
        }
    }

    private void alignUnitCells() {
    }
}

