/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.util.Logger;
import org.jmol.util.MeshSlicer;

public class MeshCapper {
    private MeshSlicer slicer;
    private boolean dumping;
    private Map<Integer, CapVertex> capMap;
    private Lst<CapVertex> vertices;
    private Lst<CapVertex[]> lstRegions;
    private static final int DESCENDER = 0;
    private static final int ASCENDER = 1;
    private static final int LAST = 2;
    private int nTriangles;
    private int nRegions;
    private Lst<int[]> lstTriangles;
    private int nPoints;
    M3 m3;
    M3 m3inv;

    public MeshCapper set(MeshSlicer meshSlicer) {
        this.slicer = meshSlicer;
        this.dumping = Logger.debugging;
        return this;
    }

    void clear() {
        this.capMap = new Hashtable<Integer, CapVertex>();
        this.vertices = new Lst();
    }

    public int[][] triangulateFaces(int[][] nArray, P3[] p3Array, int[][] nArray2) {
        this.lstTriangles = new Lst();
        P3[] p3Array2 = new P3[10];
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int[] nArray3 = nArray[n];
            int n3 = nArray3.length;
            if (p3Array2.length < n3) {
                p3Array2 = new P3[n3];
            }
            int n4 = this.lstTriangles.size();
            int n5 = n3;
            while (--n5 >= 0) {
                p3Array2[n5] = p3Array[nArray3[n5]];
            }
            this.triangulatePolygon(p3Array2, n3);
            n5 = this.lstTriangles.size();
            int[] nArray4 = new int[n5 - n4];
            if (nArray2 != null) {
                nArray2[n] = nArray4;
            }
            int n6 = n4;
            while (n6 < n5) {
                int[] nArray5 = (int[])this.lstTriangles.get(n6);
                nArray4[n6 - n4] = n6;
                int n7 = 3;
                while (--n7 >= 0) {
                    nArray5[n7] = nArray3[nArray5[n7]];
                }
                nArray5[3] = -nArray5[3];
                ++n6;
            }
            ++n;
        }
        int[][] nArray6 = AU.newInt2(this.lstTriangles.size());
        this.lstTriangles.toArray((T[])nArray6);
        return nArray6;
    }

    public int[][] triangulatePolygon(P3[] p3Array, int n) {
        boolean bl;
        this.clear();
        boolean bl2 = bl = n >= 0;
        if (!bl || this.lstTriangles == null) {
            this.lstTriangles = new Lst();
        }
        this.nPoints = bl ? n : p3Array.length;
        n = this.nPoints;
        CapVertex capVertex = null;
        int n2 = 0;
        while (n2 < n) {
            if (p3Array[n2] == null) {
                return null;
            }
            CapVertex capVertex2 = new CapVertex(p3Array[n2], n2);
            this.vertices.addLast(capVertex2);
            if (capVertex != null) {
                capVertex.link(capVertex2);
            }
            capVertex = capVertex2;
            ++n2;
        }
        capVertex.link((CapVertex)this.vertices.get(0));
        this.createCap(null);
        if (bl) {
            return null;
        }
        int[][] nArray = AU.newInt2(this.lstTriangles.size());
        int n3 = this.lstTriangles.size();
        while (--n3 >= 0) {
            nArray[n3] = (int[])this.lstTriangles.get(n3);
        }
        return nArray;
    }

    void addEdge(int n, int n2, int n3) {
        CapVertex capVertex = this.addPoint(n3, n);
        CapVertex capVertex2 = this.addPoint(n3, n2);
        capVertex.link(capVertex2);
    }

    private CapVertex addPoint(int n, int n2) {
        Integer n3 = n2;
        CapVertex capVertex = this.capMap.get(n3);
        if (capVertex == null) {
            T3 t3 = this.slicer.m.vs[n2];
            n2 = this.slicer.addIntersectionVertex(t3, 0.0f, -1, n, null, -1, -1);
            capVertex = new CapVertex(t3, n2);
            this.vertices.addLast(capVertex);
            this.capMap.put(n3, capVertex);
        }
        if (this.dumping) {
            Logger.info(String.valueOf(n2) + "\t" + this.slicer.m.vs[n2]);
        }
        return capVertex;
    }

    private T3 getInputPoint(CapVertex capVertex) {
        return this.slicer == null ? P3.newP(capVertex) : this.slicer.m.vs[capVertex.ipt];
    }

    private void outputTriangle(int n, int n2, int n3) {
        if (this.slicer == null) {
            int n4 = 0;
            if (this.isEdge(n, n2)) {
                n4 |= 1;
            }
            if (this.isEdge(n2, n3)) {
                n4 |= 2;
            }
            if (this.isEdge(n3, n)) {
                n4 |= 4;
            }
            this.lstTriangles.addLast(new int[]{n, n2, n3, n4});
        } else {
            this.slicer.addTriangle(n, n2, n3);
        }
    }

    private boolean isEdge(int n, int n2) {
        return n2 == (n + 1) % this.nPoints;
    }

    void createCap(V3 v3) {
        CapVertex capVertex;
        V3 v32;
        this.capMap = null;
        this.lstRegions = new Lst();
        CapVertex[] capVertexArray = new CapVertex[this.vertices.size()];
        if (capVertexArray.length < 3) {
            return;
        }
        if (Logger.debugging) {
            Logger.info("MeshCapper using " + capVertexArray.length + " vertices");
        }
        this.vertices.toArray(capVertexArray);
        this.vertices = null;
        V3 v33 = V3.newVsub(capVertexArray[0], capVertexArray[1]);
        if (v3 == null) {
            v32 = V3.newVsub(capVertexArray[0], capVertexArray[capVertexArray.length - 1]);
        } else {
            v32 = V3.newV(v3);
            v32.cross(v32, v33);
        }
        Quat quat = Quat.getQuaternionFrameV(v33, v32, null, false);
        this.m3 = quat.getMatrix();
        this.m3inv = M3.newM3(this.m3);
        this.m3inv.invert();
        int n = capVertexArray.length;
        while (--n >= 0) {
            this.m3inv.rotate(capVertexArray[n]);
        }
        this.fixEndsAndSortVertices(capVertexArray);
        CapVertex capVertex2 = capVertex = capVertexArray[0];
        try {
            while ((capVertex2 = this.process(capVertex2)) != capVertex) {
            }
        }
        catch (Exception exception) {
            System.out.println("MeshCapper exception " + exception);
            exception.printStackTrace();
        }
        if (this.slicer != null) {
            this.clear();
        }
        if (Logger.debugging) {
            Logger.info("MeshCapper created " + this.nTriangles + " triangles " + this.nRegions + " regions");
        }
    }

    private void fixEndsAndSortVertices(CapVertex[] capVertexArray) {
        int n;
        Lst<CapVertex> lst = new Lst<CapVertex>();
        Lst<CapVertex> lst2 = new Lst<CapVertex>();
        int n2 = n = capVertexArray.length;
        while (--n2 >= 0) {
            if (capVertexArray[n2].next == null) {
                lst.addLast(capVertexArray[n2]);
                continue;
            }
            if (capVertexArray[n2].prev != null) continue;
            lst2.addLast(capVertexArray[n2]);
        }
        n2 = lst.size();
        while (--n2 >= 0) {
            CapVertex capVertex = (CapVertex)lst.get(n2);
            CapVertex capVertex2 = this.findNearestVertex(lst2, capVertex);
            if (capVertex2 == null) {
                System.out.println("MESHCAPPER OHOH");
                continue;
            }
            capVertex.link(capVertex2);
            if (!((double)capVertex.distanceSquared(capVertex2) < 1.0E-6)) continue;
            capVertex2.link(null);
        }
        Arrays.sort(capVertexArray, new MeshCapperSorter());
        n2 = n;
        while (--n2 >= 0) {
            capVertexArray[n2].yxNext = capVertexArray[(n2 + 1) % n];
        }
        capVertexArray[n - 1].yxNext = capVertexArray[0];
    }

    private CapVertex findNearestVertex(Lst<CapVertex> lst, CapVertex capVertex) {
        float f = Float.MAX_VALUE;
        CapVertex capVertex2 = null;
        int n = -1;
        int n2 = lst.size();
        while (--n2 >= 0) {
            CapVertex capVertex3 = (CapVertex)lst.get(n2);
            float f2 = capVertex3.distanceSquared(capVertex);
            if (!(f2 < f)) continue;
            f = f2;
            capVertex2 = capVertex3;
            n = n2;
        }
        if (n >= 0) {
            lst.removeItemAt(n);
        }
        return capVertex2;
    }

    private CapVertex process(CapVertex capVertex) {
        boolean bl;
        CapVertex capVertex2 = capVertex.yxNext;
        capVertex.yxNext = null;
        if (this.dumping) {
            Logger.info(capVertex.toString());
        }
        if (capVertex.prev == capVertex.next) {
            return capVertex2;
        }
        boolean bl2 = capVertex.prev.region != null;
        boolean bl3 = bl = capVertex.next.region != null;
        if (this.dumping) {
            Logger.info("#" + (bl ? capVertex.next.id : "    ") + "    " + (bl2 ? capVertex.prev.id : "") + "\n#" + (bl ? "   \\" : "    ") + (bl2 ? "    /\n" : "\n") + "#    " + capVertex.id);
        }
        if (!bl2 && !bl) {
            CapVertex capVertex3 = this.getLastPoint(capVertex);
            if (capVertex3 == null) {
                this.newRegion(capVertex);
                return capVertex2;
            }
            CapVertex capVertex4 = this.processSplit(capVertex, capVertex3);
            capVertex4.yxNext = capVertex2;
            capVertex2 = capVertex4;
            bl = true;
        }
        if (bl2) {
            this.processMonotonic(capVertex, true);
        }
        if (bl) {
            this.processMonotonic(capVertex, false);
        }
        if (bl2 && bl) {
            if (capVertex.prev.prev == capVertex.next) {
                this.lstRegions.removeObj(capVertex.region);
                this.addTriangle(capVertex.prev, capVertex, capVertex.next, "end");
                MeshCapper.clearV(capVertex.prev);
                MeshCapper.clearV(capVertex.next);
            } else {
                capVertex.region = null;
            }
        }
        return capVertex2;
    }

    private static void clearV(CapVertex capVertex) {
        if (capVertex != null) {
            capVertex.clear();
        }
    }

    private void processMonotonic(CapVertex capVertex, boolean bl) {
        CapVertex capVertex2 = bl ? capVertex.prev : capVertex.next;
        capVertex.region = capVertex2.region;
        CapVertex capVertex3 = capVertex.region[2];
        if (capVertex3 == capVertex) {
            this.lstRegions.removeObj(capVertex.region);
            return;
        }
        if (capVertex3 == capVertex2) {
            CapVertex capVertex4 = capVertex3;
            CapVertex capVertex5 = bl ? capVertex4.prev : capVertex4.next;
            while (capVertex5 != capVertex && capVertex5.yxNext == null && bl == capVertex.x > capVertex.interpolateX(capVertex5, capVertex4)) {
                if (bl) {
                    this.addTriangle(capVertex5, capVertex4, capVertex, "same desc " + capVertex.ipt);
                    capVertex4 = capVertex5;
                    capVertex5 = capVertex5.prev;
                    continue;
                }
                this.addTriangle(capVertex, capVertex4, capVertex5, "same asc " + capVertex.ipt);
                capVertex4 = capVertex5;
                capVertex5 = capVertex5.next;
            }
        } else {
            CapVertex capVertex6 = capVertex2;
            do {
                CapVertex capVertex7 = capVertex6;
                if (bl) {
                    capVertex6 = capVertex7.prev;
                    this.addTriangle(capVertex6, capVertex7, capVertex, "opp desc " + capVertex.id);
                    continue;
                }
                capVertex6 = capVertex7.next;
                this.addTriangle(capVertex, capVertex7, capVertex6, "opp asc " + capVertex.id);
            } while (capVertex6 != capVertex3 && capVertex6 != capVertex && capVertex6.yxNext == null);
            if (capVertex3.region == null) {
                this.lstRegions.removeObj(capVertex.region);
                CapVertex capVertex8 = bl ? capVertex3.prev : capVertex3.next;
                capVertex3.region = capVertex8.region;
                capVertex.region = capVertex8.region;
            }
        }
        CapVertex capVertex9 = capVertex;
        capVertex.region[bl ? 0 : 1] = capVertex9;
        capVertex.region[2] = capVertex9;
    }

    private CapVertex processSplit(CapVertex capVertex, CapVertex capVertexArray) {
        Object object;
        CapVertex capVertex2 = capVertexArray.cloneV();
        if (this.dumping) {
            capVertex2.id = String.valueOf(capVertex2.id) + "a";
        }
        CapVertex capVertex3 = capVertex.cloneV();
        if (this.dumping) {
            capVertex3.id = String.valueOf(capVertex3.id) + "a";
        }
        if (capVertexArray.region == null) {
            capVertexArray.region = capVertexArray.next.region;
            capVertex2.region = capVertexArray.prev.region;
        } else {
            this.newRegion((CapVertex)capVertexArray);
            object = capVertexArray;
            while (object.next.region != null) {
                object.next.region = object.region;
                object.region[0] = object = object.next;
            }
        }
        object = capVertex2.region;
        if (object[2] == capVertexArray) {
            object[2] = capVertex2;
        }
        object[0] = capVertex2;
        if (object[1] == capVertexArray) {
            object[1] = capVertex2;
        }
        capVertex.link((CapVertex)capVertexArray);
        capVertex2.prev.link(capVertex2);
        capVertex2.link(capVertex3);
        capVertex3.link(capVertex3.next);
        return capVertex3;
    }

    private void newRegion(CapVertex capVertex) {
        ++this.nRegions;
        capVertex.region = new CapVertex[]{capVertex, capVertex, capVertex};
        this.lstRegions.addLast(capVertex.region);
    }

    private CapVertex getLastPoint(CapVertex capVertex) {
        CapVertex capVertex2 = null;
        float f = Float.MAX_VALUE;
        int n = this.lstRegions.size();
        while (--n >= 0) {
            boolean bl;
            CapVertex[] capVertexArray = (CapVertex[])this.lstRegions.get(n);
            CapVertex capVertex3 = capVertexArray[0];
            if (capVertex3 == capVertexArray[1]) continue;
            boolean bl2 = capVertex3.region != null;
            boolean bl3 = bl = (bl2 ? capVertex.interpolateX(capVertex3, capVertex3.next) : capVertex3.x) < capVertex.x;
            if (bl2 && capVertex2 != null && capVertex2.x != capVertex3.x && bl == capVertex2.x < capVertex3.x) {
                capVertex2 = null;
                f = Float.MAX_VALUE;
            }
            if (!bl) continue;
            CapVertex capVertex4 = capVertexArray[1];
            bl2 = capVertex4.region != null;
            boolean bl4 = bl = (bl2 ? capVertex.interpolateX(capVertex4, capVertex4.prev) : capVertex4.x) >= capVertex.x;
            if (bl2 && capVertex2 != null && capVertex2.x != capVertex4.x && bl == capVertex2.x > capVertex4.x) {
                capVertex2 = null;
                f = Float.MAX_VALUE;
            }
            if (!bl || !(capVertexArray[2].y < f)) continue;
            f = capVertexArray[2].y;
            capVertex2 = capVertexArray[2];
        }
        return capVertex2;
    }

    private boolean checkWinding(CapVertex capVertex, CapVertex capVertex2, CapVertex capVertex3) {
        return (capVertex2.x - capVertex.x) * (capVertex3.y - capVertex.y) > (capVertex2.y - capVertex.y) * (capVertex3.x - capVertex.x);
    }

    private void addTriangle(CapVertex capVertex, CapVertex capVertex2, CapVertex capVertex3, String string) {
        ++this.nTriangles;
        if (this.checkWinding(capVertex, capVertex2, capVertex3)) {
            if (this.dumping) {
                this.drawTriangle(this.nTriangles, capVertex, capVertex2, capVertex3, "red");
            }
            this.outputTriangle(capVertex.ipt, capVertex2.ipt, capVertex3.ipt);
        } else if (this.dumping) {
            Logger.info("#!!!BAD WINDING " + string);
        }
        capVertex2.link(null);
    }

    private void drawTriangle(int n, CapVertex capVertex, CapVertex capVertex2, CapVertex capVertex3, String string) {
        T3 t3 = this.getInputPoint(capVertex);
        T3 t32 = this.getInputPoint(capVertex2);
        T3 t33 = this.getInputPoint(capVertex3);
        Logger.info("draw " + string + n + "/* " + capVertex.id + " " + capVertex2.id + " " + capVertex3.id + " */" + t3 + t32 + t33 + " color " + string);
    }

    private class CapVertex
    extends T3
    implements Cloneable {
        int ipt;
        String id = "";
        protected CapVertex yxNext;
        CapVertex prev;
        CapVertex next;
        CapVertex[] region;

        CapVertex(T3 t3, int n) {
            this.ipt = n;
            this.id = "" + n;
            this.setT(t3);
        }

        public CapVertex cloneV() {
            try {
                return (CapVertex)this.clone();
            }
            catch (Exception exception) {
                return null;
            }
        }

        protected float interpolateX(CapVertex capVertex, CapVertex capVertex2) {
            float f = capVertex2.y - capVertex.y;
            float f2 = capVertex2.x - capVertex.x;
            return f != 0.0f ? capVertex.x + (this.y - capVertex.y) * f2 / f : (f2 > 0.0f ? Float.MAX_VALUE : -3.4028235E38f);
        }

        protected void link(CapVertex capVertex) {
            if (capVertex == null) {
                this.prev.next = this.next;
                this.next.prev = this.prev;
                this.clear();
            } else {
                this.next = capVertex;
                capVertex.prev = this;
            }
        }

        protected void clear() {
            this.prev = null;
            this.next = null;
            this.yxNext = null;
            this.region = null;
        }

        private String dumpRegion() {
            String string = "\n#REGION d=" + this.region[0].id + " a=" + this.region[1].id + " last=" + this.region[2].id + "\n# ";
            CapVertex capVertex = this.region[1];
            while (true) {
                string = String.valueOf(string) + capVertex.id + " ";
                if (capVertex == this.region[0]) break;
                capVertex = capVertex.next;
            }
            return String.valueOf(string) + "\n";
        }

        @Override
        public String toString() {
            T3 t3;
            T3 t32 = t3 = MeshCapper.this.m3 == null ? this : new P3();
            if (MeshCapper.this.m3 != null) {
                MeshCapper.this.m3.rotate2(this, t3);
            }
            return "draw p" + this.id + " {" + t3.x + " " + t3.y + " " + t3.z + "} # " + (this.prev == null ? "null" : this.prev.id) + (this.next == null ? " null" : " " + this.next.id) + (this.region == null ? "" : this.dumpRegion());
        }
    }

    public class MeshCapperSorter
    implements Comparator<CapVertex> {
        @Override
        public int compare(CapVertex capVertex, CapVertex capVertex2) {
            return capVertex.y < capVertex2.y ? 1 : (capVertex.y > capVertex2.y || capVertex.x < capVertex2.x ? -1 : (capVertex.x > capVertex2.x ? 1 : 0));
        }
    }
}

