/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.jcodings.Encoding;
import org.joni.ast.Node;
import org.joni.constants.internal.StringType;

public final class StringNode
extends Node
implements StringType {
    private static final int NODE_STR_MARGIN = 16;
    private static final int NODE_STR_BUF_SIZE = 24;
    public static final StringNode EMPTY = new StringNode(null, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public byte[] bytes;
    public int p;
    public int end;
    public int flag;

    private StringNode(int size2) {
        super(0);
        this.bytes = new byte[size2];
    }

    public StringNode() {
        this(24);
    }

    public static StringNode fromCodePoint(int code, Encoding enc) {
        StringNode str = new StringNode(7);
        str.end = enc.codeToMbc(code, str.bytes, str.p);
        return str;
    }

    public StringNode(byte[] bytes2, int p2, int end2) {
        super(0);
        this.bytes = bytes2;
        this.p = p2;
        this.end = end2;
        this.setShared();
    }

    private void ensure(int ahead) {
        int len = this.end - this.p + ahead;
        if (len >= this.bytes.length) {
            byte[] tmp = new byte[len + 16];
            System.arraycopy(this.bytes, this.p, tmp, 0, this.end - this.p);
            this.bytes = tmp;
        }
    }

    private void modifyEnsure(int ahead) {
        if (this.isShared()) {
            int len = this.end - this.p + ahead;
            byte[] tmp = new byte[len + 16];
            System.arraycopy(this.bytes, this.p, tmp, 0, this.end - this.p);
            this.bytes = tmp;
            this.end -= this.p;
            this.p = 0;
            this.clearShared();
        } else {
            this.ensure(ahead);
        }
    }

    @Override
    public String getName() {
        return "String";
    }

    public int length() {
        return this.end - this.p;
    }

    public int length(Encoding enc) {
        return enc.strLength(this.bytes, this.p, this.end);
    }

    public StringNode splitLastChar(Encoding enc) {
        int prev;
        StringNode n = null;
        if (this.end > this.p && (prev = enc.prevCharHead(this.bytes, this.p, this.end, this.end)) != -1 && prev > this.p) {
            n = new StringNode(this.bytes, prev, this.end);
            if (this.isRaw()) {
                n.setRaw();
            }
            this.end = prev;
        }
        return n;
    }

    public boolean canBeSplit(Encoding enc) {
        if (this.end > this.p) {
            return enc.length(this.bytes, this.p, this.end) < this.end - this.p;
        }
        return false;
    }

    public void set(byte[] bytes2, int p2, int end2) {
        this.bytes = bytes2;
        this.p = p2;
        this.end = end2;
        this.setShared();
    }

    public void catBytes(byte[] cat, int catP, int catEnd) {
        int len = catEnd - catP;
        this.modifyEnsure(len);
        System.arraycopy(cat, catP, this.bytes, this.end, len);
        this.end += len;
    }

    public void catByte(byte c) {
        this.modifyEnsure(1);
        this.bytes[this.end++] = c;
    }

    public void catCode(int code, Encoding enc) {
        this.modifyEnsure(7);
        this.end += enc.codeToMbc(code, this.bytes, this.end);
    }

    public void setRaw() {
        this.flag |= 1;
    }

    public void clearRaw() {
        this.flag &= 0xFFFFFFFE;
    }

    public boolean isRaw() {
        return (this.flag & 1) != 0;
    }

    public void setAmbig() {
        this.flag |= 2;
    }

    public void clearAmbig() {
        this.flag &= 0xFFFFFFFD;
    }

    public boolean isAmbig() {
        return (this.flag & 2) != 0;
    }

    public void setDontGetOptInfo() {
        this.flag |= 4;
    }

    public void clearDontGetOptInfo() {
        this.flag &= 0xFFFFFFFB;
    }

    public boolean isDontGetOptInfo() {
        return (this.flag & 4) != 0;
    }

    public void setShared() {
        this.flag |= 8;
    }

    public void clearShared() {
        this.flag &= 0xFFFFFFF7;
    }

    public boolean isShared() {
        return (this.flag & 8) != 0;
    }

    public String flagsToString() {
        StringBuilder flags2 = new StringBuilder();
        if (this.isRaw()) {
            flags2.append("RAW ");
        }
        if (this.isAmbig()) {
            flags2.append("AMBIG ");
        }
        if (this.isDontGetOptInfo()) {
            flags2.append("DONT_GET_OPT_INFO ");
        }
        if (this.isShared()) {
            flags2.append("SHARED ");
        }
        return flags2.toString();
    }

    @Override
    public String toString(int level2) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n  flags: " + this.flagsToString());
        sb.append("\n  bytes: '");
        for (int i2 = this.p; i2 < this.end; ++i2) {
            if ((this.bytes[i2] & 0xFF) >= 32 && (this.bytes[i2] & 0xFF) < 127) {
                sb.append((char)this.bytes[i2]);
                continue;
            }
            sb.append(String.format("[0x%02x]", this.bytes[i2]));
        }
        sb.append("'");
        return sb.toString();
    }
}

