/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class BcTlsSecret
extends AbstractTlsSecret {
    protected final BcTlsCrypto crypto;

    public BcTlsSecret(BcTlsCrypto bcTlsCrypto, byte[] byArray) {
        super(byArray);
        this.crypto = bcTlsCrypto;
    }

    public synchronized TlsSecret deriveUsingPRF(int n, String string, byte[] byArray, int n2) {
        this.checkAlive();
        byte[] byArray2 = Arrays.concatenate((byte[])Strings.toByteArray((String)string), (byte[])byArray);
        byte[] byArray3 = n == 0 ? this.prf_1_0(this.data, byArray2, n2) : this.prf_1_2(n, this.data, byArray2, n2);
        return this.crypto.adoptLocalSecret(byArray3);
    }

    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }

    protected void hmacHash(Digest digest, byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3) {
        HMac hMac = new HMac(digest);
        hMac.init((CipherParameters)new KeyParameter(byArray, n, n2));
        byte[] byArray4 = byArray2;
        int n3 = hMac.getMacSize();
        byte[] byArray5 = new byte[n3];
        byte[] byArray6 = new byte[n3];
        for (int i = 0; i < byArray3.length; i += n3) {
            hMac.update(byArray4, 0, byArray4.length);
            hMac.doFinal(byArray5, 0);
            byArray4 = byArray5;
            hMac.update(byArray4, 0, byArray4.length);
            hMac.update(byArray2, 0, byArray2.length);
            hMac.doFinal(byArray6, 0);
            System.arraycopy(byArray6, 0, byArray3, i, Math.min(n3, byArray3.length - i));
        }
    }

    protected byte[] prf_1_0(byte[] byArray, byte[] byArray2, int n) {
        int n2 = (byArray.length + 1) / 2;
        byte[] byArray3 = new byte[n];
        this.hmacHash(this.crypto.createDigest((short)1), byArray, 0, n2, byArray2, byArray3);
        byte[] byArray4 = new byte[n];
        this.hmacHash(this.crypto.createDigest((short)2), byArray, byArray.length - n2, n2, byArray2, byArray4);
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            byArray3[n3] = (byte)(byArray3[n3] ^ byArray4[i]);
        }
        return byArray3;
    }

    protected byte[] prf_1_2(int n, byte[] byArray, byte[] byArray2, int n2) {
        Digest digest = this.crypto.createDigest(TlsUtils.getHashAlgorithmForPRFAlgorithm(n));
        byte[] byArray3 = new byte[n2];
        this.hmacHash(digest, byArray, 0, byArray.length, byArray2, byArray3);
        return byArray3;
    }
}

