/* DO NOT EDIT!  Generated by mk-octave-config-h.sh.  */
/*

Copyright (C) 2016-2018 John W. Eaton

This file is part of Octave.

Octave is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 3 of the License, or (at your
option) any later version.

Octave is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with Octave; see the file COPYING.  If not, see
<https://www.gnu.org/licenses/>.

*/

/*

All Octave source files should begin with

  #if defined (HAVE_CONFIG_H)
  #  include "config.h"
  #endif

All public Octave header files should have the form

  #if ! defined (INCLUSION_GUARD_SYMBOL)
  #define INCLUSION_GUARD_SYMBOL 1

  #include "octave-config.h"

  // Contents of header file.

  #endif

In Octave source files, INCLUSION_GUARD_SYMBOL should have the form

  octave_NAME_h

with NAME formed from the header file name with '-' replaced by '_'.

It is safe to include octave-config.h unconditionally since it will
expand to an empty file if it is included after Octave's
autoconf-generated config.h file.

Users of Octave's libraries should not need to include octave-config.h
since all of Octave's header files already include it.

*/

#if ! defined (octave_octave_config_h)
#define octave_octave_config_h 1

#if ! defined (OCTAVE_AUTOCONFIG_H_INCLUDED)

#  if defined (__cplusplus)
#    include <cstdint>
#  else
#    include <stdint.h>
#  endif

#  if defined (__GNUC__)
#    if __GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ >= 5)
#      define OCTAVE_DEPRECATED(ver, msg) __attribute__ ((__deprecated__ ("[" #ver "]: " msg)))
#    else
#      define OCTAVE_DEPRECATED(ver, msg) __attribute__ ((__deprecated__))
#    endif
#    define OCTAVE_NORETURN __attribute__ ((__noreturn__))
#    define OCTAVE_UNUSED __attribute__ ((__unused__))

#    define HAVE_OCTAVE_DEPRECATED_ATTR 1
#    define HAVE_OCTAVE_NORETURN_ATTR 1
#    define HAVE_OCTAVE_UNUSED_ATTR 1
#  else
#    define OCTAVE_DEPRECATED(ver, msg)
#    define OCTAVE_NORETURN
#    define OCTAVE_UNUSED

/* #    undef HAVE_OCTAVE_DEPRECATED_ATTR */
/* #    undef HAVE_OCTAVE_NORETURN_ATTR */
/* #    undef HAVE_OCTAVE_UNUSED_ATTR */
#  endif

#  if ! defined (OCTAVE_FALLTHROUGH)
#    if defined (__cplusplus) && __cplusplus > 201402L
#      define OCTAVE_FALLTHROUGH [[fallthrough]]
#    elif defined (__GNUC__) && __GNUC__ < 7
#      define OCTAVE_FALLTHROUGH ((void) 0)
#    else
#      define OCTAVE_FALLTHROUGH __attribute__ ((__fallthrough__))
#    endif
#  endif

#  define OCTAVE_USE_DEPRECATED_FUNCTIONS 1

#  if defined (__cplusplus)
template <typename T>
static inline void
octave_unused_parameter (const T&)
{ }
#  else
#    define octave_unused_parameter(param) (void) param;
#  endif

#  if defined (_MSC_VER)
#    define OCTAVE_EXPORT __declspec(dllexport)
#    define OCTAVE_IMPORT __declspec(dllimport)
#  else
     /* All other compilers, at least for now. */
#    define OCTAVE_EXPORT
#    define OCTAVE_IMPORT
#  endif

#  define OCTAVE_API OCTAVE_IMPORT
#  define OCTINTERP_API OCTAVE_IMPORT

typedef int64_t octave_idx_type;
typedef int32_t octave_f77_int_type;

#  define OCTAVE_HAVE_F77_INT_TYPE 1


#  if defined (__cplusplus) && ! defined (OCTAVE_THREAD_LOCAL)
#    define OCTAVE_THREAD_LOCAL
#  endif

#  define OCTAVE_FLOAT_TRUNCATE volatile

#  define OCTAVE_ENABLE_64 1
#  define OCTAVE_ENABLE_ATOMIC_REFCOUNT 1
#  define OCTAVE_ENABLE_OPENMP 1
#  define OCTAVE_HAVE_FAST_INT_OPS 1
#  define OCTAVE_HAVE_LONG_LONG_INT 1
#  define OCTAVE_HAVE_UNSIGNED_LONG_LONG_INT 1
#  define OCTAVE_HAVE_OVERLOAD_CHAR_INT8_TYPES 1
#  define OCTAVE_SIZEOF_F77_INT_TYPE 4
#  define OCTAVE_SIZEOF_IDX_TYPE 8

/* #  undef gid_t */
/* #  undef uid_t */
/* #  undef nlink_t */
/* typedef short dev_t; */
/* typedef unsigned long ino_t; */

/* #  undef OCTAVE_INT_USE_LONG_DOUBLE */
/* #  undef OCTAVE_ENSURE_LONG_DOUBLE_OPERATIONS_ARE_NOT_TRUNCATED */

/* #  undef F77_USES_CRAY_CALLING_CONVENTION */
/* #  undef F77_USES_F2C_CALLING_CONVENTION */
#  define F77_USES_GFORTRAN_CALLING_CONVENTION 1
/* #  undef F77_USES_VISUAL_FORTRAN_CALLING_CONVENTION */

#  define F77_FUNC(name,NAME) name ## _
#  define F77_FUNC_(name,NAME) name ## _

#endif

#endif
