/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.ModelPreviewComponent;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.ModelMaterialsController;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Locale;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ModelMaterialsComponent
extends JButton
implements View {
    public ModelMaterialsComponent(final UserPreferences userPreferences, final ModelMaterialsController modelMaterialsController) {
        this.setText(SwingTools.getLocalizedLabelText(userPreferences, ModelMaterialsComponent.class, "modifyButton.text", new Object[0]));
        if (!OperatingSystem.isMacOSX()) {
            this.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ModelMaterialsComponent.class, "modifyButton.mnemonic", new Object[0])).getKeyCode());
        }
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelMaterialsPanel modelMaterialsPanel = new ModelMaterialsPanel(userPreferences, modelMaterialsController);
                modelMaterialsPanel.displayView(ModelMaterialsComponent.this);
            }
        });
    }

    private static class ModelMaterialsPanel
    extends JPanel {
        private final ModelMaterialsController controller;
        private JLabel previewLabel;
        private ModelPreviewComponent previewComponent;
        private JLabel materialsLabel;
        private JList materialsList;
        private JLabel colorAndTextureLabel;
        private JRadioButton defaultColorAndTextureRadioButton;
        private JRadioButton invisibleRadioButton;
        private JRadioButton colorRadioButton;
        private ColorButton colorButton;
        private JRadioButton textureRadioButton;
        private JComponent textureComponent;
        private JLabel shininessLabel;
        private JSlider shininessSlider;
        private PropertyChangeListener textureChangeListener;

        public ModelMaterialsPanel(UserPreferences userPreferences, ModelMaterialsController modelMaterialsController) {
            super(new GridBagLayout());
            this.controller = modelMaterialsController;
            this.createComponents(userPreferences, modelMaterialsController);
            this.setMnemonics(userPreferences);
            this.layoutComponents();
        }

        private void createComponents(UserPreferences userPreferences, final ModelMaterialsController modelMaterialsController) {
            this.materialsLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ModelMaterialsComponent.class, "materialsLabel.text", new Object[0]));
            this.materialsList = new JList(new MaterialsListModel(modelMaterialsController));
            this.materialsList.setSelectionMode(2);
            this.materialsList.setCellRenderer(new MaterialListCellRenderer());
            this.previewLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ModelMaterialsComponent.class, "previewLabel.text", new Object[0]));
            this.previewComponent = new ModelPreviewComponent(true);
            this.previewComponent.setFocusable(false);
            ModelManager.getInstance().loadModel(modelMaterialsController.getModel(), new ModelManager.ModelObserver(){

                @Override
                public void modelUpdated(BranchGroup branchGroup) {
                    final MaterialsListModel materialsListModel = (MaterialsListModel)materialsList.getModel();
                    previewComponent.setModel(modelMaterialsController.getModel(), modelMaterialsController.isBackFaceShown(), modelMaterialsController.getModelRotation(), modelMaterialsController.getModelWidth(), modelMaterialsController.getModelDepth(), modelMaterialsController.getModelHeight());
                    previewComponent.setModelMaterials(materialsListModel.getMaterials());
                    previewComponent.setModelTranformations(modelMaterialsController.getModelTransformations());
                    materialsListModel.addListDataListener(new ListDataListener(){

                        @Override
                        public void contentsChanged(ListDataEvent listDataEvent) {
                            previewComponent.setModelMaterials(materialsListModel.getMaterials());
                        }

                        @Override
                        public void intervalRemoved(ListDataEvent listDataEvent) {
                        }

                        @Override
                        public void intervalAdded(ListDataEvent listDataEvent) {
                        }
                    });
                }

                @Override
                public void modelError(Exception exception) {
                    previewLabel.setVisible(false);
                    previewComponent.setVisible(false);
                }
            });
            this.colorAndTextureLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ModelMaterialsComponent.class, "colorAndTextureLabel.text", new Object[0]));
            this.defaultColorAndTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, ModelMaterialsComponent.class, "defaultColorAndTextureRadioButton.text", new Object[0]));
            final ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (defaultColorAndTextureRadioButton.isEnabled() && defaultColorAndTextureRadioButton.isSelected()) {
                        for (int n : materialsList.getSelectedIndices()) {
                            HomeMaterial homeMaterial = (HomeMaterial)materialsList.getModel().getElementAt(n);
                            ((MaterialsListModel)materialsList.getModel()).setMaterialAt(new HomeMaterial(homeMaterial.getName(), null, null, homeMaterial.getShininess()), n);
                        }
                    }
                }
            };
            this.defaultColorAndTextureRadioButton.addChangeListener(changeListener);
            this.invisibleRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, ModelMaterialsComponent.class, "invisibleRadioButton.text", new Object[0]));
            final ChangeListener changeListener2 = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (invisibleRadioButton.isEnabled() && invisibleRadioButton.isSelected()) {
                        for (int n : materialsList.getSelectedIndices()) {
                            HomeMaterial homeMaterial = (HomeMaterial)materialsList.getModel().getElementAt(n);
                            ((MaterialsListModel)materialsList.getModel()).setMaterialAt(new HomeMaterial(homeMaterial.getName(), 0, null, homeMaterial.getShininess()), n);
                        }
                    }
                }
            };
            this.invisibleRadioButton.addChangeListener(changeListener2);
            this.colorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, ModelMaterialsComponent.class, "colorRadioButton.text", new Object[0]));
            final ChangeListener changeListener3 = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (colorRadioButton.isEnabled() && colorRadioButton.isSelected()) {
                        for (int n : materialsList.getSelectedIndices()) {
                            HomeMaterial homeMaterial = (HomeMaterial)materialsList.getModel().getElementAt(n);
                            Integer n2 = ((MaterialsListModel)materialsList.getModel()).getDefaultMaterialAt(n).getColor();
                            Integer n3 = n2 != colorButton.getColor() ? colorButton.getColor() : null;
                            ((MaterialsListModel)materialsList.getModel()).setMaterialAt(new HomeMaterial(homeMaterial.getName(), n3, null, homeMaterial.getShininess()), n);
                        }
                    }
                }
            };
            this.colorRadioButton.addChangeListener(changeListener3);
            this.colorButton = new ColorButton(userPreferences);
            this.colorButton.setColorDialogTitle(userPreferences.getLocalizedString(ModelMaterialsComponent.class, "colorDialog.title", new Object[0]));
            final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!colorRadioButton.isSelected()) {
                        colorRadioButton.setSelected(true);
                    } else {
                        changeListener3.stateChanged(null);
                    }
                }
            };
            this.colorButton.addPropertyChangeListener("color", propertyChangeListener);
            final TextureChoiceController textureChoiceController = modelMaterialsController.getTextureController();
            this.textureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, ModelMaterialsComponent.class, "textureRadioButton.text", new Object[0]));
            final ChangeListener changeListener4 = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (textureRadioButton.isEnabled() && textureRadioButton.isSelected()) {
                        for (int n : materialsList.getSelectedIndices()) {
                            HomeMaterial homeMaterial = (HomeMaterial)materialsList.getModel().getElementAt(n);
                            HomeTexture homeTexture = ((MaterialsListModel)materialsList.getModel()).getDefaultMaterialAt(n).getTexture();
                            HomeTexture homeTexture2 = homeTexture != textureChoiceController.getTexture() ? textureChoiceController.getTexture() : null;
                            ((MaterialsListModel)materialsList.getModel()).setMaterialAt(new HomeMaterial(homeMaterial.getName(), null, homeTexture2, homeMaterial.getShininess()), n);
                        }
                    }
                }
            };
            this.textureRadioButton.addChangeListener(changeListener4);
            this.textureComponent = (JComponent)((Object)textureChoiceController.getView());
            this.textureChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!textureRadioButton.isSelected()) {
                        textureRadioButton.setSelected(true);
                    } else {
                        changeListener4.stateChanged(null);
                    }
                }
            };
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.defaultColorAndTextureRadioButton);
            buttonGroup.add(this.invisibleRadioButton);
            buttonGroup.add(this.colorRadioButton);
            buttonGroup.add(this.textureRadioButton);
            this.shininessLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ModelMaterialsComponent.class, "shininessLabel.text", new Object[0]));
            this.shininessSlider = new JSlider(0, 128);
            JLabel jLabel = new JLabel(userPreferences.getLocalizedString(ModelMaterialsComponent.class, "mattLabel.text", new Object[0]));
            JLabel jLabel2 = new JLabel(userPreferences.getLocalizedString(ModelMaterialsComponent.class, "shinyLabel.text", new Object[0]));
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            ((Dictionary)hashtable).put(0, jLabel);
            ((Dictionary)hashtable).put(128, jLabel2);
            this.shininessSlider.setLabelTable(hashtable);
            this.shininessSlider.setPaintLabels(true);
            this.shininessSlider.setPaintTicks(true);
            this.shininessSlider.setMajorTickSpacing(16);
            final ChangeListener changeListener5 = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    for (int n : materialsList.getSelectedIndices()) {
                        HomeMaterial homeMaterial = (HomeMaterial)materialsList.getModel().getElementAt(n);
                        int n2 = shininessSlider.getValue();
                        ((MaterialsListModel)materialsList.getModel()).setMaterialAt(new HomeMaterial(homeMaterial.getName(), homeMaterial.getColor(), homeMaterial.getTexture(), Float.valueOf((float)n2 / 128.0f)), n);
                    }
                }
            };
            this.shininessSlider.addChangeListener(changeListener5);
            this.materialsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!materialsList.isSelectionEmpty()) {
                        defaultColorAndTextureRadioButton.removeChangeListener(changeListener);
                        invisibleRadioButton.removeChangeListener(changeListener2);
                        colorRadioButton.removeChangeListener(changeListener3);
                        textureRadioButton.removeChangeListener(changeListener4);
                        colorButton.removePropertyChangeListener("color", propertyChangeListener);
                        if (((JComponent)((Object)textureChoiceController.getView())).isShowing()) {
                            textureChoiceController.removePropertyChangeListener(TextureChoiceController.Property.TEXTURE, textureChangeListener);
                        }
                        shininessSlider.removeChangeListener(changeListener5);
                        HomeMaterial homeMaterial = (HomeMaterial)materialsList.getSelectedValue();
                        HomeTexture homeTexture = homeMaterial.getTexture();
                        Integer n = homeMaterial.getColor();
                        Float f = homeMaterial.getShininess();
                        HomeMaterial homeMaterial2 = ((MaterialsListModel)materialsList.getModel()).getDefaultMaterialAt(materialsList.getSelectedIndex());
                        if (n == null && homeTexture == null) {
                            defaultColorAndTextureRadioButton.setSelected(true);
                            homeTexture = homeMaterial2.getTexture();
                            if (homeTexture != null) {
                                colorButton.setColor(null);
                                modelMaterialsController.getTextureController().setTexture(homeTexture);
                            } else {
                                n = homeMaterial2.getColor();
                                if (n != null) {
                                    textureChoiceController.setTexture(null);
                                    colorButton.setColor(n);
                                }
                            }
                        } else if (homeTexture != null) {
                            textureRadioButton.setSelected(true);
                            colorButton.setColor(null);
                            textureChoiceController.setTexture(homeTexture);
                        } else if ((n & 0xFF000000) == 0) {
                            invisibleRadioButton.setSelected(true);
                            homeTexture = homeMaterial2.getTexture();
                            if (homeTexture != null) {
                                colorButton.setColor(null);
                                modelMaterialsController.getTextureController().setTexture(homeTexture);
                            } else {
                                n = homeMaterial2.getColor();
                                if (n != null) {
                                    textureChoiceController.setTexture(null);
                                    colorButton.setColor(n);
                                }
                            }
                        } else {
                            colorRadioButton.setSelected(true);
                            textureChoiceController.setTexture(null);
                            colorButton.setColor(n);
                        }
                        if (f != null) {
                            shininessSlider.setValue((int)(f.floatValue() * 128.0f));
                        } else {
                            shininessSlider.setValue((int)(homeMaterial2.getShininess().floatValue() * 128.0f));
                        }
                        defaultColorAndTextureRadioButton.addChangeListener(changeListener);
                        invisibleRadioButton.addChangeListener(changeListener2);
                        colorRadioButton.addChangeListener(changeListener3);
                        textureRadioButton.addChangeListener(changeListener4);
                        colorButton.addPropertyChangeListener("color", propertyChangeListener);
                        if (((JComponent)((Object)textureChoiceController.getView())).isShowing()) {
                            textureChoiceController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, textureChangeListener);
                        }
                        shininessSlider.addChangeListener(changeListener5);
                    }
                    this.enableComponents();
                }
            });
            this.materialsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && !materialsList.isSelectionEmpty()) {
                        if (colorButton.getColor() != null) {
                            colorButton.doClick(200);
                        } else if (modelMaterialsController.getTextureController().getTexture() != null && textureComponent instanceof AbstractButton) {
                            ((AbstractButton)textureComponent).doClick(200);
                        }
                    }
                }
            });
            if (this.materialsList.getModel().getSize() > 0) {
                this.materialsList.setSelectedIndex(0);
            } else {
                this.materialsList.getModel().addListDataListener(new ListDataListener(){

                    @Override
                    public void intervalAdded(ListDataEvent listDataEvent) {
                        materialsList.setSelectedIndex(0);
                        ((ListModel)listDataEvent.getSource()).removeListDataListener(this);
                    }

                    @Override
                    public void contentsChanged(ListDataEvent listDataEvent) {
                        this.intervalAdded(listDataEvent);
                    }

                    @Override
                    public void intervalRemoved(ListDataEvent listDataEvent) {
                    }
                });
            }
            this.enableComponents();
        }

        private void enableComponents() {
            boolean bl = this.materialsList.isSelectionEmpty();
            this.defaultColorAndTextureRadioButton.setEnabled(!bl);
            this.invisibleRadioButton.setEnabled(!bl);
            this.textureRadioButton.setEnabled(!bl);
            this.textureComponent.setEnabled(!bl);
            this.colorRadioButton.setEnabled(!bl);
            this.colorButton.setEnabled(!bl);
            this.shininessSlider.setEnabled(!bl);
        }

        private void setMnemonics(UserPreferences userPreferences) {
            if (!OperatingSystem.isMacOSX()) {
                this.materialsLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ModelMaterialsComponent.class, "materialsLabel.mnemonic", new Object[0])).getKeyCode());
                this.materialsLabel.setLabelFor(this.materialsList);
                this.defaultColorAndTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ModelMaterialsComponent.class, "defaultColorAndTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.invisibleRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ModelMaterialsComponent.class, "invisibleRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.colorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ModelMaterialsComponent.class, "colorRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.textureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ModelMaterialsComponent.class, "textureRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.shininessLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ModelMaterialsComponent.class, "shininessLabel.mnemonic", new Object[0])).getKeyCode());
                this.shininessLabel.setLabelFor(this.shininessSlider);
            }
        }

        private void layoutComponents() {
            int n = Math.round(5.0f * SwingTools.getResolutionScale());
            this.add((Component)this.previewLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, 10), 0, 0));
            float f = SwingTools.getResolutionScale();
            this.previewComponent.setPreferredSize(new Dimension((int)(250.0f * f), (int)(250.0f * f)));
            this.add((Component)this.previewComponent, new GridBagConstraints(0, 1, 1, 7, 0.5, 1.0, 11, 1, new Insets(2, 0, 0, 15), 0, 0));
            this.add((Component)this.materialsLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, 15), 0, 0));
            JScrollPane jScrollPane = new JScrollPane(this.materialsList);
            Dimension dimension = jScrollPane.getPreferredSize();
            jScrollPane.setPreferredSize(new Dimension(Math.min(200, dimension.width), dimension.height));
            this.add((Component)jScrollPane, new GridBagConstraints(1, 1, 1, 7, 0.5, 1.0, 10, 1, new Insets(0, 0, 0, 15), 0, 0));
            SwingTools.installFocusBorder(this.materialsList);
            this.add((Component)this.colorAndTextureLabel, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, 0), 0, 0));
            this.add((Component)this.defaultColorAndTextureRadioButton, new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, 0), 0, 0));
            this.add((Component)this.invisibleRadioButton, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, 0), 0, 0));
            this.add((Component)this.colorRadioButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n, n), 0, 0));
            this.add((Component)this.colorButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, n, 0), 0, 0));
            this.add((Component)this.textureRadioButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, n), 0, 0));
            this.add((Component)this.textureComponent, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.textureComponent.setPreferredSize(this.colorButton.getPreferredSize());
            this.add((Component)this.shininessLabel, new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 21, 0, new Insets(15, 0, n, 0), 0, 0));
            this.add((Component)this.shininessSlider, new GridBagConstraints(2, 6, 2, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, n, 0), -20, 0));
        }

        public void displayView(View view) {
            JOptionPane jOptionPane = new JOptionPane(this, -1, 2);
            JRootPane jRootPane = SwingUtilities.getRootPane((JComponent)((Object)view));
            if (jRootPane != null) {
                jOptionPane.setComponentOrientation(jRootPane.getComponentOrientation());
            }
            final JDialog jDialog = jOptionPane.createDialog(jRootPane, this.controller.getDialogTitle());
            jDialog.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
            jDialog.setResizable(true);
            jDialog.pack();
            jDialog.setMinimumSize(this.getPreferredSize());
            this.controller.getTextureController().addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, this.textureChangeListener);
            jDialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this);
                    jDialog.removeComponentListener(this);
                }
            });
            final MaterialBlinker materialBlinker = new MaterialBlinker();
            materialBlinker.start();
            this.materialsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    materialBlinker.restart();
                }
            });
            jDialog.setVisible(true);
            jDialog.dispose();
            materialBlinker.stop();
            this.controller.getTextureController().removePropertyChangeListener(TextureChoiceController.Property.TEXTURE, this.textureChangeListener);
            if (Integer.valueOf(0).equals(jOptionPane.getValue())) {
                this.controller.setMaterials(((MaterialsListModel)this.materialsList.getModel()).getMaterials());
            }
        }

        private class MaterialBlinker
        extends Timer {
            public MaterialBlinker() {
                super(500, null);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MaterialBlinker.this.toggleBlinkingState();
                    }
                });
            }

            private void toggleBlinkingState() {
                MaterialsListModel materialsListModel = (MaterialsListModel)ModelMaterialsPanel.this.materialsList.getModel();
                HomeMaterial[] homeMaterialArray = materialsListModel.getMaterials();
                if (materialsListModel.getSize() > 1) {
                    if (this.getDelay() != 1000) {
                        this.setDelay(1000);
                        for (int n : ModelMaterialsPanel.this.materialsList.getSelectedIndices()) {
                            homeMaterialArray = homeMaterialArray == null ? new HomeMaterial[materialsListModel.getSize()] : (HomeMaterial[])homeMaterialArray.clone();
                            HomeMaterial homeMaterial = materialsListModel.getDefaultMaterialAt(n);
                            HomeMaterial homeMaterial2 = homeMaterialArray[n] != null ? homeMaterialArray[n] : homeMaterial;
                            int n2 = ModelMaterialsPanel.this.materialsList.getSelectionBackground().darker().getRGB();
                            if (homeMaterial2.getTexture() == null) {
                                int n3;
                                int n4;
                                int n5;
                                Integer n6 = homeMaterial2.getColor();
                                if (n6 == null) {
                                    n6 = homeMaterial.getColor();
                                }
                                if (Math.max(n5 = n6 >> 16 & 0xFF, Math.max(n4 = n6 >> 8 & 0xFF, n3 = n6 & 0xFF)) > 119) {
                                    n2 = new Color(n6).darker().darker().getRGB();
                                } else if ((n5 + n4 + n3) / 3 > 15) {
                                    n2 = new Color(n6).brighter().brighter().getRGB();
                                }
                            }
                            homeMaterialArray[n] = new HomeMaterial(homeMaterial2.getName(), n2, null, homeMaterial2.getShininess());
                            ModelMaterialsPanel.this.previewComponent.setModelMaterials(homeMaterialArray);
                        }
                    } else {
                        this.setDelay(100);
                        ModelMaterialsPanel.this.previewComponent.setModelMaterials(homeMaterialArray);
                    }
                }
            }

            @Override
            public void restart() {
                this.setInitialDelay(100);
                this.setDelay(100);
                super.restart();
            }
        }

        private static class MaterialsListModel
        extends AbstractListModel {
            private HomeMaterial[] defaultMaterials;
            private HomeMaterial[] materials;

            public MaterialsListModel(final ModelMaterialsController modelMaterialsController) {
                this.materials = modelMaterialsController.getMaterials();
                ModelManager.getInstance().loadModel(modelMaterialsController.getModel(), new ModelManager.ModelObserver(){

                    @Override
                    public void modelUpdated(BranchGroup branchGroup) {
                        MaterialsListModel.access$1402(this, ModelManager.getInstance().getMaterials((Node)branchGroup, modelMaterialsController.getModelCreator()));
                        if (materials != null) {
                            HomeMaterial[] homeMaterialArray = new HomeMaterial[defaultMaterials.length];
                            boolean bl = false;
                            block0: for (int i = 0; i < defaultMaterials.length; ++i) {
                                String string = defaultMaterials[i].getName();
                                for (int j = 0; j < materials.length; ++j) {
                                    if (materials[j] == null || !materials[j].getName().equals(string)) continue;
                                    homeMaterialArray[i] = materials[j];
                                    bl = true;
                                    continue block0;
                                }
                            }
                            if (bl) {
                                MaterialsListModel.access$1502(this, homeMaterialArray);
                            } else {
                                MaterialsListModel.access$1502(this, null);
                            }
                        }
                        this.fireContentsChanged(this, 0, defaultMaterials.length);
                    }

                    @Override
                    public void modelError(Exception exception) {
                    }
                });
            }

            @Override
            public Object getElementAt(int n) {
                if (this.materials != null && this.materials[n] != null && this.materials[n].getName() != null && this.materials[n].getName().equals(this.defaultMaterials[n].getName())) {
                    return this.materials[n];
                }
                return new HomeMaterial(this.defaultMaterials[n].getName(), null, null, null);
            }

            @Override
            public int getSize() {
                if (this.defaultMaterials != null) {
                    return this.defaultMaterials.length;
                }
                return 0;
            }

            public HomeMaterial getDefaultMaterialAt(int n) {
                return this.defaultMaterials[n];
            }

            public void setMaterialAt(HomeMaterial homeMaterial, int n) {
                if (this.materials != null && homeMaterial.getColor() == null && homeMaterial.getTexture() == null && homeMaterial.getShininess() == null) {
                    this.materials[n] = null;
                    boolean bl = true;
                    for (HomeMaterial homeMaterial2 : this.materials) {
                        if (homeMaterial2 == null) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        this.materials = null;
                    }
                } else {
                    if (this.materials == null || this.materials.length != this.defaultMaterials.length) {
                        this.materials = new HomeMaterial[this.defaultMaterials.length];
                    }
                    this.materials[n] = homeMaterial;
                }
                this.fireContentsChanged(this, n, n);
            }

            public HomeMaterial[] getMaterials() {
                return this.materials;
            }

            static /* synthetic */ HomeMaterial[] access$1402(MaterialsListModel materialsListModel, HomeMaterial[] homeMaterialArray) {
                materialsListModel.defaultMaterials = homeMaterialArray;
                return homeMaterialArray;
            }

            static /* synthetic */ HomeMaterial[] access$1502(MaterialsListModel materialsListModel, HomeMaterial[] homeMaterialArray) {
                materialsListModel.materials = homeMaterialArray;
                return homeMaterialArray;
            }
        }

        private class MaterialListCellRenderer
        extends DefaultListCellRenderer {
            private Font defaultFont;
            private Icon emptyIcon = new Icon(){

                @Override
                public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                }

                @Override
                public int getIconHeight() {
                    return MaterialListCellRenderer.this.defaultFont.getSize();
                }

                @Override
                public int getIconWidth() {
                    return this.getIconHeight();
                }
            };

            private MaterialListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(final JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (this.defaultFont == null) {
                    this.defaultFont = this.getFont();
                }
                HomeMaterial homeMaterial = (HomeMaterial)object;
                super.getListCellRendererComponent((JList<?>)jList, homeMaterial.getName(), n, bl, bl2);
                HomeTexture homeTexture = homeMaterial.getTexture();
                Integer n2 = homeMaterial.getColor();
                HomeMaterial homeMaterial2 = ((MaterialsListModel)ModelMaterialsPanel.this.materialsList.getModel()).getDefaultMaterialAt(n);
                if (homeTexture == null && n2 == null && (homeTexture = homeMaterial2.getTexture()) == null) {
                    n2 = homeMaterial2.getColor();
                }
                if (homeTexture != null) {
                    final HomeTexture homeTexture2 = homeTexture;
                    this.setIcon(new Icon(){

                        @Override
                        public int getIconHeight() {
                            return MaterialListCellRenderer.this.defaultFont.getSize();
                        }

                        @Override
                        public int getIconWidth() {
                            return this.getIconHeight();
                        }

                        @Override
                        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                            Icon icon = IconManager.getInstance().getIcon(homeTexture2.getImage(), this.getIconHeight(), jList);
                            if (icon.getIconWidth() != icon.getIconHeight()) {
                                Graphics2D graphics2D = (Graphics2D)graphics;
                                AffineTransform affineTransform = graphics2D.getTransform();
                                graphics2D.translate(n, n2);
                                graphics2D.scale((float)icon.getIconHeight() / (float)icon.getIconWidth(), 1.0);
                                icon.paintIcon(component, graphics2D, 0, 0);
                                graphics2D.setTransform(affineTransform);
                            } else {
                                icon.paintIcon(component, graphics, n, n2);
                            }
                        }
                    });
                } else if (n2 != null && (n2 & 0xFF000000) != 0) {
                    final Color color = new Color(n2);
                    this.setIcon(new Icon(){

                        @Override
                        public int getIconHeight() {
                            return MaterialListCellRenderer.this.getFont().getSize();
                        }

                        @Override
                        public int getIconWidth() {
                            return this.getIconHeight();
                        }

                        @Override
                        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                            int n3 = this.getIconHeight();
                            graphics.setColor(color);
                            graphics.fillRect(n + 2, n2 + 2, n3 - 3, n3 - 3);
                            graphics.setColor(component.getParent().getParent().getForeground());
                            graphics.drawRect(n + 1, n2 + 1, n3 - 2, n3 - 2);
                        }
                    });
                } else {
                    this.setIcon(this.emptyIcon);
                }
                return this;
            }
        }
    }
}

