// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Descriptor.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceGrid_Descriptor_h__
#define __IceGrid_Descriptor_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/Identity.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceGrid/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 1
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEGRID_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEGRID_API /**/
#   elif defined(ICEGRID_API_EXPORTS)
#       define ICEGRID_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEGRID_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceGrid
{

class CommunicatorDescriptor;
class ServerDescriptor;
class ServiceDescriptor;
class IceBoxDescriptor;
class LoadBalancingPolicy;
class RandomLoadBalancingPolicy;
class OrderedLoadBalancingPolicy;
class RoundRobinLoadBalancingPolicy;
class AdaptiveLoadBalancingPolicy;
class BoxedString;
class BoxedDistributionDescriptor;

}

namespace IceGrid
{

/**
 * A mapping of string to string.
 */
using StringStringDict = ::std::map<::std::string, ::std::string>;

/**
 * Property descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct PropertyDescriptor
{
    /**
     * The name of the property.
     */
    ::std::string name;
    /**
     * The value of the property.
     */
    ::std::string value;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(name, value);
    }
};

/**
 * A sequence of property descriptors.
 */
using PropertyDescriptorSeq = ::std::vector<PropertyDescriptor>;

/**
 * A property set descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct PropertySetDescriptor
{
    /**
     * References to named property sets.
     */
    ::Ice::StringSeq references;
    /**
     * The property set properties.
     */
    PropertyDescriptorSeq properties;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::Ice::StringSeq&, const PropertyDescriptorSeq&> ice_tuple() const
    {
        return std::tie(references, properties);
    }
};

/**
 * A mapping of property set name to property set descriptor.
 */
using PropertySetDescriptorDict = ::std::map<::std::string, PropertySetDescriptor>;

/**
 * An Ice object descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct ObjectDescriptor
{
    /**
     * The identity of the object.
     */
    ::Ice::Identity id;
    /**
     * The object type.
     */
    ::std::string type;
    /**
     * Proxy options to use with the proxy created for this Ice object. If empty,
     * the proxy will be created with the proxy options specified on the object
     * adapter or replica group.
     */
    ::std::string proxyOptions;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::Ice::Identity&, const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(id, type, proxyOptions);
    }
};

/**
 * A sequence of object descriptors.
 */
using ObjectDescriptorSeq = ::std::vector<ObjectDescriptor>;

/**
 * An Ice object adapter descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct AdapterDescriptor
{
    /**
     * The object adapter name.
     */
    ::std::string name;
    /**
     * The description of this object adapter.
     */
    ::std::string description;
    /**
     * The object adapter id.
     */
    ::std::string id;
    /**
     * The replica id of this adapter.
     */
    ::std::string replicaGroupId;
    /**
     * The adapter priority. This is eventually used when the adapter
     * is member of a replica group to sort the adapter endpoints by
     * priority.
     */
    ::std::string priority;
    /**
     * Flag to specify if the object adapter will register a process object.
     */
    bool registerProcess;
    /**
     * If true the lifetime of this object adapter is the same of the
     * server lifetime. This information is used by the IceGrid node
     * to figure out the server state: the server is active only if
     * all its "server lifetime" adapters are active.
     */
    bool serverLifetime;
    /**
     * The well-known object descriptors associated with this object adapter.
     */
    ObjectDescriptorSeq objects;
    /**
     * The allocatable object descriptors associated with this object adapter.
     */
    ObjectDescriptorSeq allocatables;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const bool&, const bool&, const ObjectDescriptorSeq&, const ObjectDescriptorSeq&> ice_tuple() const
    {
        return std::tie(name, description, id, replicaGroupId, priority, registerProcess, serverLifetime, objects, allocatables);
    }
};

/**
 * A sequence of adapter descriptors.
 */
using AdapterDescriptorSeq = ::std::vector<AdapterDescriptor>;

/**
 * A Freeze database environment descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct DbEnvDescriptor
{
    /**
     * The name of the database environment.
     */
    ::std::string name;
    /**
     * The description of this database environment.
     */
    ::std::string description;
    /**
     * The home of the database environment (i.e., the directory where
     * the database files will be stored). If empty, the node will
     * provide a default database directory, otherwise the directory
     * must exist.
     */
    ::std::string dbHome;
    /**
     * The configuration properties of the database environment.
     */
    PropertyDescriptorSeq properties;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const ::std::string&, const ::std::string&, const PropertyDescriptorSeq&> ice_tuple() const
    {
        return std::tie(name, description, dbHome, properties);
    }
};

/**
 * A sequence of database environment descriptors.
 */
using DbEnvDescriptorSeq = ::std::vector<DbEnvDescriptor>;

/**
 * A distribution descriptor defines an IcePatch2 server and the
 * directories to retrieve from the patch server.
 * \headerfile IceGrid/IceGrid.h
 */
struct DistributionDescriptor
{
    /**
     * The proxy of the IcePatch2 server.
     */
    ::std::string icepatch;
    /**
     * The source directories.
     */
    ::Ice::StringSeq directories;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const ::Ice::StringSeq&> ice_tuple() const
    {
        return std::tie(icepatch, directories);
    }
};

/**
 * A sequence of server descriptors.
 */
using ServerDescriptorSeq = ::std::vector<::std::shared_ptr<ServerDescriptor>>;

/**
 * A sequence of service descriptors.
 */
using ServiceDescriptorSeq = ::std::vector<::std::shared_ptr<ServiceDescriptor>>;

/**
 * A server template instance descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct ServerInstanceDescriptor
{
    /**
     * The template used by this instance.
     */
    ::std::string _cpp_template;
    /**
     * The template parameter values.
     */
    StringStringDict parameterValues;
    /**
     * The property set.
     */
    PropertySetDescriptor propertySet;
    /**
     * The services property sets. It's only valid to set these
     * property sets if the template is an IceBox server template.
     */
    PropertySetDescriptorDict servicePropertySets;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const StringStringDict&, const PropertySetDescriptor&, const PropertySetDescriptorDict&> ice_tuple() const
    {
        return std::tie(_cpp_template, parameterValues, propertySet, servicePropertySets);
    }
};

/**
 * A sequence of server instance descriptors.
 */
using ServerInstanceDescriptorSeq = ::std::vector<ServerInstanceDescriptor>;

/**
 * A template descriptor for server or service templates.
 * \headerfile IceGrid/IceGrid.h
 */
struct TemplateDescriptor
{
    /**
     * The template.
     */
    ::std::shared_ptr<CommunicatorDescriptor> descriptor;
    /**
     * The parameters required to instantiate the template.
     */
    ::Ice::StringSeq parameters;
    /**
     * The parameters default values.
     */
    StringStringDict parameterDefaults;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::shared_ptr<CommunicatorDescriptor>&, const ::Ice::StringSeq&, const StringStringDict&> ice_tuple() const
    {
        return std::tie(descriptor, parameters, parameterDefaults);
    }
};

/**
 * A mapping of template identifier to template descriptor.
 */
using TemplateDescriptorDict = ::std::map<::std::string, TemplateDescriptor>;

/**
 * A service template instance descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct ServiceInstanceDescriptor
{
    /**
     * The template used by this instance.
     */
    ::std::string _cpp_template;
    /**
     * The template parameter values.
     */
    StringStringDict parameterValues;
    /**
     * The service definition if the instance isn't a template
     * instance (i.e.: if the template attribute is empty).
     */
    ::std::shared_ptr<ServiceDescriptor> descriptor;
    /**
     * The property set.
     */
    PropertySetDescriptor propertySet;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const StringStringDict&, const ::std::shared_ptr<ServiceDescriptor>&, const PropertySetDescriptor&> ice_tuple() const
    {
        return std::tie(_cpp_template, parameterValues, descriptor, propertySet);
    }
};

/**
 * A sequence of service instance descriptors.
 */
using ServiceInstanceDescriptorSeq = ::std::vector<ServiceInstanceDescriptor>;

/**
 * A node descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct NodeDescriptor
{
    /**
     * The variables defined for the node.
     */
    StringStringDict variables;
    /**
     * The server instances.
     */
    ServerInstanceDescriptorSeq serverInstances;
    /**
     * Servers (which are not template instances).
     */
    ServerDescriptorSeq servers;
    /**
     * Load factor of the node.
     */
    ::std::string loadFactor;
    /**
     * The description of this node.
     */
    ::std::string description;
    /**
     * Property set descriptors.
     */
    PropertySetDescriptorDict propertySets;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const StringStringDict&, const ServerInstanceDescriptorSeq&, const ServerDescriptorSeq&, const ::std::string&, const ::std::string&, const PropertySetDescriptorDict&> ice_tuple() const
    {
        return std::tie(variables, serverInstances, servers, loadFactor, description, propertySets);
    }
};

/**
 * Mapping of node name to node descriptor.
 */
using NodeDescriptorDict = ::std::map<::std::string, NodeDescriptor>;

/**
 * A replica group descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct ReplicaGroupDescriptor
{
    /**
     * The id of the replica group.
     */
    ::std::string id;
    /**
     * The load balancing policy.
     */
    ::std::shared_ptr<LoadBalancingPolicy> loadBalancing;
    /**
     * Default options for proxies created for the replica group.
     */
    ::std::string proxyOptions;
    /**
     * The object descriptors associated with this object adapter.
     */
    ObjectDescriptorSeq objects;
    /**
     * The description of this replica group.
     */
    ::std::string description;
    /**
     * The filter to use for this replica group.
     */
    ::std::string filter;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const ::std::shared_ptr<LoadBalancingPolicy>&, const ::std::string&, const ObjectDescriptorSeq&, const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(id, loadBalancing, proxyOptions, objects, description, filter);
    }
};

/**
 * A sequence of replica groups.
 */
using ReplicaGroupDescriptorSeq = ::std::vector<ReplicaGroupDescriptor>;

/**
 * An application descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct ApplicationDescriptor
{
    /**
     * The application name.
     */
    ::std::string name;
    /**
     * The variables defined in the application descriptor.
     */
    StringStringDict variables;
    /**
     * The replica groups.
     */
    ReplicaGroupDescriptorSeq replicaGroups;
    /**
     * The server templates.
     */
    TemplateDescriptorDict serverTemplates;
    /**
     * The service templates.
     */
    TemplateDescriptorDict serviceTemplates;
    /**
     * The application nodes.
     */
    NodeDescriptorDict nodes;
    /**
     * The application distribution.
     */
    DistributionDescriptor distrib;
    /**
     * The description of this application.
     */
    ::std::string description;
    /**
     * Property set descriptors.
     */
    PropertySetDescriptorDict propertySets;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const StringStringDict&, const ReplicaGroupDescriptorSeq&, const TemplateDescriptorDict&, const TemplateDescriptorDict&, const NodeDescriptorDict&, const DistributionDescriptor&, const ::std::string&, const PropertySetDescriptorDict&> ice_tuple() const
    {
        return std::tie(name, variables, replicaGroups, serverTemplates, serviceTemplates, nodes, distrib, description, propertySets);
    }
};

/**
 * A sequence of application descriptors.
 */
using ApplicationDescriptorSeq = ::std::vector<ApplicationDescriptor>;

/**
 * A node update descriptor to describe the updates to apply to a
 * node of a deployed application.
 * \headerfile IceGrid/IceGrid.h
 */
struct NodeUpdateDescriptor
{
    /**
     * The name of the node to update.
     */
    ::std::string name;
    /**
     * The updated description (or null if the description wasn't
     * updated.)
     */
    ::std::shared_ptr<BoxedString> description;
    /**
     * The variables to update.
     */
    StringStringDict variables;
    /**
     * The variables to remove.
     */
    ::Ice::StringSeq removeVariables;
    /**
     * The property sets to update.
     */
    PropertySetDescriptorDict propertySets;
    /**
     * The property sets to remove.
     */
    ::Ice::StringSeq removePropertySets;
    /**
     * The server instances to update.
     */
    ServerInstanceDescriptorSeq serverInstances;
    /**
     * The servers which are not template instances to update.
     */
    ServerDescriptorSeq servers;
    /**
     * The ids of the servers to remove.
     */
    ::Ice::StringSeq removeServers;
    /**
     * The updated load factor of the node (or null if the load factor
     * was not updated).
     */
    ::std::shared_ptr<BoxedString> loadFactor;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const ::std::shared_ptr<BoxedString>&, const StringStringDict&, const ::Ice::StringSeq&, const PropertySetDescriptorDict&, const ::Ice::StringSeq&, const ServerInstanceDescriptorSeq&, const ServerDescriptorSeq&, const ::Ice::StringSeq&, const ::std::shared_ptr<BoxedString>&> ice_tuple() const
    {
        return std::tie(name, description, variables, removeVariables, propertySets, removePropertySets, serverInstances, servers, removeServers, loadFactor);
    }
};

/**
 * A sequence of node update descriptors.
 */
using NodeUpdateDescriptorSeq = ::std::vector<NodeUpdateDescriptor>;

/**
 * An application update descriptor to describe the updates to apply
 * to a deployed application.
 * \headerfile IceGrid/IceGrid.h
 */
struct ApplicationUpdateDescriptor
{
    /**
     * The name of the application to update.
     */
    ::std::string name;
    /**
     * The updated description (or null if the description wasn't
     * updated.)
     */
    ::std::shared_ptr<BoxedString> description;
    /**
     * The updated distribution application descriptor.
     */
    ::std::shared_ptr<BoxedDistributionDescriptor> distrib;
    /**
     * The variables to update.
     */
    StringStringDict variables;
    /**
     * The variables to remove.
     */
    ::Ice::StringSeq removeVariables;
    /**
     * The property sets to update.
     */
    PropertySetDescriptorDict propertySets;
    /**
     * The property sets to remove.
     */
    ::Ice::StringSeq removePropertySets;
    /**
     * The replica groups to update.
     */
    ReplicaGroupDescriptorSeq replicaGroups;
    /**
     * The replica groups to remove.
     */
    ::Ice::StringSeq removeReplicaGroups;
    /**
     * The server templates to update.
     */
    TemplateDescriptorDict serverTemplates;
    /**
     * The ids of the server template to remove.
     */
    ::Ice::StringSeq removeServerTemplates;
    /**
     * The service templates to update.
     */
    TemplateDescriptorDict serviceTemplates;
    /**
     * The ids of the service template to remove.
     */
    ::Ice::StringSeq removeServiceTemplates;
    /**
     * The application nodes to update.
     */
    NodeUpdateDescriptorSeq nodes;
    /**
     * The nodes to remove.
     */
    ::Ice::StringSeq removeNodes;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const ::std::shared_ptr<BoxedString>&, const ::std::shared_ptr<BoxedDistributionDescriptor>&, const StringStringDict&, const ::Ice::StringSeq&, const PropertySetDescriptorDict&, const ::Ice::StringSeq&, const ReplicaGroupDescriptorSeq&, const ::Ice::StringSeq&, const TemplateDescriptorDict&, const ::Ice::StringSeq&, const TemplateDescriptorDict&, const ::Ice::StringSeq&, const NodeUpdateDescriptorSeq&, const ::Ice::StringSeq&> ice_tuple() const
    {
        return std::tie(name, description, distrib, variables, removeVariables, propertySets, removePropertySets, replicaGroups, removeReplicaGroups, serverTemplates, removeServerTemplates, serviceTemplates, removeServiceTemplates, nodes, removeNodes);
    }
};

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace IceGrid
{

/**
 * A communicator descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) CommunicatorDescriptor : public ::Ice::ValueHelper<CommunicatorDescriptor, ::Ice::Value>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~CommunicatorDescriptor();

    CommunicatorDescriptor() = default;

    CommunicatorDescriptor(const CommunicatorDescriptor&) = default;
    CommunicatorDescriptor(CommunicatorDescriptor&&) = default;
    CommunicatorDescriptor& operator=(const CommunicatorDescriptor&) = default;
    CommunicatorDescriptor& operator=(CommunicatorDescriptor&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param adapters The object adapters.
     * @param propertySet The property set.
     * @param dbEnvs The database environments.
     * @param logs The path of each log file.
     * @param description A description of this descriptor.
     */
    CommunicatorDescriptor(const AdapterDescriptorSeq& adapters, const PropertySetDescriptor& propertySet, const DbEnvDescriptorSeq& dbEnvs, const ::Ice::StringSeq& logs, const ::std::string& description) :
        adapters(::std::move(adapters)),
        propertySet(::std::move(propertySet)),
        dbEnvs(::std::move(dbEnvs)),
        logs(::std::move(logs)),
        description(::std::move(description))
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const AdapterDescriptorSeq&, const PropertySetDescriptor&, const DbEnvDescriptorSeq&, const ::Ice::StringSeq&, const ::std::string&> ice_tuple() const
    {
        return std::tie(adapters, propertySet, dbEnvs, logs, description);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The object adapters.
     */
    AdapterDescriptorSeq adapters;
    /**
     * The property set.
     */
    PropertySetDescriptor propertySet;
    /**
     * The database environments.
     */
    DbEnvDescriptorSeq dbEnvs;
    /**
     * The path of each log file.
     */
    ::Ice::StringSeq logs;
    /**
     * A description of this descriptor.
     */
    ::std::string description;
};

/// \cond INTERNAL
static CommunicatorDescriptor _iceS_CommunicatorDescriptor_init;
/// \endcond

/**
 * An Ice server descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) ServerDescriptor : public ::Ice::ValueHelper<ServerDescriptor, CommunicatorDescriptor>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ServerDescriptor();

    ServerDescriptor() = default;

    ServerDescriptor(const ServerDescriptor&) = default;
    ServerDescriptor(ServerDescriptor&&) = default;
    ServerDescriptor& operator=(const ServerDescriptor&) = default;
    ServerDescriptor& operator=(ServerDescriptor&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param adapters The object adapters.
     * @param propertySet The property set.
     * @param dbEnvs The database environments.
     * @param logs The path of each log file.
     * @param description A description of this descriptor.
     * @param id The server id.
     * @param exe The path of the server executable.
     * @param iceVersion The Ice version used by this server.
     * @param pwd The path to the server working directory.
     * @param options The command line options to pass to the server executable.
     * @param envs The server environment variables.
     * @param activation The server activation mode (possible values are "on-demand" or "manual").
     * @param activationTimeout The activation timeout (an integer value representing the number of seconds to wait for activation).
     * @param deactivationTimeout The deactivation timeout (an integer value representing the number of seconds to wait for deactivation).
     * @param applicationDistrib Specifies if the server depends on the application distribution.
     * @param distrib The distribution descriptor.
     * @param allocatable Specifies if the server is allocatable.
     * @param user The user account used to run the server.
     */
    ServerDescriptor(const AdapterDescriptorSeq& adapters, const PropertySetDescriptor& propertySet, const DbEnvDescriptorSeq& dbEnvs, const ::Ice::StringSeq& logs, const ::std::string& description, const ::std::string& id, const ::std::string& exe, const ::std::string& iceVersion, const ::std::string& pwd, const ::Ice::StringSeq& options, const ::Ice::StringSeq& envs, const ::std::string& activation, const ::std::string& activationTimeout, const ::std::string& deactivationTimeout, bool applicationDistrib, const DistributionDescriptor& distrib, bool allocatable, const ::std::string& user) :
        Ice::ValueHelper<ServerDescriptor, CommunicatorDescriptor>(::std::move(adapters), ::std::move(propertySet), ::std::move(dbEnvs), ::std::move(logs), ::std::move(description)),
        id(::std::move(id)),
        exe(::std::move(exe)),
        iceVersion(::std::move(iceVersion)),
        pwd(::std::move(pwd)),
        options(::std::move(options)),
        envs(::std::move(envs)),
        activation(::std::move(activation)),
        activationTimeout(::std::move(activationTimeout)),
        deactivationTimeout(::std::move(deactivationTimeout)),
        applicationDistrib(applicationDistrib),
        distrib(::std::move(distrib)),
        allocatable(allocatable),
        user(::std::move(user))
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const AdapterDescriptorSeq&, const PropertySetDescriptor&, const DbEnvDescriptorSeq&, const ::Ice::StringSeq&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::Ice::StringSeq&, const ::Ice::StringSeq&, const ::std::string&, const ::std::string&, const ::std::string&, const bool&, const DistributionDescriptor&, const bool&, const ::std::string&> ice_tuple() const
    {
        return std::tie(adapters, propertySet, dbEnvs, logs, description, id, exe, iceVersion, pwd, options, envs, activation, activationTimeout, deactivationTimeout, applicationDistrib, distrib, allocatable, user);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The server id.
     */
    ::std::string id;
    /**
     * The path of the server executable.
     */
    ::std::string exe;
    /**
     * The Ice version used by this server. This is only required if
     * backward compatibility with servers using old Ice versions is
     * needed (otherwise the registry will assume the server is using
     * the same Ice version).
     * For example "3.1.1", "3.2", "3.3.0".
     */
    ::std::string iceVersion;
    /**
     * The path to the server working directory.
     */
    ::std::string pwd;
    /**
     * The command line options to pass to the server executable.
     */
    ::Ice::StringSeq options;
    /**
     * The server environment variables.
     */
    ::Ice::StringSeq envs;
    /**
     * The server activation mode (possible values are "on-demand" or
     * "manual").
     */
    ::std::string activation;
    /**
     * The activation timeout (an integer value representing the
     * number of seconds to wait for activation).
     */
    ::std::string activationTimeout;
    /**
     * The deactivation timeout (an integer value representing the
     * number of seconds to wait for deactivation).
     */
    ::std::string deactivationTimeout;
    /**
     * Specifies if the server depends on the application
     * distribution.
     */
    bool applicationDistrib;
    /**
     * The distribution descriptor.
     */
    DistributionDescriptor distrib;
    /**
     * Specifies if the server is allocatable.
     */
    bool allocatable;
    /**
     * The user account used to run the server.
     */
    ::std::string user;
};

/**
 * An IceBox service descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) ServiceDescriptor : public ::Ice::ValueHelper<ServiceDescriptor, CommunicatorDescriptor>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~ServiceDescriptor();

    ServiceDescriptor() = default;

    ServiceDescriptor(const ServiceDescriptor&) = default;
    ServiceDescriptor(ServiceDescriptor&&) = default;
    ServiceDescriptor& operator=(const ServiceDescriptor&) = default;
    ServiceDescriptor& operator=(ServiceDescriptor&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param adapters The object adapters.
     * @param propertySet The property set.
     * @param dbEnvs The database environments.
     * @param logs The path of each log file.
     * @param description A description of this descriptor.
     * @param name The service name.
     * @param entry The entry point of the IceBox service.
     */
    ServiceDescriptor(const AdapterDescriptorSeq& adapters, const PropertySetDescriptor& propertySet, const DbEnvDescriptorSeq& dbEnvs, const ::Ice::StringSeq& logs, const ::std::string& description, const ::std::string& name, const ::std::string& entry) :
        Ice::ValueHelper<ServiceDescriptor, CommunicatorDescriptor>(::std::move(adapters), ::std::move(propertySet), ::std::move(dbEnvs), ::std::move(logs), ::std::move(description)),
        name(::std::move(name)),
        entry(::std::move(entry))
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const AdapterDescriptorSeq&, const PropertySetDescriptor&, const DbEnvDescriptorSeq&, const ::Ice::StringSeq&, const ::std::string&, const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(adapters, propertySet, dbEnvs, logs, description, name, entry);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The service name.
     */
    ::std::string name;
    /**
     * The entry point of the IceBox service.
     */
    ::std::string entry;
};

/**
 * An IceBox server descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) IceBoxDescriptor : public ::Ice::ValueHelper<IceBoxDescriptor, ServerDescriptor>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~IceBoxDescriptor();

    IceBoxDescriptor() = default;

    IceBoxDescriptor(const IceBoxDescriptor&) = default;
    IceBoxDescriptor(IceBoxDescriptor&&) = default;
    IceBoxDescriptor& operator=(const IceBoxDescriptor&) = default;
    IceBoxDescriptor& operator=(IceBoxDescriptor&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param adapters The object adapters.
     * @param propertySet The property set.
     * @param dbEnvs The database environments.
     * @param logs The path of each log file.
     * @param description A description of this descriptor.
     * @param id The server id.
     * @param exe The path of the server executable.
     * @param iceVersion The Ice version used by this server.
     * @param pwd The path to the server working directory.
     * @param options The command line options to pass to the server executable.
     * @param envs The server environment variables.
     * @param activation The server activation mode (possible values are "on-demand" or "manual").
     * @param activationTimeout The activation timeout (an integer value representing the number of seconds to wait for activation).
     * @param deactivationTimeout The deactivation timeout (an integer value representing the number of seconds to wait for deactivation).
     * @param applicationDistrib Specifies if the server depends on the application distribution.
     * @param distrib The distribution descriptor.
     * @param allocatable Specifies if the server is allocatable.
     * @param user The user account used to run the server.
     * @param services The service instances.
     */
    IceBoxDescriptor(const AdapterDescriptorSeq& adapters, const PropertySetDescriptor& propertySet, const DbEnvDescriptorSeq& dbEnvs, const ::Ice::StringSeq& logs, const ::std::string& description, const ::std::string& id, const ::std::string& exe, const ::std::string& iceVersion, const ::std::string& pwd, const ::Ice::StringSeq& options, const ::Ice::StringSeq& envs, const ::std::string& activation, const ::std::string& activationTimeout, const ::std::string& deactivationTimeout, bool applicationDistrib, const DistributionDescriptor& distrib, bool allocatable, const ::std::string& user, const ServiceInstanceDescriptorSeq& services) :
        Ice::ValueHelper<IceBoxDescriptor, ServerDescriptor>(::std::move(adapters), ::std::move(propertySet), ::std::move(dbEnvs), ::std::move(logs), ::std::move(description), ::std::move(id), ::std::move(exe), ::std::move(iceVersion), ::std::move(pwd), ::std::move(options), ::std::move(envs), ::std::move(activation), ::std::move(activationTimeout), ::std::move(deactivationTimeout), applicationDistrib, ::std::move(distrib), allocatable, ::std::move(user)),
        services(::std::move(services))
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const AdapterDescriptorSeq&, const PropertySetDescriptor&, const DbEnvDescriptorSeq&, const ::Ice::StringSeq&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::Ice::StringSeq&, const ::Ice::StringSeq&, const ::std::string&, const ::std::string&, const ::std::string&, const bool&, const DistributionDescriptor&, const bool&, const ::std::string&, const ServiceInstanceDescriptorSeq&> ice_tuple() const
    {
        return std::tie(adapters, propertySet, dbEnvs, logs, description, id, exe, iceVersion, pwd, options, envs, activation, activationTimeout, deactivationTimeout, applicationDistrib, distrib, allocatable, user, services);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The service instances.
     */
    ServiceInstanceDescriptorSeq services;
};

/**
 * A base class for load balancing policies.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) LoadBalancingPolicy : public ::Ice::ValueHelper<LoadBalancingPolicy, ::Ice::Value>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~LoadBalancingPolicy();

    LoadBalancingPolicy() = default;

    LoadBalancingPolicy(const LoadBalancingPolicy&) = default;
    LoadBalancingPolicy(LoadBalancingPolicy&&) = default;
    LoadBalancingPolicy& operator=(const LoadBalancingPolicy&) = default;
    LoadBalancingPolicy& operator=(LoadBalancingPolicy&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param nReplicas The number of replicas that will be used to gather the endpoints of a replica group.
     */
    explicit LoadBalancingPolicy(const ::std::string& nReplicas) :
        nReplicas(::std::move(nReplicas))
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(nReplicas);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The number of replicas that will be used to gather the
     * endpoints of a replica group.
     */
    ::std::string nReplicas;
};

/**
 * Random load balancing policy.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) RandomLoadBalancingPolicy : public ::Ice::ValueHelper<RandomLoadBalancingPolicy, LoadBalancingPolicy>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~RandomLoadBalancingPolicy();

    RandomLoadBalancingPolicy() = default;

    RandomLoadBalancingPolicy(const RandomLoadBalancingPolicy&) = default;
    RandomLoadBalancingPolicy(RandomLoadBalancingPolicy&&) = default;
    RandomLoadBalancingPolicy& operator=(const RandomLoadBalancingPolicy&) = default;
    RandomLoadBalancingPolicy& operator=(RandomLoadBalancingPolicy&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param nReplicas The number of replicas that will be used to gather the endpoints of a replica group.
     */
    explicit RandomLoadBalancingPolicy(const ::std::string& nReplicas) :
        Ice::ValueHelper<RandomLoadBalancingPolicy, LoadBalancingPolicy>(::std::move(nReplicas))
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(nReplicas);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();
};

/**
 * Ordered load balancing policy.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) OrderedLoadBalancingPolicy : public ::Ice::ValueHelper<OrderedLoadBalancingPolicy, LoadBalancingPolicy>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~OrderedLoadBalancingPolicy();

    OrderedLoadBalancingPolicy() = default;

    OrderedLoadBalancingPolicy(const OrderedLoadBalancingPolicy&) = default;
    OrderedLoadBalancingPolicy(OrderedLoadBalancingPolicy&&) = default;
    OrderedLoadBalancingPolicy& operator=(const OrderedLoadBalancingPolicy&) = default;
    OrderedLoadBalancingPolicy& operator=(OrderedLoadBalancingPolicy&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param nReplicas The number of replicas that will be used to gather the endpoints of a replica group.
     */
    explicit OrderedLoadBalancingPolicy(const ::std::string& nReplicas) :
        Ice::ValueHelper<OrderedLoadBalancingPolicy, LoadBalancingPolicy>(::std::move(nReplicas))
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(nReplicas);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();
};

/**
 * Round robin load balancing policy.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) RoundRobinLoadBalancingPolicy : public ::Ice::ValueHelper<RoundRobinLoadBalancingPolicy, LoadBalancingPolicy>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~RoundRobinLoadBalancingPolicy();

    RoundRobinLoadBalancingPolicy() = default;

    RoundRobinLoadBalancingPolicy(const RoundRobinLoadBalancingPolicy&) = default;
    RoundRobinLoadBalancingPolicy(RoundRobinLoadBalancingPolicy&&) = default;
    RoundRobinLoadBalancingPolicy& operator=(const RoundRobinLoadBalancingPolicy&) = default;
    RoundRobinLoadBalancingPolicy& operator=(RoundRobinLoadBalancingPolicy&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param nReplicas The number of replicas that will be used to gather the endpoints of a replica group.
     */
    explicit RoundRobinLoadBalancingPolicy(const ::std::string& nReplicas) :
        Ice::ValueHelper<RoundRobinLoadBalancingPolicy, LoadBalancingPolicy>(::std::move(nReplicas))
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(nReplicas);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();
};

/**
 * Adaptive load balancing policy.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) AdaptiveLoadBalancingPolicy : public ::Ice::ValueHelper<AdaptiveLoadBalancingPolicy, LoadBalancingPolicy>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~AdaptiveLoadBalancingPolicy();

    AdaptiveLoadBalancingPolicy() = default;

    AdaptiveLoadBalancingPolicy(const AdaptiveLoadBalancingPolicy&) = default;
    AdaptiveLoadBalancingPolicy(AdaptiveLoadBalancingPolicy&&) = default;
    AdaptiveLoadBalancingPolicy& operator=(const AdaptiveLoadBalancingPolicy&) = default;
    AdaptiveLoadBalancingPolicy& operator=(AdaptiveLoadBalancingPolicy&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param nReplicas The number of replicas that will be used to gather the endpoints of a replica group.
     * @param loadSample The load sample to use for the load balancing.
     */
    AdaptiveLoadBalancingPolicy(const ::std::string& nReplicas, const ::std::string& loadSample) :
        Ice::ValueHelper<AdaptiveLoadBalancingPolicy, LoadBalancingPolicy>(::std::move(nReplicas)),
        loadSample(::std::move(loadSample))
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(nReplicas, loadSample);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The load sample to use for the load balancing. The allowed
     * values for this attribute are "1", "5" and "15", representing
     * respectively the load average over the past minute, the past 5
     * minutes and the past 15 minutes.
     */
    ::std::string loadSample;
};

/**
 * A "boxed" string.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) BoxedString : public ::Ice::ValueHelper<BoxedString, ::Ice::Value>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~BoxedString();

    BoxedString() = default;

    BoxedString(const BoxedString&) = default;
    BoxedString(BoxedString&&) = default;
    BoxedString& operator=(const BoxedString&) = default;
    BoxedString& operator=(BoxedString&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param value The value of the boxed string.
     */
    explicit BoxedString(const ::std::string& value) :
        value(::std::move(value))
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(value);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The value of the boxed string.
     */
    ::std::string value;
};

/**
 * A "boxed" distribution descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) BoxedDistributionDescriptor : public ::Ice::ValueHelper<BoxedDistributionDescriptor, ::Ice::Value>
{
public:

    ICE_MEMBER(ICEGRID_API) virtual ~BoxedDistributionDescriptor();

    BoxedDistributionDescriptor() = default;

    BoxedDistributionDescriptor(const BoxedDistributionDescriptor&) = default;
    BoxedDistributionDescriptor(BoxedDistributionDescriptor&&) = default;
    BoxedDistributionDescriptor& operator=(const BoxedDistributionDescriptor&) = default;
    BoxedDistributionDescriptor& operator=(BoxedDistributionDescriptor&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param value The value of the boxed distribution descriptor.
     */
    explicit BoxedDistributionDescriptor(const DistributionDescriptor& value) :
        value(::std::move(value))
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const DistributionDescriptor&> ice_tuple() const
    {
        return std::tie(value);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

    /**
     * The value of the boxed distribution descriptor.
     */
    DistributionDescriptor value;
};

}

namespace IceGrid
{

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits<::IceGrid::PropertyDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::PropertyDescriptor, S>
{
    static void read(S* istr, ::IceGrid::PropertyDescriptor& v)
    {
        istr->readAll(v.name, v.value);
    }
};

template<>
struct StreamableTraits<::IceGrid::PropertySetDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::PropertySetDescriptor, S>
{
    static void read(S* istr, ::IceGrid::PropertySetDescriptor& v)
    {
        istr->readAll(v.references, v.properties);
    }
};

template<>
struct StreamableTraits<::IceGrid::ObjectDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ObjectDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ObjectDescriptor& v)
    {
        istr->readAll(v.id, v.type, v.proxyOptions);
    }
};

template<>
struct StreamableTraits<::IceGrid::AdapterDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 9;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::AdapterDescriptor, S>
{
    static void read(S* istr, ::IceGrid::AdapterDescriptor& v)
    {
        istr->readAll(v.name, v.description, v.id, v.replicaGroupId, v.priority, v.registerProcess, v.serverLifetime, v.objects, v.allocatables);
    }
};

template<>
struct StreamableTraits<::IceGrid::DbEnvDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::DbEnvDescriptor, S>
{
    static void read(S* istr, ::IceGrid::DbEnvDescriptor& v)
    {
        istr->readAll(v.name, v.description, v.dbHome, v.properties);
    }
};

template<typename S>
struct StreamReader<::IceGrid::CommunicatorDescriptor, S>
{
    static void read(S* istr, ::IceGrid::CommunicatorDescriptor& v)
    {
        istr->readAll(v.adapters, v.propertySet, v.dbEnvs, v.logs, v.description);
    }
};

template<>
struct StreamableTraits<::IceGrid::DistributionDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::DistributionDescriptor, S>
{
    static void read(S* istr, ::IceGrid::DistributionDescriptor& v)
    {
        istr->readAll(v.icepatch, v.directories);
    }
};

template<typename S>
struct StreamWriter<::IceGrid::ServerDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ServerDescriptor& v)
    {
        ostr->writeAll(v.id, v.exe, v.iceVersion, v.pwd, v.options, v.envs, v.activation, v.activationTimeout, v.deactivationTimeout, v.applicationDistrib, v.distrib, v.allocatable, v.user);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ServerDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServerDescriptor& v)
    {
        istr->readAll(v.id, v.exe, v.iceVersion, v.pwd, v.options, v.envs, v.activation, v.activationTimeout, v.deactivationTimeout, v.applicationDistrib, v.distrib, v.allocatable, v.user);
    }
};

template<typename S>
struct StreamWriter<::IceGrid::ServiceDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ServiceDescriptor& v)
    {
        ostr->writeAll(v.name, v.entry);
    }
};

template<typename S>
struct StreamReader<::IceGrid::ServiceDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServiceDescriptor& v)
    {
        istr->readAll(v.name, v.entry);
    }
};

template<>
struct StreamableTraits<::IceGrid::ServerInstanceDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 5;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ServerInstanceDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServerInstanceDescriptor& v)
    {
        istr->readAll(v._cpp_template, v.parameterValues, v.propertySet, v.servicePropertySets);
    }
};

template<>
struct StreamableTraits<::IceGrid::TemplateDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 3;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::TemplateDescriptor, S>
{
    static void read(S* istr, ::IceGrid::TemplateDescriptor& v)
    {
        istr->readAll(v.descriptor, v.parameters, v.parameterDefaults);
    }
};

template<>
struct StreamableTraits<::IceGrid::ServiceInstanceDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 5;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ServiceInstanceDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServiceInstanceDescriptor& v)
    {
        istr->readAll(v._cpp_template, v.parameterValues, v.descriptor, v.propertySet);
    }
};

template<typename S>
struct StreamWriter<::IceGrid::IceBoxDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::IceBoxDescriptor& v)
    {
        ostr->writeAll(v.services);
    }
};

template<typename S>
struct StreamReader<::IceGrid::IceBoxDescriptor, S>
{
    static void read(S* istr, ::IceGrid::IceBoxDescriptor& v)
    {
        istr->readAll(v.services);
    }
};

template<>
struct StreamableTraits<::IceGrid::NodeDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 6;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::NodeDescriptor, S>
{
    static void read(S* istr, ::IceGrid::NodeDescriptor& v)
    {
        istr->readAll(v.variables, v.serverInstances, v.servers, v.loadFactor, v.description, v.propertySets);
    }
};

template<typename S>
struct StreamReader<::IceGrid::LoadBalancingPolicy, S>
{
    static void read(S* istr, ::IceGrid::LoadBalancingPolicy& v)
    {
        istr->readAll(v.nReplicas);
    }
};

template<typename S>
struct StreamWriter<::IceGrid::RandomLoadBalancingPolicy, S>
{
    static void write(S*, const ::IceGrid::RandomLoadBalancingPolicy&)
    {
    }
};

template<typename S>
struct StreamReader<::IceGrid::RandomLoadBalancingPolicy, S>
{
    static void read(S*, ::IceGrid::RandomLoadBalancingPolicy&)
    {
    }
};

template<typename S>
struct StreamWriter<::IceGrid::OrderedLoadBalancingPolicy, S>
{
    static void write(S*, const ::IceGrid::OrderedLoadBalancingPolicy&)
    {
    }
};

template<typename S>
struct StreamReader<::IceGrid::OrderedLoadBalancingPolicy, S>
{
    static void read(S*, ::IceGrid::OrderedLoadBalancingPolicy&)
    {
    }
};

template<typename S>
struct StreamWriter<::IceGrid::RoundRobinLoadBalancingPolicy, S>
{
    static void write(S*, const ::IceGrid::RoundRobinLoadBalancingPolicy&)
    {
    }
};

template<typename S>
struct StreamReader<::IceGrid::RoundRobinLoadBalancingPolicy, S>
{
    static void read(S*, ::IceGrid::RoundRobinLoadBalancingPolicy&)
    {
    }
};

template<typename S>
struct StreamWriter<::IceGrid::AdaptiveLoadBalancingPolicy, S>
{
    static void write(S* ostr, const ::IceGrid::AdaptiveLoadBalancingPolicy& v)
    {
        ostr->writeAll(v.loadSample);
    }
};

template<typename S>
struct StreamReader<::IceGrid::AdaptiveLoadBalancingPolicy, S>
{
    static void read(S* istr, ::IceGrid::AdaptiveLoadBalancingPolicy& v)
    {
        istr->readAll(v.loadSample);
    }
};

template<>
struct StreamableTraits<::IceGrid::ReplicaGroupDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 6;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ReplicaGroupDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ReplicaGroupDescriptor& v)
    {
        istr->readAll(v.id, v.loadBalancing, v.proxyOptions, v.objects, v.description, v.filter);
    }
};

template<>
struct StreamableTraits<::IceGrid::ApplicationDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 10;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ApplicationDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ApplicationDescriptor& v)
    {
        istr->readAll(v.name, v.variables, v.replicaGroups, v.serverTemplates, v.serviceTemplates, v.nodes, v.distrib, v.description, v.propertySets);
    }
};

template<typename S>
struct StreamReader<::IceGrid::BoxedString, S>
{
    static void read(S* istr, ::IceGrid::BoxedString& v)
    {
        istr->readAll(v.value);
    }
};

template<>
struct StreamableTraits<::IceGrid::NodeUpdateDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 10;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::NodeUpdateDescriptor, S>
{
    static void read(S* istr, ::IceGrid::NodeUpdateDescriptor& v)
    {
        istr->readAll(v.name, v.description, v.variables, v.removeVariables, v.propertySets, v.removePropertySets, v.serverInstances, v.servers, v.removeServers, v.loadFactor);
    }
};

template<typename S>
struct StreamReader<::IceGrid::BoxedDistributionDescriptor, S>
{
    static void read(S* istr, ::IceGrid::BoxedDistributionDescriptor& v)
    {
        istr->readAll(v.value);
    }
};

template<>
struct StreamableTraits<::IceGrid::ApplicationUpdateDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 15;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ApplicationUpdateDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ApplicationUpdateDescriptor& v)
    {
        istr->readAll(v.name, v.description, v.distrib, v.variables, v.removeVariables, v.propertySets, v.removePropertySets, v.replicaGroups, v.removeReplicaGroups, v.serverTemplates, v.removeServerTemplates, v.serviceTemplates, v.removeServiceTemplates, v.nodes, v.removeNodes);
    }
};

}
/// \endcond

/// \cond INTERNAL
namespace IceGrid
{

using CommunicatorDescriptorPtr = ::std::shared_ptr<CommunicatorDescriptor>;

using ServerDescriptorPtr = ::std::shared_ptr<ServerDescriptor>;

using ServiceDescriptorPtr = ::std::shared_ptr<ServiceDescriptor>;

using IceBoxDescriptorPtr = ::std::shared_ptr<IceBoxDescriptor>;

using LoadBalancingPolicyPtr = ::std::shared_ptr<LoadBalancingPolicy>;

using RandomLoadBalancingPolicyPtr = ::std::shared_ptr<RandomLoadBalancingPolicy>;

using OrderedLoadBalancingPolicyPtr = ::std::shared_ptr<OrderedLoadBalancingPolicy>;

using RoundRobinLoadBalancingPolicyPtr = ::std::shared_ptr<RoundRobinLoadBalancingPolicy>;

using AdaptiveLoadBalancingPolicyPtr = ::std::shared_ptr<AdaptiveLoadBalancingPolicy>;

using BoxedStringPtr = ::std::shared_ptr<BoxedString>;

using BoxedDistributionDescriptorPtr = ::std::shared_ptr<BoxedDistributionDescriptor>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace IceGrid
{

class CommunicatorDescriptor;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::CommunicatorDescriptor>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::CommunicatorDescriptor*);
/// \endcond

class ServerDescriptor;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ServerDescriptor>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::ServerDescriptor*);
/// \endcond

class ServiceDescriptor;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ServiceDescriptor>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::ServiceDescriptor*);
/// \endcond

class IceBoxDescriptor;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::IceBoxDescriptor>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::IceBoxDescriptor*);
/// \endcond

class LoadBalancingPolicy;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::LoadBalancingPolicy>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::LoadBalancingPolicy*);
/// \endcond

class RandomLoadBalancingPolicy;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::RandomLoadBalancingPolicy>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::RandomLoadBalancingPolicy*);
/// \endcond

class OrderedLoadBalancingPolicy;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::OrderedLoadBalancingPolicy>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::OrderedLoadBalancingPolicy*);
/// \endcond

class RoundRobinLoadBalancingPolicy;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::RoundRobinLoadBalancingPolicy>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::RoundRobinLoadBalancingPolicy*);
/// \endcond

class AdaptiveLoadBalancingPolicy;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::AdaptiveLoadBalancingPolicy>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::AdaptiveLoadBalancingPolicy*);
/// \endcond

class BoxedString;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::BoxedString>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::BoxedString*);
/// \endcond

class BoxedDistributionDescriptor;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::BoxedDistributionDescriptor>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::BoxedDistributionDescriptor*);
/// \endcond

}

}

namespace IceGrid
{

class CommunicatorDescriptor;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(CommunicatorDescriptor*);
/// \endcond
typedef ::IceInternal::Handle< CommunicatorDescriptor> CommunicatorDescriptorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::CommunicatorDescriptor> CommunicatorDescriptorPrx;
typedef CommunicatorDescriptorPrx CommunicatorDescriptorPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(CommunicatorDescriptorPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class ServerDescriptor;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(ServerDescriptor*);
/// \endcond
typedef ::IceInternal::Handle< ServerDescriptor> ServerDescriptorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ServerDescriptor> ServerDescriptorPrx;
typedef ServerDescriptorPrx ServerDescriptorPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(ServerDescriptorPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class ServiceDescriptor;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(ServiceDescriptor*);
/// \endcond
typedef ::IceInternal::Handle< ServiceDescriptor> ServiceDescriptorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ServiceDescriptor> ServiceDescriptorPrx;
typedef ServiceDescriptorPrx ServiceDescriptorPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(ServiceDescriptorPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class IceBoxDescriptor;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(IceBoxDescriptor*);
/// \endcond
typedef ::IceInternal::Handle< IceBoxDescriptor> IceBoxDescriptorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::IceBoxDescriptor> IceBoxDescriptorPrx;
typedef IceBoxDescriptorPrx IceBoxDescriptorPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(IceBoxDescriptorPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class LoadBalancingPolicy;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(LoadBalancingPolicy*);
/// \endcond
typedef ::IceInternal::Handle< LoadBalancingPolicy> LoadBalancingPolicyPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::LoadBalancingPolicy> LoadBalancingPolicyPrx;
typedef LoadBalancingPolicyPrx LoadBalancingPolicyPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(LoadBalancingPolicyPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class RandomLoadBalancingPolicy;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(RandomLoadBalancingPolicy*);
/// \endcond
typedef ::IceInternal::Handle< RandomLoadBalancingPolicy> RandomLoadBalancingPolicyPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::RandomLoadBalancingPolicy> RandomLoadBalancingPolicyPrx;
typedef RandomLoadBalancingPolicyPrx RandomLoadBalancingPolicyPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(RandomLoadBalancingPolicyPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class OrderedLoadBalancingPolicy;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(OrderedLoadBalancingPolicy*);
/// \endcond
typedef ::IceInternal::Handle< OrderedLoadBalancingPolicy> OrderedLoadBalancingPolicyPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::OrderedLoadBalancingPolicy> OrderedLoadBalancingPolicyPrx;
typedef OrderedLoadBalancingPolicyPrx OrderedLoadBalancingPolicyPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(OrderedLoadBalancingPolicyPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class RoundRobinLoadBalancingPolicy;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(RoundRobinLoadBalancingPolicy*);
/// \endcond
typedef ::IceInternal::Handle< RoundRobinLoadBalancingPolicy> RoundRobinLoadBalancingPolicyPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::RoundRobinLoadBalancingPolicy> RoundRobinLoadBalancingPolicyPrx;
typedef RoundRobinLoadBalancingPolicyPrx RoundRobinLoadBalancingPolicyPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(RoundRobinLoadBalancingPolicyPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class AdaptiveLoadBalancingPolicy;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(AdaptiveLoadBalancingPolicy*);
/// \endcond
typedef ::IceInternal::Handle< AdaptiveLoadBalancingPolicy> AdaptiveLoadBalancingPolicyPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::AdaptiveLoadBalancingPolicy> AdaptiveLoadBalancingPolicyPrx;
typedef AdaptiveLoadBalancingPolicyPrx AdaptiveLoadBalancingPolicyPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(AdaptiveLoadBalancingPolicyPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class BoxedString;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(BoxedString*);
/// \endcond
typedef ::IceInternal::Handle< BoxedString> BoxedStringPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::BoxedString> BoxedStringPrx;
typedef BoxedStringPrx BoxedStringPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(BoxedStringPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class BoxedDistributionDescriptor;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(BoxedDistributionDescriptor*);
/// \endcond
typedef ::IceInternal::Handle< BoxedDistributionDescriptor> BoxedDistributionDescriptorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::BoxedDistributionDescriptor> BoxedDistributionDescriptorPrx;
typedef BoxedDistributionDescriptorPrx BoxedDistributionDescriptorPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(BoxedDistributionDescriptorPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace IceGrid
{

/**
 * A mapping of string to string.
 */
typedef ::std::map< ::std::string, ::std::string> StringStringDict;

/**
 * Property descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct PropertyDescriptor
{
    /**
     * The name of the property.
     */
    ::std::string name;
    /**
     * The value of the property.
     */
    ::std::string value;

    bool operator==(const PropertyDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(name != rhs_.name)
        {
            return false;
        }
        if(value != rhs_.value)
        {
            return false;
        }
        return true;
    }

    bool operator<(const PropertyDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(name < rhs_.name)
        {
            return true;
        }
        else if(rhs_.name < name)
        {
            return false;
        }
        if(value < rhs_.value)
        {
            return true;
        }
        else if(rhs_.value < value)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const PropertyDescriptor& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const PropertyDescriptor& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const PropertyDescriptor& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const PropertyDescriptor& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * A sequence of property descriptors.
 */
typedef ::std::vector<IceGrid::PropertyDescriptor> PropertyDescriptorSeq;

/**
 * A property set descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct PropertySetDescriptor
{
    /**
     * References to named property sets.
     */
    ::Ice::StringSeq references;
    /**
     * The property set properties.
     */
    PropertyDescriptorSeq properties;

    bool operator==(const PropertySetDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(references != rhs_.references)
        {
            return false;
        }
        if(properties != rhs_.properties)
        {
            return false;
        }
        return true;
    }

    bool operator<(const PropertySetDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(references < rhs_.references)
        {
            return true;
        }
        else if(rhs_.references < references)
        {
            return false;
        }
        if(properties < rhs_.properties)
        {
            return true;
        }
        else if(rhs_.properties < properties)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const PropertySetDescriptor& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const PropertySetDescriptor& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const PropertySetDescriptor& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const PropertySetDescriptor& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * A mapping of property set name to property set descriptor.
 */
typedef ::std::map< ::std::string, IceGrid::PropertySetDescriptor> PropertySetDescriptorDict;

/**
 * An Ice object descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct ObjectDescriptor
{
    /**
     * The identity of the object.
     */
    ::Ice::Identity id;
    /**
     * The object type.
     */
    ::std::string type;
    /**
     * Proxy options to use with the proxy created for this Ice object. If empty,
     * the proxy will be created with the proxy options specified on the object
     * adapter or replica group.
     */
    ::std::string proxyOptions;

    bool operator==(const ObjectDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(id != rhs_.id)
        {
            return false;
        }
        if(type != rhs_.type)
        {
            return false;
        }
        if(proxyOptions != rhs_.proxyOptions)
        {
            return false;
        }
        return true;
    }

    bool operator<(const ObjectDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(id < rhs_.id)
        {
            return true;
        }
        else if(rhs_.id < id)
        {
            return false;
        }
        if(type < rhs_.type)
        {
            return true;
        }
        else if(rhs_.type < type)
        {
            return false;
        }
        if(proxyOptions < rhs_.proxyOptions)
        {
            return true;
        }
        else if(rhs_.proxyOptions < proxyOptions)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const ObjectDescriptor& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const ObjectDescriptor& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const ObjectDescriptor& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const ObjectDescriptor& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * A sequence of object descriptors.
 */
typedef ::std::vector<IceGrid::ObjectDescriptor> ObjectDescriptorSeq;

/**
 * An Ice object adapter descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct AdapterDescriptor
{
    /**
     * The object adapter name.
     */
    ::std::string name;
    /**
     * The description of this object adapter.
     */
    ::std::string description;
    /**
     * The object adapter id.
     */
    ::std::string id;
    /**
     * The replica id of this adapter.
     */
    ::std::string replicaGroupId;
    /**
     * The adapter priority. This is eventually used when the adapter
     * is member of a replica group to sort the adapter endpoints by
     * priority.
     */
    ::std::string priority;
    /**
     * Flag to specify if the object adapter will register a process object.
     */
    bool registerProcess;
    /**
     * If true the lifetime of this object adapter is the same of the
     * server lifetime. This information is used by the IceGrid node
     * to figure out the server state: the server is active only if
     * all its "server lifetime" adapters are active.
     */
    bool serverLifetime;
    /**
     * The well-known object descriptors associated with this object adapter.
     */
    ObjectDescriptorSeq objects;
    /**
     * The allocatable object descriptors associated with this object adapter.
     */
    ObjectDescriptorSeq allocatables;

    bool operator==(const AdapterDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(name != rhs_.name)
        {
            return false;
        }
        if(description != rhs_.description)
        {
            return false;
        }
        if(id != rhs_.id)
        {
            return false;
        }
        if(replicaGroupId != rhs_.replicaGroupId)
        {
            return false;
        }
        if(priority != rhs_.priority)
        {
            return false;
        }
        if(registerProcess != rhs_.registerProcess)
        {
            return false;
        }
        if(serverLifetime != rhs_.serverLifetime)
        {
            return false;
        }
        if(objects != rhs_.objects)
        {
            return false;
        }
        if(allocatables != rhs_.allocatables)
        {
            return false;
        }
        return true;
    }

    bool operator<(const AdapterDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(name < rhs_.name)
        {
            return true;
        }
        else if(rhs_.name < name)
        {
            return false;
        }
        if(description < rhs_.description)
        {
            return true;
        }
        else if(rhs_.description < description)
        {
            return false;
        }
        if(id < rhs_.id)
        {
            return true;
        }
        else if(rhs_.id < id)
        {
            return false;
        }
        if(replicaGroupId < rhs_.replicaGroupId)
        {
            return true;
        }
        else if(rhs_.replicaGroupId < replicaGroupId)
        {
            return false;
        }
        if(priority < rhs_.priority)
        {
            return true;
        }
        else if(rhs_.priority < priority)
        {
            return false;
        }
        if(registerProcess < rhs_.registerProcess)
        {
            return true;
        }
        else if(rhs_.registerProcess < registerProcess)
        {
            return false;
        }
        if(serverLifetime < rhs_.serverLifetime)
        {
            return true;
        }
        else if(rhs_.serverLifetime < serverLifetime)
        {
            return false;
        }
        if(objects < rhs_.objects)
        {
            return true;
        }
        else if(rhs_.objects < objects)
        {
            return false;
        }
        if(allocatables < rhs_.allocatables)
        {
            return true;
        }
        else if(rhs_.allocatables < allocatables)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const AdapterDescriptor& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const AdapterDescriptor& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const AdapterDescriptor& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const AdapterDescriptor& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * A sequence of adapter descriptors.
 */
typedef ::std::vector<IceGrid::AdapterDescriptor> AdapterDescriptorSeq;

/**
 * A Freeze database environment descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct DbEnvDescriptor
{
    /**
     * The name of the database environment.
     */
    ::std::string name;
    /**
     * The description of this database environment.
     */
    ::std::string description;
    /**
     * The home of the database environment (i.e., the directory where
     * the database files will be stored). If empty, the node will
     * provide a default database directory, otherwise the directory
     * must exist.
     */
    ::std::string dbHome;
    /**
     * The configuration properties of the database environment.
     */
    PropertyDescriptorSeq properties;

    bool operator==(const DbEnvDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(name != rhs_.name)
        {
            return false;
        }
        if(description != rhs_.description)
        {
            return false;
        }
        if(dbHome != rhs_.dbHome)
        {
            return false;
        }
        if(properties != rhs_.properties)
        {
            return false;
        }
        return true;
    }

    bool operator<(const DbEnvDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(name < rhs_.name)
        {
            return true;
        }
        else if(rhs_.name < name)
        {
            return false;
        }
        if(description < rhs_.description)
        {
            return true;
        }
        else if(rhs_.description < description)
        {
            return false;
        }
        if(dbHome < rhs_.dbHome)
        {
            return true;
        }
        else if(rhs_.dbHome < dbHome)
        {
            return false;
        }
        if(properties < rhs_.properties)
        {
            return true;
        }
        else if(rhs_.properties < properties)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const DbEnvDescriptor& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const DbEnvDescriptor& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const DbEnvDescriptor& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const DbEnvDescriptor& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * A sequence of database environment descriptors.
 */
typedef ::std::vector<IceGrid::DbEnvDescriptor> DbEnvDescriptorSeq;

/**
 * A distribution descriptor defines an IcePatch2 server and the
 * directories to retrieve from the patch server.
 * \headerfile IceGrid/IceGrid.h
 */
struct DistributionDescriptor
{
    /**
     * The proxy of the IcePatch2 server.
     */
    ::std::string icepatch;
    /**
     * The source directories.
     */
    ::Ice::StringSeq directories;

    bool operator==(const DistributionDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(icepatch != rhs_.icepatch)
        {
            return false;
        }
        if(directories != rhs_.directories)
        {
            return false;
        }
        return true;
    }

    bool operator<(const DistributionDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(icepatch < rhs_.icepatch)
        {
            return true;
        }
        else if(rhs_.icepatch < icepatch)
        {
            return false;
        }
        if(directories < rhs_.directories)
        {
            return true;
        }
        else if(rhs_.directories < directories)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const DistributionDescriptor& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const DistributionDescriptor& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const DistributionDescriptor& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const DistributionDescriptor& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * A sequence of server descriptors.
 */
typedef ::std::vector<IceGrid::ServerDescriptorPtr> ServerDescriptorSeq;

/**
 * A sequence of service descriptors.
 */
typedef ::std::vector<IceGrid::ServiceDescriptorPtr> ServiceDescriptorSeq;

/**
 * A server template instance descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct ServerInstanceDescriptor
{
    /**
     * The template used by this instance.
     */
    ::std::string _cpp_template;
    /**
     * The template parameter values.
     */
    StringStringDict parameterValues;
    /**
     * The property set.
     */
    PropertySetDescriptor propertySet;
    /**
     * The services property sets. It's only valid to set these
     * property sets if the template is an IceBox server template.
     */
    PropertySetDescriptorDict servicePropertySets;

    bool operator==(const ServerInstanceDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(_cpp_template != rhs_._cpp_template)
        {
            return false;
        }
        if(parameterValues != rhs_.parameterValues)
        {
            return false;
        }
        if(propertySet != rhs_.propertySet)
        {
            return false;
        }
        if(servicePropertySets != rhs_.servicePropertySets)
        {
            return false;
        }
        return true;
    }

    bool operator<(const ServerInstanceDescriptor& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(_cpp_template < rhs_._cpp_template)
        {
            return true;
        }
        else if(rhs_._cpp_template < _cpp_template)
        {
            return false;
        }
        if(parameterValues < rhs_.parameterValues)
        {
            return true;
        }
        else if(rhs_.parameterValues < parameterValues)
        {
            return false;
        }
        if(propertySet < rhs_.propertySet)
        {
            return true;
        }
        else if(rhs_.propertySet < propertySet)
        {
            return false;
        }
        if(servicePropertySets < rhs_.servicePropertySets)
        {
            return true;
        }
        else if(rhs_.servicePropertySets < servicePropertySets)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const ServerInstanceDescriptor& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const ServerInstanceDescriptor& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const ServerInstanceDescriptor& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const ServerInstanceDescriptor& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * A sequence of server instance descriptors.
 */
typedef ::std::vector<IceGrid::ServerInstanceDescriptor> ServerInstanceDescriptorSeq;

/**
 * A template descriptor for server or service templates.
 * \headerfile IceGrid/IceGrid.h
 */
struct TemplateDescriptor
{
    /**
     * The template.
     */
    CommunicatorDescriptorPtr descriptor;
    /**
     * The parameters required to instantiate the template.
     */
    ::Ice::StringSeq parameters;
    /**
     * The parameters default values.
     */
    StringStringDict parameterDefaults;
};

/**
 * A mapping of template identifier to template descriptor.
 */
typedef ::std::map< ::std::string, IceGrid::TemplateDescriptor> TemplateDescriptorDict;

/**
 * A service template instance descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct ServiceInstanceDescriptor
{
    /**
     * The template used by this instance.
     */
    ::std::string _cpp_template;
    /**
     * The template parameter values.
     */
    StringStringDict parameterValues;
    /**
     * The service definition if the instance isn't a template
     * instance (i.e.: if the template attribute is empty).
     */
    ServiceDescriptorPtr descriptor;
    /**
     * The property set.
     */
    PropertySetDescriptor propertySet;
};

/**
 * A sequence of service instance descriptors.
 */
typedef ::std::vector<IceGrid::ServiceInstanceDescriptor> ServiceInstanceDescriptorSeq;

/**
 * A node descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct NodeDescriptor
{
    /**
     * The variables defined for the node.
     */
    StringStringDict variables;
    /**
     * The server instances.
     */
    ServerInstanceDescriptorSeq serverInstances;
    /**
     * Servers (which are not template instances).
     */
    ServerDescriptorSeq servers;
    /**
     * Load factor of the node.
     */
    ::std::string loadFactor;
    /**
     * The description of this node.
     */
    ::std::string description;
    /**
     * Property set descriptors.
     */
    PropertySetDescriptorDict propertySets;
};

/**
 * Mapping of node name to node descriptor.
 */
typedef ::std::map< ::std::string, IceGrid::NodeDescriptor> NodeDescriptorDict;

/**
 * A replica group descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct ReplicaGroupDescriptor
{
    /**
     * The id of the replica group.
     */
    ::std::string id;
    /**
     * The load balancing policy.
     */
    LoadBalancingPolicyPtr loadBalancing;
    /**
     * Default options for proxies created for the replica group.
     */
    ::std::string proxyOptions;
    /**
     * The object descriptors associated with this object adapter.
     */
    ObjectDescriptorSeq objects;
    /**
     * The description of this replica group.
     */
    ::std::string description;
    /**
     * The filter to use for this replica group.
     */
    ::std::string filter;
};

/**
 * A sequence of replica groups.
 */
typedef ::std::vector<IceGrid::ReplicaGroupDescriptor> ReplicaGroupDescriptorSeq;

/**
 * An application descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
struct ApplicationDescriptor
{
    /**
     * The application name.
     */
    ::std::string name;
    /**
     * The variables defined in the application descriptor.
     */
    StringStringDict variables;
    /**
     * The replica groups.
     */
    ReplicaGroupDescriptorSeq replicaGroups;
    /**
     * The server templates.
     */
    TemplateDescriptorDict serverTemplates;
    /**
     * The service templates.
     */
    TemplateDescriptorDict serviceTemplates;
    /**
     * The application nodes.
     */
    NodeDescriptorDict nodes;
    /**
     * The application distribution.
     */
    DistributionDescriptor distrib;
    /**
     * The description of this application.
     */
    ::std::string description;
    /**
     * Property set descriptors.
     */
    PropertySetDescriptorDict propertySets;
};

/**
 * A sequence of application descriptors.
 */
typedef ::std::vector<IceGrid::ApplicationDescriptor> ApplicationDescriptorSeq;

/**
 * A node update descriptor to describe the updates to apply to a
 * node of a deployed application.
 * \headerfile IceGrid/IceGrid.h
 */
struct NodeUpdateDescriptor
{
    /**
     * The name of the node to update.
     */
    ::std::string name;
    /**
     * The updated description (or null if the description wasn't
     * updated.)
     */
    BoxedStringPtr description;
    /**
     * The variables to update.
     */
    StringStringDict variables;
    /**
     * The variables to remove.
     */
    ::Ice::StringSeq removeVariables;
    /**
     * The property sets to update.
     */
    PropertySetDescriptorDict propertySets;
    /**
     * The property sets to remove.
     */
    ::Ice::StringSeq removePropertySets;
    /**
     * The server instances to update.
     */
    ServerInstanceDescriptorSeq serverInstances;
    /**
     * The servers which are not template instances to update.
     */
    ServerDescriptorSeq servers;
    /**
     * The ids of the servers to remove.
     */
    ::Ice::StringSeq removeServers;
    /**
     * The updated load factor of the node (or null if the load factor
     * was not updated).
     */
    BoxedStringPtr loadFactor;
};

/**
 * A sequence of node update descriptors.
 */
typedef ::std::vector<IceGrid::NodeUpdateDescriptor> NodeUpdateDescriptorSeq;

/**
 * An application update descriptor to describe the updates to apply
 * to a deployed application.
 * \headerfile IceGrid/IceGrid.h
 */
struct ApplicationUpdateDescriptor
{
    /**
     * The name of the application to update.
     */
    ::std::string name;
    /**
     * The updated description (or null if the description wasn't
     * updated.)
     */
    BoxedStringPtr description;
    /**
     * The updated distribution application descriptor.
     */
    BoxedDistributionDescriptorPtr distrib;
    /**
     * The variables to update.
     */
    StringStringDict variables;
    /**
     * The variables to remove.
     */
    ::Ice::StringSeq removeVariables;
    /**
     * The property sets to update.
     */
    PropertySetDescriptorDict propertySets;
    /**
     * The property sets to remove.
     */
    ::Ice::StringSeq removePropertySets;
    /**
     * The replica groups to update.
     */
    ReplicaGroupDescriptorSeq replicaGroups;
    /**
     * The replica groups to remove.
     */
    ::Ice::StringSeq removeReplicaGroups;
    /**
     * The server templates to update.
     */
    TemplateDescriptorDict serverTemplates;
    /**
     * The ids of the server template to remove.
     */
    ::Ice::StringSeq removeServerTemplates;
    /**
     * The service templates to update.
     */
    TemplateDescriptorDict serviceTemplates;
    /**
     * The ids of the service template to remove.
     */
    ::Ice::StringSeq removeServiceTemplates;
    /**
     * The application nodes to update.
     */
    NodeUpdateDescriptorSeq nodes;
    /**
     * The nodes to remove.
     */
    ::Ice::StringSeq removeNodes;
};

}

namespace IceGrid
{

}

namespace IceProxy
{

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) CommunicatorDescriptor : public virtual ::Ice::Proxy<CommunicatorDescriptor, ::IceProxy::Ice::Object>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) ServerDescriptor : public virtual ::Ice::Proxy<ServerDescriptor, ::IceProxy::IceGrid::CommunicatorDescriptor>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) ServiceDescriptor : public virtual ::Ice::Proxy<ServiceDescriptor, ::IceProxy::IceGrid::CommunicatorDescriptor>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) IceBoxDescriptor : public virtual ::Ice::Proxy<IceBoxDescriptor, ::IceProxy::IceGrid::ServerDescriptor>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) LoadBalancingPolicy : public virtual ::Ice::Proxy<LoadBalancingPolicy, ::IceProxy::Ice::Object>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) RandomLoadBalancingPolicy : public virtual ::Ice::Proxy<RandomLoadBalancingPolicy, ::IceProxy::IceGrid::LoadBalancingPolicy>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) OrderedLoadBalancingPolicy : public virtual ::Ice::Proxy<OrderedLoadBalancingPolicy, ::IceProxy::IceGrid::LoadBalancingPolicy>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) RoundRobinLoadBalancingPolicy : public virtual ::Ice::Proxy<RoundRobinLoadBalancingPolicy, ::IceProxy::IceGrid::LoadBalancingPolicy>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) AdaptiveLoadBalancingPolicy : public virtual ::Ice::Proxy<AdaptiveLoadBalancingPolicy, ::IceProxy::IceGrid::LoadBalancingPolicy>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) BoxedString : public virtual ::Ice::Proxy<BoxedString, ::IceProxy::Ice::Object>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICEGRID_API) BoxedDistributionDescriptor : public virtual ::Ice::Proxy<BoxedDistributionDescriptor, ::IceProxy::Ice::Object>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace IceGrid
{

/**
 * A communicator descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API CommunicatorDescriptor : public virtual ::Ice::Object
{
public:

    typedef CommunicatorDescriptorPrx ProxyType;
    typedef CommunicatorDescriptorPtr PointerType;

    virtual ~CommunicatorDescriptor();

    CommunicatorDescriptor()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param adapters The object adapters.
     * @param propertySet The property set.
     * @param dbEnvs The database environments.
     * @param logs The path of each log file.
     * @param description A description of this descriptor.
     */
    CommunicatorDescriptor(const AdapterDescriptorSeq& adapters, const PropertySetDescriptor& propertySet, const DbEnvDescriptorSeq& dbEnvs, const ::Ice::StringSeq& logs, const ::std::string& description) :
        adapters(adapters),
        propertySet(propertySet),
        dbEnvs(dbEnvs),
        logs(logs),
        description(description)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The object adapters.
     */
    AdapterDescriptorSeq adapters;
    /**
     * The property set.
     */
    PropertySetDescriptor propertySet;
    /**
     * The database environments.
     */
    DbEnvDescriptorSeq dbEnvs;
    /**
     * The path of each log file.
     */
    ::Ice::StringSeq logs;
    /**
     * A description of this descriptor.
     */
    ::std::string description;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_CommunicatorDescriptor_init = ::IceGrid::CommunicatorDescriptor::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const CommunicatorDescriptor& lhs, const CommunicatorDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const CommunicatorDescriptor& lhs, const CommunicatorDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * An Ice server descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API ServerDescriptor : public CommunicatorDescriptor
{
public:

    typedef ServerDescriptorPrx ProxyType;
    typedef ServerDescriptorPtr PointerType;

    virtual ~ServerDescriptor();

    ServerDescriptor()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param adapters The object adapters.
     * @param propertySet The property set.
     * @param dbEnvs The database environments.
     * @param logs The path of each log file.
     * @param description A description of this descriptor.
     * @param id The server id.
     * @param exe The path of the server executable.
     * @param iceVersion The Ice version used by this server.
     * @param pwd The path to the server working directory.
     * @param options The command line options to pass to the server executable.
     * @param envs The server environment variables.
     * @param activation The server activation mode (possible values are "on-demand" or "manual").
     * @param activationTimeout The activation timeout (an integer value representing the number of seconds to wait for activation).
     * @param deactivationTimeout The deactivation timeout (an integer value representing the number of seconds to wait for deactivation).
     * @param applicationDistrib Specifies if the server depends on the application distribution.
     * @param distrib The distribution descriptor.
     * @param allocatable Specifies if the server is allocatable.
     * @param user The user account used to run the server.
     */
    ServerDescriptor(const AdapterDescriptorSeq& adapters, const PropertySetDescriptor& propertySet, const DbEnvDescriptorSeq& dbEnvs, const ::Ice::StringSeq& logs, const ::std::string& description, const ::std::string& id, const ::std::string& exe, const ::std::string& iceVersion, const ::std::string& pwd, const ::Ice::StringSeq& options, const ::Ice::StringSeq& envs, const ::std::string& activation, const ::std::string& activationTimeout, const ::std::string& deactivationTimeout, bool applicationDistrib, const DistributionDescriptor& distrib, bool allocatable, const ::std::string& user) :
        ::IceGrid::CommunicatorDescriptor(adapters, propertySet, dbEnvs, logs, description),
        id(id),
        exe(exe),
        iceVersion(iceVersion),
        pwd(pwd),
        options(options),
        envs(envs),
        activation(activation),
        activationTimeout(activationTimeout),
        deactivationTimeout(deactivationTimeout),
        applicationDistrib(applicationDistrib),
        distrib(distrib),
        allocatable(allocatable),
        user(user)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The server id.
     */
    ::std::string id;
    /**
     * The path of the server executable.
     */
    ::std::string exe;
    /**
     * The Ice version used by this server. This is only required if
     * backward compatibility with servers using old Ice versions is
     * needed (otherwise the registry will assume the server is using
     * the same Ice version).
     * For example "3.1.1", "3.2", "3.3.0".
     */
    ::std::string iceVersion;
    /**
     * The path to the server working directory.
     */
    ::std::string pwd;
    /**
     * The command line options to pass to the server executable.
     */
    ::Ice::StringSeq options;
    /**
     * The server environment variables.
     */
    ::Ice::StringSeq envs;
    /**
     * The server activation mode (possible values are "on-demand" or
     * "manual").
     */
    ::std::string activation;
    /**
     * The activation timeout (an integer value representing the
     * number of seconds to wait for activation).
     */
    ::std::string activationTimeout;
    /**
     * The deactivation timeout (an integer value representing the
     * number of seconds to wait for deactivation).
     */
    ::std::string deactivationTimeout;
    /**
     * Specifies if the server depends on the application
     * distribution.
     */
    bool applicationDistrib;
    /**
     * The distribution descriptor.
     */
    DistributionDescriptor distrib;
    /**
     * Specifies if the server is allocatable.
     */
    bool allocatable;
    /**
     * The user account used to run the server.
     */
    ::std::string user;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_ServerDescriptor_init = ::IceGrid::ServerDescriptor::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const ServerDescriptor& lhs, const ServerDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ServerDescriptor& lhs, const ServerDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * An IceBox service descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API ServiceDescriptor : public CommunicatorDescriptor
{
public:

    typedef ServiceDescriptorPrx ProxyType;
    typedef ServiceDescriptorPtr PointerType;

    virtual ~ServiceDescriptor();

    ServiceDescriptor()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param adapters The object adapters.
     * @param propertySet The property set.
     * @param dbEnvs The database environments.
     * @param logs The path of each log file.
     * @param description A description of this descriptor.
     * @param name The service name.
     * @param entry The entry point of the IceBox service.
     */
    ServiceDescriptor(const AdapterDescriptorSeq& adapters, const PropertySetDescriptor& propertySet, const DbEnvDescriptorSeq& dbEnvs, const ::Ice::StringSeq& logs, const ::std::string& description, const ::std::string& name, const ::std::string& entry) :
        ::IceGrid::CommunicatorDescriptor(adapters, propertySet, dbEnvs, logs, description),
        name(name),
        entry(entry)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The service name.
     */
    ::std::string name;
    /**
     * The entry point of the IceBox service.
     */
    ::std::string entry;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_ServiceDescriptor_init = ::IceGrid::ServiceDescriptor::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const ServiceDescriptor& lhs, const ServiceDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ServiceDescriptor& lhs, const ServiceDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * An IceBox server descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API IceBoxDescriptor : public ServerDescriptor, public ::IceInternal::GCObject
{
public:

    typedef IceBoxDescriptorPrx ProxyType;
    typedef IceBoxDescriptorPtr PointerType;

    virtual ~IceBoxDescriptor();

    IceBoxDescriptor()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param adapters The object adapters.
     * @param propertySet The property set.
     * @param dbEnvs The database environments.
     * @param logs The path of each log file.
     * @param description A description of this descriptor.
     * @param id The server id.
     * @param exe The path of the server executable.
     * @param iceVersion The Ice version used by this server.
     * @param pwd The path to the server working directory.
     * @param options The command line options to pass to the server executable.
     * @param envs The server environment variables.
     * @param activation The server activation mode (possible values are "on-demand" or "manual").
     * @param activationTimeout The activation timeout (an integer value representing the number of seconds to wait for activation).
     * @param deactivationTimeout The deactivation timeout (an integer value representing the number of seconds to wait for deactivation).
     * @param applicationDistrib Specifies if the server depends on the application distribution.
     * @param distrib The distribution descriptor.
     * @param allocatable Specifies if the server is allocatable.
     * @param user The user account used to run the server.
     * @param services The service instances.
     */
    IceBoxDescriptor(const AdapterDescriptorSeq& adapters, const PropertySetDescriptor& propertySet, const DbEnvDescriptorSeq& dbEnvs, const ::Ice::StringSeq& logs, const ::std::string& description, const ::std::string& id, const ::std::string& exe, const ::std::string& iceVersion, const ::std::string& pwd, const ::Ice::StringSeq& options, const ::Ice::StringSeq& envs, const ::std::string& activation, const ::std::string& activationTimeout, const ::std::string& deactivationTimeout, bool applicationDistrib, const DistributionDescriptor& distrib, bool allocatable, const ::std::string& user, const ServiceInstanceDescriptorSeq& services) :
        ::IceGrid::ServerDescriptor(adapters, propertySet, dbEnvs, logs, description, id, exe, iceVersion, pwd, options, envs, activation, activationTimeout, deactivationTimeout, applicationDistrib, distrib, allocatable, user),
        services(services)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
    /// \cond INTERNAL
    virtual void _iceGcVisitMembers(::IceInternal::GCVisitor&);
    /// \endcond

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The service instances.
     */
    ServiceInstanceDescriptorSeq services;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_IceBoxDescriptor_init = ::IceGrid::IceBoxDescriptor::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const IceBoxDescriptor& lhs, const IceBoxDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const IceBoxDescriptor& lhs, const IceBoxDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * A base class for load balancing policies.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API LoadBalancingPolicy : public virtual ::Ice::Object
{
public:

    typedef LoadBalancingPolicyPrx ProxyType;
    typedef LoadBalancingPolicyPtr PointerType;

    virtual ~LoadBalancingPolicy();

    LoadBalancingPolicy()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param nReplicas The number of replicas that will be used to gather the endpoints of a replica group.
     */
    explicit LoadBalancingPolicy(const ::std::string& nReplicas) :
        nReplicas(nReplicas)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The number of replicas that will be used to gather the
     * endpoints of a replica group.
     */
    ::std::string nReplicas;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_LoadBalancingPolicy_init = ::IceGrid::LoadBalancingPolicy::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const LoadBalancingPolicy& lhs, const LoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const LoadBalancingPolicy& lhs, const LoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Random load balancing policy.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API RandomLoadBalancingPolicy : public LoadBalancingPolicy
{
public:

    typedef RandomLoadBalancingPolicyPrx ProxyType;
    typedef RandomLoadBalancingPolicyPtr PointerType;

    virtual ~RandomLoadBalancingPolicy();

    RandomLoadBalancingPolicy()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param nReplicas The number of replicas that will be used to gather the endpoints of a replica group.
     */
    explicit RandomLoadBalancingPolicy(const ::std::string& nReplicas) :
        ::IceGrid::LoadBalancingPolicy(nReplicas)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_RandomLoadBalancingPolicy_init = ::IceGrid::RandomLoadBalancingPolicy::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const RandomLoadBalancingPolicy& lhs, const RandomLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const RandomLoadBalancingPolicy& lhs, const RandomLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Ordered load balancing policy.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API OrderedLoadBalancingPolicy : public LoadBalancingPolicy
{
public:

    typedef OrderedLoadBalancingPolicyPrx ProxyType;
    typedef OrderedLoadBalancingPolicyPtr PointerType;

    virtual ~OrderedLoadBalancingPolicy();

    OrderedLoadBalancingPolicy()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param nReplicas The number of replicas that will be used to gather the endpoints of a replica group.
     */
    explicit OrderedLoadBalancingPolicy(const ::std::string& nReplicas) :
        ::IceGrid::LoadBalancingPolicy(nReplicas)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_OrderedLoadBalancingPolicy_init = ::IceGrid::OrderedLoadBalancingPolicy::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const OrderedLoadBalancingPolicy& lhs, const OrderedLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const OrderedLoadBalancingPolicy& lhs, const OrderedLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Round robin load balancing policy.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API RoundRobinLoadBalancingPolicy : public LoadBalancingPolicy
{
public:

    typedef RoundRobinLoadBalancingPolicyPrx ProxyType;
    typedef RoundRobinLoadBalancingPolicyPtr PointerType;

    virtual ~RoundRobinLoadBalancingPolicy();

    RoundRobinLoadBalancingPolicy()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param nReplicas The number of replicas that will be used to gather the endpoints of a replica group.
     */
    explicit RoundRobinLoadBalancingPolicy(const ::std::string& nReplicas) :
        ::IceGrid::LoadBalancingPolicy(nReplicas)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_RoundRobinLoadBalancingPolicy_init = ::IceGrid::RoundRobinLoadBalancingPolicy::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const RoundRobinLoadBalancingPolicy& lhs, const RoundRobinLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const RoundRobinLoadBalancingPolicy& lhs, const RoundRobinLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Adaptive load balancing policy.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API AdaptiveLoadBalancingPolicy : public LoadBalancingPolicy
{
public:

    typedef AdaptiveLoadBalancingPolicyPrx ProxyType;
    typedef AdaptiveLoadBalancingPolicyPtr PointerType;

    virtual ~AdaptiveLoadBalancingPolicy();

    AdaptiveLoadBalancingPolicy()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param nReplicas The number of replicas that will be used to gather the endpoints of a replica group.
     * @param loadSample The load sample to use for the load balancing.
     */
    AdaptiveLoadBalancingPolicy(const ::std::string& nReplicas, const ::std::string& loadSample) :
        ::IceGrid::LoadBalancingPolicy(nReplicas),
        loadSample(loadSample)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The load sample to use for the load balancing. The allowed
     * values for this attribute are "1", "5" and "15", representing
     * respectively the load average over the past minute, the past 5
     * minutes and the past 15 minutes.
     */
    ::std::string loadSample;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_AdaptiveLoadBalancingPolicy_init = ::IceGrid::AdaptiveLoadBalancingPolicy::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const AdaptiveLoadBalancingPolicy& lhs, const AdaptiveLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const AdaptiveLoadBalancingPolicy& lhs, const AdaptiveLoadBalancingPolicy& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * A "boxed" string.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API BoxedString : public virtual ::Ice::Object
{
public:

    typedef BoxedStringPrx ProxyType;
    typedef BoxedStringPtr PointerType;

    virtual ~BoxedString();

    BoxedString()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param value The value of the boxed string.
     */
    explicit BoxedString(const ::std::string& value) :
        value(value)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The value of the boxed string.
     */
    ::std::string value;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_BoxedString_init = ::IceGrid::BoxedString::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const BoxedString& lhs, const BoxedString& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const BoxedString& lhs, const BoxedString& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * A "boxed" distribution descriptor.
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API BoxedDistributionDescriptor : public virtual ::Ice::Object
{
public:

    typedef BoxedDistributionDescriptorPrx ProxyType;
    typedef BoxedDistributionDescriptorPtr PointerType;

    virtual ~BoxedDistributionDescriptor();

    BoxedDistributionDescriptor()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param value The value of the boxed distribution descriptor.
     */
    explicit BoxedDistributionDescriptor(const DistributionDescriptor& value) :
        value(value)
    {
    }

    /**
     * Polymporphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The value of the boxed distribution descriptor.
     */
    DistributionDescriptor value;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_BoxedDistributionDescriptor_init = ::IceGrid::BoxedDistributionDescriptor::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const BoxedDistributionDescriptor& lhs, const BoxedDistributionDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const BoxedDistributionDescriptor& lhs, const BoxedDistributionDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::IceGrid::PropertyDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::PropertyDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::PropertyDescriptor& v)
    {
        ostr->write(v.name);
        ostr->write(v.value);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::PropertyDescriptor, S>
{
    static void read(S* istr, ::IceGrid::PropertyDescriptor& v)
    {
        istr->read(v.name);
        istr->read(v.value);
    }
};

template<>
struct StreamableTraits< ::IceGrid::PropertySetDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::PropertySetDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::PropertySetDescriptor& v)
    {
        ostr->write(v.references);
        ostr->write(v.properties);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::PropertySetDescriptor, S>
{
    static void read(S* istr, ::IceGrid::PropertySetDescriptor& v)
    {
        istr->read(v.references);
        istr->read(v.properties);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ObjectDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ObjectDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ObjectDescriptor& v)
    {
        ostr->write(v.id);
        ostr->write(v.type);
        ostr->write(v.proxyOptions);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ObjectDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ObjectDescriptor& v)
    {
        istr->read(v.id);
        istr->read(v.type);
        istr->read(v.proxyOptions);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AdapterDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 9;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::AdapterDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::AdapterDescriptor& v)
    {
        ostr->write(v.name);
        ostr->write(v.description);
        ostr->write(v.id);
        ostr->write(v.replicaGroupId);
        ostr->write(v.priority);
        ostr->write(v.registerProcess);
        ostr->write(v.serverLifetime);
        ostr->write(v.objects);
        ostr->write(v.allocatables);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AdapterDescriptor, S>
{
    static void read(S* istr, ::IceGrid::AdapterDescriptor& v)
    {
        istr->read(v.name);
        istr->read(v.description);
        istr->read(v.id);
        istr->read(v.replicaGroupId);
        istr->read(v.priority);
        istr->read(v.registerProcess);
        istr->read(v.serverLifetime);
        istr->read(v.objects);
        istr->read(v.allocatables);
    }
};

template<>
struct StreamableTraits< ::IceGrid::DbEnvDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::DbEnvDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::DbEnvDescriptor& v)
    {
        ostr->write(v.name);
        ostr->write(v.description);
        ostr->write(v.dbHome);
        ostr->write(v.properties);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::DbEnvDescriptor, S>
{
    static void read(S* istr, ::IceGrid::DbEnvDescriptor& v)
    {
        istr->read(v.name);
        istr->read(v.description);
        istr->read(v.dbHome);
        istr->read(v.properties);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::CommunicatorDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::CommunicatorDescriptor& v)
    {
        ostr->write(v.adapters);
        ostr->write(v.propertySet);
        ostr->write(v.dbEnvs);
        ostr->write(v.logs);
        ostr->write(v.description);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::CommunicatorDescriptor, S>
{
    static void read(S* istr, ::IceGrid::CommunicatorDescriptor& v)
    {
        istr->read(v.adapters);
        istr->read(v.propertySet);
        istr->read(v.dbEnvs);
        istr->read(v.logs);
        istr->read(v.description);
    }
};

template<>
struct StreamableTraits< ::IceGrid::DistributionDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::DistributionDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::DistributionDescriptor& v)
    {
        ostr->write(v.icepatch);
        ostr->write(v.directories);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::DistributionDescriptor, S>
{
    static void read(S* istr, ::IceGrid::DistributionDescriptor& v)
    {
        istr->read(v.icepatch);
        istr->read(v.directories);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ServerDescriptor& v)
    {
        ostr->write(v.id);
        ostr->write(v.exe);
        ostr->write(v.iceVersion);
        ostr->write(v.pwd);
        ostr->write(v.options);
        ostr->write(v.envs);
        ostr->write(v.activation);
        ostr->write(v.activationTimeout);
        ostr->write(v.deactivationTimeout);
        ostr->write(v.applicationDistrib);
        ostr->write(v.distrib);
        ostr->write(v.allocatable);
        ostr->write(v.user);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServerDescriptor& v)
    {
        istr->read(v.id);
        istr->read(v.exe);
        istr->read(v.iceVersion);
        istr->read(v.pwd);
        istr->read(v.options);
        istr->read(v.envs);
        istr->read(v.activation);
        istr->read(v.activationTimeout);
        istr->read(v.deactivationTimeout);
        istr->read(v.applicationDistrib);
        istr->read(v.distrib);
        istr->read(v.allocatable);
        istr->read(v.user);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::ServiceDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ServiceDescriptor& v)
    {
        ostr->write(v.name);
        ostr->write(v.entry);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServiceDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServiceDescriptor& v)
    {
        istr->read(v.name);
        istr->read(v.entry);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServerInstanceDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 5;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerInstanceDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ServerInstanceDescriptor& v)
    {
        ostr->write(v._cpp_template);
        ostr->write(v.parameterValues);
        ostr->write(v.propertySet);
        ostr->write(v.servicePropertySets);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerInstanceDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServerInstanceDescriptor& v)
    {
        istr->read(v._cpp_template);
        istr->read(v.parameterValues);
        istr->read(v.propertySet);
        istr->read(v.servicePropertySets);
    }
};

template<>
struct StreamableTraits< ::IceGrid::TemplateDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 3;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::TemplateDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::TemplateDescriptor& v)
    {
        ostr->write(v.descriptor);
        ostr->write(v.parameters);
        ostr->write(v.parameterDefaults);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::TemplateDescriptor, S>
{
    static void read(S* istr, ::IceGrid::TemplateDescriptor& v)
    {
        istr->read(v.descriptor);
        istr->read(v.parameters);
        istr->read(v.parameterDefaults);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServiceInstanceDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 5;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServiceInstanceDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ServiceInstanceDescriptor& v)
    {
        ostr->write(v._cpp_template);
        ostr->write(v.parameterValues);
        ostr->write(v.descriptor);
        ostr->write(v.propertySet);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServiceInstanceDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ServiceInstanceDescriptor& v)
    {
        istr->read(v._cpp_template);
        istr->read(v.parameterValues);
        istr->read(v.descriptor);
        istr->read(v.propertySet);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::IceBoxDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::IceBoxDescriptor& v)
    {
        ostr->write(v.services);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::IceBoxDescriptor, S>
{
    static void read(S* istr, ::IceGrid::IceBoxDescriptor& v)
    {
        istr->read(v.services);
    }
};

template<>
struct StreamableTraits< ::IceGrid::NodeDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 6;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::NodeDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::NodeDescriptor& v)
    {
        ostr->write(v.variables);
        ostr->write(v.serverInstances);
        ostr->write(v.servers);
        ostr->write(v.loadFactor);
        ostr->write(v.description);
        ostr->write(v.propertySets);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::NodeDescriptor, S>
{
    static void read(S* istr, ::IceGrid::NodeDescriptor& v)
    {
        istr->read(v.variables);
        istr->read(v.serverInstances);
        istr->read(v.servers);
        istr->read(v.loadFactor);
        istr->read(v.description);
        istr->read(v.propertySets);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::LoadBalancingPolicy, S>
{
    static void write(S* ostr, const ::IceGrid::LoadBalancingPolicy& v)
    {
        ostr->write(v.nReplicas);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::LoadBalancingPolicy, S>
{
    static void read(S* istr, ::IceGrid::LoadBalancingPolicy& v)
    {
        istr->read(v.nReplicas);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::AdaptiveLoadBalancingPolicy, S>
{
    static void write(S* ostr, const ::IceGrid::AdaptiveLoadBalancingPolicy& v)
    {
        ostr->write(v.loadSample);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AdaptiveLoadBalancingPolicy, S>
{
    static void read(S* istr, ::IceGrid::AdaptiveLoadBalancingPolicy& v)
    {
        istr->read(v.loadSample);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ReplicaGroupDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 6;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ReplicaGroupDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ReplicaGroupDescriptor& v)
    {
        ostr->write(v.id);
        ostr->write(v.loadBalancing);
        ostr->write(v.proxyOptions);
        ostr->write(v.objects);
        ostr->write(v.description);
        ostr->write(v.filter);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ReplicaGroupDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ReplicaGroupDescriptor& v)
    {
        istr->read(v.id);
        istr->read(v.loadBalancing);
        istr->read(v.proxyOptions);
        istr->read(v.objects);
        istr->read(v.description);
        istr->read(v.filter);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ApplicationDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 10;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ApplicationDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ApplicationDescriptor& v)
    {
        ostr->write(v.name);
        ostr->write(v.variables);
        ostr->write(v.replicaGroups);
        ostr->write(v.serverTemplates);
        ostr->write(v.serviceTemplates);
        ostr->write(v.nodes);
        ostr->write(v.distrib);
        ostr->write(v.description);
        ostr->write(v.propertySets);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ApplicationDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ApplicationDescriptor& v)
    {
        istr->read(v.name);
        istr->read(v.variables);
        istr->read(v.replicaGroups);
        istr->read(v.serverTemplates);
        istr->read(v.serviceTemplates);
        istr->read(v.nodes);
        istr->read(v.distrib);
        istr->read(v.description);
        istr->read(v.propertySets);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::BoxedString, S>
{
    static void write(S* ostr, const ::IceGrid::BoxedString& v)
    {
        ostr->write(v.value);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::BoxedString, S>
{
    static void read(S* istr, ::IceGrid::BoxedString& v)
    {
        istr->read(v.value);
    }
};

template<>
struct StreamableTraits< ::IceGrid::NodeUpdateDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 10;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::NodeUpdateDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::NodeUpdateDescriptor& v)
    {
        ostr->write(v.name);
        ostr->write(v.description);
        ostr->write(v.variables);
        ostr->write(v.removeVariables);
        ostr->write(v.propertySets);
        ostr->write(v.removePropertySets);
        ostr->write(v.serverInstances);
        ostr->write(v.servers);
        ostr->write(v.removeServers);
        ostr->write(v.loadFactor);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::NodeUpdateDescriptor, S>
{
    static void read(S* istr, ::IceGrid::NodeUpdateDescriptor& v)
    {
        istr->read(v.name);
        istr->read(v.description);
        istr->read(v.variables);
        istr->read(v.removeVariables);
        istr->read(v.propertySets);
        istr->read(v.removePropertySets);
        istr->read(v.serverInstances);
        istr->read(v.servers);
        istr->read(v.removeServers);
        istr->read(v.loadFactor);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::BoxedDistributionDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::BoxedDistributionDescriptor& v)
    {
        ostr->write(v.value);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::BoxedDistributionDescriptor, S>
{
    static void read(S* istr, ::IceGrid::BoxedDistributionDescriptor& v)
    {
        istr->read(v.value);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ApplicationUpdateDescriptor>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 15;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ApplicationUpdateDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::ApplicationUpdateDescriptor& v)
    {
        ostr->write(v.name);
        ostr->write(v.description);
        ostr->write(v.distrib);
        ostr->write(v.variables);
        ostr->write(v.removeVariables);
        ostr->write(v.propertySets);
        ostr->write(v.removePropertySets);
        ostr->write(v.replicaGroups);
        ostr->write(v.removeReplicaGroups);
        ostr->write(v.serverTemplates);
        ostr->write(v.removeServerTemplates);
        ostr->write(v.serviceTemplates);
        ostr->write(v.removeServiceTemplates);
        ostr->write(v.nodes);
        ostr->write(v.removeNodes);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ApplicationUpdateDescriptor, S>
{
    static void read(S* istr, ::IceGrid::ApplicationUpdateDescriptor& v)
    {
        istr->read(v.name);
        istr->read(v.description);
        istr->read(v.distrib);
        istr->read(v.variables);
        istr->read(v.removeVariables);
        istr->read(v.propertySets);
        istr->read(v.removePropertySets);
        istr->read(v.replicaGroups);
        istr->read(v.removeReplicaGroups);
        istr->read(v.serverTemplates);
        istr->read(v.removeServerTemplates);
        istr->read(v.serviceTemplates);
        istr->read(v.removeServiceTemplates);
        istr->read(v.nodes);
        istr->read(v.removeNodes);
    }
};

}
/// \endcond

namespace IceGrid
{

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
