/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.explorer;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasupport.Positionable;
import com.sun.tools.visualvm.core.explorer.DataSourcesComparator;
import com.sun.tools.visualvm.core.explorer.ExplorerNodesComparator;
import com.sun.tools.visualvm.core.explorer.ExplorerSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

final class ExplorerNode
extends DefaultMutableTreeNode
implements Positionable {
    static final String PROPERTY_RELATIVE_POSITION = "prop_relative_position";
    private String name;
    private Icon icon;
    private int preferredPosition;
    private int autoExpansionPolicy;
    private boolean defaultComparator = true;
    private ExplorerNodesComparator comparator = new ExplorerNodesComparator(new PositionableComparator());
    private int maxEndPosition = -1;
    private int maxLastPosition = -1;
    private final Map<DataSource, Integer> endPositions = Collections.synchronizedMap(new HashMap());
    private final Map<DataSource, Integer> lastPositions = Collections.synchronizedMap(new HashMap());
    private boolean firstExpansionFlag = true;

    public ExplorerNode(DataSource dataSource) {
        super(dataSource);
    }

    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public DataSource getUserObject() {
        return (DataSource)super.getUserObject();
    }

    public void addNode(ExplorerNode newChild) {
        this.addNodes(Collections.singleton(newChild));
    }

    public void addNodes(Set<ExplorerNode> newChildren) {
        int originalChildCount = this.getChildCount();
        for (ExplorerNode child : newChildren) {
            this.add(child);
            this.checkAddRelativePosition(child);
        }
        this.sortChildren();
        boolean shouldExpand = false;
        boolean firstChildAdded = originalChildCount == 0 && this.getChildCount() > 0;
        switch (this.autoExpansionPolicy) {
            case 1: {
                if (this.firstExpansionFlag && firstChildAdded) {
                    shouldExpand = true;
                }
                this.firstExpansionFlag = false;
                break;
            }
            case 2: {
                if (!firstChildAdded) break;
                shouldExpand = true;
                break;
            }
            case 3: 
            case 4: {
                if (newChildren.size() <= 0) break;
                shouldExpand = true;
            }
        }
        if (shouldExpand) {
            ExplorerSupport.sharedInstance().expandNode(this);
        }
    }

    @Override
    public void remove(MutableTreeNode aChild) {
        super.remove(aChild);
        this.checkRemoveRelativePosition((ExplorerNode)aChild);
        if (this.autoExpansionPolicy == 4) {
            ExplorerSupport.sharedInstance().expandNode(this);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public int getPreferredPosition() {
        return this.preferredPosition;
    }

    boolean setName(String name) {
        if (this.parent == null) {
            this.name = name;
            return false;
        }
        if (this.name == null || !this.name.equals(name)) {
            this.name = name;
            ((ExplorerNode)this.parent).sortChildren();
            return true;
        }
        return false;
    }

    void setIcon(Icon icon) {
        this.icon = icon;
    }

    void setPreferredPosition(int preferredPosition) {
        this.preferredPosition = preferredPosition;
    }

    boolean setComparator(Comparator<DataSource> comparator) {
        boolean change = false;
        if (comparator == null) {
            boolean bl = change = !this.defaultComparator;
            if (change) {
                this.comparator = new ExplorerNodesComparator(new PositionableComparator());
            }
            this.defaultComparator = true;
        } else {
            boolean bl = change = this.defaultComparator || !this.comparator.uses(comparator);
            if (change) {
                this.comparator = new ExplorerNodesComparator(comparator);
            }
            this.defaultComparator = false;
        }
        if (change) {
            this.sortChildren();
        }
        return change;
    }

    void setAutoExpansionPolicy(int autoExpansionPolicy) {
        this.autoExpansionPolicy = autoExpansionPolicy;
        this.firstExpansionFlag = true;
    }

    private void sortChildren() {
        if (this.getChildCount() == 0) {
            return;
        }
        Collections.sort(this.children, this.comparator);
    }

    private void checkAddRelativePosition(ExplorerNode node) {
        int pos = node.getPreferredPosition();
        DataSource d = node.getUserObject();
        if (pos == 0x7FFFFFFE) {
            this.addPosition(d, this.endPositions);
        } else if (pos == Integer.MAX_VALUE) {
            this.addPosition(d, this.lastPositions);
        }
    }

    private void addPosition(DataSource node, Map<DataSource, Integer> positions) {
        Storage s = node.getStorage();
        String PREF = "prop_preferred_position";
        int nodePos = 0;
        boolean posDirty = true;
        try {
            nodePos = this.getMaxPosition(positions) + 1;
            nodePos = Integer.parseInt(s.getCustomProperty(PROPERTY_RELATIVE_POSITION));
            posDirty = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s.getCustomProperty(PREF) != null && posDirty) {
            s.setCustomProperty(PROPERTY_RELATIVE_POSITION, Integer.toString(nodePos));
        }
        positions.put(node, nodePos);
        this.updateMaxPosition(positions, nodePos, false);
    }

    private void checkRemoveRelativePosition(ExplorerNode node) {
        int pos = node.getPreferredPosition();
        DataSource d = node.getUserObject();
        if (pos == 0x7FFFFFFE) {
            this.removePosition(d, this.endPositions);
        } else if (pos == Integer.MAX_VALUE) {
            this.removePosition(d, this.lastPositions);
        }
    }

    private void removePosition(DataSource node, Map<DataSource, Integer> positions) {
        int nodePos = positions.remove(node);
        this.updateMaxPosition(positions, nodePos, true);
    }

    private int getMaxPosition(Map<DataSource, Integer> positions) {
        if (positions == this.endPositions) {
            return this.maxEndPosition;
        }
        return this.maxLastPosition;
    }

    private void setMaxPosition(Map<DataSource, Integer> positions, int newMax) {
        if (positions == this.endPositions) {
            this.maxEndPosition = newMax;
        } else {
            this.maxLastPosition = newMax;
        }
    }

    private void updateMaxPosition(Map<DataSource, Integer> positions, int position, boolean remove) {
        int maxPos = this.getMaxPosition(positions);
        if (!remove && maxPos < position) {
            this.setMaxPosition(positions, position);
        } else if (remove && maxPos == position) {
            int newMax = -1;
            Collection<Integer> values = positions.values();
            for (int i : values) {
                if (i <= newMax) continue;
                newMax = i;
            }
            this.setMaxPosition(positions, newMax);
        }
    }

    private class PositionableComparator
    extends DataSourcesComparator {
        private PositionableComparator() {
        }

        @Override
        protected int getRelativePosition(DataSource d, int positionType) {
            if (positionType == 0x7FFFFFFE) {
                return (Integer)ExplorerNode.this.endPositions.get(d);
            }
            if (positionType == Integer.MAX_VALUE) {
                return (Integer)ExplorerNode.this.lastPositions.get(d);
            }
            return positionType;
        }
    }
}

