/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api;

import java.util.Collection;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.modules.profiler.api.Bundle;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.spi.java.GoToSourceProvider;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class GoToSource {
    private static final RequestProcessor srcOpenerRP = new RequestProcessor("Profiler Source Opener");

    public static boolean isAvailable() {
        return Lookup.getDefault().lookup(GoToSourceProvider.class) != null;
    }

    public static void openFile(final FileObject fileObject, final int n) {
        srcOpenerRP.post(new Runnable(){

            @Override
            public void run() {
                GoToSource.openFileImpl(fileObject, n);
            }
        });
    }

    public static void openSource(Lookup.Provider provider, String string, String string2, String string3) {
        GoToSource.openSource(provider, string, string2, string3, -1);
    }

    public static void openSource(Lookup.Provider provider, String string, String string2, int n) {
        GoToSource.openSource(provider, string, string2, null, n);
    }

    private static void openSource(final Lookup.Provider provider, final String string, final String string2, final String string3, final int n) {
        srcOpenerRP.post(new Runnable(){

            @Override
            public void run() {
                GoToSource.openSourceImpl(provider, string, string2, string3, n);
            }
        });
    }

    private static void openSourceImpl(Lookup.Provider provider, String string, String string2, String string3, int n) {
        int n2;
        int n3 = n2 = string2 == null ? -1 : string2.indexOf("[native]");
        if (n2 > -1) {
            string2 = string2.substring(0, n2);
        }
        ProfilerLogger.debug((String)("Open Source: Project: " + provider));
        ProfilerLogger.debug((String)("Open Source: Class name: " + string));
        ProfilerLogger.debug((String)("Open Source: Method name: " + string2));
        ProfilerLogger.debug((String)("Open Source: Method sig: " + string3));
        Collection collection = Lookup.getDefault().lookupAll(GoToSourceProvider.class);
        String string4 = Bundle.OpeningSourceMsg(string);
        String string5 = string4 + " ...";
        StatusDisplayer.getDefault().setStatusText(string5);
        for (GoToSourceProvider goToSourceProvider : collection) {
            try {
                if (!goToSourceProvider.openSource(provider, string, string2, string3, n)) continue;
                return;
            }
            catch (Exception exception) {
                ProfilerLogger.log((Exception)exception);
            }
        }
        ProfilerDialogs.displayError(Bundle.NoSourceFoundMessage(string));
    }

    private static void openFileImpl(FileObject fileObject, int n) {
        ProfilerLogger.debug((String)("Open Source: FileObject: " + fileObject));
        ProfilerLogger.debug((String)("Open Source: Offset: " + n));
        Collection collection = Lookup.getDefault().lookupAll(GoToSourceProvider.class);
        String string = Bundle.OpeningFileMsg(fileObject.getName());
        String string2 = string + " ...";
        StatusDisplayer.getDefault().setStatusText(string2);
        for (GoToSourceProvider goToSourceProvider : collection) {
            try {
                if (!goToSourceProvider.openFile(fileObject, n)) continue;
                return;
            }
            catch (Exception exception) {
                ProfilerLogger.log((Exception)exception);
            }
        }
        ProfilerDialogs.displayError(Bundle.OpenFileFailsMessage(fileObject.getName(), n));
    }
}

