/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.lib.profiler.results.jdbc.JdbcGraphBuilder;

class SQLStatement {
    static final Object NEW_STATEMENT = new Object();
    static final Object NEW_PREPARED_STATEMENT = new Object();
    static final Object NEW_CALLABLE_STATEMENT = new Object();
    private List batch = new ArrayList();
    private ArrayList parameters = new ArrayList();
    private String sqlTemplate;
    private final int type;

    SQLStatement(int n) {
        this.type = n;
    }

    SQLStatement(int n, String string) {
        this.sqlTemplate = string;
        this.type = n;
    }

    String invoke(String string, String string2, List list) {
        String string3 = null;
        switch (string) {
            case "executeQuery": {
                if (list.size() == 1) {
                    string3 = this.executeQuery();
                    break;
                }
                string3 = this.executeQuery((String)list.get(1));
                break;
            }
            case "executeUpdate": {
                if (list.size() == 1) {
                    string3 = this.executeUpdate();
                    break;
                }
                string3 = this.executeUpdate((String)list.get(1));
                break;
            }
            case "execute": {
                if (list.size() == 1) {
                    string3 = this.execute();
                    break;
                }
                string3 = this.execute((String)list.get(1));
                break;
            }
            case "addBatch": {
                if (list.size() == 1) {
                    this.addBatch();
                    break;
                }
                this.addBatch((String)list.get(1));
                break;
            }
            case "clearBatch": {
                this.clearBatch();
                break;
            }
            case "executeBatch": {
                string3 = this.executeBatch();
                break;
            }
            case "setDate": {
                this.setDate((Integer)list.get(1), (String)list.get(2));
                break;
            }
            case "setTimestamp": {
                this.setTimestamp((Integer)list.get(1), (String)list.get(2));
                break;
            }
            case "setNull": {
                this.setNull((Integer)list.get(1), (Integer)list.get(2));
                break;
            }
            default: {
                if (!string.startsWith("set") || list.size() < 3 || !(list.get(1) instanceof Integer)) break;
                this.setParameter(string, (Integer)list.get(1), list.get(2));
            }
        }
        return string3;
    }

    String executeQuery(String string) {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINE)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINE, "executeQuery {0}", new Object[]{string});
        }
        return string;
    }

    String executeUpdate(String string) {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINE)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINE, "executeUpdate {0}", new Object[]{string});
        }
        return string;
    }

    String execute(String string) {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINE)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINE, "execute {0}", new Object[]{string});
        }
        return string;
    }

    void addBatch() {
        this.batch.add(this.getFullSql());
    }

    void addBatch(String string) {
        this.batch.add(string);
    }

    void clearBatch() {
        this.batch.clear();
    }

    String executeBatch() {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINE)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINE, "executeBatch {0}", new Object[]{Arrays.toString(this.batch.toArray())});
        }
        return Arrays.toString(this.batch.toArray());
    }

    void setNull(int n, int n2) {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINER)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINER, "setNull index:{0} type:{1}", new Object[]{n, n2});
        }
        this.ensureCapacity(n);
        this.parameters.set(n, "NULL");
    }

    void setBoolean(int n, Boolean bl) {
        this.parameters.ensureCapacity(n + 1);
        this.parameters.add(bl);
    }

    void setByte(int n, byte by) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setShort(int n, short s) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setInt(int n, int n2) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setLong(int n, long l) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setFloat(int n, float f) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setDouble(int n, double d) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setBigDecimal(int n, BigDecimal bigDecimal) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setString(int n, String string) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setBytes(int n, byte[] byArray) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setDate(int n, String string) {
        this.ensureCapacity(n);
        long l = Long.valueOf(string);
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINER)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINER, "setDate index:{0} value:{1}", new Object[]{n, new Date(l)});
        }
        this.parameters.set(n, new Date(l));
    }

    void setTime(int n, Time time) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setTimestamp(int n, String string) {
        this.ensureCapacity(n);
        long l = Long.valueOf(string);
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINER)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINER, "setTime index:{0} value:{1}", new Object[]{n, new Timestamp(l)});
        }
        this.parameters.set(n, new Timestamp(l));
    }

    void setAsciiStream(int n, InputStream inputStream, int n2) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setUnicodeStream(int n, InputStream inputStream, int n2) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setBinaryStream(int n, InputStream inputStream, int n2) {
        this.parameters.ensureCapacity(n + 1);
    }

    void clearParameters() throws SQLException {
        this.parameters.clear();
    }

    void setObject(int n, Object object, int n2) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setObject(int n, Object object) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setCharacterStream(int n, Reader reader, int n2) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setRef(int n, Ref ref) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setBlob(int n, Blob blob) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setClob(int n, Clob clob) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setArray(int n, Array array) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setDate(int n, Date date, Calendar calendar) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setTime(int n, Time time, Calendar calendar) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setTimestamp(int n, Timestamp timestamp, Calendar calendar) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setNull(int n, int n2, String string) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setURL(int n, URL uRL) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setRowId(int n, RowId rowId) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setNString(int n, String string) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setNCharacterStream(int n, Reader reader, long l) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setNClob(int n, NClob nClob) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setClob(int n, Reader reader, long l) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setBlob(int n, InputStream inputStream, long l) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setNClob(int n, Reader reader, long l) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setSQLXML(int n, SQLXML sQLXML) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setObject(int n, Object object, int n2, int n3) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setAsciiStream(int n, InputStream inputStream, long l) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setBinaryStream(int n, InputStream inputStream, long l) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setCharacterStream(int n, Reader reader, long l) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setAsciiStream(int n, InputStream inputStream) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setBinaryStream(int n, InputStream inputStream) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setCharacterStream(int n, Reader reader) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setNCharacterStream(int n, Reader reader) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setClob(int n, Reader reader) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setBlob(int n, InputStream inputStream) {
        this.parameters.ensureCapacity(n + 1);
    }

    void setNClob(int n, Reader reader) {
        this.parameters.ensureCapacity(n + 1);
    }

    private void setParameter(String string, Integer n, Object object) {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINER)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINER, "{0} index:{1} value:{2}", new Object[]{string, n, object});
        }
        this.ensureCapacity(n);
        this.parameters.set(n, object);
    }

    String executeQuery() {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINE)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINE, "executeQuery {0}", new Object[]{this.getFullSql()});
        }
        return this.getFullSql();
    }

    String executeUpdate() {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINE)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINE, "executeUpdate {0}", new Object[]{this.getFullSql()});
        }
        return this.getFullSql();
    }

    String execute() {
        if (JdbcGraphBuilder.JDBC_LOGGER.isLoggable(Level.FINE)) {
            JdbcGraphBuilder.JDBC_LOGGER.log(Level.FINE, "execute {0}", new Object[]{this.getFullSql()});
        }
        return this.getFullSql();
    }

    private void ensureCapacity(Integer n) {
        while (this.parameters.size() <= n) {
            this.parameters.add(null);
        }
    }

    private String getFullSql() {
        if (this.sqlTemplate == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this.sqlTemplate.length());
        int n = 0;
        int n2 = 1;
        do {
            String string;
            int n3 = n;
            if ((n = this.sqlTemplate.indexOf(63, n)) == -1) {
                n = this.sqlTemplate.length();
                string = "";
            } else {
                string = n2 >= this.parameters.size() ? "!!!!!UNSET" : this.formatParamter(this.parameters.get(n2++));
            }
            stringBuilder.append(this.sqlTemplate.substring(n3, n));
            stringBuilder.append(string);
        } while (++n < this.sqlTemplate.length());
        return stringBuilder.toString();
    }

    private String formatParamter(Object object) {
        if (object instanceof String) {
            return "'" + object + "'";
        }
        if (object == null) {
            return "*NULL*";
        }
        return object.toString();
    }

    public String toString() {
        return super.toString() + ":" + this.sqlTemplate;
    }

    int getType() {
        return this.type;
    }
}

