/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.api;

import java.util.List;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.JavaClass;

public final class StringDecoder {
    private final byte coder;
    private final List<String> values;
    private int HI_BYTE_SHIFT;
    private int LO_BYTE_SHIFT;

    public StringDecoder(Heap heap, byte by, List<String> list) {
        this.coder = by;
        this.values = list;
        if (this.coder == 1) {
            JavaClass javaClass = heap.getJavaClassByName("java.lang.StringUTF16");
            this.HI_BYTE_SHIFT = (Integer)javaClass.getValueOfStaticField("HI_BYTE_SHIFT");
            this.LO_BYTE_SHIFT = (Integer)javaClass.getValueOfStaticField("LO_BYTE_SHIFT");
        }
    }

    public int getStringLength() {
        int n = this.values.size();
        switch (this.coder) {
            case -1: {
                return n;
            }
            case 0: {
                return n;
            }
            case 1: {
                return n / 2;
            }
        }
        return n;
    }

    public String getValueAt(int n) {
        switch (this.coder) {
            case -1: {
                return this.values.get(n);
            }
            case 0: {
                char c = (char)(Byte.valueOf(this.values.get(n)) & 0xFF);
                return String.valueOf(c);
            }
            case 1: {
                byte by = Byte.valueOf(this.values.get(n *= 2));
                byte by2 = Byte.valueOf(this.values.get(n + 1));
                char c = (char)((by & 0xFF) << this.HI_BYTE_SHIFT | (by2 & 0xFF) << this.LO_BYTE_SHIFT);
                return String.valueOf(c);
            }
        }
        return "?";
    }
}

