/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.mapviewer.DefaultTileFactory;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.Tile;
import org.jdesktop.swingx.mapviewer.TileCache;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.jdesktop.swingx.mapviewer.util.GeoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTileFactory
extends TileFactory {
    private static final Logger LOG = Logger.getLogger(DefaultTileFactory.class.getName());
    private BufferedImage tileLoadingImage;
    private static final int SOCKET_TIMEOUT_MS = 30000;
    private HashSet<String> maps = new HashSet();
    private static final ImageObserver dummyObserver = new ImageObserver(){

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            return false;
        }
    };
    private TileFactoryInfo info;
    private static TileCache cache = new TileCache();
    private static final String PROP_USER_AGENT_IDEN = "User-Agent";
    private static final String PROP_USER_AGENT_DEFAULT_VALUE = "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)";
    private static String userAgent = "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)";
    private static final TilesHandler tileHandler = new TilesHandler();
    private static final int THREAD_TIMEOUT = 500;

    public AbstractTileFactory(TileFactoryInfo info) {
        super(info);
        Deamons.addDeamonUser();
        this.setupFactory(info);
    }

    private void setupFactory(TileFactoryInfo info) {
        BufferedImage loadingImage;
        this.info = info;
        try {
            URL url = this.getClass().getResource("resources/loading.png");
            if (url == null) {
                url = AbstractTileFactory.class.getResource("resources/loading.png");
            }
            loadingImage = ImageIO.read(url);
        }
        catch (Throwable ex) {
            LOG.severe("could not load 'loading.png'");
            loadingImage = null;
        }
        if (loadingImage == null) {
            loadingImage = new BufferedImage(16, 16, 2);
            Graphics2D g2 = loadingImage.createGraphics();
            g2.setColor(Color.black);
            g2.fillRect(0, 0, 16, 16);
            g2.dispose();
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        int tileSize = info.getTileSize(0);
        this.tileLoadingImage = gc.createCompatibleImage(tileSize, tileSize, 1);
        Graphics2D g = this.tileLoadingImage.createGraphics();
        g.setColor(Color.GRAY);
        g.fillRect(0, 0, tileSize, tileSize);
        int imageX = (tileSize - loadingImage.getWidth(null)) / 2;
        int imageY = (tileSize - loadingImage.getHeight(null)) / 2;
        g.drawImage((Image)loadingImage, imageX, imageY, dummyObserver);
    }

    @Override
    public int getTileSize(int zoom) {
        int tilezoom = this.getTileZoom(zoom);
        return this.getInfo().getTileSize(tilezoom) << tilezoom - zoom;
    }

    @Override
    public Dimension getMapSize(int zoom) {
        int tilezoom = this.getTileZoom(zoom);
        int scale = 1 << tilezoom - zoom;
        Dimension s = GeoUtil.getMapSize(tilezoom, this.getInfo());
        if (scale != 1) {
            s.setSize(s.getWidth() * (double)scale, s.getHeight() * (double)scale);
        }
        return s;
    }

    @Override
    public Point2D geoToPixel(GeoPosition c, int zoom) {
        int tilezoom = this.getTileZoom(zoom);
        int scale = 1 << tilezoom - zoom;
        Point2D p = GeoUtil.getBitmapCoordinate(c, tilezoom, this.getInfo());
        if (scale != 1) {
            p.setLocation(p.getX() * (double)scale, p.getY() * (double)scale);
        }
        return p;
    }

    @Override
    public GeoPosition pixelToGeo(Point2D pixelCoordinate, int zoom) {
        int tilezoom = this.getTileZoom(zoom);
        int scale = 1 << tilezoom - zoom;
        Point2D p = (Point2D)pixelCoordinate.clone();
        if (scale != 1) {
            p.setLocation(p.getX() / (double)scale, p.getY() / (double)scale);
        }
        return this.getInfo().getPosition(p, tilezoom);
    }

    @Override
    public TileFactoryInfo getInfo() {
        return this.info;
    }

    public TileCache getTileCache() {
        return cache;
    }

    public static void setTileCache(TileCache cache) {
        AbstractTileFactory.cache = cache;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Deamons.removeDeamonUser();
        for (String mapName : this.maps) {
            this.removeRequiredTiles(mapName);
        }
        this.maps.clear();
    }

    private static final String getCacheTileKey(Tile tile) {
        return tile.getKey();
    }

    public static void setUserAgent(String userAgent) {
        AbstractTileFactory.userAgent = userAgent;
    }

    private static BufferedImage tryTileInCache(Tile tile) {
        BufferedImage image = cache.get(AbstractTileFactory.getCacheTileKey(tile));
        Long imageDate = cache.getImageDate(AbstractTileFactory.getCacheTileKey(tile));
        if (image != null) {
            tile.setImage(image);
        }
        if (image == null || imageDate == null || System.currentTimeMillis() - imageDate > 604800000L) {
            tile.setNeedsToBeDownLoaded(true);
            tileHandler.tileStatusChanged();
        }
        return image;
    }

    @Override
    public void setRequiredTiles(Collection<Tile> tiles, String mapName) {
        this.maps.add(mapName);
        tileHandler.setRequiredTiles(tiles, mapName, this.info);
    }

    @Override
    public Tile getTile(String key, String mapName) {
        return tileHandler.getTile(key, mapName);
    }

    @Override
    public Tile getTileInstance(int x, int y, int zoom) {
        String key = this.getTileKey(x, y, zoom = this.getTileZoom(zoom));
        Tile t = tileHandler.getTile(key);
        if (t != null) {
            return t;
        }
        t = super.getTileInstance(x, y, zoom);
        tileHandler.addTile(key, t);
        return t;
    }

    @Override
    public void removeRequiredTiles(String mapName) {
        if (tileHandler.removeRequiredTiles(mapName)) {
            this.maps.remove(mapName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TilesHandler {
        final Hashtable<String, Hashtable<String, Tile>> requiredTiles = new Hashtable();
        final Hashtable<String, SoftReference<Tile>> tileReferenceCache = new Hashtable(32);
        private Iterator<Hashtable<String, Tile>> loadMapIterator = null;
        private Iterator<Tile> loadTileIterator = null;
        private Iterator<Hashtable<String, Tile>> downloadMapIterator = null;
        private Iterator<Tile> downloadTileIterator = null;

        private TilesHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Tile getTile(String key) {
            Tile t;
            Hashtable<String, SoftReference<Tile>> hashtable = this.tileReferenceCache;
            synchronized (hashtable) {
                SoftReference<Tile> tr = this.tileReferenceCache.get(key);
                t = tr != null ? tr.get() : null;
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTile(String key, Tile t) {
            Hashtable<String, SoftReference<Tile>> hashtable = this.tileReferenceCache;
            synchronized (hashtable) {
                this.tileReferenceCache.put(key, new SoftReference<Tile>(t));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Tile getTile(String key, String mapName) {
            Hashtable<String, Hashtable<String, Tile>> hashtable = this.requiredTiles;
            synchronized (hashtable) {
                Hashtable<String, Tile> requiredTilesForMap = this.requiredTiles.get(mapName);
                if (requiredTilesForMap == null) {
                    return null;
                }
                return requiredTilesForMap.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tileStatusChanged() {
            Hashtable<String, Hashtable<String, Tile>> hashtable = this.requiredTiles;
            synchronized (hashtable) {
                this.requiredTiles.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initLoadMapIterator() {
            Hashtable<String, Hashtable<String, Tile>> hashtable = this.requiredTiles;
            synchronized (hashtable) {
                this.loadMapIterator = this.requiredTiles.values().iterator();
                this.loadTileIterator = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Tile getTileToLoad() {
            try {
                while (true) {
                    Hashtable<String, Hashtable<String, Tile>> hashtable = this.requiredTiles;
                    synchronized (hashtable) {
                        if (this.loadMapIterator == null || !this.loadMapIterator.hasNext()) {
                            this.initLoadMapIterator();
                        }
                        Tile tile = null;
                        if (this.loadMapIterator != null) {
                            while (true) {
                                if (this.loadTileIterator != null && this.loadTileIterator.hasNext()) {
                                    tile = this.loadTileIterator.next();
                                    if (!tile.setNeedsToBeLoaded(false)) continue;
                                    return tile;
                                }
                                if (!this.loadMapIterator.hasNext() || (this.loadTileIterator = this.loadMapIterator.next().values().iterator()) == null) break;
                            }
                        }
                        this.requiredTiles.wait(500L);
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, " caught exception while polling requiredTiles", e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initDownloadMapIterator() {
            Hashtable<String, Hashtable<String, Tile>> hashtable = this.requiredTiles;
            synchronized (hashtable) {
                this.downloadMapIterator = this.requiredTiles.values().iterator();
                this.downloadTileIterator = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Tile getTileToDownload() {
            try {
                while (true) {
                    Hashtable<String, Hashtable<String, Tile>> hashtable = this.requiredTiles;
                    synchronized (hashtable) {
                        if (this.downloadMapIterator == null || !this.downloadMapIterator.hasNext()) {
                            this.initDownloadMapIterator();
                        }
                        Tile tile = null;
                        if (this.downloadMapIterator != null) {
                            while (true) {
                                if (this.downloadTileIterator != null && this.downloadTileIterator.hasNext()) {
                                    tile = this.downloadTileIterator.next();
                                    if (!tile.setNeedsToBeDownLoaded(false)) continue;
                                    return tile;
                                }
                                if (!this.downloadMapIterator.hasNext() || (this.downloadTileIterator = this.downloadMapIterator.next().values().iterator()) == null) break;
                            }
                        }
                        this.requiredTiles.wait(500L);
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, " caught exception while polling requiredTiles", e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRequiredTiles(Collection<Tile> tiles, String mapName, TileFactoryInfo info) {
            Deamons.startTileLoaders();
            Hashtable<String, Hashtable<String, Tile>> hashtable = this.requiredTiles;
            synchronized (hashtable) {
                Hashtable<String, Tile> requiredTilesForMap = this.requiredTiles.get(mapName);
                if (requiredTilesForMap == null) {
                    requiredTilesForMap = new Hashtable();
                    this.requiredTiles.put(mapName, requiredTilesForMap);
                }
                Iterator<Map.Entry<String, Tile>> entryIt = requiredTilesForMap.entrySet().iterator();
                while (entryIt.hasNext()) {
                    Map.Entry<String, Tile> entry = entryIt.next();
                    if (tiles.contains((Object)entry.getValue())) continue;
                    entryIt.remove();
                }
                for (Tile tile : tiles) {
                    if (requiredTilesForMap.containsKey(tile.getKey()) || tile.getImage() != null || !GeoUtil.isValidTile(tile.getX(), tile.getY(), tile.getZoom(), info)) continue;
                    requiredTilesForMap.put(tile.getKey(), tile);
                    tile.setNeedsToBeLoaded(true);
                    if (requiredTilesForMap.get(tile.getKey()) != null) continue;
                    LOG.log(Level.SEVERE, "Problem adding tile " + tile.getKey());
                }
                this.requiredTilesUpdated();
                this.requiredTiles.notifyAll();
            }
        }

        private void requiredTilesUpdated() {
            this.initLoadMapIterator();
            this.initDownloadMapIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeRequiredTiles(String mapName) {
            Hashtable<String, Hashtable<String, Tile>> hashtable = this.requiredTiles;
            synchronized (hashtable) {
                if (this.requiredTiles.containsKey(mapName)) {
                    this.requiredTiles.get(mapName).clear();
                    this.requiredTiles.remove(mapName);
                    this.requiredTilesUpdated();
                }
                return this.requiredTiles.isEmpty();
            }
        }
    }

    private static class TileDownloader
    implements Runnable {
        private String name;
        private volatile boolean running;

        TileDownloader(String name) {
            this.name = name;
        }

        public void stop() {
            this.running = false;
        }

        public void run() {
            this.running = true;
            while (this.running) {
                Tile tile = tileHandler.getTileToDownload();
                if (tile == null) continue;
                ByteArrayOutputStream bout = new ByteArrayOutputStream(40960);
                byte[] buf = new byte[256];
                String urlString = tile.getURL();
                try {
                    int n;
                    URL url = new URL(urlString);
                    URLConnection conn = url.openConnection();
                    conn.setRequestProperty(AbstractTileFactory.PROP_USER_AGENT_IDEN, userAgent);
                    conn.setConnectTimeout(30000);
                    conn.setReadTimeout(30000);
                    InputStream ins = conn.getInputStream();
                    bout.reset();
                    while ((n = ins.read(buf)) != -1) {
                        bout.write(buf, 0, n);
                    }
                    byte[] bimg = bout.toByteArray();
                    BufferedImage img = GraphicsUtilities.loadCompatibleImage((InputStream)new ByteArrayInputStream(bimg));
                    cache.put(AbstractTileFactory.getCacheTileKey(tile), bimg, img);
                    tile.setImage(img);
                }
                catch (Exception e) {
                    if (e instanceof SocketTimeoutException) {
                        LOG.log(Level.INFO, this.name + " timed out downloading tile: " + tile.getKey() + " url: " + urlString);
                        tile.setNeedsToBeDownLoaded(true);
                        tileHandler.tileStatusChanged();
                        continue;
                    }
                    if (e instanceof FileNotFoundException) {
                        LOG.log(Level.INFO, this.name + " tile doesn't exist: " + tile.getKey() + " url: " + urlString);
                        continue;
                    }
                    LOG.log(Level.SEVERE, this.name + " error downloading tile: " + tile.getKey() + " url: " + urlString, e);
                }
                catch (OutOfMemoryError e) {
                    LOG.log(Level.SEVERE, this.name + " out of memory " + tile.getKey() + " url: " + urlString, e);
                }
            }
        }
    }

    private static class TileLoader
    implements Runnable {
        private String name;
        private volatile boolean running;

        private TileLoader(String name) {
            this.name = name;
        }

        public void run() {
            this.running = true;
            while (this.running) {
                try {
                    Tile tile = tileHandler.getTileToLoad();
                    if (tile == null) continue;
                    AbstractTileFactory.tryTileInCache(tile);
                    if (!tile.needsToBeDownLoaded()) continue;
                    tileHandler.tileStatusChanged();
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Problem in load loop", e);
                }
            }
        }

        public void stop() {
            this.running = false;
        }
    }

    private static final class Deamons {
        private static int numTileFactoriesUsingDeamons = 0;
        private static ThreadGroup tg;
        private static final int numTileLoaders = 10;

        private Deamons() {
        }

        private static synchronized void addDeamonUser() {
            ++numTileFactoriesUsingDeamons;
        }

        private static synchronized void removeDeamonUser() {
            if (--numTileFactoriesUsingDeamons == 0 && tg != null) {
                try {
                    tg.stop();
                    tg.interrupt();
                    tg.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                tg = null;
            }
        }

        private static synchronized void startTileLoaders() {
            if (tg == null) {
                Thread t;
                int i;
                tg = new ThreadGroup("tileloaders");
                tg.setDaemon(true);
                for (i = 1; i <= 10; ++i) {
                    t = new Thread(tg, new TileLoader("loader-" + i), "tile-loader-" + i);
                    t.setPriority(1);
                    t.setDaemon(true);
                    t.start();
                }
                for (i = 1; i <= 10; ++i) {
                    t = new Thread(tg, new TileDownloader("tile-downloader-" + i), "tile-downloader-" + i);
                    t.setPriority(1);
                    t.setDaemon(true);
                    t.start();
                }
            }
        }
    }
}

