/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.buildinit.plugins.internal.CrossConfigurationScriptBlockBuilder;
import org.gradle.buildinit.plugins.internal.DependenciesBuilder;
import org.gradle.buildinit.plugins.internal.RepositoriesBuilder;
import org.gradle.buildinit.plugins.internal.ScriptBlockBuilder;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.internal.file.PathToFileResolver;

public class BuildScriptBuilder {
    private final BuildInitDsl dsl;
    private final PathToFileResolver fileResolver;
    private final String fileNameWithoutExtension;
    private final List<String> headerLines = new ArrayList<String>();
    private final TopLevelBlock block = new TopLevelBlock();

    public BuildScriptBuilder(BuildInitDsl dsl, PathToFileResolver fileResolver, String fileNameWithoutExtension) {
        this.dsl = dsl;
        this.fileResolver = fileResolver;
        this.fileNameWithoutExtension = fileNameWithoutExtension;
    }

    public BuildScriptBuilder fileComment(String comment) {
        this.headerLines.addAll(BuildScriptBuilder.splitComment(comment));
        return this;
    }

    private static List<String> splitComment(String comment) {
        return Splitter.on((String)"\n").splitToList((CharSequence)comment.trim());
    }

    public BuildScriptBuilder plugin(@Nullable String comment, String pluginId) {
        this.block.plugins.add(new PluginSpec(pluginId, null, comment));
        return this;
    }

    public BuildScriptBuilder plugin(@Nullable String comment, String pluginId, String version) {
        this.block.plugins.add(new PluginSpec(pluginId, version, comment));
        return this;
    }

    public BuildScriptBuilder dependency(String configuration, @Nullable String comment, String ... dependencies) {
        this.dependencies().dependency(configuration, comment, dependencies);
        return this;
    }

    public BuildScriptBuilder implementationDependency(@Nullable String comment, String ... dependencies) {
        return this.dependency("implementation", comment, dependencies);
    }

    public BuildScriptBuilder testImplementationDependency(@Nullable String comment, String ... dependencies) {
        return this.dependency("testImplementation", comment, dependencies);
    }

    public BuildScriptBuilder testRuntimeOnlyDependency(@Nullable String comment, String ... dependencies) {
        return this.dependency("testRuntimeOnly", comment, dependencies);
    }

    public Expression methodInvocationExpression(String methodName, Object ... methodArgs) {
        return new MethodInvocationValue(methodName, BuildScriptBuilder.expressionValues(methodArgs));
    }

    public Expression propertyExpression(String value) {
        return new LiteralValue(value);
    }

    private static List<ExpressionValue> expressionValues(Object ... expressions) {
        ArrayList<ExpressionValue> result = new ArrayList<ExpressionValue>(expressions.length);
        for (Object expression : expressions) {
            result.add(BuildScriptBuilder.expressionValue(expression));
        }
        return result;
    }

    private static Map<String, ExpressionValue> expressionMap(Map<String, ?> expressions) {
        LinkedHashMap<String, ExpressionValue> result = new LinkedHashMap<String, ExpressionValue>();
        for (Map.Entry<String, ?> entry : expressions.entrySet()) {
            result.put(entry.getKey(), BuildScriptBuilder.expressionValue(entry.getValue()));
        }
        return result;
    }

    private static ExpressionValue expressionValue(Object expression) {
        if (expression instanceof CharSequence) {
            return new StringValue((CharSequence)expression);
        }
        if (expression instanceof ExpressionValue) {
            return (ExpressionValue)expression;
        }
        if (expression instanceof Number || expression instanceof Boolean) {
            return new LiteralValue(expression);
        }
        if (expression instanceof Map) {
            return new MapLiteralValue(BuildScriptBuilder.expressionMap((Map)expression));
        }
        throw new IllegalArgumentException("Don't know how to treat " + expression + " as an expression.");
    }

    public RepositoriesBuilder repositories() {
        return this.block.repositories;
    }

    DependenciesBuilder dependencies() {
        return this.block.dependencies;
    }

    public CrossConfigurationScriptBlockBuilder allprojects() {
        return this.block.allprojects;
    }

    public CrossConfigurationScriptBlockBuilder subprojects() {
        return this.block.subprojects;
    }

    public BuildScriptBuilder methodInvocation(@Nullable String comment, String methodName, Object ... methodArgs) {
        this.block.methodInvocation(comment, methodName, methodArgs);
        return this;
    }

    public BuildScriptBuilder propertyAssignment(@Nullable String comment, String propertyName, Object propertyValue) {
        this.block.propertyAssignment(comment, propertyName, propertyValue);
        return this;
    }

    public ScriptBlockBuilder block(@Nullable String comment, String methodName) {
        return this.block.block(comment, methodName);
    }

    public BuildScriptBuilder taskMethodInvocation(@Nullable String comment, String taskName, String taskType, String methodName, Object ... methodArgs) {
        this.block.tasks.add(new TaskSelector(taskName, taskType), new MethodInvocation(comment, new MethodInvocationValue(methodName, BuildScriptBuilder.expressionValues(methodArgs))));
        return this;
    }

    public BuildScriptBuilder taskPropertyAssignment(@Nullable String comment, String taskName, String taskType, String propertyName, Object propertyValue) {
        this.block.tasks.add(new TaskSelector(taskName, taskType), new PropertyAssignment(comment, propertyName, BuildScriptBuilder.expressionValue(propertyValue)));
        return this;
    }

    public BuildScriptBuilder taskPropertyAssignment(@Nullable String comment, String taskType, String propertyName, Object propertyValue) {
        this.block.taskTypes.add(new TaskTypeSelector(taskType), new PropertyAssignment(comment, propertyName, BuildScriptBuilder.expressionValue(propertyValue)));
        return this;
    }

    public ScriptBlockBuilder taskRegistration(String comment, String taskName, String taskType) {
        TaskRegistration registration = new TaskRegistration(comment, taskName, taskType);
        this.block.tasksRegistrations.add(registration);
        return registration.body;
    }

    public BuildScriptBuilder conventionPropertyAssignment(@Nullable String comment, String conventionName, String propertyName, Object propertyValue) {
        this.block.conventions.add(new ConventionSelector(conventionName), new PropertyAssignment(comment, propertyName, BuildScriptBuilder.expressionValue(propertyValue)));
        return this;
    }

    public TemplateOperation create() {
        return new TemplateOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generate() {
                File target = BuildScriptBuilder.this.getTargetFile();
                try (PrintWriter writer = new PrintWriter(new FileWriter(target));){
                    PrettyPrinter printer = BuildScriptBuilder.prettyPrinterFor(BuildScriptBuilder.this.dsl, writer);
                    printer.printFileHeader(BuildScriptBuilder.this.headerLines);
                    BuildScriptBuilder.this.block.writeBodyTo(printer);
                }
                catch (Exception e) {
                    throw new GradleException("Could not generate file " + target + ".", (Throwable)e);
                }
            }
        };
    }

    private File getTargetFile() {
        return this.fileResolver.resolve((Object)this.dsl.fileNameFor(this.fileNameWithoutExtension));
    }

    private static PrettyPrinter prettyPrinterFor(BuildInitDsl dsl, PrintWriter writer) {
        return new PrettyPrinter(BuildScriptBuilder.syntaxFor(dsl), writer);
    }

    private static Syntax syntaxFor(BuildInitDsl dsl) {
        switch (dsl) {
            case KOTLIN: {
                return new KotlinSyntax();
            }
            case GROOVY: {
                return new GroovySyntax();
            }
        }
        throw new IllegalStateException();
    }

    private static final class GroovySyntax
    implements Syntax {
        private GroovySyntax() {
        }

        @Override
        public String string(String string) {
            return "'" + string + "'";
        }

        @Override
        public String mapLiteral(Map<String, ExpressionValue> map) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            this.addEntries(map, builder);
            builder.append("]");
            return builder.toString();
        }

        private void addEntries(Map<String, ExpressionValue> map, StringBuilder builder) {
            boolean first = true;
            for (Map.Entry<String, ExpressionValue> entry : map.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(entry.getKey());
                builder.append(": ");
                builder.append(entry.getValue().with(this));
            }
        }

        @Override
        public String firstArg(ExpressionValue argument) {
            if (argument instanceof MapLiteralValue) {
                MapLiteralValue literalValue = (MapLiteralValue)argument;
                StringBuilder builder = new StringBuilder();
                this.addEntries(literalValue.literal, builder);
                return builder.toString();
            }
            return argument.with(this);
        }

        @Override
        public String pluginDependencySpec(String pluginId, @Nullable String version) {
            if (version != null) {
                return "id '" + pluginId + "' version '" + version + "'";
            }
            return "id '" + pluginId + "'";
        }

        @Override
        public String nestedPluginDependencySpec(String pluginId, @Nullable String version) {
            if (version != null) {
                throw new UnsupportedOperationException();
            }
            return "apply plugin: '" + pluginId + "'";
        }

        @Override
        public String dependencySpec(String config, String notation) {
            return config + " " + notation;
        }

        @Override
        public String propertyAssignment(PropertyAssignment expression) {
            String propertyName = expression.propertyName;
            ExpressionValue propertyValue = expression.propertyValue;
            return propertyName + " = " + propertyValue.with(this);
        }

        @Override
        public String conventionSelector(ConventionSelector selector) {
            return null;
        }

        @Override
        public String taskSelector(TaskSelector selector) {
            return selector.taskName;
        }

        @Override
        public String taskRegistration(String taskName, String taskType) {
            return "task " + taskName + "(type: " + taskType + ")";
        }
    }

    private static final class KotlinSyntax
    implements Syntax {
        private KotlinSyntax() {
        }

        @Override
        public String string(String string) {
            return '\"' + string + '\"';
        }

        @Override
        public String mapLiteral(Map<String, ExpressionValue> map) {
            StringBuilder builder = new StringBuilder();
            builder.append("mapOf(");
            boolean first = true;
            for (Map.Entry<String, ExpressionValue> entry : map.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(this.string(entry.getKey()));
                builder.append(" to ");
                builder.append(entry.getValue().with(this));
            }
            builder.append(")");
            return builder.toString();
        }

        @Override
        public String firstArg(ExpressionValue argument) {
            return argument.with(this);
        }

        @Override
        public String pluginDependencySpec(String pluginId, @Nullable String version) {
            if (version != null) {
                return "id(\"" + pluginId + "\").version(\"" + version + "\")";
            }
            return pluginId.matches("[a-z]+") ? pluginId : "`" + pluginId + "`";
        }

        @Override
        public String nestedPluginDependencySpec(String pluginId, @Nullable String version) {
            if (version != null) {
                throw new UnsupportedOperationException();
            }
            return "plugins.apply(\"" + pluginId + "\")";
        }

        @Override
        public String dependencySpec(String config, String notation) {
            return config + "(" + notation + ")";
        }

        @Override
        public String propertyAssignment(PropertyAssignment expression) {
            String propertyName = expression.propertyName;
            ExpressionValue propertyValue = expression.propertyValue;
            if (propertyValue.isBooleanType()) {
                return this.booleanPropertyNameFor(propertyName) + " = " + propertyValue.with(this);
            }
            return propertyName + " = " + propertyValue.with(this);
        }

        private String booleanPropertyNameFor(String propertyName) {
            return "is" + StringUtils.capitalize((String)propertyName);
        }

        @Override
        public String conventionSelector(ConventionSelector selector) {
            return selector.conventionName;
        }

        @Override
        public String taskSelector(TaskSelector selector) {
            return "val " + selector.taskName + " by tasks.getting(" + selector.taskType + "::class)";
        }

        @Override
        public String taskRegistration(String taskName, String taskType) {
            return "val " + taskName + " by tasks.creating(" + taskType + "::class)";
        }
    }

    private static interface Syntax {
        public String pluginDependencySpec(String var1, @Nullable String var2);

        public String nestedPluginDependencySpec(String var1, @Nullable String var2);

        public String dependencySpec(String var1, String var2);

        public String propertyAssignment(PropertyAssignment var1);

        @Nullable
        public String conventionSelector(ConventionSelector var1);

        public String taskSelector(TaskSelector var1);

        public String string(String var1);

        public String taskRegistration(String var1, String var2);

        public String mapLiteral(Map<String, ExpressionValue> var1);

        public String firstArg(ExpressionValue var1);
    }

    private static final class PrettyPrinter {
        private final Syntax syntax;
        private final PrintWriter writer;
        private String indent = "";
        private boolean needSeparatorLine = true;
        private boolean firstStatementOfBlock = false;
        private boolean hasSeparatorLine = false;

        PrettyPrinter(Syntax syntax, PrintWriter writer) {
            this.syntax = syntax;
            this.writer = writer;
        }

        public void printFileHeader(Collection<String> lines) {
            this.println("/*");
            this.println(" * This file was generated by the Gradle 'init' task.");
            if (!lines.isEmpty()) {
                this.println(" *");
                for (String headerLine : lines) {
                    if (headerLine.isEmpty()) {
                        this.println(" *");
                        continue;
                    }
                    this.println(" * " + headerLine);
                }
            }
            this.println(" */");
        }

        public void printBlock(String blockSelector, BlockBody blockBody) {
            String indentBefore = this.indent;
            this.println(blockSelector + " {");
            this.indent = this.indent + "    ";
            this.needSeparatorLine = false;
            this.firstStatementOfBlock = true;
            blockBody.writeBodyTo(this);
            this.indent = indentBefore;
            this.println("}");
            this.needSeparatorLine = true;
        }

        public void printStatements(List<? extends Statement> statements) {
            for (Statement statement : statements) {
                this.printStatement(statement);
            }
        }

        private void printStatementSeparator() {
            if (this.needSeparatorLine && !this.hasSeparatorLine) {
                this.println();
                this.needSeparatorLine = false;
            }
        }

        private void printStatement(Statement statement) {
            boolean needsSeparator;
            Statement.Type type = statement.type();
            if (type == Statement.Type.Empty) {
                return;
            }
            boolean hasComment = statement.getComment() != null;
            boolean bl = needsSeparator = hasComment || type == Statement.Type.Group;
            if (needsSeparator && !this.firstStatementOfBlock) {
                this.needSeparatorLine = true;
            }
            this.printStatementSeparator();
            if (hasComment) {
                for (String line : BuildScriptBuilder.splitComment(statement.getComment())) {
                    this.println("// " + line);
                }
            }
            statement.writeCodeTo(this);
            this.firstStatementOfBlock = false;
            if (needsSeparator) {
                this.needSeparatorLine = true;
            }
        }

        private void println(String s) {
            if (!this.indent.isEmpty()) {
                this.writer.print(this.indent);
            }
            this.writer.println(s);
            this.hasSeparatorLine = false;
        }

        private void println() {
            this.writer.println();
            this.hasSeparatorLine = true;
        }
    }

    private static class ConfigurationStatements<T extends ConfigSelector>
    implements Statement {
        final ListMultimap<T, Statement> blocks = MultimapBuilder.linkedHashKeys().arrayListValues().build();

        private ConfigurationStatements() {
        }

        void add(T selector, Statement statement) {
            this.blocks.put(selector, (Object)statement);
        }

        @Override
        @Nullable
        public String getComment() {
            return null;
        }

        @Override
        public Statement.Type type() {
            return this.blocks.isEmpty() ? Statement.Type.Empty : Statement.Type.Single;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            for (ConfigSelector configSelector : this.blocks.keySet()) {
                String selector = configSelector.codeBlockSelectorFor(printer.syntax);
                if (selector != null) {
                    BlockStatement statement = new BlockStatement(selector);
                    statement.body.statements.addAll(this.blocks.get((Object)configSelector));
                    printer.printStatement(statement);
                    continue;
                }
                printer.printStatements(this.blocks.get((Object)configSelector));
            }
        }
    }

    private static class TaskRegistration
    implements Statement {
        final String taskName;
        final String taskType;
        final String comment;
        final ScriptBlockImpl body = new ScriptBlockImpl();

        TaskRegistration(String comment, String taskName, String taskType) {
            this.comment = comment;
            this.taskName = taskName;
            this.taskType = taskType;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.comment;
        }

        @Override
        public Statement.Type type() {
            return Statement.Type.Group;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.printBlock(printer.syntax.taskRegistration(this.taskName, this.taskType), this.body);
        }
    }

    private static class TopLevelBlock
    extends ScriptBlockImpl {
        final BlockStatement plugins = new BlockStatement("plugins");
        final StatementSequence tasksRegistrations = new StatementSequence();
        final RepositoriesBlock repositories = new RepositoriesBlock();
        final DependenciesBlock dependencies = new DependenciesBlock();
        final CrossConfigBlock allprojects = new CrossConfigBlock("allprojects");
        final CrossConfigBlock subprojects = new CrossConfigBlock("subprojects");
        final ConfigurationStatements<TaskTypeSelector> taskTypes = new ConfigurationStatements();
        final ConfigurationStatements<TaskSelector> tasks = new ConfigurationStatements();
        final ConfigurationStatements<ConventionSelector> conventions = new ConfigurationStatements();

        private TopLevelBlock() {
        }

        @Override
        public void writeBodyTo(PrettyPrinter printer) {
            printer.printStatement(this.plugins);
            printer.printStatement(this.allprojects);
            printer.printStatement(this.subprojects);
            printer.printStatement(this.repositories);
            printer.printStatement(this.dependencies);
            printer.printStatement(this.tasksRegistrations);
            super.writeBodyTo(printer);
            printer.printStatement(this.conventions);
            printer.printStatement(this.taskTypes);
            printer.printStatement(this.tasks);
        }
    }

    private static class CrossConfigBlock
    extends ScriptBlockImpl
    implements CrossConfigurationScriptBlockBuilder,
    Statement {
        final String blockName;
        final RepositoriesBlock repositories = new RepositoriesBlock();
        final DependenciesBlock dependencies = new DependenciesBlock();
        final StatementSequence plugins = new StatementSequence();
        final StatementSequence taskRegistrations = new StatementSequence();
        final ConfigurationStatements<TaskTypeSelector> taskTypes = new ConfigurationStatements();
        final ConfigurationStatements<TaskSelector> tasks = new ConfigurationStatements();
        final ConfigurationStatements<ConventionSelector> conventions = new ConfigurationStatements();

        CrossConfigBlock(String blockName) {
            this.blockName = blockName;
        }

        @Override
        public RepositoriesBuilder repositories() {
            return this.repositories;
        }

        @Override
        public DependenciesBuilder dependencies() {
            return this.dependencies;
        }

        @Override
        public void plugin(String comment, String pluginId) {
            this.plugins.add(new NestedPluginSpec(pluginId, null, comment));
        }

        @Override
        public void taskPropertyAssignment(String comment, String taskType, String propertyName, Object propertyValue) {
            this.taskTypes.add(new TaskTypeSelector(taskType), new PropertyAssignment(comment, propertyName, BuildScriptBuilder.expressionValue(propertyValue)));
        }

        @Override
        public void taskMethodInvocation(@Nullable String comment, String taskName, String taskType, String methodName, Object ... methodArgs) {
            this.tasks.add(new TaskSelector(taskName, taskType), new MethodInvocation(comment, new MethodInvocationValue(methodName, BuildScriptBuilder.expressionValues(methodArgs))));
        }

        @Override
        public ScriptBlockBuilder taskRegistration(String comment, String taskName, String taskType) {
            TaskRegistration registration = new TaskRegistration(comment, taskName, taskType);
            this.taskRegistrations.add(registration);
            return registration.body;
        }

        @Override
        public Statement.Type type() {
            if (super.type() == Statement.Type.Empty && this.repositories.type() == Statement.Type.Empty && this.plugins.type() == Statement.Type.Empty && this.taskRegistrations.type() == Statement.Type.Empty && this.conventions.type() == Statement.Type.Empty && this.tasks.type() == Statement.Type.Empty && this.taskTypes.type() == Statement.Type.Empty && this.dependencies.type() == Statement.Type.Empty) {
                return Statement.Type.Empty;
            }
            return Statement.Type.Group;
        }

        @Override
        @Nullable
        public String getComment() {
            return null;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.printBlock(this.blockName, this);
        }

        @Override
        public void writeBodyTo(PrettyPrinter printer) {
            printer.printStatement(this.plugins);
            printer.printStatement(this.repositories);
            printer.printStatement(this.dependencies);
            printer.printStatement(this.taskRegistrations);
            super.writeBodyTo(printer);
            printer.printStatement(this.conventions);
            printer.printStatement(this.taskTypes);
            printer.printStatement(this.tasks);
        }
    }

    private static class ScriptBlockImpl
    implements ScriptBlockBuilder,
    BlockBody {
        final List<Statement> statements = new ArrayList<Statement>();

        private ScriptBlockImpl() {
        }

        public void add(Statement statement) {
            this.statements.add(statement);
        }

        public Statement.Type type() {
            for (Statement statement : this.statements) {
                if (statement.type() == Statement.Type.Empty) continue;
                return Statement.Type.Group;
            }
            return Statement.Type.Empty;
        }

        @Override
        public void writeBodyTo(PrettyPrinter printer) {
            printer.printStatements(this.statements);
        }

        @Override
        public void propertyAssignment(String comment, String propertyName, Object propertyValue) {
            this.statements.add(new PropertyAssignment(comment, propertyName, BuildScriptBuilder.expressionValue(propertyValue)));
        }

        @Override
        public void methodInvocation(String comment, String methodName, Object ... methodArgs) {
            this.statements.add(new MethodInvocation(comment, new MethodInvocationValue(methodName, BuildScriptBuilder.expressionValues(methodArgs))));
        }

        @Override
        public ScriptBlockBuilder block(String comment, String methodName) {
            ScriptBlock scriptBlock = new ScriptBlock(comment, methodName);
            this.statements.add(scriptBlock);
            return scriptBlock.body;
        }

        @Override
        public Expression propertyExpression(String value) {
            return new LiteralValue(value);
        }
    }

    private static class MavenRepoExpression
    extends AbstractStatement {
        private final String url;

        MavenRepoExpression(@Nullable String comment, String url) {
            super(comment);
            this.url = url;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            ScriptBlockImpl statements = new ScriptBlockImpl();
            statements.propertyAssignment(null, "url", this.url);
            printer.printBlock("maven", statements);
        }
    }

    private static class DependenciesBlock
    implements DependenciesBuilder,
    Statement,
    BlockBody {
        final ListMultimap<String, Statement> dependencies = MultimapBuilder.linkedHashKeys().arrayListValues().build();

        private DependenciesBlock() {
        }

        @Override
        public void dependency(String configuration, @Nullable String comment, String ... dependencies) {
            this.dependencies.put((Object)configuration, (Object)new DepSpec(configuration, comment, Arrays.asList(dependencies)));
        }

        @Override
        public void projectDependency(String configuration, @Nullable String comment, String projectPath) {
            this.dependencies.put((Object)configuration, (Object)new ProjectDepSpec(configuration, comment, projectPath));
        }

        @Override
        @Nullable
        public String getComment() {
            return null;
        }

        @Override
        public Statement.Type type() {
            return this.dependencies.isEmpty() ? Statement.Type.Empty : Statement.Type.Group;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.printBlock("dependencies", this);
        }

        @Override
        public void writeBodyTo(PrettyPrinter printer) {
            for (String config : this.dependencies.keySet()) {
                for (Statement depSpec : this.dependencies.get((Object)config)) {
                    printer.printStatement(depSpec);
                }
            }
        }
    }

    private static class RepositoriesBlock
    extends BlockStatement
    implements RepositoriesBuilder {
        RepositoriesBlock() {
            super("repositories");
        }

        @Override
        public void mavenLocal(String comment) {
            this.add(new MethodInvocation(comment, new MethodInvocationValue("mavenLocal")));
        }

        @Override
        public void jcenter(@Nullable String comment) {
            this.add(new MethodInvocation(comment, new MethodInvocationValue("jcenter")));
        }

        @Override
        public void maven(String comment, String url) {
            this.add(new MavenRepoExpression(comment, url));
        }
    }

    private static class ScriptBlock
    extends BlockStatement {
        ScriptBlock(String comment, String methodName) {
            super(comment, methodName);
        }

        @Override
        public Statement.Type type() {
            return Statement.Type.Group;
        }
    }

    private static class BlockStatement
    implements Statement {
        private final String comment;
        final String blockSelector;
        final ScriptBlockImpl body = new ScriptBlockImpl();

        BlockStatement(String blockSelector) {
            this.comment = null;
            this.blockSelector = blockSelector;
        }

        BlockStatement(String comment, String blockSelector) {
            this.comment = comment;
            this.blockSelector = blockSelector;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.comment;
        }

        @Override
        public Statement.Type type() {
            return this.body.type();
        }

        void add(Statement statement) {
            this.body.add(statement);
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.printBlock(this.blockSelector, this.body);
        }
    }

    private static class StatementSequence
    implements Statement {
        final ScriptBlockImpl statements = new ScriptBlockImpl();

        private StatementSequence() {
        }

        public void add(Statement statement) {
            this.statements.add(statement);
        }

        @Override
        @Nullable
        public String getComment() {
            return null;
        }

        @Override
        public Statement.Type type() {
            return this.statements.type();
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            this.statements.writeBodyTo(printer);
        }
    }

    private static interface BlockBody {
        public void writeBodyTo(PrettyPrinter var1);
    }

    private static class PropertyAssignment
    extends AbstractStatement {
        final String propertyName;
        final ExpressionValue propertyValue;

        private PropertyAssignment(String comment, String propertyName, ExpressionValue propertyValue) {
            super(comment);
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.println(printer.syntax.propertyAssignment(this));
        }
    }

    private static class MethodInvocation
    extends AbstractStatement {
        final MethodInvocationValue invocationExpression;

        private MethodInvocation(String comment, MethodInvocationValue invocationExpression) {
            super(comment);
            this.invocationExpression = invocationExpression;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.println(this.invocationExpression.with(printer.syntax));
        }
    }

    private static abstract class AbstractStatement
    implements Statement {
        final String comment;

        AbstractStatement(@Nullable String comment) {
            this.comment = comment;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.comment;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Statement.Type type() {
            return Statement.Type.Single;
        }
    }

    private static interface Statement {
        @Nullable
        public String getComment();

        public Type type();

        public void writeCodeTo(PrettyPrinter var1);

        public static enum Type {
            Empty,
            Single,
            Group;

        }
    }

    private static class ConventionSelector
    implements ConfigSelector {
        final String conventionName;

        private ConventionSelector(String conventionName) {
            this.conventionName = conventionName;
        }

        @Override
        public String codeBlockSelectorFor(Syntax syntax) {
            return syntax.conventionSelector(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConventionSelector that = (ConventionSelector)o;
            return Objects.equal((Object)this.conventionName, (Object)that.conventionName);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.conventionName});
        }
    }

    private static class TaskTypeSelector
    implements ConfigSelector {
        final String taskType;

        TaskTypeSelector(String taskType) {
            this.taskType = taskType;
        }

        @Override
        @Nullable
        public String codeBlockSelectorFor(Syntax syntax) {
            return "tasks.withType(" + this.taskType + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskTypeSelector that = (TaskTypeSelector)o;
            return Objects.equal((Object)this.taskType, (Object)that.taskType);
        }

        public int hashCode() {
            return this.taskType.hashCode();
        }
    }

    private static class TaskSelector
    implements ConfigSelector {
        final String taskName;
        final String taskType;

        private TaskSelector(String taskName, String taskType) {
            this.taskName = taskName;
            this.taskType = taskType;
        }

        @Override
        @Nullable
        public String codeBlockSelectorFor(Syntax syntax) {
            return syntax.taskSelector(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskSelector that = (TaskSelector)o;
            return Objects.equal((Object)this.taskName, (Object)that.taskName) && Objects.equal((Object)this.taskType, (Object)that.taskType);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.taskName, this.taskType});
        }
    }

    private static interface ConfigSelector {
        @Nullable
        public String codeBlockSelectorFor(Syntax var1);
    }

    private static class ConfigSpec {
        final ConfigSelector selector;
        final Statement statement;

        ConfigSpec(ConfigSelector selector, Statement statement) {
            this.selector = selector;
            this.statement = statement;
        }
    }

    private static class ProjectDepSpec
    extends AbstractStatement {
        private final String configuration;
        private final String projectPath;

        ProjectDepSpec(String configuration, String comment, String projectPath) {
            super(comment);
            this.configuration = configuration;
            this.projectPath = projectPath;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.println(printer.syntax.dependencySpec(this.configuration, "project(" + printer.syntax.string(this.projectPath) + ")"));
        }
    }

    private static class DepSpec
    extends AbstractStatement {
        final String configuration;
        final List<String> deps;

        DepSpec(String configuration, String comment, List<String> deps) {
            super(comment);
            this.configuration = configuration;
            this.deps = deps;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            for (String dep : this.deps) {
                printer.println(printer.syntax.dependencySpec(this.configuration, printer.syntax.string(dep)));
            }
        }
    }

    public static class NestedPluginSpec
    extends PluginSpec {
        NestedPluginSpec(String id, @Nullable String version, String comment) {
            super(id, version, comment);
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.println(printer.syntax.nestedPluginDependencySpec(this.id, this.version));
        }
    }

    private static class PluginSpec
    extends AbstractStatement {
        final String id;
        @Nullable
        final String version;

        PluginSpec(String id, @Nullable String version, String comment) {
            super(comment);
            this.id = id;
            this.version = version;
        }

        @Override
        public void writeCodeTo(PrettyPrinter printer) {
            printer.println(printer.syntax.pluginDependencySpec(this.id, this.version));
        }
    }

    private static class MethodInvocationValue
    implements ExpressionValue {
        final String methodName;
        final List<ExpressionValue> arguments;

        MethodInvocationValue(String methodName, List<ExpressionValue> arguments) {
            this.methodName = methodName;
            this.arguments = arguments;
        }

        MethodInvocationValue(String methodName) {
            this(methodName, Collections.emptyList());
        }

        @Override
        public boolean isBooleanType() {
            return false;
        }

        @Override
        public String with(Syntax syntax) {
            StringBuilder result = new StringBuilder();
            result.append(this.methodName);
            result.append("(");
            for (int i = 0; i < this.arguments.size(); ++i) {
                ExpressionValue argument = this.arguments.get(i);
                if (i == 0) {
                    result.append(syntax.firstArg(argument));
                    continue;
                }
                result.append(", ");
                result.append(argument.with(syntax));
            }
            result.append(")");
            return result.toString();
        }
    }

    private static class MapLiteralValue
    implements ExpressionValue {
        final Map<String, ExpressionValue> literal;

        public MapLiteralValue(Map<String, ExpressionValue> literal) {
            this.literal = literal;
        }

        @Override
        public boolean isBooleanType() {
            return false;
        }

        @Override
        public String with(Syntax syntax) {
            return syntax.mapLiteral(this.literal);
        }
    }

    private static class LiteralValue
    implements ExpressionValue {
        final Object literal;

        LiteralValue(Object literal) {
            this.literal = literal;
        }

        @Override
        public boolean isBooleanType() {
            return this.literal instanceof Boolean;
        }

        @Override
        public String with(Syntax syntax) {
            return this.literal.toString();
        }
    }

    private static class StringValue
    implements ExpressionValue {
        final CharSequence value;

        StringValue(CharSequence value) {
            this.value = value;
        }

        @Override
        public boolean isBooleanType() {
            return false;
        }

        @Override
        public String with(Syntax syntax) {
            return syntax.string(this.value.toString());
        }
    }

    private static interface ExpressionValue
    extends Expression {
        public boolean isBooleanType();

        public String with(Syntax var1);
    }

    public static interface Expression {
    }
}

