/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.routes;

import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.play.internal.routes.DefaultVersionedRoutesCompilerAdapter;
import org.gradle.scala.internal.reflect.ScalaListBuffer;
import org.gradle.scala.internal.reflect.ScalaMethod;
import org.gradle.scala.internal.reflect.ScalaObject;
import org.gradle.scala.internal.reflect.ScalaReflectionUtil;

public class RoutesCompilerAdapterV24X
extends DefaultVersionedRoutesCompilerAdapter {
    private static final Logger LOGGER = Logging.getLogger(RoutesCompilerAdapterV24X.class);
    private static final String PLAY_ROUTES_COMPILER_STATIC_ROUTES_GENERATOR = "play.routes.compiler.StaticRoutesGenerator";
    private static final String PLAY_ROUTES_COMPILER_INJECTED_ROUTES_GENERATOR = "play.routes.compiler.InjectedRoutesGenerator";
    private final List<String> defaultScalaImports = Lists.newArrayList((Object[])new String[]{"controllers.Assets.Asset"});
    private final List<String> defaultJavaImports = Lists.newArrayList((Object[])new String[]{"controllers.Assets.Asset", "play.libs.F"});

    public RoutesCompilerAdapterV24X(String playVersion, String scalaVersion) {
        super(playVersion, scalaVersion);
    }

    @Override
    public ScalaMethod getCompileMethod(ClassLoader cl) throws ClassNotFoundException {
        return ScalaReflectionUtil.scalaMethod(cl, "play.routes.compiler.RoutesCompiler", "compile", cl.loadClass("play.routes.compiler.RoutesCompiler$RoutesCompilerTask"), cl.loadClass("play.routes.compiler.RoutesGenerator"), File.class);
    }

    @Override
    public Object[] createCompileParameters(ClassLoader cl, File file, File destinationDir, boolean javaProject, boolean namespaceReverseRouter, boolean generateReverseRoutes, boolean injectedRoutesGenerator, Collection<String> additionalImports) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        List<String> defaultImports = javaProject ? this.defaultJavaImports : this.defaultScalaImports;
        defaultImports.addAll(additionalImports);
        Object routesCompilerTask = DirectInstantiator.instantiate(cl.loadClass("play.routes.compiler.RoutesCompiler$RoutesCompilerTask"), (Object[])new Object[]{file, ScalaListBuffer.fromList(cl, defaultImports), this.isGenerateForwardsRouter(), generateReverseRoutes, namespaceReverseRouter});
        String routeGenerator = injectedRoutesGenerator ? PLAY_ROUTES_COMPILER_INJECTED_ROUTES_GENERATOR : PLAY_ROUTES_COMPILER_STATIC_ROUTES_GENERATOR;
        return new Object[]{routesCompilerTask, new ScalaObject(cl, routeGenerator).getInstance(), destinationDir};
    }

    protected boolean isGenerateForwardsRouter() {
        return true;
    }

    @Override
    public Boolean interpretResult(Object result) throws ClassNotFoundException {
        JavaMethod isRight = JavaReflectionUtil.method((Object)result, Boolean.class, (String)"isRight", (Class[])new Class[0]);
        Boolean successful = (Boolean)Cast.cast(Boolean.class, (Object)isRight.invoke(result, new Object[0]));
        if (successful.booleanValue()) {
            JavaMethod right = JavaReflectionUtil.method((Object)result, Object.class, (String)"right", (Class[])new Class[0]);
            Object rightResult = right.invoke(result, new Object[0]);
            JavaMethod get = JavaReflectionUtil.method((Object)rightResult, Object.class, (String)"get", (Class[])new Class[0]);
            Object generatedFiles = get.invoke(rightResult, new Object[0]);
            JavaMethod isEmpty = JavaReflectionUtil.method((Object)generatedFiles, Object.class, (String)"isEmpty", (Class[])new Class[0]);
            Object empty = isEmpty.invoke(generatedFiles, new Object[0]);
            JavaMethod booleanValue = JavaReflectionUtil.method((Object)empty, Boolean.class, (String)"booleanValue", (Class[])new Class[0]);
            return (Boolean)booleanValue.invoke(empty, new Object[0]);
        }
        JavaMethod left = JavaReflectionUtil.method((Object)result, Object.class, (String)"left", (Class[])new Class[0]);
        Object leftResult = left.invoke(result, new Object[0]);
        JavaMethod get = JavaReflectionUtil.method((Object)leftResult, Object.class, (String)"get", (Class[])new Class[0]);
        Object errorSeq = get.invoke(leftResult, new Object[0]);
        ClassLoader resultCl = result.getClass().getClassLoader();
        ScalaMethod seqAsJavaList = ScalaReflectionUtil.scalaMethod(resultCl, "scala.collection.JavaConversions", "seqAsJavaList", resultCl.loadClass("scala.collection.Seq"));
        List errors = (List)Cast.uncheckedCast((Object)seqAsJavaList.invoke(errorSeq));
        RoutesCompilationErrorAdapter errorAdapter = new RoutesCompilationErrorAdapter(resultCl.loadClass("play.routes.compiler.RoutesCompilationError"), resultCl.loadClass("scala.Option"));
        for (Object error : errors) {
            RoutesCompilationError adaptedError = errorAdapter.adapt(error);
            String message = adaptedError.toString();
            LOGGER.error(message);
        }
        throw new RuntimeException("route compilation failed with errors");
    }

    private static class RoutesCompilationError {
        private final File source;
        private final String message;
        private final int line;
        private final int col;

        private RoutesCompilationError(File source, String message, int line, int col) {
            this.source = source;
            this.message = message;
            this.line = line;
            this.col = col;
        }

        public String toString() {
            if (this.line > 0 && this.col > 0) {
                return this.source.getAbsolutePath() + ":" + this.line + ":" + this.col + " " + this.message;
            }
            return this.source.getAbsolutePath() + " " + this.message;
        }
    }

    private static class RoutesCompilationErrorAdapter {
        private final JavaMethod<Object, File> sourceMethod;
        private final JavaMethod<Object, String> messageMethod;
        private final JavaMethod<Object, Object> lineMethod;
        private final JavaMethod<Object, Object> columnMethod;
        private final JavaMethod<Object, Object> getMethod;

        private RoutesCompilationErrorAdapter(Class<?> routesCompilationError, Class<?> option) {
            this.sourceMethod = (JavaMethod)Cast.uncheckedCast((Object)JavaReflectionUtil.method(routesCompilationError, File.class, (String)"source", (Class[])new Class[0]));
            this.messageMethod = (JavaMethod)Cast.uncheckedCast((Object)JavaReflectionUtil.method(routesCompilationError, String.class, (String)"message", (Class[])new Class[0]));
            this.lineMethod = (JavaMethod)Cast.uncheckedCast((Object)JavaReflectionUtil.method(routesCompilationError, Object.class, (String)"line", (Class[])new Class[0]));
            this.columnMethod = (JavaMethod)Cast.uncheckedCast((Object)JavaReflectionUtil.method(routesCompilationError, Object.class, (String)"column", (Class[])new Class[0]));
            this.getMethod = (JavaMethod)Cast.uncheckedCast((Object)JavaReflectionUtil.method(option, Object.class, (String)"get", (Class[])new Class[0]));
        }

        RoutesCompilationError adapt(Object error) {
            return new RoutesCompilationError((File)this.sourceMethod.invoke(error, new Object[0]), (String)this.messageMethod.invoke(error, new Object[0]), this.toInt(this.lineMethod.invoke(error, new Object[0])), this.toInt(this.columnMethod.invoke(error, new Object[0])));
        }

        Integer toInt(Object optionInt) {
            try {
                return (Integer)Cast.uncheckedCast((Object)this.getMethod.invoke(optionInt, new Object[0]));
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

