/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.inject.Inject;

public class InjectUtil {
    public static Constructor<?> selectConstructor(Class<?> type) {
        return InjectUtil.selectConstructor(type, type);
    }

    public static Constructor<?> selectConstructor(Class<?> type, Class<?> reportAs) {
        Constructor<?>[] constructors = type.getDeclaredConstructors();
        if (constructors.length == 1) {
            Constructor<?> constructor = constructors[0];
            if (constructor.getParameterTypes().length == 0 && InjectUtil.isPublicOrPackageScoped(type, constructor)) {
                return constructor;
            }
            if (constructor.getAnnotation(Inject.class) != null) {
                return constructor;
            }
            if (constructor.getParameterTypes().length == 0) {
                throw new IllegalArgumentException(String.format("The constructor for class %s should be public or package protected or annotated with @Inject.", reportAs.getName()));
            }
            throw new IllegalArgumentException(String.format("The constructor for class %s should be annotated with @Inject.", reportAs.getName()));
        }
        ArrayList injectConstructors = new ArrayList();
        for (Constructor<?> constructor : constructors) {
            if (constructor.getAnnotation(Inject.class) == null) continue;
            injectConstructors.add(constructor);
        }
        if (injectConstructors.isEmpty()) {
            throw new IllegalArgumentException(String.format("Class %s has no constructor that is annotated with @Inject.", reportAs.getName()));
        }
        if (injectConstructors.size() > 1) {
            throw new IllegalArgumentException(String.format("Class %s has multiple constructors that are annotated with @Inject.", reportAs.getName()));
        }
        return (Constructor)injectConstructors.get(0);
    }

    private static boolean isPublicOrPackageScoped(Class<?> type, Constructor<?> constructor) {
        if (InjectUtil.isPackagePrivate(type.getModifiers())) {
            return !Modifier.isPrivate(constructor.getModifiers()) && !Modifier.isProtected(constructor.getModifiers());
        }
        return Modifier.isPublic(constructor.getModifiers());
    }

    private static boolean isPackagePrivate(int modifiers) {
        return !Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPublic(modifiers);
    }
}

