/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.changes.TaskFingerprintUtil;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.impl.DefaultBeforeExecutionState;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class CacheBackedTaskHistoryRepository
implements TaskHistoryRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheBackedTaskHistoryRepository.class);
    private final ExecutionHistoryStore executionHistoryStore;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final ValueSnapshotter valueSnapshotter;
    private final FileCollectionFingerprinterRegistry fingerprinterRegistry;

    public CacheBackedTaskHistoryRepository(ExecutionHistoryStore executionHistoryStore, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ValueSnapshotter valueSnapshotter, FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        this.executionHistoryStore = executionHistoryStore;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.valueSnapshotter = valueSnapshotter;
        this.fingerprinterRegistry = fingerprinterRegistry;
    }

    @Override
    public TaskHistoryRepository.History getHistory(final TaskInternal task, final TaskProperties taskProperties) {
        return new TaskHistoryRepository.History(){
            private boolean afterPreviousExecutionStateLoadAttempted;
            private AfterPreviousExecutionState afterPreviousExecutionState;
            private BeforeExecutionState beforeExecutionState;

            @Override
            public AfterPreviousExecutionState getAfterPreviousExecutionState() {
                if (!this.afterPreviousExecutionStateLoadAttempted) {
                    this.afterPreviousExecutionStateLoadAttempted = true;
                    this.afterPreviousExecutionState = CacheBackedTaskHistoryRepository.this.loadPreviousExecution(task);
                }
                return this.afterPreviousExecutionState;
            }

            @Override
            public BeforeExecutionState getBeforeExecutionState() {
                if (this.beforeExecutionState == null) {
                    this.beforeExecutionState = CacheBackedTaskHistoryRepository.this.createExecution(task, taskProperties, this.getAfterPreviousExecutionState());
                }
                return this.beforeExecutionState;
            }

            @Override
            public void persist(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> newOutputFingerprints, boolean successful, OriginMetadata originMetadata) {
                BeforeExecutionState execution = this.getBeforeExecutionState();
                CacheBackedTaskHistoryRepository.this.executionHistoryStore.store(task.getPath(), OriginMetadata.fromPreviousBuild((UniqueId)originMetadata.getBuildInvocationId(), (long)originMetadata.getExecutionTime()), execution.getImplementation(), execution.getAdditionalImplementations(), execution.getInputProperties(), execution.getInputFileProperties(), newOutputFingerprints, successful);
            }
        };
    }

    private BeforeExecutionState createExecution(TaskInternal task, TaskProperties taskProperties, @Nullable AfterPreviousExecutionState afterPreviousExecutionState) {
        Class<?> taskClass = task.getClass();
        List<ContextAwareTaskAction> taskActions = task.getTaskActions();
        ImplementationSnapshot taskImplementation = ImplementationSnapshot.of(taskClass, (ClassLoaderHierarchyHasher)this.classLoaderHierarchyHasher);
        ImmutableList<ImplementationSnapshot> taskActionImplementations = CacheBackedTaskHistoryRepository.collectActionImplementations(taskActions, this.classLoaderHierarchyHasher);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Implementation for {}: {}", (Object)task, (Object)taskImplementation);
            LOGGER.debug("Action implementations for {}: {}", (Object)task, taskActionImplementations);
        }
        ImmutableSortedMap previousInputProperties = afterPreviousExecutionState == null ? ImmutableSortedMap.of() : afterPreviousExecutionState.getInputProperties();
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = CacheBackedTaskHistoryRepository.snapshotTaskInputProperties(task, taskProperties, (ImmutableSortedMap<String, ValueSnapshot>)previousInputProperties, this.valueSnapshotter);
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFiles = TaskFingerprintUtil.fingerprintTaskFiles(task, taskProperties.getInputFileProperties(), this.fingerprinterRegistry);
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputFiles = TaskFingerprintUtil.fingerprintTaskFiles(task, taskProperties.getOutputFileProperties(), this.fingerprinterRegistry);
        return new DefaultBeforeExecutionState(taskImplementation, taskActionImplementations, inputProperties, inputFiles, outputFiles);
    }

    private static ImmutableList<ImplementationSnapshot> collectActionImplementations(Collection<ContextAwareTaskAction> taskActions, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        if (taskActions.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder actionImplementations = ImmutableList.builder();
        for (ContextAwareTaskAction taskAction : taskActions) {
            actionImplementations.add((Object)taskAction.getActionImplementation(classLoaderHierarchyHasher));
        }
        return actionImplementations.build();
    }

    private static ImmutableSortedMap<String, ValueSnapshot> snapshotTaskInputProperties(TaskInternal task, TaskProperties taskProperties, ImmutableSortedMap<String, ValueSnapshot> previousInputProperties, ValueSnapshotter valueSnapshotter) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        Map inputPropertyValues = (Map)taskProperties.getInputPropertyValues().create();
        assert (inputPropertyValues != null);
        for (Map.Entry entry : inputPropertyValues.entrySet()) {
            String propertyName = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                ValueSnapshot previousSnapshot = (ValueSnapshot)previousInputProperties.get((Object)propertyName);
                if (previousSnapshot == null) {
                    builder.put((Object)propertyName, (Object)valueSnapshotter.snapshot(value));
                    continue;
                }
                builder.put((Object)propertyName, (Object)valueSnapshotter.snapshot(value, previousSnapshot));
            }
            catch (Exception e) {
                throw new UncheckedIOException(String.format("Unable to store input properties for %s. Property '%s' with value '%s' cannot be serialized.", task, propertyName, value), (Throwable)e);
            }
        }
        return builder.build();
    }

    @Nullable
    private AfterPreviousExecutionState loadPreviousExecution(TaskInternal task) {
        return this.executionHistoryStore.load(task.getPath());
    }
}

