/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.test;

import joptsimple.OptionSet;
import org.springframework.boot.cli.command.OptionParsingCommand;
import org.springframework.boot.cli.command.options.CompilerOptionHandler;
import org.springframework.boot.cli.command.options.OptionSetGroovyCompilerConfiguration;
import org.springframework.boot.cli.command.options.SourceOptions;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.boot.cli.command.test.TestRunner;
import org.springframework.boot.cli.command.test.TestRunnerConfiguration;

public class TestCommand
extends OptionParsingCommand {
    public TestCommand() {
        super("test", "Run a spring groovy script test", new TestOptionHandler());
    }

    @Override
    public String getUsageHelp() {
        return "[options] <files> [--] [args]";
    }

    private static class TestOptionHandler
    extends CompilerOptionHandler {
        private TestRunner runner;

        private TestOptionHandler() {
        }

        @Override
        protected ExitStatus run(OptionSet options) throws Exception {
            SourceOptions sourceOptions = new SourceOptions(options);
            TestRunnerConfigurationAdapter configuration = new TestRunnerConfigurationAdapter(options, this);
            this.runner = new TestRunner(configuration, sourceOptions.getSourcesArray());
            this.runner.compileAndRunTests();
            return ExitStatus.OK.hangup();
        }

        private class TestRunnerConfigurationAdapter
        extends OptionSetGroovyCompilerConfiguration
        implements TestRunnerConfiguration {
            TestRunnerConfigurationAdapter(OptionSet options, CompilerOptionHandler optionHandler) {
                super(options, optionHandler);
            }
        }
    }
}

