/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.jboss;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.instrument.classloading.jboss.JBossClassLoaderAdapter;
import org.springframework.instrument.classloading.jboss.JBossMCTranslatorAdapter;
import org.springframework.util.ReflectionUtils;

class JBossMCAdapter
implements JBossClassLoaderAdapter {
    private static final String LOADER_NAME = "org.jboss.classloader.spi.base.BaseClassLoader";
    private static final String TRANSLATOR_NAME = "org.jboss.util.loading.Translator";
    private final ClassLoader classLoader;
    private final Object target;
    private final Class<?> translatorClass;
    private final Method addTranslator;

    public JBossMCAdapter(ClassLoader classLoader) {
        try {
            Class<?> clazzLoaderType = classLoader.loadClass(LOADER_NAME);
            Object clazzLoader = null;
            for (ClassLoader cl = classLoader; cl != null && clazzLoader == null; cl = cl.getParent()) {
                if (!clazzLoaderType.isInstance(cl)) continue;
                clazzLoader = cl;
            }
            if (clazzLoader == null) {
                throw new IllegalArgumentException(classLoader + " and its parents are not suitable ClassLoaders: A [" + LOADER_NAME + "] implementation is required.");
            }
            this.classLoader = clazzLoader;
            classLoader = clazzLoader.getClass().getClassLoader();
            Method method = clazzLoaderType.getDeclaredMethod("getPolicy", new Class[0]);
            ReflectionUtils.makeAccessible((Method)method);
            this.target = method.invoke((Object)this.classLoader, new Object[0]);
            this.translatorClass = classLoader.loadClass(TRANSLATOR_NAME);
            this.addTranslator = this.target.getClass().getMethod("addTranslator", this.translatorClass);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Could not initialize JBoss LoadTimeWeaver because the JBoss 6 API classes are not available", ex);
        }
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        JBossMCTranslatorAdapter adapter = new JBossMCTranslatorAdapter(transformer);
        Object adapterInstance = Proxy.newProxyInstance(this.translatorClass.getClassLoader(), new Class[]{this.translatorClass}, (InvocationHandler)adapter);
        try {
            this.addTranslator.invoke(this.target, adapterInstance);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Could not add transformer on JBoss 6 ClassLoader " + this.classLoader, ex);
        }
    }

    @Override
    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }
}

