import * as inspector from 'inspector';
export interface ErrorMetadata {
    type: String;
    subtype: String;
    className: String;
    description: String;
    objectId: String;
    uncaught: Boolean;
}
export interface ScopeMetadata extends inspector.Debugger.Scope {
    context: PropertyMetadata[];
}
export interface PropertyMetadata {
    properties?: PropertyMetadata[];
    name: string;
    value?: inspector.Runtime.RemoteObject;
    writable?: boolean;
    get?: inspector.Runtime.RemoteObject;
    set?: inspector.Runtime.RemoteObject;
    configurable?: boolean;
    enumerable?: boolean;
    wasThrown?: boolean;
    isOwn?: boolean;
    symbol?: inspector.Runtime.RemoteObject;
}
export interface TrappedException {
    error: ErrorMetadata;
    frame: Object;
    asyncStackTrace?: inspector.Runtime.StackTrace;
}
export interface FetchObjectPropertiesReturnType {
    (err?: Error, data?: PropertyMetadata[]): void;
}
export default class NotifyInspector {
    private inspectorService;
    private exceptionsTrapped;
    constructor();
    init(): void;
    destroy(): void;
    trapException(listener: String): (error: any) => void;
    isObjectInteresting(entry: PropertyMetadata): Boolean;
    isPropertyIntesting(entry: PropertyMetadata, parent?: PropertyMetadata): Boolean;
    formatProperty(property: PropertyMetadata): {
        name: string;
        value: any;
        properties: PropertyMetadata[] | undefined;
    };
    fetchObjectProperties(session: inspector.Session, object: String, cb: FetchObjectPropertiesReturnType): void;
    catchAllDebugger(): Boolean | void;
}
