/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.system;

public class ByteUtil {
    public static final byte[] get2Bytes(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return byArray;
    }

    public static final byte[] get4Bytes(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return byArray;
    }

    public static final byte[] get4BytesInv(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(n & 0xFF);
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[1] = (byte)(n >> 16 & 0xFF);
        byArray[0] = (byte)(n >> 24 & 0xFF);
        return byArray;
    }

    public static final byte[] get8Bytes(long l) {
        byte[] byArray = new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 56 & 0xFFL)};
        return byArray;
    }

    public static final long toLong(byte[] byArray) {
        return (long)ByteUtil.toInt(byArray[0], byArray[1], byArray[2], byArray[3]) | (long)ByteUtil.toInt(byArray[4], byArray[5], byArray[6], byArray[7]) << 32;
    }

    public static final int toInt(byte by, byte by2, byte by3, byte by4) {
        return by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by4 & 0xFF) << 24;
    }

    public static final int toInt(byte[] byArray) {
        return ByteUtil.toInt(byArray[0], byArray[1], byArray[2], byArray[3]);
    }

    public static final int toInt(byte[] byArray, int n) {
        return ByteUtil.toInt(byArray[n + 0], byArray[n + 1], byArray[n + 2], byArray[n + 3]);
    }

    public static final int floatToHalf(float f) {
        int n = Float.floatToRawIntBits(f);
        int n2 = n >> 16 & 0x8000;
        int n3 = (n >> 23 & 0xFF) - 112;
        int n4 = n & 0x7FFFFF;
        if (n3 <= 0) {
            if (n3 < -10) {
                return 0;
            }
            if (((n4 = (n4 | 0x800000) >> 1 - n3) & 0x1000) == 4096) {
                n4 += 8192;
            }
            return n2 | n4 >> 13;
        }
        if (n3 == 143) {
            if (n4 == 0) {
                return n2 | 0x7C00;
            }
            return n2 | 0x7C00 | n4 | ((n4 >>= 13) == 0 ? 0 : 1);
        }
        if ((n4 & 0x1000) == 4096 && ((n4 += 8192) & 0x800000) == 0x800000) {
            n4 = 0;
            ++n3;
        }
        if (n3 > 30) {
            return n2 | 0x7C00;
        }
        return n2 | n3 << 10 | n4 >> 13;
    }
}

