/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Context;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;

class TransparencyAttributesRetained
extends NodeComponentRetained {
    static final int MODE_CHANGED = 1;
    static final int VALUE_CHANGED = 2;
    static final int SRC_BLEND_FUNCTION_CHANGED = 4;
    static final int DST_BLEND_FUNCTION_CHANGED = 8;
    int isDirty = 65535;
    int transparencyMode = 4;
    float transparency = 0.0f;
    int srcBlendFunction = 2;
    int dstBlendFunction = 3;

    TransparencyAttributesRetained() {
    }

    final void initTransparencyMode(int n) {
        this.transparencyMode = n;
    }

    final void setTransparencyMode(int n) {
        this.initTransparencyMode(n);
        this.sendMessage(1, new Integer(n));
    }

    final int getTransparencyMode() {
        return this.transparencyMode;
    }

    final void initTransparency(float f) {
        this.transparency = f;
    }

    final void setTransparency(float f) {
        this.initTransparency(f);
        this.sendMessage(2, new Float(f));
    }

    final float getTransparency() {
        return this.transparency;
    }

    final void initSrcBlendFunction(int n) {
        this.srcBlendFunction = n;
    }

    final void setSrcBlendFunction(int n) {
        this.initSrcBlendFunction(n);
        this.sendMessage(4, new Integer(n));
    }

    final int getSrcBlendFunction() {
        return this.srcBlendFunction;
    }

    final void initDstBlendFunction(int n) {
        this.dstBlendFunction = n;
    }

    final void setDstBlendFunction(int n) {
        this.initDstBlendFunction(n);
        this.sendMessage(8, new Integer(n));
    }

    final int getDstBlendFunction() {
        return this.dstBlendFunction;
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                TransparencyAttributesRetained transparencyAttributesRetained = new TransparencyAttributesRetained();
                transparencyAttributesRetained.source = this.source;
                transparencyAttributesRetained.set(this);
                this.mirror = transparencyAttributesRetained;
            }
        } else {
            ((TransparencyAttributesRetained)this.mirror).set(this);
        }
    }

    static boolean useAlpha(TransparencyAttributesRetained transparencyAttributesRetained) {
        return transparencyAttributesRetained != null && transparencyAttributesRetained.transparencyMode != 4 && transparencyAttributesRetained.transparencyMode != 3;
    }

    void updateNative(Context context, float f, int n, int n2, boolean bl, boolean bl2) {
        Pipeline.getPipeline().updateTransparencyAttributes(context, f, n, n2, bl, bl2, this.transparencyMode, this.srcBlendFunction, this.dstBlendFunction);
    }

    @Override
    synchronized void initMirrorObject() {
        ((TransparencyAttributesRetained)this.mirror).set(this);
    }

    @Override
    synchronized void updateMirrorObject(int n, Object object) {
        TransparencyAttributesRetained transparencyAttributesRetained = (TransparencyAttributesRetained)this.mirror;
        if ((n & 1) != 0) {
            transparencyAttributesRetained.transparencyMode = (Integer)object;
        } else if ((n & 2) != 0) {
            transparencyAttributesRetained.transparency = ((Float)object).floatValue();
        } else if ((n & 4) != 0) {
            transparencyAttributesRetained.srcBlendFunction = (Integer)object;
        } else if ((n & 8) != 0) {
            transparencyAttributesRetained.dstBlendFunction = (Integer)object;
        }
    }

    boolean equivalent(TransparencyAttributesRetained transparencyAttributesRetained) {
        return transparencyAttributesRetained != null && transparencyAttributesRetained.transparencyMode == this.transparencyMode && transparencyAttributesRetained.transparency == this.transparency && transparencyAttributesRetained.srcBlendFunction == this.srcBlendFunction && transparencyAttributesRetained.dstBlendFunction == this.dstBlendFunction;
    }

    protected void set(TransparencyAttributesRetained transparencyAttributesRetained) {
        super.set(transparencyAttributesRetained);
        this.transparencyMode = transparencyAttributesRetained.transparencyMode;
        this.transparency = transparencyAttributesRetained.transparency;
        this.srcBlendFunction = transparencyAttributesRetained.srcBlendFunction;
        this.dstBlendFunction = transparencyAttributesRetained.dstBlendFunction;
    }

    final void sendMessage(int n, Object object) {
        ArrayList<VirtualUniverse> arrayList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 12;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i = 0; i < arrayList.size(); ++i) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 12;
            j3dMessage.universe = arrayList.get(i);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            ArrayList<GeometryAtom> arrayList3 = arrayList2.get(i);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    @Override
    void handleFrequencyChange(int n) {
        if (n == 1 || n == 3 || n == 5) {
            this.setFrequencyChangeMask(n, 1);
        }
    }
}

