/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.keymap;

import javax.swing.UIManager;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;

public class EmacsUtil {
    Buffer buffer = jEdit.getActiveView().getBuffer();
    TextArea textArea = jEdit.getActiveView().getTextArea();

    public void emacsKillLine() {
        char c;
        int n;
        boolean bl = this.repeatingSameMacro("Emacs/Emacs_Kill_Line");
        int n2 = this.textArea.getCaretPosition();
        int n3 = this.textArea.getCaretLine();
        int n4 = this.textArea.getLineEndOffset(n3);
        for (n = n2 + 1; n < n4 && Character.isWhitespace(c = this.charAt(n)); ++n) {
        }
        String string = null;
        Selection.Range range = null;
        if (n == n4) {
            if (n3 != this.textArea.getLastPhysicalLine()) {
                range = new Selection.Range(n2, n);
            }
        } else {
            range = new Selection.Range(n2, n4 - 1);
        }
        if (range != null) {
            this.textArea.setSelection(range);
            string = this.textArea.getSelectedText();
            this.textArea.replaceSelection("");
            this.textArea.removeFromSelection(range);
            if (bl) {
                String string2 = this.getClipboard();
                if (string2 == null) {
                    string2 = "";
                }
                this.setClipboard(string2 + string);
            } else {
                this.setClipboard(string);
            }
        }
    }

    public boolean repeatingSameMacro(String string) {
        InputHandler inputHandler = jEdit.getActiveView().getInputHandler();
        EditAction editAction = inputHandler.getLastAction();
        int n = inputHandler.getLastActionCount();
        boolean bl = false;
        if (editAction.getName().equals(string) && n > 1) {
            bl = true;
        }
        return bl;
    }

    public String lineAt(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        while (!this.atEndOfBuffer(n)) {
            char c = this.charAt(n);
            stringBuilder.append(c);
            if (c != '\n') continue;
            break;
        }
        return stringBuilder.toString();
    }

    public char charAt(int n) {
        if (n >= this.buffer.getLength()) {
            return '\u0000';
        }
        return this.buffer.getText(n, 1).charAt(0);
    }

    public char charAtCaret() {
        int n = this.textArea.getCaretPosition();
        return this.atEndOfBuffer() ? (char)'\u0000' : this.buffer.getText(n, 1).charAt(0);
    }

    public boolean atEndOfBuffer() {
        JEditTextArea jEditTextArea = jEdit.getActiveView().getTextArea();
        return this.atEndOfBuffer(jEditTextArea.getCaretPosition());
    }

    public boolean atEndOfBuffer(int n) {
        return n >= this.buffer.getLength();
    }

    public int eatNonAlphanums() {
        boolean bl = true;
        while (bl) {
            char c = this.charAtCaret();
            if (c == '\n') {
                this.textArea.goToNextLine(false);
                this.textArea.goToStartOfLine(false);
                continue;
            }
            if (Character.isLetterOrDigit(c)) {
                bl = false;
                continue;
            }
            this.textArea.goToNextCharacter(false);
        }
        return this.textArea.getCaretPosition();
    }

    public int eatWhitespace() {
        boolean bl = true;
        while (bl) {
            char c = this.charAtCaret();
            if (c == '\n') {
                this.textArea.goToNextLine(false);
                this.textArea.goToStartOfLine(false);
                continue;
            }
            if (Character.isWhitespace(c)) {
                this.textArea.goToNextCharacter(false);
                continue;
            }
            bl = false;
        }
        return this.textArea.getCaretPosition();
    }

    public int getCardinalProperty(String string, int n) {
        int n2 = jEdit.getIntegerProperty(string, n);
        if (n2 <= 0) {
            n2 = n;
        }
        return n2;
    }

    public String makeBufferPropertyName(String string) {
        return this.makeBufferPropertyName(this.buffer, string);
    }

    public String makeBufferPropertyName(Buffer buffer, String string) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder(string);
        String string3 = System.getProperty("file.separator");
        if (!string3.equals("/")) {
            if (string3.equals("\\")) {
                string3 = string3 + '\\';
            }
            string2 = buffer.getPath().replaceAll(string3, "/");
        } else {
            string2 = buffer.getPath();
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public int getDefaultWrap() {
        return this.getCardinalProperty("buffer.maxLineLen", 79);
    }

    public int getMark(Buffer buffer) {
        String string = this.makeBufferPropertyName("emacs.mark");
        int n = this.getCardinalProperty(string, -1);
        if (n != -1 && n >= buffer.getLength()) {
            n = buffer.getLength() - 1;
        }
        return n;
    }

    public void setMark(Buffer buffer, int n) {
        String string = this.makeBufferPropertyName(buffer, "emacs.mark");
        jEdit.setTemporaryProperty(string, String.valueOf(n));
    }

    public void beep() {
        UIManager.getLookAndFeel().provideErrorFeedback(null);
    }

    public Selection getKillRegion() {
        int n = this.textArea.getCaretPosition();
        Selection selection = this.textArea.getSelectionAtOffset(n);
        if (selection == null) {
            int n2 = this.getMark(this.buffer);
            if (n2 == -1) {
                this.beep();
                return null;
            }
            selection = new Selection.Range(Math.min(n, n2), Math.max(n, n2));
            this.textArea.setSelection(selection);
        }
        return selection;
    }

    public String getClipboard() {
        return String.valueOf(Registers.getRegister('$'));
    }

    public void setClipboard(String string) {
        Registers.setRegister('$', string);
    }

    public void setClipboard(Selection selection) {
        JEditTextArea jEditTextArea = jEdit.getActiveView().getTextArea();
        this.setClipboard(jEditTextArea.getSelectedText(selection));
    }

    public void addToClipboardAndHistory(String string) {
        this.setClipboard(string);
        HistoryModel.getModel("clipboard").addItem(string);
    }

    public void addToClipboardAndHistory(Selection selection) {
        this.addToClipboardAndHistory(this.textArea.getSelectedText(selection));
    }

    public int findEndOfSentence() {
        int n = this.textArea.getCaretPosition();
        while (!this.atEndOfBuffer(n)) {
            char c = this.charAt(n);
            if (c == '.' && Character.isWhitespace(this.charAt(n + 1))) {
                ++n;
                break;
            }
            ++n;
        }
        return n;
    }

    public int findBeginningOfSentence() {
        int n = this.textArea.getCaretPosition() - 1;
        if (this.charAt(n) == '.') {
            --n;
        }
        while (n > 0) {
            char c = this.charAt(n);
            if (c == '.') {
                if (Character.isWhitespace(this.charAt(n + 1))) {
                    ++n;
                    break;
                }
            } else if (Character.isUpperCase(c) && (--n <= 0 || Character.isWhitespace(this.charAt(n)))) break;
            --n;
        }
        return n;
    }
}

