/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Map;
import javajs.J2SIgnoreImport;
import javajs.api.BytePoster;
import javajs.api.GenericFileInterface;
import javajs.util.AU;
import javajs.util.BArray;
import javajs.util.Base64;
import javajs.util.CompoundDocument;
import javajs.util.DataReader;
import javajs.util.LimitedLineReader;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import org.jmol.adapter.readers.spartan.SpartanUtil;
import org.jmol.api.Interface;
import org.jmol.api.JmolDomReaderInterface;
import org.jmol.api.JmolFilesReaderInterface;
import org.jmol.io.FileReader;
import org.jmol.io.JmolUtil;
import org.jmol.script.SV;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;
import org.jmol.viewer.JmolAsyncException;
import org.jmol.viewer.Viewer;

@J2SIgnoreImport(value={Rdr.StreamReader.class})
public class FileManager
implements BytePoster {
    public static String SIMULATION_PROTOCOL = "http://SIMULATION/";
    public Viewer vwr;
    private SpartanUtil spartanDoc;
    JmolUtil jzu;
    private String pathForAllFiles = "";
    private String nameAsGiven = "zapped";
    private String fullPathName;
    private String lastFullPathName;
    private String lastNameAsGiven = "zapped";
    private String fileName;
    private URL appletDocumentBaseURL = null;
    private String appletProxy;
    private static final String DELPHI_BINARY_MAGIC_NUMBER = "\u0014\u0000\u0000\u0000";
    public static final String PMESH_BINARY_MAGIC_NUMBER = "PM\u0001\u0000";
    public static final String JPEG_CONTINUE_STRING = " #Jmol...\u0000";
    private static String[] scriptFilePrefixes = new String[]{"/*file*/\"", "FILE0=\"", "FILE1=\""};
    private Map<String, Object> cache = new Hashtable<String, Object>();
    public Map<String, Object> pngjCache;
    public Map<String, byte[]> spardirCache;

    FileManager(Viewer viewer) {
        this.vwr = viewer;
        this.clear();
    }

    public SpartanUtil spartanUtil() {
        return this.spartanDoc == null ? (this.spartanDoc = ((SpartanUtil)Interface.getInterface("org.jmol.adapter.readers.spartan.SpartanUtil", this.vwr, "fm getSpartanUtil()")).set(this)) : this.spartanDoc;
    }

    public JmolUtil getJzu() {
        return this.jzu == null ? (this.jzu = (JmolUtil)Interface.getOption("io.JmolUtil", this.vwr, "file")) : this.jzu;
    }

    void clear() {
        this.setFileInfo(new String[]{this.vwr.getZapName()});
        this.spardirCache = null;
    }

    private void setLoadState(Map<String, Object> map) {
        if (this.vwr.getPreserveState()) {
            map.put("loadState", this.vwr.g.getLoadState(map));
        }
    }

    public String getPathForAllFiles() {
        return this.pathForAllFiles;
    }

    String setPathForAllFiles(String string) {
        if (string.length() > 0 && !string.endsWith("/") && !string.endsWith("|")) {
            string = String.valueOf(string) + "/";
        }
        this.pathForAllFiles = string;
        return this.pathForAllFiles;
    }

    public void setFileInfo(String[] stringArray) {
        if (stringArray == null) {
            this.fullPathName = this.lastFullPathName;
            this.nameAsGiven = this.lastNameAsGiven;
            return;
        }
        this.fullPathName = stringArray[0];
        this.fileName = stringArray[Math.min(1, stringArray.length - 1)];
        this.nameAsGiven = stringArray[Math.min(2, stringArray.length - 1)];
        if (!this.nameAsGiven.equals("zapped")) {
            this.lastNameAsGiven = this.nameAsGiven;
            this.lastFullPathName = this.fullPathName;
        }
    }

    public String[] getFileInfo() {
        return new String[]{this.fullPathName, this.fileName, this.nameAsGiven};
    }

    public String getFullPathName(boolean bl) {
        String string;
        String string2 = string = this.fullPathName != null ? this.fullPathName : this.nameAsGiven;
        return !bl || !string.equals("zapped") ? string : (this.lastFullPathName != null ? this.lastFullPathName : this.lastNameAsGiven);
    }

    public String getFileName() {
        return this.fileName != null ? this.fileName : this.nameAsGiven;
    }

    String getAppletDocumentBase() {
        return this.appletDocumentBaseURL == null ? "" : this.appletDocumentBaseURL.toString();
    }

    void setAppletContext(String string) {
        try {
            System.out.println("setting document base to \"" + string + "\"");
            this.appletDocumentBaseURL = string.length() == 0 ? null : new URL(null, string, null);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("error setting document base to " + string);
        }
    }

    void setAppletProxy(String string) {
        this.appletProxy = string == null || string.length() == 0 ? null : string;
    }

    Object createAtomSetCollectionFromFile(String string, Map<String, Object> map, boolean bl) {
        int n;
        String string2;
        if (map.get("atomDataOnly") == null) {
            this.setLoadState(map);
        }
        if (!(string2 = string).equals(string = this.vwr.resolveDatabaseFormat(string)) && string2.indexOf("/") < 0 && Viewer.hasDatabasePrefix(string2)) {
            map.put("dbName", string2);
        }
        if (string.endsWith("%2D%")) {
            String string3 = (String)map.get("filter");
            map.put("filter", String.valueOf(string3 == null ? "" : string3) + "2D");
            string = string.substring(0, string.length() - 4);
        }
        String string4 = (n = string.indexOf("::")) >= 0 ? string.substring(n + 2) : string;
        String string5 = n >= 0 ? string.substring(0, n) : null;
        Logger.info("\nFileManager.getAtomSetCollectionFromFile(" + string4 + ")" + (string.equals(string4) ? "" : " //" + string));
        String[] stringArray = this.getClassifiedName(string4, true);
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        String string6 = stringArray[0];
        String string7 = stringArray[1];
        map.put("fullPathName", String.valueOf(string5 == null ? "" : String.valueOf(string5) + "::") + FileManager.fixDOSName(string6));
        if (this.vwr.getBoolean(603979880) && this.vwr.getBoolean(603979825)) {
            this.vwr.getChimeMessenger().update(string6);
        }
        FileReader fileReader = new FileReader(this.vwr, string7, string6, string4, string5, null, map, bl);
        fileReader.run();
        return fileReader.getAtomSetCollection();
    }

    Object createAtomSetCollectionFromFiles(String[] stringArray, Map<String, Object> map, boolean bl) {
        this.setLoadState(map);
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        String[] stringArray4 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            int n2 = stringArray[n].indexOf("::");
            String string = n2 >= 0 ? stringArray[n].substring(n2 + 2) : stringArray[n];
            System.out.println(String.valueOf(n) + " FM " + string);
            String string2 = n2 >= 0 ? stringArray[n].substring(0, n2) : null;
            String[] stringArray5 = this.getClassifiedName(string, true);
            if (stringArray5.length == 1) {
                return stringArray5[0];
            }
            stringArray2[n] = stringArray5[0];
            stringArray[n] = FileManager.fixDOSName(stringArray5[0]);
            stringArray4[n] = string2;
            stringArray3[n] = string;
            ++n;
        }
        map.put("fullPathNames", stringArray2);
        map.put("fileTypes", stringArray4);
        JmolFilesReaderInterface jmolFilesReaderInterface = this.newFilesReader(stringArray2, stringArray3, stringArray4, null, map, bl);
        jmolFilesReaderInterface.run();
        return jmolFilesReaderInterface.getAtomSetCollection();
    }

    Object createAtomSetCollectionFromString(String string, Map<String, Object> map, boolean bl) {
        this.setLoadState(map);
        boolean bl2 = string.indexOf("Viewer.AddHydrogens") >= 0;
        String[] stringArray = bl2 ? this.getFileInfo() : null;
        FileReader fileReader = new FileReader(this.vwr, "string", null, null, null, Rdr.getBR(string), map, bl);
        fileReader.run();
        if (stringArray != null) {
            this.setFileInfo(stringArray);
        }
        if (!bl && !(fileReader.getAtomSetCollection() instanceof String)) {
            this.setFileInfo(new String[]{string == "5\n\nC 0 0 0\nH .63 .63 .63\nH -.63 -.63 .63\nH -.63 .63 -.63\nH .63 -.63 -.63" ? "Jmol Model Kit" : "string"});
        }
        return fileReader.getAtomSetCollection();
    }

    Object createAtomSeCollectionFromStrings(String[] stringArray, SB sB, Map<String, Object> map, boolean bl) {
        DataReader[] dataReaderArray;
        String[] stringArray2;
        if (!map.containsKey("isData")) {
            stringArray2 = "\"" + this.vwr.getDataSeparator() + "\"";
            dataReaderArray = "\"" + (bl ? "append" : "model") + " inline\"";
            SB sB2 = new SB();
            sB2.append("set dataSeparator \"~~~next file~~~\";\ndata ").append((String)dataReaderArray);
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    sB2.append("~~~next file~~~");
                }
                sB2.append(stringArray[n]);
                ++n;
            }
            sB2.append("end ").append((String)dataReaderArray).append(";set dataSeparator ").append((String)stringArray2);
            sB.appendSB(sB2);
        }
        this.setLoadState(map);
        Logger.info("FileManager.getAtomSetCollectionFromStrings(string[])");
        stringArray2 = new String[stringArray.length];
        dataReaderArray = new DataReader[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = "string[" + n + "]";
            dataReaderArray[n] = FileManager.newDataReader(this.vwr, stringArray[n]);
            ++n;
        }
        JmolFilesReaderInterface jmolFilesReaderInterface = this.newFilesReader(stringArray2, stringArray2, null, dataReaderArray, map, bl);
        jmolFilesReaderInterface.run();
        return jmolFilesReaderInterface.getAtomSetCollection();
    }

    Object createAtomSeCollectionFromArrayData(Lst<Object> lst, Map<String, Object> map, boolean bl) {
        Logger.info("FileManager.getAtomSetCollectionFromArrayData(Vector)");
        int n = lst.size();
        String[] stringArray = new String[n];
        DataReader[] dataReaderArray = new DataReader[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = "String[" + n2 + "]";
            dataReaderArray[n2] = FileManager.newDataReader(this.vwr, lst.get(n2));
            ++n2;
        }
        JmolFilesReaderInterface jmolFilesReaderInterface = this.newFilesReader(stringArray, stringArray, null, dataReaderArray, map, bl);
        jmolFilesReaderInterface.run();
        return jmolFilesReaderInterface.getAtomSetCollection();
    }

    static DataReader newDataReader(Viewer viewer, Object object) {
        String string;
        String string2 = object instanceof String ? "String" : (AU.isAS(object) ? "Array" : (string = object instanceof Lst ? "List" : null));
        if (string == null) {
            return null;
        }
        DataReader dataReader = (DataReader)Interface.getInterface("javajs.util." + string + "DataReader", viewer, "file");
        return dataReader.setData(object);
    }

    private JmolFilesReaderInterface newFilesReader(String[] stringArray, String[] stringArray2, String[] stringArray3, DataReader[] dataReaderArray, Map<String, Object> map, boolean bl) {
        JmolFilesReaderInterface jmolFilesReaderInterface = (JmolFilesReaderInterface)Interface.getOption("io.FilesReader", this.vwr, "file");
        jmolFilesReaderInterface.set(this, this.vwr, stringArray, stringArray2, stringArray3, dataReaderArray, map, bl);
        return jmolFilesReaderInterface;
    }

    Object createAtomSetCollectionFromDOM(Object object, Map<String, Object> map) {
        JmolDomReaderInterface jmolDomReaderInterface = (JmolDomReaderInterface)Interface.getOption("io.DOMReadaer", this.vwr, "file");
        jmolDomReaderInterface.set(this, this.vwr, object, map);
        jmolDomReaderInterface.run();
        return jmolDomReaderInterface.getAtomSetCollection();
    }

    Object createAtomSetCollectionFromReader(String string, String string2, Object object, Map<String, Object> map) {
        FileReader fileReader = new FileReader(this.vwr, string2, string, null, null, object, map, false);
        fileReader.run();
        return fileReader.getAtomSetCollection();
    }

    BufferedInputStream getBufferedInputStream(String string) {
        Object object = this.getBufferedReaderOrErrorMessageFromName(string, new String[2], true, true);
        return object instanceof BufferedInputStream ? (BufferedInputStream)object : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getBufferedInputStreamOrErrorMessageFromName(String string, String string2, boolean bl, boolean bl2, byte[] byArray, boolean bl3, boolean bl4) {
        byte[] byArray2;
        BufferedInputStream bufferedInputStream = null;
        Object object = null;
        String string3 = null;
        byArray2 = bl4 && byArray == null ? (byArray2 = this.getPngjOrDroppedBytes(string2, string)) : null;
        try {
            if (bl4 && string.indexOf(".png") >= 0 && this.pngjCache == null && !this.vwr.getBoolean(603979960)) {
                this.pngjCache = new Hashtable<String, Object>();
            }
            if (byArray2 == null) {
                boolean bl5;
                int n;
                boolean bl6;
                boolean bl7 = string.indexOf("?POST?_PNGJBIN_") >= 0;
                boolean bl8 = bl6 = bl7 || string.indexOf("?POST?_PNGJ_") >= 0;
                if (string.indexOf("?POST?_PNG_") > 0 || bl6) {
                    String[] stringArray = new String[1];
                    byte[] byArray3 = this.vwr.getImageAsBytes(bl6 ? "PNGJ" : "PNG", 0, 0, -1, stringArray);
                    if (stringArray[0] != null) {
                        return stringArray[0];
                    }
                    if (bl7) {
                        byArray = byArray3;
                        string = PT.rep(string, "?_", "=_");
                    } else {
                        string = new SB().append(string).append("=").appendSB(Base64.getBase64(byArray3)).toString();
                    }
                }
                boolean bl9 = (n = OC.urlTypeIndex(string)) >= 0;
                String string4 = null;
                if (bl9 && (n = string.indexOf("?POST?")) >= 0) {
                    string4 = string.substring(n + 6);
                    string = string.substring(0, n);
                }
                boolean bl10 = bl5 = this.appletDocumentBaseURL != null;
                if (bl5 || bl9) {
                    URL uRL;
                    if (bl5 && bl9 && this.appletProxy != null) {
                        string = String.valueOf(this.appletProxy) + "?url=" + this.urlEncode(string);
                    }
                    URL uRL2 = uRL = bl5 ? new URL(this.appletDocumentBaseURL, string, null) : new URL(null, string, null);
                    if (bl2) {
                        return null;
                    }
                    string = uRL.toString();
                    if (bl && string.toLowerCase().indexOf("password") < 0) {
                        Logger.info("FileManager opening url " + string);
                    }
                    object = this.vwr.apiPlatform.getURLContents(uRL, byArray, string4, false);
                    byte[] byArray4 = null;
                    if (object instanceof SB) {
                        SB sB = (SB)object;
                        if (bl3 && !Rdr.isBase64(sB)) {
                            return Rdr.getBR(sB.toString());
                        }
                        byArray4 = Rdr.getBytesFromSB(sB);
                    } else if (AU.isAB(object)) {
                        byArray4 = (byte[])object;
                    }
                    if (byArray4 != null) {
                        object = Rdr.getBIS(byArray4);
                    }
                } else if (!bl4 || (byArray2 = (byte[])this.cacheGet(string, true)) == null) {
                    if (bl) {
                        Logger.info("FileManager opening file " + string);
                    }
                    object = this.vwr.apiPlatform.getBufferedFileInputStream(string);
                }
                if (object instanceof String) {
                    return object;
                }
            }
            bufferedInputStream = byArray2 == null ? (BufferedInputStream)object : Rdr.getBIS(byArray2);
            if (!bl2) return bufferedInputStream;
            bufferedInputStream.close();
            return null;
        }
        catch (Exception exception) {
            try {
                if (bufferedInputStream == null) return "" + exception;
                bufferedInputStream.close();
                return "" + exception;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return "" + exception;
        }
    }

    public static BufferedReader getBufferedReaderForResource(Viewer viewer, Object object, String string, String string2) throws IOException {
        URL uRL = object.getClass().getResource(string2);
        if (uRL == null) {
            System.err.println("Couldn't find file: " + string + string2);
            throw new IOException();
        }
        if (viewer == null || !viewer.async) {
            return Rdr.getBufferedReader(new BufferedInputStream((InputStream)uRL.getContent()), null);
        }
        String string3 = string2 = uRL == null ? viewer.vwrOptions.get("codePath") + string + string2 : uRL.getFile();
        if (viewer.async) {
            Object object2 = viewer.fm.cacheGet(string2, false);
            if (object2 == null) {
                throw new JmolAsyncException(string2);
            }
            return Rdr.getBufferedReader(Rdr.getBIS((byte[])object2), null);
        }
        return (BufferedReader)viewer.fm.getBufferedReaderOrErrorMessageFromName(string2, new String[2], false, true);
    }

    private String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public String getEmbeddedFileState(String string, boolean bl, String string2) {
        String[] stringArray = this.getZipDirectory(string, false, bl);
        if (stringArray.length == 0) {
            String string3 = this.vwr.getFileAsString4(string, -1, false, true, false, "file");
            return string3.indexOf("**** Jmol Embedded Script ****") < 0 ? "" : FileManager.getEmbeddedScript(string3);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].indexOf(string2) >= 0) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = String.valueOf(string) + "|" + stringArray[n];
                String[] stringArray3 = stringArray2;
                this.getFileDataAsString(stringArray3, -1, false, false, false);
                return stringArray3[1];
            }
            ++n;
        }
        return "";
    }

    Object getFullPathNameOrError(String string, boolean bl, String[] stringArray) {
        String[] stringArray2 = this.getClassifiedName(JC.fixProtocol(string), true);
        if (stringArray2 == null || stringArray2[0] == null || stringArray2.length < 2) {
            String[] stringArray3 = new String[2];
            stringArray3[1] = "cannot read file name: " + string;
            return stringArray3;
        }
        String string2 = stringArray2[0];
        String string3 = FileManager.fixDOSName(stringArray2[0]);
        string2 = Rdr.getZipRoot(string2);
        Object object = this.getBufferedInputStreamOrErrorMessageFromName(string2, string3, false, !bl, null, false, !bl);
        stringArray[0] = string3;
        if (object instanceof String) {
            stringArray[1] = (String)object;
        }
        return object;
    }

    public Object getBufferedReaderOrErrorMessageFromName(String string, String[] stringArray, boolean bl, boolean bl2) {
        String[] stringArray2;
        byte[] byArray;
        Object object = this.cacheGet(string = JC.fixProtocol(string), false);
        boolean bl3 = AU.isAB(object);
        byte[] byArray2 = byArray = bl3 ? (byte[])object : null;
        if (string.startsWith("cache://")) {
            if (object == null) {
                return "cannot read " + string;
            }
            if (bl3) {
                byArray = (byte[])object;
            } else {
                return Rdr.getBR((String)object);
            }
        }
        if ((stringArray2 = this.getClassifiedName(string, true)) == null) {
            return "cannot read file name: " + string;
        }
        if (stringArray != null) {
            stringArray[0] = FileManager.fixDOSName(stringArray2[0]);
        }
        return this.getUnzippedReaderOrStreamFromName(stringArray2[0], byArray, false, bl, false, bl2, null);
    }

    public Object getUnzippedReaderOrStreamFromName(String string, Object object, boolean bl, boolean bl2, boolean bl3, boolean bl4, Map<String, Object> map) {
        Object object2;
        if (bl4 && object == null) {
            Object object3 = string.endsWith(".spt") ? new String[3] : (object2 = string.indexOf(".spardir") < 0 ? null : this.spartanUtil().getFileList(string, bl3));
            if (object2 != null) {
                return object2;
            }
        }
        string = JC.fixProtocol(string);
        if (object == null) {
            byte[] byArray = this.getCachedPngjBytes(string);
            object = byArray;
            if (byArray != null && map != null) {
                map.put("sourcePNGJ", Boolean.TRUE);
            }
        }
        string = string.replace("#_DOCACHE_", "");
        object2 = string;
        String[] stringArray = null;
        if (string.indexOf("|") >= 0) {
            stringArray = PT.split(string.replace('\\', '/'), "|");
            if (object == null) {
                Logger.info("FileManager opening zip " + string);
            }
            string = stringArray[0];
        }
        BufferedInputStream bufferedInputStream = object == null ? this.getBufferedInputStreamOrErrorMessageFromName(string, (String)object2, true, false, null, !bl2, true) : (AU.isAB(object) ? Rdr.getBIS((byte[])object) : (BufferedInputStream)object);
        try {
            if (bufferedInputStream instanceof String || bufferedInputStream instanceof BufferedReader) {
                return bufferedInputStream;
            }
            BufferedInputStream bufferedInputStream2 = bufferedInputStream;
            if (Rdr.isGzipS(bufferedInputStream2)) {
                bufferedInputStream2 = Rdr.getUnzippedInputStream(this.vwr.getJzt(), bufferedInputStream2);
            } else if (Rdr.isBZip2S(bufferedInputStream2)) {
                bufferedInputStream2 = Rdr.getUnzippedInputStreamBZip2(this.vwr.getJzt(), bufferedInputStream2);
            }
            if (bl2 && stringArray == null) {
                return bufferedInputStream2;
            }
            if (Rdr.isCompoundDocumentS(bufferedInputStream2)) {
                CompoundDocument compoundDocument = (CompoundDocument)Interface.getInterface("javajs.util.CompoundDocument", this.vwr, "file");
                compoundDocument.setDocStream(this.vwr.getJzt(), bufferedInputStream2);
                String string2 = compoundDocument.getAllDataFiles("Molecule", "Input").toString();
                return bl2 ? Rdr.getBIS(string2.getBytes()) : Rdr.getBR(string2);
            }
            if (Rdr.isMessagePackS(bufferedInputStream2) || Rdr.isPickleS(bufferedInputStream2)) {
                return bufferedInputStream2;
            }
            if (Rdr.isZipS(bufferedInputStream2 = Rdr.getPngZipStream(bufferedInputStream2, true))) {
                if (bl) {
                    return this.vwr.getJzt().newZipInputStream(bufferedInputStream2);
                }
                Object object4 = this.vwr.getJzt().getZipFileDirectory(bufferedInputStream2, stringArray, 1, bl2);
                return object4 instanceof String ? Rdr.getBR((String)object4) : object4;
            }
            return bl2 ? bufferedInputStream2 : Rdr.getBufferedReader(bufferedInputStream2, null);
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    public String[] getZipDirectory(String string, boolean bl, boolean bl2) {
        Object object = this.getBufferedInputStreamOrErrorMessageFromName(string, string, false, false, null, false, bl2);
        return this.vwr.getJzt().getZipDirectoryAndClose((BufferedInputStream)object, bl ? "JmolManifest" : null);
    }

    public Object getFileAsBytes(String string, OC oC) {
        Object object;
        if (string == null) {
            return null;
        }
        String string2 = string;
        String[] stringArray = null;
        if (string.indexOf("|") >= 0) {
            stringArray = PT.split(string, "|");
            string = stringArray[0];
        }
        byte[] byArray = object = stringArray == null ? null : this.getPngjOrDroppedBytes(string2, string);
        if (object == null) {
            Object object2 = this.getBufferedInputStreamOrErrorMessageFromName(string, string2, false, false, null, false, true);
            if (object2 instanceof String) {
                return "Error:" + object2;
            }
            try {
                BufferedInputStream bufferedInputStream = (BufferedInputStream)object2;
                object = oC != null || stringArray == null || stringArray.length <= 1 || !Rdr.isZipS(bufferedInputStream) && !Rdr.isPngZipStream(bufferedInputStream) ? Rdr.getStreamAsBytes(bufferedInputStream, oC) : this.vwr.getJzt().getZipFileContentsAsBytes(bufferedInputStream, stringArray, 1);
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                return exception.toString();
            }
        }
        if (oC == null || !AU.isAB(object)) {
            return object;
        }
        oC.write((byte[])object, 0, -1);
        return String.valueOf(((byte[])object).length) + " bytes";
    }

    public Map<String, Object> getFileAsMap(String string, String string2) {
        Object object;
        String[] stringArray;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (string == null) {
            stringArray = new String[1];
            byte[] byArray = this.vwr.getImageAsBytes(string2, -1, -1, -1, stringArray);
            if (stringArray[0] != null) {
                hashtable.put("_ERROR_", stringArray[0]);
                return hashtable;
            }
            object = Rdr.getBIS(byArray);
        } else {
            stringArray = new String[2];
            object = this.getFullPathNameOrError(string, true, stringArray);
            if (object instanceof String) {
                hashtable.put("_ERROR_", object);
                return hashtable;
            }
            if (!this.checkSecurity(stringArray[0])) {
                hashtable.put("_ERROR_", "java.io. Security exception: cannot read file " + stringArray[0]);
                return hashtable;
            }
        }
        try {
            this.vwr.getJzt().readFileAsMap((BufferedInputStream)object, hashtable, string);
        }
        catch (Exception exception) {
            hashtable.clear();
            hashtable.put("_ERROR_", "" + exception);
        }
        return hashtable;
    }

    public boolean getFileDataAsString(String[] stringArray, int n, boolean bl, boolean bl2, boolean bl3) {
        stringArray[1] = "";
        String string = stringArray[0];
        if (string == null) {
            return false;
        }
        Object object = this.getBufferedReaderOrErrorMessageFromName(string, stringArray, false, bl);
        if (object instanceof String) {
            stringArray[1] = (String)object;
            return false;
        }
        if (bl3 && !this.checkSecurity(stringArray[0])) {
            stringArray[1] = "java.io. Security exception: cannot read file " + stringArray[0];
            return false;
        }
        try {
            return Rdr.readAllAsString((BufferedReader)object, n, bl2, stringArray, 1);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean checkSecurity(String string) {
        if (!string.startsWith("file:")) {
            return true;
        }
        int n = string.lastIndexOf(47);
        return string.lastIndexOf(":/") != n - 1 && string.indexOf("/.") < 0 && string.lastIndexOf(46) >= string.lastIndexOf(47);
    }

    public boolean loadImage(Object object, String string, boolean bl) {
        boolean bl2;
        Object object2 = null;
        String string2 = null;
        byte[] byArray = null;
        boolean bl3 = bl2 = string != null && string.startsWith("\u0001");
        if (bl2) {
            if (string.equals("\u0001closeall\u0001null")) {
                return this.vwr.loadImageData(Boolean.TRUE, "\u0001closeall", "\u0001closeall", null);
            }
            if ("\u0001close".equals(object)) {
                return this.vwr.loadImageData(Boolean.FALSE, "\u0001close", string, null);
            }
        }
        if (object instanceof Map) {
            Object object3 = object = ((Map)object).containsKey("_DATA_") ? ((Map)object).get("_DATA_") : ((Map)object).get("_IMAGE_");
        }
        if (object instanceof SV) {
            object = ((SV)object).value;
        }
        String string3 = object instanceof String ? (String)object : null;
        boolean bl4 = false;
        if (string3 != null && string3.startsWith(";base64,")) {
            byArray = Base64.decodeBase64(string3);
        } else if (object instanceof BArray) {
            byArray = ((BArray)object).data;
        } else if (string == null || object instanceof String) {
            String[] stringArray = this.getClassifiedName((String)object, true);
            String string4 = string2 = stringArray == null ? "cannot read file name: " + object : FileManager.fixDOSName(stringArray[0]);
            if (stringArray != null) {
                object2 = this.getJzu().getImage(this.vwr, string2, string, bl);
            }
            bl4 = object2 == null;
        } else {
            object2 = object;
        }
        if (byArray != null) {
            object2 = this.getJzu().getImage(this.vwr, byArray, string, true);
            bl4 = false;
        }
        if (object2 instanceof String) {
            string2 = (String)object2;
            object2 = null;
        }
        if (!Viewer.isJS && object2 != null && byArray != null) {
            string2 = ";base64," + Base64.getBase64(byArray).toString();
        }
        if (!Viewer.isJS || bl2 && string2 == null || !bl2 && object2 != null) {
            return this.vwr.loadImageData(object2, string2, string, null);
        }
        return bl4;
    }

    private String[] getClassifiedName(String string, boolean bl) {
        int n;
        String string2;
        boolean bl2;
        if (string == null) {
            return new String[1];
        }
        boolean bl3 = bl2 = this.pathForAllFiles.length() > 0;
        if (string.startsWith("?") || string.startsWith("http://?")) {
            if (!Viewer.isJS && (string = this.vwr.dialogAsk("Load", string, null)) == null) {
                return new String[]{bl ? "#CANCELED#" : null};
            }
            bl2 = false;
        }
        GenericFileInterface genericFileInterface = null;
        URL uRL = null;
        String[] stringArray = null;
        if (string.startsWith("cache://")) {
            stringArray = new String[3];
            stringArray[0] = stringArray[2] = string;
            stringArray[1] = FileManager.stripPath(stringArray[0]);
            return stringArray;
        }
        if ((string = this.vwr.resolveDatabaseFormat(string)).indexOf(":") < 0 && string.indexOf("/") != 0) {
            string = FileManager.addDirectory(this.vwr.getDefaultDirectory(), string);
        }
        if (this.appletDocumentBaseURL == null) {
            if (OC.urlTypeIndex(string) >= 0 || this.vwr.haveAccess(Viewer.ACCESS.NONE) || this.vwr.haveAccess(Viewer.ACCESS.READSPT) && !string.endsWith(".spt") && !string.endsWith("/")) {
                try {
                    uRL = new URL(null, string, null);
                }
                catch (MalformedURLException malformedURLException) {
                    return new String[]{bl ? malformedURLException.toString() : null};
                }
            } else {
                genericFileInterface = this.vwr.apiPlatform.newFile(string);
                string2 = genericFileInterface.getFullPath();
                String string3 = genericFileInterface.getName();
                stringArray = new String[]{string2 == null ? string3 : string2, string3, string2 == null ? string3 : "file:/" + string2.replace('\\', '/')};
            }
        } else {
            try {
                if (string.indexOf(":\\") == 1 || string.indexOf(":/") == 1) {
                    string = "file:/" + string;
                }
                uRL = new URL(this.appletDocumentBaseURL, string, null);
            }
            catch (MalformedURLException malformedURLException) {
                return new String[]{bl ? malformedURLException.toString() : null};
            }
        }
        if (uRL != null) {
            stringArray = new String[3];
            stringArray[0] = stringArray[2] = uRL.toString();
            stringArray[1] = FileManager.stripPath(stringArray[0]);
        }
        if (bl2) {
            string2 = stringArray[0];
            stringArray[0] = String.valueOf(this.pathForAllFiles) + stringArray[1];
            Logger.info("FileManager substituting " + string2 + " --> " + stringArray[0]);
        }
        if (bl && (genericFileInterface != null || OC.urlTypeIndex(stringArray[0]) == 5) && (n = (string2 = genericFileInterface == null ? PT.trim(stringArray[0].substring(5), "/") : stringArray[0]).length() - stringArray[1].length() - 1) > 0) {
            string2 = string2.substring(0, n);
            FileManager.setLocalPath(this.vwr, string2, true);
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String addDirectory(String string, String string2) {
        String string3;
        if (string.length() == 0) {
            return string2;
        }
        int n = string2.length() > 0 ? (int)string2.charAt(0) : 32;
        String string4 = string.toLowerCase();
        if ((string4.endsWith(".zip") || string4.endsWith(".tar")) && n != 124 && n != 47) {
            string = String.valueOf(string) + "|";
        }
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(string));
        if (n != 47 && n != 47) {
            char c = string.charAt(string.length() - 1);
            n = c;
            if (c != '|' && n != 47) {
                string3 = "/";
                return stringBuilder.append(string3).append(string2).toString();
            }
        }
        string3 = "";
        return stringBuilder.append(string3).append(string2).toString();
    }

    String getDefaultDirectory(String string) {
        String[] stringArray = this.getClassifiedName(string, true);
        if (stringArray == null) {
            return "";
        }
        string = FileManager.fixPath(stringArray[0]);
        return string == null ? "" : string.substring(0, string.lastIndexOf("/"));
    }

    private static String fixPath(String string) {
        string = FileManager.fixDOSName(string);
        int n = (string = PT.rep(string, "/./", "/")).lastIndexOf("//") + 1;
        if (n < 1) {
            n = string.indexOf(":/") + 1;
        }
        if (n < 1) {
            n = string.indexOf("/");
        }
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        string = string.substring(n);
        while ((n = string.lastIndexOf("/../")) >= 0) {
            int n2 = string.substring(0, n).lastIndexOf("/");
            if (n2 < 0) {
                return PT.rep(String.valueOf(string2) + string, "/../", "/");
            }
            string = String.valueOf(string.substring(0, n2)) + string.substring(n + 3);
        }
        if (string.length() == 0) {
            string = "/";
        }
        return String.valueOf(string2) + string;
    }

    public String getFilePath(String string, boolean bl, boolean bl2) {
        String[] stringArray = this.getClassifiedName(string, false);
        return stringArray == null || stringArray.length == 1 ? "" : (bl2 ? stringArray[1] : (bl ? stringArray[2] : (stringArray[0] == null ? "" : FileManager.fixDOSName(stringArray[0]))));
    }

    public static GenericFileInterface getLocalDirectory(Viewer viewer, boolean bl) {
        String string = (String)viewer.getP(bl ? "currentLocalPath" : "defaultDirectoryLocal");
        if (bl && string.length() == 0) {
            string = (String)viewer.getP("defaultDirectoryLocal");
        }
        if (string.length() == 0) {
            return viewer.isApplet ? null : viewer.apiPlatform.newFile(System.getProperty("user.dir", "."));
        }
        if (viewer.isApplet && string.indexOf("file:/") == 0) {
            string = string.substring(6);
        }
        GenericFileInterface genericFileInterface = viewer.apiPlatform.newFile(string);
        try {
            return genericFileInterface.isDirectory() ? genericFileInterface : genericFileInterface.getParentAsFile();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setLocalPath(Viewer viewer, String string, boolean bl) {
        while (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        viewer.setStringProperty("currentLocalPath", string);
        if (!bl) {
            viewer.setStringProperty("defaultDirectoryLocal", string);
        }
    }

    public static String getLocalPathForWritingFile(Viewer viewer, String string) {
        if (string.startsWith("http://")) {
            return string;
        }
        if ((string = PT.rep(string, "?", "")).indexOf("file:/") == 0) {
            return string.substring(6);
        }
        if (string.indexOf("/") == 0 || string.indexOf(":") >= 0) {
            return string;
        }
        GenericFileInterface genericFileInterface = null;
        try {
            genericFileInterface = FileManager.getLocalDirectory(viewer, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return genericFileInterface == null ? string : FileManager.fixPath(String.valueOf(genericFileInterface.toString()) + "/" + string);
    }

    public static String fixDOSName(String string) {
        return string.indexOf(":\\") >= 0 ? string.replace('\\', '/') : string;
    }

    public static String stripPath(String string) {
        int n = Math.max(string.lastIndexOf("|"), string.lastIndexOf("/"));
        return string.substring(n + 1);
    }

    public static String determineSurfaceTypeIs(InputStream inputStream) {
        BufferedReader bufferedReader;
        try {
            bufferedReader = Rdr.getBufferedReader(new BufferedInputStream(inputStream), "ISO-8859-1");
        }
        catch (IOException iOException) {
            return null;
        }
        return FileManager.determineSurfaceFileType(bufferedReader);
    }

    public static boolean isScriptType(String string) {
        return PT.isOneOf(string.toLowerCase().substring(string.lastIndexOf(".") + 1), ";pse;spt;png;pngj;jmol;zip;");
    }

    public static boolean isSurfaceType(String string) {
        return PT.isOneOf(string.toLowerCase().substring(string.lastIndexOf(".") + 1), ";jvxl;kin;o;msms;map;pmesh;mrc;efvet;cube;obj;dssr;bcif;");
    }

    public static String determineSurfaceFileType(BufferedReader bufferedReader) {
        Object object;
        String string = null;
        if (bufferedReader instanceof Rdr.StreamReader && ((BufferedInputStream)(object = ((Rdr.StreamReader)bufferedReader).getStream())).markSupported()) {
            byte[] byArray;
            block51: {
                block50: {
                    block49: {
                        block48: {
                            ((BufferedInputStream)object).mark(300);
                            byArray = new byte[300];
                            ((BufferedInputStream)object).read(byArray, 0, 300);
                            ((BufferedInputStream)object).reset();
                            if ((byArray[0] & 0xFF) != 131) break block48;
                            return "BCifDensity";
                        }
                        if (byArray[0] != 80 || byArray[1] != 77 || byArray[2] != 1 || byArray[3] != 0) break block49;
                        return "Pmesh";
                    }
                    if (byArray[208] != 77 || byArray[209] != 65 || byArray[210] != 80) break block50;
                    return "Mrc";
                }
                if (byArray[0] != 20 || byArray[1] != 0 || byArray[2] != 0 || byArray[3] != 0) break block51;
                return "DelPhi";
            }
            try {
                if (byArray[36] == 0 && byArray[37] == 100) {
                    return "Dsn6";
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = null;
        try {
            object = new LimitedLineReader(bufferedReader, 16000);
            string = ((LimitedLineReader)object).getHeader(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object == null || string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf(0);
        if (n >= 0) {
            if (string.charAt(0) == '\u0083') {
                return "BCifDensity";
            }
            if (string.indexOf(PMESH_BINARY_MAGIC_NUMBER) == 0) {
                return "Pmesh";
            }
            if (string.indexOf("MAP ") == 208) {
                return "Mrc";
            }
            if (string.indexOf(DELPHI_BINARY_MAGIC_NUMBER) == 0) {
                return "DelPhi";
            }
            if (string.length() > 37 && (string.charAt(36) == '\u0000' && string.charAt(37) == 'd' || string.charAt(36) == '\u0000' && string.charAt(37) == 'd')) {
                return "Dsn6";
            }
        }
        switch (string.charAt(0)) {
            case '@': {
                if (string.indexOf("@text") != 0) break;
                return "Kinemage";
            }
            case '#': {
                if (string.indexOf(".obj") >= 0) {
                    return "Obj";
                }
                if (string.indexOf("MSMS") < 0) break;
                return "Msms";
            }
            case '&': {
                if (string.indexOf("&plot") != 0) break;
                return "Jaguar";
            }
            case '\n': 
            case '\r': {
                if (string.indexOf("ZYX") < 0) break;
                return "Xplor";
            }
        }
        if (string.indexOf("Here is your gzipped map") >= 0) {
            return "UPPSALA" + string;
        }
        if (string.startsWith("data_SERVER")) {
            return "CifDensity";
        }
        if (string.startsWith("4MESHC")) {
            return "Pmesh4";
        }
        if (string.indexOf("! nspins") >= 0) {
            return "CastepDensity";
        }
        if (string.indexOf("<jvxl") >= 0 && string.indexOf("<?xml") >= 0) {
            return "JvxlXml";
        }
        if (string.indexOf("#JVXL+") >= 0) {
            return "Jvxl+";
        }
        if (string.indexOf("#JVXL") >= 0) {
            return "Jvxl";
        }
        if (string.indexOf("#JmolPmesh") >= 0) {
            return "Pmesh";
        }
        if (string.indexOf("#obj") >= 0) {
            return "Obj";
        }
        if (string.indexOf("#pmesh") >= 0) {
            return "Obj";
        }
        if (string.indexOf("<efvet ") >= 0) {
            return "Efvet";
        }
        if (string.indexOf("usemtl") >= 0) {
            return "Obj";
        }
        if (string.indexOf("# object with") == 0) {
            return "Nff";
        }
        if (string.indexOf("BEGIN_DATAGRID_3D") >= 0 || string.indexOf("BEGIN_BANDGRID_3D") >= 0) {
            return "Xsf";
        }
        if (string.indexOf("tiles in x, y") >= 0) {
            return "Ras3D";
        }
        if (string.indexOf(" 0.00000e+00 0.00000e+00      0      0\n") >= 0) {
            return "Uhbd";
        }
        string = ((LimitedLineReader)object).readLineWithNewline();
        if (string.indexOf("object 1 class gridpositions counts") == 0) {
            return "Apbs";
        }
        String[] stringArray = PT.getTokens(string);
        String string2 = ((LimitedLineReader)object).readLineWithNewline();
        if (stringArray.length == 2 && PT.parseInt(stringArray[0]) == 3 && PT.parseInt(stringArray[1]) != Integer.MIN_VALUE && (stringArray = PT.getTokens(string2)).length == 3 && PT.parseInt(stringArray[0]) != Integer.MIN_VALUE && PT.parseInt(stringArray[1]) != Integer.MIN_VALUE && PT.parseInt(stringArray[2]) != Integer.MIN_VALUE) {
            return "PltFormatted";
        }
        String string3 = ((LimitedLineReader)object).readLineWithNewline();
        if (string.startsWith("v ") && string2.startsWith("v ") && string3.startsWith("v ")) {
            return "Obj";
        }
        int n2 = PT.parseInt(string3);
        if (n2 == Integer.MIN_VALUE) {
            return string3.indexOf("+") == 0 ? "Jvxl+" : null;
        }
        stringArray = PT.getTokens(string3);
        if (stringArray[0].indexOf(".") > 0) {
            return string3.length() >= 60 || stringArray.length != 3 ? null : "VaspChgcar";
        }
        if (n2 >= 0) {
            return stringArray.length == 4 || stringArray.length == 5 && stringArray[4].equals("1") ? "Cube" : null;
        }
        n2 = -n2;
        int n3 = 4 + n2;
        while (--n3 >= 0) {
            string = ((LimitedLineReader)object).readLineWithNewline();
            if (string != null) continue;
            return null;
        }
        n3 = PT.parseInt(string);
        if (n3 == Integer.MIN_VALUE) {
            return null;
        }
        return n3 < 0 ? "Jvxl" : "Cube";
    }

    public static String getManifestScriptPath(String string) {
        String string2;
        if (string.indexOf("$SCRIPT_PATH$") >= 0) {
            return "";
        }
        String string3 = string2 = string.indexOf(10) >= 0 ? "\n" : "\r";
        if (string.indexOf(".spt") >= 0) {
            String[] stringArray = PT.split(string, string2);
            int n = stringArray.length;
            while (--n >= 0) {
                if (stringArray[n].indexOf(".spt") < 0) continue;
                return "|" + PT.trim(stringArray[n], "\r\n \t");
            }
        }
        return null;
    }

    public static String getEmbeddedScript(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf("**** Jmol Embedded Script ****");
        if (n < 0) {
            return string;
        }
        int n2 = string.lastIndexOf("/*", n);
        int n3 = string.indexOf(String.valueOf(string.charAt(n2 + 2) == '*' ? "*" : "") + "*/", n);
        if (n2 >= 0 && n3 >= n) {
            string = String.valueOf(string.substring(n + "**** Jmol Embedded Script ****".length(), n3)) + "\n";
        }
        while ((n2 = string.indexOf(JPEG_CONTINUE_STRING)) >= 0) {
            string = String.valueOf(string.substring(0, n2)) + string.substring(n2 + JPEG_CONTINUE_STRING.length() + 4);
        }
        if (Logger.debugging) {
            Logger.debug(string);
        }
        return string;
    }

    public static void getFileReferences(String string, Lst<String> lst) {
        int n = 0;
        while (n < scriptFilePrefixes.length) {
            String string2 = scriptFilePrefixes[n];
            int n2 = -1;
            while ((n2 = string.indexOf(string2, n2 + 1)) >= 0) {
                String string3 = PT.getQuotedStringAt(string, n2);
                if (string3.indexOf("::") >= 0) {
                    string3 = PT.split(string3, "::")[1];
                }
                lst.addLast(string3);
            }
            ++n;
        }
    }

    public static String setScriptFileReferences(String string, String string2, String string3, String string4) {
        if (string2 != null) {
            string = FileManager.setScriptFileRefs(string, string2, true);
        }
        if (string3 != null) {
            string = FileManager.setScriptFileRefs(string, string3, false);
        }
        string = PT.rep(string, "\u0001\"", "\"");
        if (string4 != null) {
            while (string4.endsWith("/")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            int n = 0;
            while (n < scriptFilePrefixes.length) {
                String string5 = scriptFilePrefixes[n];
                string = PT.rep(string, String.valueOf(string5) + ".", String.valueOf(string5) + string4);
                ++n;
            }
        }
        return string;
    }

    private static String setScriptFileRefs(String string, String string2, boolean bl) {
        if (string2 == null) {
            return string;
        }
        boolean bl2 = string2.length() == 0;
        Lst<String> lst = new Lst<String>();
        FileManager.getFileReferences(string, lst);
        Lst<String> lst2 = new Lst<String>();
        Lst<String> lst3 = new Lst<String>();
        int n = lst.size();
        int n2 = 0;
        while (n2 < n) {
            String string3 = (String)lst.get(n2);
            String string4 = string3;
            if (bl == OC.isLocal(string4)) {
                int n3;
                int n4 = n3 = bl2 ? -1 : string4.indexOf("/" + string2 + "/");
                if (n3 >= 0) {
                    string4 = string4.substring(n3 + 1);
                } else {
                    n3 = string4.lastIndexOf("/");
                    if (n3 < 0 && !bl2) {
                        string4 = "/" + string4;
                    }
                    if (n3 < 0 || bl2) {
                        ++n3;
                    }
                    string4 = String.valueOf(string2) + string4.substring(n3);
                }
            }
            Logger.info("FileManager substituting " + string3 + " --> " + string4);
            lst2.addLast("\"" + string3 + "\"");
            lst3.addLast("\u0001\"" + string4 + "\"");
            ++n2;
        }
        return PT.replaceStrings(string, lst2, lst3);
    }

    void cachePut(String string, Object object) {
        string = FileManager.fixDOSName(string);
        if (Logger.debugging) {
            Logger.debug("cachePut " + string);
        }
        if (object == null || "".equals(object)) {
            this.cache.remove(string);
            return;
        }
        this.cache.put(string, object);
        this.getCachedPngjBytes(string);
    }

    public Object cacheGet(String string, boolean bl) {
        int n = (string = FileManager.fixDOSName(string)).indexOf("|");
        if (n >= 0 && !string.endsWith("##JmolSurfaceInfo##")) {
            string = string.substring(0, n);
        }
        string = this.getFilePath(string, true, false);
        Object object = null;
        object = this.cache.get(string);
        if (object != null) {
            Logger.info("cacheGet " + string);
        }
        return bl && object instanceof String ? null : object;
    }

    void cacheClear() {
        Logger.info("cache cleared");
        this.cache.clear();
        if (this.pngjCache == null) {
            return;
        }
        this.pngjCache = null;
        Logger.info("PNGJ cache cleared");
    }

    public int cacheFileByNameAdd(String string, boolean bl) {
        Object object;
        if (string == null || !bl && string.equalsIgnoreCase("")) {
            this.cacheClear();
            return -1;
        }
        if (bl) {
            object = this.getFileAsBytes(string = JC.fixProtocol(this.vwr.resolveDatabaseFormat(string)), null);
            if (object instanceof String) {
                return 0;
            }
            this.cachePut(string, object);
        } else {
            if (string.endsWith("*")) {
                return AU.removeMapKeys(this.cache, string.substring(0, string.length() - 1));
            }
            object = this.cache.remove(FileManager.fixDOSName(string));
        }
        return object == null ? 0 : (object instanceof String ? ((String)object).length() : ((byte[])object).length);
    }

    public Map<String, Integer> cacheList() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (Map.Entry<String, Object> entry : this.cache.entrySet()) {
            hashtable.put(entry.getKey(), AU.isAB(entry.getValue()) ? ((byte[])entry.getValue()).length : entry.getValue().toString().length());
        }
        return hashtable;
    }

    public String getCanonicalName(String string) {
        String[] stringArray = this.getClassifiedName(string, true);
        return stringArray == null ? string : stringArray[2];
    }

    public void recachePngjBytes(String string, byte[] byArray) {
        if (this.pngjCache == null || !this.pngjCache.containsKey(string)) {
            return;
        }
        this.pngjCache.put(string, byArray);
        Logger.info("PNGJ recaching " + string + " (" + byArray.length + ")");
    }

    private byte[] getPngjOrDroppedBytes(String string, String string2) {
        byte[] byArray = this.getCachedPngjBytes(string);
        return byArray == null ? (byte[])this.cacheGet(string2, true) : byArray;
    }

    private byte[] getCachedPngjBytes(String string) {
        return string == null || this.pngjCache == null || string.indexOf(".png") < 0 ? null : this.getJzu().getCachedPngjBytes(this, string);
    }

    @Override
    public String postByteArray(String string, byte[] byArray) {
        if (string.startsWith("cache://")) {
            this.cachePut(string, byArray);
            return "OK " + byArray.length + "cached";
        }
        Object object = this.getBufferedInputStreamOrErrorMessageFromName(string, null, false, false, byArray, false, true);
        if (object instanceof String) {
            return (String)object;
        }
        try {
            object = Rdr.getStreamAsBytes((BufferedInputStream)object, null);
        }
        catch (IOException iOException) {
            try {
                ((BufferedInputStream)object).close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        return object == null ? "" : Rdr.fixUTF((byte[])object);
    }
}

