/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java.impl;

import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.java.JavaHeapFragment;
import com.sun.tools.visualvm.heapviewer.java.impl.Bundle;
import com.sun.tools.visualvm.heapviewer.java.impl.JavaReferencesProvider;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNodeFilter;
import com.sun.tools.visualvm.heapviewer.model.Progress;
import com.sun.tools.visualvm.heapviewer.model.ProgressNode;
import com.sun.tools.visualvm.heapviewer.model.RootNode;
import com.sun.tools.visualvm.heapviewer.model.TextNode;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewPlugin;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerActions;
import com.sun.tools.visualvm.heapviewer.ui.TreeTableView;
import com.sun.tools.visualvm.heapviewer.ui.TreeTableViewColumn;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SortOrder;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.api.icons.Icons;

class JavaReferencesPlugin
extends HeapViewPlugin {
    private final Heap heap;
    private Instance selected;
    private final TreeTableView objectsView;
    private final Set<Instance> computingInstances = Collections.synchronizedSet(new HashSet());

    public JavaReferencesPlugin(HeapContext context, HeapViewerActions actions) {
        super(Bundle.JavaReferencesPlugin_Name(), Bundle.JavaReferencesPlugin_Description(), Icons.getIcon((String)"ProfilerIcons.NodeReverse"));
        this.heap = context.getFragment().getHeap();
        this.objectsView = new TreeTableView("java_objects_references", context, actions, TreeTableViewColumn.instancesMinimal(this.heap, false)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) {
                Instance _selected = null;
                1 var9_9 = this;
                synchronized (var9_9) {
                    _selected = JavaReferencesPlugin.this.selected;
                }
                if (_selected != null) {
                    if (JavaReferencesPlugin.this.computingInstances.contains(_selected)) {
                        return new HeapViewerNode[]{new ProgressNode()};
                    }
                    JavaReferencesPlugin.this.computingInstances.add(_selected);
                    try {
                        HeapViewerNode[] heapViewerNodeArray;
                        HeapViewerNode[] nodes = JavaReferencesProvider.getNodes(_selected, root, heap, viewID, null, dataTypes, sortOrders, progress);
                        if (nodes == null || nodes.length == 0) {
                            HeapViewerNode[] heapViewerNodeArray2 = new HeapViewerNode[1];
                            heapViewerNodeArray = heapViewerNodeArray2;
                            heapViewerNodeArray2[0] = new TextNode(Bundle.JavaReferencesPlugin_NoReferences());
                        } else {
                            heapViewerNodeArray = nodes;
                        }
                        HeapViewerNode[] heapViewerNodeArray3 = heapViewerNodeArray;
                        return heapViewerNodeArray3;
                    }
                    finally {
                        JavaReferencesPlugin.this.computingInstances.remove(_selected);
                    }
                }
                return new HeapViewerNode[]{new TextNode(Bundle.JavaReferencesPlugin_NoSelection())};
            }
        };
    }

    @Override
    protected JComponent createComponent() {
        return this.objectsView.getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        Instance newSelected;
        Instance instance = newSelected = node == null ? null : HeapViewerNode.getValue(node, DataType.INSTANCE, this.heap);
        if (Objects.equals(this.selected, newSelected)) {
            return;
        }
        JavaReferencesPlugin javaReferencesPlugin = this;
        synchronized (javaReferencesPlugin) {
            this.selected = newSelected;
        }
        this.objectsView.reloadView();
    }

    public static class Provider
    extends HeapViewPlugin.Provider {
        @Override
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (!viewID.startsWith("diff") && JavaHeapFragment.isJavaHeap(context)) {
                return new JavaReferencesPlugin(context, actions);
            }
            return null;
        }
    }
}

