/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts.xy;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartOverlay;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.ui.charts.xy.ProfilerXYItemPainter;

public class ProfilerXYSelectionOverlay
extends ChartOverlay {
    private ChartComponent chart;
    private int selectionExtent;
    private final ConfigurationListener configurationListener = new ConfigurationListener();
    private final SelectionListener selectionListener = new SelectionListener();
    private final Set<Point> selectedValues = new HashSet<Point>();
    private Paint markPaint;
    private Paint oddPerfPaint;
    private Paint evenPerfPaint;
    private Stroke markStroke;
    private Stroke oddPerfStroke;
    private Stroke evenPerfStroke;

    public ProfilerXYSelectionOverlay() {
        this.initDefaultValues();
    }

    public final void registerChart(ChartComponent chartComponent) {
        this.unregisterListener();
        this.chart = chartComponent;
        this.registerListener();
    }

    public final void unregisterChart(ChartComponent chartComponent) {
        this.unregisterListener();
        this.chart = null;
    }

    private void registerListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.addConfigurationListener((ChartConfigurationListener)this.configurationListener);
        this.chart.getSelectionModel().addSelectionListener((ChartSelectionListener)this.selectionListener);
    }

    private void unregisterListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.removeConfigurationListener((ChartConfigurationListener)this.configurationListener);
        this.chart.getSelectionModel().removeSelectionListener((ChartSelectionListener)this.selectionListener);
    }

    private void initDefaultValues() {
        this.markPaint = new Color(80, 80, 80);
        this.oddPerfPaint = Color.BLACK;
        this.evenPerfPaint = Color.WHITE;
        this.markStroke = new BasicStroke(2.8f, 1, 1);
        this.oddPerfStroke = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{1.0f, 3.0f}, 0.0f);
        this.evenPerfStroke = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{1.0f, 3.0f}, 2.0f);
        this.selectionExtent = 3;
    }

    public void paint(Graphics graphics) {
        if (this.selectedValues.isEmpty()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(this.chart.getRenderingHints());
        Iterator<Point> iterator = this.selectedValues.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Point point = iterator.next();
            if (!bl) {
                graphics2D.setPaint(this.evenPerfPaint);
                graphics2D.setStroke(this.evenPerfStroke);
                graphics2D.drawLine(point.x, 0, point.x, this.getHeight());
                graphics2D.setPaint(this.oddPerfPaint);
                graphics2D.setStroke(this.oddPerfStroke);
                graphics2D.drawLine(point.x, 0, point.x, this.getHeight());
                graphics2D.setPaint(this.markPaint);
                graphics2D.setStroke(this.markStroke);
                bl = true;
            }
            graphics2D.fillOval(point.x - this.selectionExtent + 1, point.y - this.selectionExtent + 1, this.selectionExtent * 2 - 1, this.selectionExtent * 2 - 1);
        }
    }

    private void vLineBoundsChanged(Set<Point> set, Set<Point> set2) {
        Point point;
        Point point2 = set.isEmpty() ? null : set.iterator().next();
        Point point3 = point = set2.isEmpty() ? null : set2.iterator().next();
        if (point2 != null) {
            this.repaint(point2.x - this.selectionExtent, 0, this.selectionExtent * 2, this.getHeight());
        }
        if (point != null) {
            this.repaint(point.x - this.selectionExtent, 0, this.selectionExtent * 2, this.getHeight());
        }
    }

    private static void updateSelectedValues(Set<Point> set, List<ItemSelection> list, ChartComponent chartComponent) {
        set.clear();
        for (ItemSelection itemSelection : list) {
            ProfilerXYItemPainter profilerXYItemPainter = (ProfilerXYItemPainter)chartComponent.getPaintersModel().getPainter(itemSelection.getItem());
            LongRect longRect = profilerXYItemPainter.getSelectionBounds(itemSelection, chartComponent.getChartContext());
            set.add(new Point(Utils.checkedInt((double)(longRect.x + (longRect.width >> 2) + 1L)), Utils.checkedInt((double)(longRect.y + (longRect.height >> 2) + 1L))));
        }
    }

    private class SelectionListener
    implements ChartSelectionListener {
        private SelectionListener() {
        }

        public void selectionModeChanged(int n, int n2) {
        }

        public void selectionBoundsChanged(Rectangle rectangle, Rectangle rectangle2) {
        }

        public void selectedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
        }

        public void highlightedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
            HashSet hashSet = new HashSet(ProfilerXYSelectionOverlay.this.selectedValues);
            ProfilerXYSelectionOverlay.updateSelectedValues(ProfilerXYSelectionOverlay.this.selectedValues, list, ProfilerXYSelectionOverlay.this.chart);
            ProfilerXYSelectionOverlay.this.vLineBoundsChanged(hashSet, ProfilerXYSelectionOverlay.this.selectedValues);
        }
    }

    private class ConfigurationListener
    extends ChartConfigurationListener.Adapter {
        private ConfigurationListener() {
        }

        public void contentsUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4, int n, int n2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HashSet hashSet = new HashSet(ProfilerXYSelectionOverlay.this.selectedValues);
                    ProfilerXYSelectionOverlay.updateSelectedValues(ProfilerXYSelectionOverlay.this.selectedValues, ProfilerXYSelectionOverlay.this.chart.getSelectionModel().getHighlightedItems(), ProfilerXYSelectionOverlay.this.chart);
                    ProfilerXYSelectionOverlay.this.vLineBoundsChanged(hashSet, ProfilerXYSelectionOverlay.this.selectedValues);
                }
            });
        }
    }
}

