/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.api.ActionsSupport;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.snaptracer.impl.Bundle;
import org.netbeans.modules.profiler.snaptracer.impl.IdeSnapshot;
import org.netbeans.modules.profiler.snaptracer.impl.TracerController;
import org.netbeans.modules.profiler.snaptracer.impl.TracerModel;
import org.netbeans.modules.profiler.snaptracer.impl.TracerSupportImpl;
import org.netbeans.modules.profiler.snaptracer.impl.TracerView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class IdeSnapshotAction
implements ActionListener {
    private File lastDirectory;

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                File file = IdeSnapshotAction.this.snapshotFile();
                if (file == null) {
                    return;
                }
                IdeSnapshotAction.openSnapshot(FileUtil.toFileObject((File)file));
            }
        });
    }

    static void openSnapshot(final FileObject fileObject) {
        TracerSupportImpl.getInstance().perform(new Runnable(){

            @Override
            public void run() {
                try {
                    FileObject fileObject2 = fileObject.getParent().getFileObject(fileObject.getName(), "log");
                    IdeSnapshot ideSnapshot = new IdeSnapshot(fileObject, fileObject2);
                    IdeSnapshotAction.openSnapshotImpl(ideSnapshot);
                }
                catch (Throwable throwable) {
                    ProfilerDialogs.displayError((String)Bundle.MSG_SnapshotLoadFailedMsg(fileObject.getNameExt(), throwable.getLocalizedMessage()));
                }
            }
        });
    }

    private static void openSnapshotImpl(final IdeSnapshot ideSnapshot) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TracerModel tracerModel = new TracerModel(ideSnapshot);
                TracerController tracerController = new TracerController(tracerModel);
                TopComponent topComponent = IdeSnapshotAction.ui(tracerModel, tracerController, ideSnapshot.getNpssFileObject());
                topComponent.open();
                topComponent.requestActive();
            }
        });
    }

    private static TopComponent ui(TracerModel tracerModel, TracerController tracerController, FileObject fileObject) {
        String string = fileObject.getName();
        IdeSnapshotComponent ideSnapshotComponent = new IdeSnapshotComponent(string, FileUtil.toFile((FileObject)fileObject));
        final JComponent jComponent = new TracerView(tracerModel, tracerController).createComponent();
        ideSnapshotComponent.add(jComponent, "Center");
        InputMap inputMap = ideSnapshotComponent.getInputMap(1);
        ActionMap actionMap = ideSnapshotComponent.getActionMap();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Action action = jComponent.getActionMap().get("filter-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(actionEvent);
                }
            }
        };
        ActionsSupport.registerAction((String)"filter-action-key", (Action)abstractAction, (ActionMap)actionMap, (InputMap)inputMap);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Action action = jComponent.getActionMap().get("find-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(actionEvent);
                }
            }
        };
        ActionsSupport.registerAction((String)"find-action-key", (Action)abstractAction2, (ActionMap)actionMap, (InputMap)inputMap);
        return ideSnapshotComponent;
    }

    private File snapshotFile() {
        Frame frame;
        JFileChooser jFileChooser = IdeSnapshotAction.createFileChooser(this.lastDirectory);
        if (jFileChooser.showOpenDialog(frame = WindowManager.getDefault().getMainWindow()) == 0) {
            this.lastDirectory = jFileChooser.getCurrentDirectory();
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private static JFileChooser createFileChooser(File file) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(Bundle.ACTION_IdeSnapshot_dialog());
        jFileChooser.setDialogType(0);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        String string = Bundle.ACTION_IdeSnapshot_filter();
        String string2 = ".npss";
        Filter filter = Filter.create(string, string2);
        jFileChooser.addChoosableFileFilter(filter);
        return jFileChooser;
    }

    private static abstract class Filter
    extends FileFilter {
        abstract String getExt();

        static Filter create(final String string, final String string2) {
            return new Filter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || Filter.getFileExt(file.getName()).equals(string2);
                }

                @Override
                public String getExt() {
                    return string2;
                }

                @Override
                public String getDescription() {
                    return string + " (*" + string2 + ")";
                }
            };
        }

        private static String getFileExt(String string) {
            int n = string.lastIndexOf(46);
            if (n == -1) {
                return "";
            }
            return string.substring(n);
        }

        private Filter() {
        }
    }

    private static class IdeSnapshotComponent
    extends ProfilerTopComponent {
        IdeSnapshotComponent(String string, File file) {
            this.setDisplayName(string);
            if (file != null) {
                this.putClientProperty("nb.recent.file.path", file);
                this.setToolTipText(file.getAbsolutePath());
            }
            this.setLayout(new BorderLayout());
        }

        public int getPersistenceType() {
            return 2;
        }
    }
}

