/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapdump.impl;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.snapshot.SnapshotCategory;
import com.sun.tools.visualvm.core.ui.DataSourceWindowManager;
import com.sun.tools.visualvm.heapdump.HeapDump;
import com.sun.tools.visualvm.heapdump.impl.HeapDumpImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.filechooser.FileFilter;
import org.openide.util.NbBundle;

public class HeapDumpCategory
extends SnapshotCategory<HeapDump> {
    private static final String HPROF_HEADER = "JAVA PROFILE 1.0";
    private static final long MIN_HPROF_SIZE = 0x100000L;
    private static final String NAME = NbBundle.getMessage(HeapDumpCategory.class, (String)"LBL_Heap_Dumps");
    private static final String PREFIX = "heapdump";
    private static final String SUFFIX = ".hprof";

    public HeapDumpCategory() {
        super(NAME, HeapDump.class, PREFIX, SUFFIX, 20);
    }

    public boolean supportsOpenSnapshot() {
        return true;
    }

    public void openSnapshot(File file) {
        DataSourceWindowManager.sharedInstance().openDataSource((DataSource)new HeapDumpImpl(file, null));
    }

    protected boolean isSnapshot(File file) {
        if (super.isSnapshot(file)) {
            return true;
        }
        return this.checkHprofFile(file);
    }

    private boolean checkHprofFile(File file) {
        try {
            if (file.isFile() && file.canRead() && file.length() > 0x100000L) {
                byte[] prefix = new byte[HPROF_HEADER.length() + 4];
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                raf.readFully(prefix);
                raf.close();
                if (new String(prefix).startsWith(HPROF_HEADER)) {
                    return true;
                }
            }
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        return false;
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || HeapDumpCategory.this.isSnapshot(f);
            }

            @Override
            public String getDescription() {
                String suff = HeapDumpCategory.this.getSuffix();
                return HeapDumpCategory.this.getName() + (suff != null ? " (*" + suff + ", *.*)" : "");
            }
        };
    }
}

