/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.netbeans.lib.profiler.wireprotocol.Command;

public class GetClassFileBytesCommand
extends Command {
    private String[] classes;
    private int[] classLoaderIds;

    public GetClassFileBytesCommand(String[] stringArray, int[] nArray) {
        this();
        this.classes = stringArray;
        this.classLoaderIds = nArray;
    }

    GetClassFileBytesCommand() {
        super(47);
    }

    public int[] getClassLoaderIds() {
        return this.classLoaderIds;
    }

    public String[] getClasses() {
        return this.classes;
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        if (n == 0) {
            return;
        }
        this.classes = new String[n];
        this.classLoaderIds = new int[n];
        for (int i = 0; i < n; ++i) {
            this.classes[i] = objectInputStream.readUTF().replace('/', '.');
            this.classLoaderIds[i] = objectInputStream.readInt();
        }
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.classes == null) {
            objectOutputStream.writeInt(0);
            return;
        }
        int n = this.classes.length;
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeUTF(this.classes[i]);
            objectOutputStream.writeInt(this.classLoaderIds[i]);
        }
        this.classes = null;
        this.classLoaderIds = null;
    }

    public String toString() {
        return super.toString() + " " + this.classes.length + " classes(): " + Arrays.toString(this.classes);
    }
}

