/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.transport.TransportService;

public class SettingsBasedHostsProvider
extends AbstractComponent
implements UnicastHostsProvider {
    public static final Setting<List<String>> DISCOVERY_ZEN_PING_UNICAST_HOSTS_SETTING = Setting.listSetting("discovery.zen.ping.unicast.hosts", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    public static final int LIMIT_FOREIGN_PORTS_COUNT = 1;
    public static final int LIMIT_LOCAL_PORTS_COUNT = 5;
    private final List<String> configuredHosts;
    private final int limitPortCounts;

    public SettingsBasedHostsProvider(Settings settings, TransportService transportService) {
        super(settings);
        if (DISCOVERY_ZEN_PING_UNICAST_HOSTS_SETTING.exists(settings)) {
            this.configuredHosts = DISCOVERY_ZEN_PING_UNICAST_HOSTS_SETTING.get(settings);
            this.limitPortCounts = 1;
        } else {
            this.configuredHosts = transportService.getLocalAddresses();
            this.limitPortCounts = 5;
        }
        this.logger.debug("using initial hosts {}", this.configuredHosts);
    }

    @Override
    public List<TransportAddress> buildDynamicHosts(UnicastHostsProvider.HostsResolver hostsResolver) {
        return hostsResolver.resolveHosts(this.configuredHosts, this.limitPortCounts);
    }
}

