/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pymol;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.util.AU;
import javajs.util.Lst;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class PickleReader {
    private Viewer vwr;
    private GenericBinaryDocument binaryDoc;
    private Lst<Object> stack = new Lst();
    private Lst<Integer> marks = new Lst();
    private Lst<Object> build = new Lst();
    private Map<Object, Object> memo = new Hashtable<Object, Object>();
    private boolean logging;
    private int id;
    private int markCount;
    private int filePt;
    private int emptyListPt;
    private Object thisSection;
    private boolean inMovie;
    private boolean inNames;
    private String thisName;
    private int lastMark;
    private int retrieveCount;
    private static final byte APPEND = 97;
    private static final byte APPENDS = 101;
    private static final byte BINFLOAT = 71;
    private static final byte BININT = 74;
    private static final byte BININT1 = 75;
    private static final byte BININT2 = 77;
    private static final byte BINPUT = 113;
    private static final byte BINSTRING = 84;
    private static final byte BINUNICODE = 87;
    private static final byte BUILD = 98;
    private static final byte EMPTY_DICT = 125;
    private static final byte EMPTY_LIST = 93;
    private static final byte GLOBAL = 99;
    private static final byte LONG_BINPUT = 114;
    private static final byte MARK = 40;
    private static final byte NONE = 78;
    private static final byte OBJ = 111;
    private static final byte SETITEM = 115;
    private static final byte SETITEMS = 117;
    private static final byte SHORT_BINSTRING = 85;
    private static final byte STOP = 46;
    private static final byte BINGET = 104;
    private static final byte LONG_BINGET = 106;
    private static final byte TUPLE = 116;
    private static final byte INT = 73;
    private int ipt = 0;
    byte[] aTemp = new byte[16];

    PickleReader(GenericBinaryDocument genericBinaryDocument, Viewer viewer) {
        this.binaryDoc = genericBinaryDocument;
        this.vwr = viewer;
        this.stack.ensureCapacity(1000);
    }

    private void log(String string) {
        this.vwr.log(String.valueOf(string) + "\u0000");
    }

    Map<String, Object> getMap(boolean bl) throws Exception {
        Map map;
        byte[] byArray;
        int n;
        Object object;
        this.logging = bl;
        this.ipt = 0;
        boolean bl2 = true;
        block29: while (bl2) {
            byte by = this.binaryDoc.readByte();
            ++this.ipt;
            switch (by) {
                case 125: {
                    this.push(new Hashtable());
                    break;
                }
                case 97: {
                    object = this.pop();
                    ((Lst)this.peek()).addLast(object);
                    break;
                }
                case 101: {
                    Lst<Object> lst = this.getObjects(this.getMark());
                    if (this.inNames && this.markCount == 2) {
                        int n2 = (int)this.binaryDoc.getPosition();
                        Lst<Integer> lst2 = new Lst<Integer>();
                        lst2.addLast(this.filePt);
                        lst2.addLast(n2 - this.filePt);
                        lst.addLast(lst2);
                    }
                    ((Lst)this.peek()).addAll(lst);
                    break;
                }
                case 71: {
                    double d = this.binaryDoc.readDouble();
                    this.push(d);
                    break;
                }
                case 74: {
                    n = this.binaryDoc.readIntLE();
                    this.push(n);
                    break;
                }
                case 75: {
                    n = this.binaryDoc.readByte() & 0xFF;
                    this.push(n);
                    break;
                }
                case 77: {
                    n = (this.binaryDoc.readByte() & 0xFF | (this.binaryDoc.readByte() & 0xFF) << 8) & 0xFFFF;
                    this.push(n);
                    break;
                }
                case 113: {
                    n = this.binaryDoc.readByte();
                    this.putMemo(n, false);
                    break;
                }
                case 114: {
                    n = this.binaryDoc.readIntLE();
                    this.putMemo(n, true);
                    break;
                }
                case 104: {
                    n = this.binaryDoc.readByte();
                    object = this.getMemo(n);
                    this.push(object == null ? "BINGET" + ++this.id : object);
                    break;
                }
                case 106: {
                    n = this.binaryDoc.readIntLE();
                    object = this.getMemo(n);
                    this.push(object == null ? "LONG_BINGET" + ++this.id : object);
                    break;
                }
                case 85: {
                    n = this.binaryDoc.readByte() & 0xFF;
                    byArray = new byte[n];
                    this.binaryDoc.readByteArray(byArray, 0, n);
                    if (this.inNames && this.markCount == 3 && this.lastMark == this.stack.size()) {
                        this.thisName = this.bytesToString(byArray);
                        this.filePt = this.emptyListPt;
                    }
                    this.push(byArray);
                    break;
                }
                case 84: {
                    n = this.binaryDoc.readIntLE();
                    byArray = new byte[n];
                    this.binaryDoc.readByteArray(byArray, 0, n);
                    this.push(byArray);
                    break;
                }
                case 87: {
                    n = this.binaryDoc.readIntLE();
                    byArray = new byte[n];
                    this.binaryDoc.readByteArray(byArray, 0, n);
                    this.push(byArray);
                    break;
                }
                case 93: {
                    this.emptyListPt = (int)this.binaryDoc.getPosition() - 1;
                    this.push(new Lst());
                    break;
                }
                case 99: {
                    Lst<Object> lst = new Lst();
                    lst.addLast("global");
                    lst.addLast(this.readStringAsBytes());
                    lst.addLast(this.readStringAsBytes());
                    this.push(lst);
                    break;
                }
                case 98: {
                    object = this.pop();
                    this.build.addLast(object);
                    break;
                }
                case 40: {
                    this.putMark(this.stack.size());
                    break;
                }
                case 78: {
                    this.push(null);
                    break;
                }
                case 111: {
                    this.push(this.getObjects(this.getMark()));
                    break;
                }
                case 115: {
                    object = this.pop();
                    String string = this.bytesToString(this.pop());
                    ((Map)this.peek()).put(string, object);
                    break;
                }
                case 117: {
                    int n3 = this.getMark();
                    Lst<Object> lst = this.getObjects(n3);
                    object = this.peek();
                    if (object instanceof Lst) {
                        n = 0;
                        while (n < lst.size()) {
                            ((Lst)object).addLast(lst.get(n));
                            ++n;
                        }
                        continue block29;
                    }
                    map = (Map)object;
                    n = lst.size();
                    while (--n >= 0) {
                        object = lst.get(n);
                        map.put(this.bytesToString(lst.get(--n)), object);
                    }
                    continue block29;
                }
                case 46: {
                    bl2 = false;
                    break;
                }
                case 116: {
                    this.push(this.getObjects(this.getMark()));
                    break;
                }
                case 73: {
                    String string = this.bytesToString(this.readStringAsBytes());
                    try {
                        this.push(Integer.parseInt(string));
                    }
                    catch (Exception exception) {
                        long l = Long.parseLong(string);
                        this.push((int)(l & 0xFFFFFFFFFFFFFFFFL));
                    }
                    continue block29;
                }
                default: {
                    Logger.error("Pickle reader error: " + by + " " + this.binaryDoc.getPosition());
                }
            }
        }
        if (bl) {
            this.log("");
        }
        Logger.info("PyMOL Pickle reader cached " + this.memo.size() + " tokens; retrieved " + this.retrieveCount);
        map = (Map)this.stack.removeItemAt(0);
        if (map.size() == 0) {
            n = this.stack.size();
            while (--n >= 0) {
                object = this.stack.get(n--);
                byArray = (byte[])this.stack.get(n);
                map.put(this.bytesToString(byArray), object);
            }
        }
        this.memo = null;
        return map;
    }

    private String bytesToString(Object object) {
        try {
            return AU.isAB(object) ? new String((byte[])object, "UTF-8") : object.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private void putMemo(int n, boolean bl) {
        Object object = this.peek();
        if (AU.isAB(object)) {
            object = this.bytesToString((byte[])object);
        }
        if (object instanceof String) {
            if (bl && this.markCount >= 6 || this.markCount == 3 && this.inMovie) {
                return;
            }
            this.memo.put(n, object);
        }
    }

    private Object getMemo(int n) {
        Object object = this.memo.get(n);
        if (object == null) {
            return object;
        }
        ++this.retrieveCount;
        return object;
    }

    private Lst<Object> getObjects(int n) {
        int n2 = this.stack.size() - n;
        Lst<Object> lst = new Lst<Object>();
        lst.ensureCapacity(n2);
        int n3 = n;
        while (n3 < this.stack.size()) {
            lst.addLast(this.stack.get(n3));
            ++n3;
        }
        n3 = this.stack.size();
        while (--n3 >= n) {
            this.stack.removeItemAt(n3);
        }
        return lst;
    }

    private byte[] readStringAsBytes() throws Exception {
        byte by;
        int n = 0;
        byte[] byArray = this.aTemp;
        while ((by = this.binaryDoc.readByte()) != 10) {
            if (n >= byArray.length) {
                byArray = this.aTemp = AU.arrayCopyByte(byArray, byArray.length * 2);
            }
            byArray[n++] = by;
        }
        return AU.arrayCopyByte(byArray, n);
    }

    private void putMark(int n) {
        if (this.logging) {
            this.log("\n " + Integer.toHexString((int)this.binaryDoc.getPosition()) + " [");
        }
        this.lastMark = n;
        this.marks.addLast(this.lastMark);
        ++this.markCount;
        switch (this.markCount) {
            case 2: {
                Object e = this.stack.get(n - 2);
                if (!AU.isAB(e)) break;
                this.thisSection = this.bytesToString((byte[])e);
                this.inMovie = "movie".equals(this.thisSection);
                this.inNames = "names".equals(this.thisSection);
                break;
            }
        }
    }

    private int getMark() {
        return this.marks.removeItemAt(--this.markCount);
    }

    private void push(Object object) {
        if (this.logging && (object instanceof String || object instanceof Double || object instanceof Integer)) {
            this.log((object instanceof String ? "'" + object + "'" : object) + ", ");
        }
        this.stack.addLast(object);
    }

    private Object peek() {
        return this.stack.get(this.stack.size() - 1);
    }

    private Object pop() {
        return this.stack.removeItemAt(this.stack.size() - 1);
    }
}

