/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import java.util.Map;
import javajs.util.BS;
import org.jmol.api.Interface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.api.JmolRepaintManager;
import org.jmol.api.JmolToJSmolInterface;
import org.jmol.modelset.ModelSet;
import org.jmol.render.ShapeRenderer;
import org.jmol.shape.Shape;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.Rectangle;
import org.jmol.viewer.JC;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.Viewer;

public class RepaintManager
implements JmolRepaintManager {
    private Viewer vwr;
    private ShapeManager shapeManager;
    private ShapeRenderer[] renderers;
    private final BS bsTranslucent = BS.newN(37);
    public int holdRepaint = 0;
    private boolean repaintPending;

    @Override
    public void set(Viewer viewer, ShapeManager shapeManager) {
        this.vwr = viewer;
        this.shapeManager = shapeManager;
    }

    @Override
    public boolean isRepaintPending() {
        return this.repaintPending;
    }

    @Override
    public void pushHoldRepaint(String string) {
        ++this.holdRepaint;
    }

    @Override
    public void popHoldRepaint(boolean bl, String string) {
        --this.holdRepaint;
        if (this.holdRepaint <= 0) {
            this.holdRepaint = 0;
            if (bl) {
                this.repaintPending = true;
                this.repaintNow(string);
            }
        }
    }

    @Override
    public synchronized void requestRepaintAndWait(String string) {
        JmolToJSmolInterface jmolToJSmolInterface = null;
        if (jmolToJSmolInterface != null) {
            jmolToJSmolInterface._repaint(this.vwr.html5Applet, false);
            this.repaintDone();
        }
        try {
            this.repaintNow(string);
            this.wait(this.vwr.g.repaintWaitMs);
            if (this.repaintPending) {
                Logger.error("repaintManager requestRepaintAndWait timeout");
                this.repaintDone();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean repaintIfReady(String string) {
        if (this.repaintPending) {
            return false;
        }
        this.repaintPending = true;
        if (this.holdRepaint == 0) {
            this.repaintNow(string);
        }
        return true;
    }

    private void repaintNow(String string) {
        if (!this.vwr.haveDisplay) {
            return;
        }
        this.vwr.apiPlatform.repaint(this.vwr.display);
    }

    @Override
    public synchronized void repaintDone() {
        this.repaintPending = false;
        this.notify();
    }

    @Override
    public void clear(int n) {
        if (this.renderers == null) {
            return;
        }
        if (n >= 0) {
            this.renderers[n] = null;
        } else {
            int n2 = 0;
            while (n2 < 37) {
                this.renderers[n2] = null;
                ++n2;
            }
        }
    }

    private ShapeRenderer getRenderer(int n) {
        if (this.renderers[n] != null) {
            return this.renderers[n];
        }
        String string = String.valueOf(JC.getShapeClassName(n, true)) + "Renderer";
        ShapeRenderer shapeRenderer = (ShapeRenderer)Interface.getInterface(string, this.vwr, "render");
        if (shapeRenderer == null) {
            return null;
        }
        shapeRenderer.setViewerG3dShapeID(this.vwr, n);
        this.renderers[n] = shapeRenderer;
        return this.renderers[n];
    }

    @Override
    public void render(GData gData, ModelSet modelSet, boolean bl, int[] nArray) {
        JmolRendererInterface jmolRendererInterface = (JmolRendererInterface)((Object)gData);
        if (this.renderers == null) {
            this.renderers = new ShapeRenderer[37];
        }
        this.getAllRenderers();
        try {
            Object object;
            boolean bl2 = this.vwr.getBoolean(603979934);
            jmolRendererInterface.renderBackground(null);
            if (bl) {
                this.bsTranslucent.clearAll();
                if (nArray != null) {
                    jmolRendererInterface.renderCrossHairs(nArray, this.vwr.getScreenWidth(), this.vwr.getScreenHeight(), this.vwr.tm.getNavigationOffset(), this.vwr.tm.navigationDepthPercent);
                }
                if ((object = this.vwr.getRubberBandSelection()) != null && jmolRendererInterface.setC(this.vwr.cm.colixRubberband)) {
                    jmolRendererInterface.drawRect(((Rectangle)object).x, ((Rectangle)object).y, 0, 0, ((Rectangle)object).width, ((Rectangle)object).height);
                }
                this.vwr.noFrankEcho = true;
            }
            object = null;
            int n = 0;
            while (n < 37 && gData.currentlyRendering) {
                Shape shape = this.shapeManager.getShape(n);
                if (shape != null) {
                    if (bl2) {
                        object = "rendering " + JC.getShapeClassName(n, false);
                        Logger.startTimer((String)object);
                    }
                    if ((bl || this.bsTranslucent.get(n)) && this.getRenderer(n).renderShape(jmolRendererInterface, modelSet, shape)) {
                        this.bsTranslucent.set(n);
                    }
                    if (bl2) {
                        Logger.checkTimer((String)object, false);
                    }
                }
                ++n;
            }
            jmolRendererInterface.renderAllStrings(null);
        }
        catch (Exception exception) {
            if (!Viewer.isJS) {
                exception.printStackTrace();
            }
            if (this.vwr.async && "Interface".equals(exception.getMessage())) {
                throw new NullPointerException();
            }
            Logger.error("rendering error? " + exception);
        }
    }

    private void getAllRenderers() {
        boolean bl = true;
        int n = 0;
        while (n < 37) {
            if (this.shapeManager.getShape(n) != null && this.getRenderer(n) == null) {
                this.repaintPending = !this.vwr.async;
                bl = this.repaintPending;
            }
            ++n;
        }
        if (!bl) {
            throw new NullPointerException();
        }
    }

    @Override
    public String renderExport(GData gData, ModelSet modelSet, Map<String, Object> map) {
        boolean bl;
        this.shapeManager.finalizeAtoms(null, true);
        JmolRendererInterface jmolRendererInterface = this.vwr.initializeExporter(map);
        boolean bl2 = bl = jmolRendererInterface != null;
        if (!bl) {
            Logger.error("Cannot export " + map.get("type"));
            return null;
        }
        if (this.renderers == null) {
            this.renderers = new ShapeRenderer[37];
        }
        this.getAllRenderers();
        String string = null;
        try {
            boolean bl3 = this.vwr.getBoolean(603979934);
            jmolRendererInterface.renderBackground(jmolRendererInterface);
            int n = 0;
            while (n < 37) {
                Shape shape = this.shapeManager.getShape(n);
                if (shape != null) {
                    if (bl3) {
                        string = "rendering " + JC.getShapeClassName(n, false);
                        Logger.startTimer(string);
                    }
                    this.getRenderer(n).renderShape(jmolRendererInterface, modelSet, shape);
                    if (bl3) {
                        Logger.checkTimer(string, false);
                    }
                }
                ++n;
            }
            jmolRendererInterface.renderAllStrings(jmolRendererInterface);
            string = jmolRendererInterface.finalizeOutput();
        }
        catch (Exception exception) {
            if (!Viewer.isJS) {
                exception.printStackTrace();
            }
            Logger.error("rendering error? " + exception);
        }
        return string;
    }
}

