// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * This interface allows applications to monitor changes the state
 * of the registry.
 **/
public interface RegistryObserver extends com.zeroc.Ice.Object
{
    /**
     * The <tt>registryInit</tt> operation is called after registration of
     * an observer to indicate the state of the registries.
     * @param registries The current state of the registries.
     * @param current The Current object for the invocation.
     **/
    void registryInit(RegistryInfo[] registries, com.zeroc.Ice.Current current);

    /**
     * The <tt>nodeUp</tt> operation is called to notify an observer that a node
     * came up.
     * @param node The node state.
     * @param current The Current object for the invocation.
     **/
    void registryUp(RegistryInfo node, com.zeroc.Ice.Current current);

    /**
     * The <tt>nodeDown</tt> operation is called to notify an observer that a node
     * went down.
     * @param name The node name.
     * @param current The Current object for the invocation.
     **/
    void registryDown(String name, com.zeroc.Ice.Current current);

    static final String[] _iceIds =
    {
        "::Ice::Object",
        "::IceGrid::RegistryObserver"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::IceGrid::RegistryObserver";
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_registryInit(RegistryObserver obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        RegistryInfo[] iceP_registries;
        iceP_registries = RegistryInfoSeqHelper.read(istr);
        inS.endReadParams();
        obj.registryInit(iceP_registries, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_registryUp(RegistryObserver obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        RegistryInfo iceP_node;
        iceP_node = RegistryInfo.ice_read(istr);
        inS.endReadParams();
        obj.registryUp(iceP_node, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_registryDown(RegistryObserver obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        iceP_name = istr.readString();
        inS.endReadParams();
        obj.registryDown(iceP_name, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    final static String[] _iceOps =
    {
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "registryDown",
        "registryInit",
        "registryUp"
    };

    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 1:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 2:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 3:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
            case 4:
            {
                return _iceD_registryDown(this, in, current);
            }
            case 5:
            {
                return _iceD_registryInit(this, in, current);
            }
            case 6:
            {
                return _iceD_registryUp(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
