/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.internal;

import com.sun.jmx.remote.internal.IIOPProxy;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public final class IIOPHelper {
    private static final String IMPL_CLASS = "com.sun.jmx.remote.protocol.iiop.IIOPProxyImpl";
    private static final IIOPProxy proxy = AccessController.doPrivileged(new PrivilegedAction<IIOPProxy>(){

        @Override
        public IIOPProxy run() {
            try {
                Class<?> c = Class.forName(IIOPHelper.IMPL_CLASS, true, null);
                return (IIOPProxy)c.newInstance();
            }
            catch (ClassNotFoundException cnf) {
                return null;
            }
            catch (InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    });

    private IIOPHelper() {
    }

    public static boolean isAvailable() {
        return proxy != null;
    }

    private static void ensureAvailable() {
        if (proxy == null) {
            throw new AssertionError((Object)"Should not here");
        }
    }

    public static boolean isStub(Object obj) {
        return proxy == null ? false : proxy.isStub(obj);
    }

    public static Object getDelegate(Object stub) {
        IIOPHelper.ensureAvailable();
        return proxy.getDelegate(stub);
    }

    public static void setDelegate(Object stub, Object delegate) {
        IIOPHelper.ensureAvailable();
        proxy.setDelegate(stub, delegate);
    }

    public static Object getOrb(Object stub) {
        IIOPHelper.ensureAvailable();
        return proxy.getOrb(stub);
    }

    public static void connect(Object stub, Object orb) throws RemoteException {
        IIOPHelper.ensureAvailable();
        proxy.connect(stub, orb);
    }

    public static boolean isOrb(Object obj) {
        IIOPHelper.ensureAvailable();
        return proxy.isOrb(obj);
    }

    public static Object createOrb(String[] args, Properties props) {
        IIOPHelper.ensureAvailable();
        return proxy.createOrb(args, props);
    }

    public static Object stringToObject(Object orb, String str) {
        IIOPHelper.ensureAvailable();
        return proxy.stringToObject(orb, str);
    }

    public static String objectToString(Object orb, Object obj) {
        IIOPHelper.ensureAvailable();
        return proxy.objectToString(orb, obj);
    }

    public static <T> T narrow(Object narrowFrom, Class<T> narrowTo) {
        IIOPHelper.ensureAvailable();
        return proxy.narrow(narrowFrom, narrowTo);
    }

    public static void exportObject(Remote obj) throws RemoteException {
        IIOPHelper.ensureAvailable();
        proxy.exportObject(obj);
    }

    public static void unexportObject(Remote obj) throws NoSuchObjectException {
        IIOPHelper.ensureAvailable();
        proxy.unexportObject(obj);
    }

    public static Remote toStub(Remote obj) throws NoSuchObjectException {
        IIOPHelper.ensureAvailable();
        return proxy.toStub(obj);
    }
}

