/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.collapse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.IndexOptions;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.search.SearchContextException;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.internal.SearchContext;

public class CollapseBuilder
implements Writeable,
ToXContentObject {
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField INNER_HITS_FIELD = new ParseField("inner_hits", new String[0]);
    public static final ParseField MAX_CONCURRENT_GROUP_REQUESTS_FIELD = new ParseField("max_concurrent_group_searches", new String[0]);
    private static final ObjectParser<CollapseBuilder, Void> PARSER = new ObjectParser("collapse", CollapseBuilder::new);
    private String field;
    private List<InnerHitBuilder> innerHits = Collections.emptyList();
    private int maxConcurrentGroupRequests = 0;

    private CollapseBuilder() {
    }

    public CollapseBuilder(String field) {
        Objects.requireNonNull(field, "field must be non-null");
        this.field = field;
    }

    public CollapseBuilder(StreamInput in) throws IOException {
        InnerHitBuilder innerHitBuilder;
        this.field = in.readString();
        this.maxConcurrentGroupRequests = in.readVInt();
        this.innerHits = in.getVersion().onOrAfter(Version.V_5_5_0) ? in.readList(InnerHitBuilder::new) : ((innerHitBuilder = in.readOptionalWriteable(InnerHitBuilder::new)) != null ? Collections.singletonList(innerHitBuilder) : Collections.emptyList());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeVInt(this.maxConcurrentGroupRequests);
        if (out.getVersion().onOrAfter(Version.V_5_5_0)) {
            out.writeList(this.innerHits);
        } else {
            boolean hasInnerHit = !this.innerHits.isEmpty();
            out.writeBoolean(hasInnerHit);
            if (hasInnerHit) {
                this.innerHits.get(0).writeToCollapseBWC(out);
            }
        }
    }

    public static CollapseBuilder fromXContent(XContentParser parser) {
        return (CollapseBuilder)PARSER.apply(parser, null);
    }

    private CollapseBuilder setField(String field) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        this.field = field;
        return this;
    }

    public CollapseBuilder setInnerHits(InnerHitBuilder innerHit) {
        this.innerHits = Collections.singletonList(innerHit);
        return this;
    }

    public CollapseBuilder setInnerHits(List<InnerHitBuilder> innerHits) {
        this.innerHits = innerHits;
        return this;
    }

    public CollapseBuilder setMaxConcurrentGroupRequests(int num) {
        if (num < 1) {
            throw new IllegalArgumentException("maxConcurrentGroupRequests` must be positive");
        }
        this.maxConcurrentGroupRequests = num;
        return this;
    }

    public String getField() {
        return this.field;
    }

    public List<InnerHitBuilder> getInnerHits() {
        return this.innerHits;
    }

    public int getMaxConcurrentGroupRequests() {
        return this.maxConcurrentGroupRequests;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder);
        builder.endObject();
        return builder;
    }

    private void innerToXContent(XContentBuilder builder) throws IOException {
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        if (this.maxConcurrentGroupRequests > 0) {
            builder.field(MAX_CONCURRENT_GROUP_REQUESTS_FIELD.getPreferredName(), this.maxConcurrentGroupRequests);
        }
        if (!this.innerHits.isEmpty()) {
            if (this.innerHits.size() == 1) {
                builder.field(INNER_HITS_FIELD.getPreferredName(), (ToXContent)this.innerHits.get(0));
            } else {
                builder.startArray(INNER_HITS_FIELD.getPreferredName());
                for (InnerHitBuilder innerHit : this.innerHits) {
                    innerHit.toXContent(builder, ToXContent.EMPTY_PARAMS);
                }
                builder.endArray();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollapseBuilder that = (CollapseBuilder)o;
        if (this.maxConcurrentGroupRequests != that.maxConcurrentGroupRequests) {
            return false;
        }
        if (!this.field.equals(that.field)) {
            return false;
        }
        return Objects.equals(this.innerHits, that.innerHits);
    }

    public int hashCode() {
        int result = Objects.hash(this.field, this.innerHits);
        result = 31 * result + this.maxConcurrentGroupRequests;
        return result;
    }

    public CollapseContext build(SearchContext context) {
        if (context.scrollContext() != null) {
            throw new SearchContextException(context, "cannot use `collapse` in a scroll context");
        }
        if (context.searchAfter() != null) {
            throw new SearchContextException(context, "cannot use `collapse` in conjunction with `search_after`");
        }
        if (context.rescore() != null && !context.rescore().isEmpty()) {
            throw new SearchContextException(context, "cannot use `collapse` in conjunction with `rescore`");
        }
        MappedFieldType fieldType = context.getQueryShardContext().fieldMapper(this.field);
        if (fieldType == null) {
            throw new SearchContextException(context, "no mapping found for `" + this.field + "` in order to collapse on");
        }
        if (!(fieldType instanceof KeywordFieldMapper.KeywordFieldType) && !(fieldType instanceof NumberFieldMapper.NumberFieldType)) {
            throw new SearchContextException(context, "unknown type for collapse field `" + this.field + "`, only keywords and numbers are accepted");
        }
        if (!fieldType.hasDocValues()) {
            throw new SearchContextException(context, "cannot collapse on field `" + this.field + "` without `doc_values`");
        }
        if (fieldType.indexOptions() == IndexOptions.NONE && this.innerHits != null && !this.innerHits.isEmpty()) {
            throw new SearchContextException(context, "cannot expand `inner_hits` for collapse field `" + this.field + "`, only indexed field can retrieve `inner_hits`");
        }
        return new CollapseContext(this.field, fieldType, this.innerHits);
    }

    static {
        PARSER.declareString(CollapseBuilder::setField, FIELD_FIELD);
        PARSER.declareInt(CollapseBuilder::setMaxConcurrentGroupRequests, MAX_CONCURRENT_GROUP_REQUESTS_FIELD);
        PARSER.declareField((parser, builder, context) -> {
            XContentParser.Token currentToken = parser.currentToken();
            if (currentToken == XContentParser.Token.START_OBJECT) {
                builder.setInnerHits(InnerHitBuilder.fromXContent(parser));
            } else if (currentToken == XContentParser.Token.START_ARRAY) {
                ArrayList<InnerHitBuilder> innerHitBuilders = new ArrayList<InnerHitBuilder>();
                currentToken = parser.nextToken();
                while (currentToken != XContentParser.Token.END_ARRAY) {
                    if (currentToken != XContentParser.Token.START_OBJECT) {
                        throw new ParsingException(parser.getTokenLocation(), "Invalid token in inner_hits array", new Object[0]);
                    }
                    innerHitBuilders.add(InnerHitBuilder.fromXContent(parser));
                    currentToken = parser.nextToken();
                }
                builder.setInnerHits(innerHitBuilders);
            }
        }, INNER_HITS_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
    }
}

